;;;;
;;;; psd.scm 1.3
;;;;
;;;; psd -- a portable Scheme debugger, version 1.0
;;;; Copyright (C) 1992 Pertti Kellomaki, pk@cs.tut.fi

;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 1, or (at your option)
;;;; any later version.

;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;;;; GNU General Public License for more details.

;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; See file COPYING in the psd distribution.

;;;; 
;;;; Written by Pertti Kellomaki, pk@cs.tut.fi
;;;;
;;;; SLIB interface to load psd files.

;;;; This is the file that takes care of loading psd into the Scheme
;;;; interpreter. If you want to modify psd to work with a particular
;;;; implementation, say "foo", this is the way to do it:

;;;; 1) Make a copy of the file "psd.scm" under the name "psd-foo.scm",
;;;;    and modify it to load "primitives-foo.scm" instead of
;;;;    "primitives.scm". You can also do other things.
;;;;
;;;; 2) Make a copy of the file "primitives.scm" under the name
;;;;    "primitives-foo.scm", and modify the definitions in it to
;;;;    know about the additional primitives in your implementation
;;;;
;;;; 3) When you now set the Emacs variable scheme-program-name to
;;;;    "foo" and give the commands ``M-x run-scheme'' ``M-x psd-mode'',
;;;;    you have a psd system that knows about your additional
;;;;    primitives.

;;; this is not portable.
(define psd:control-z (integer->char 26))

;;; FORCE-OUTPUT flushes any pending output on optional arg output port
;;; use this definition if your system doesn't have such a procedure.
(define (force-output . arg) #t)

;;; If you are using slib, use the following.
;(load (in-vicinity (program-vicinity) "instrum" (scheme-file-suffix)))
;(load (in-vicinity (program-vicinity) "pexpr" (scheme-file-suffix)))
;(load (in-vicinity (program-vicinity) "read" (scheme-file-suffix)))
;(load (in-vicinity (program-vicinity) "runtime" (scheme-file-suffix)))
;(load (in-vicinity (program-vicinity) "primitives" (scheme-file-suffix)))

;;; If you are not using slib, use the following instead.

(define psd-directory "/usr/local/lib/psd/")
(load (string-append psd-directory "instrum.scm"))
(load (string-append psd-directory "pexpr.scm"))
(load (string-append psd-directory "read.scm"))
(load (string-append psd-directory "runtime.scm"))
(load (string-append psd-directory "primitives.scm"))

;;;;
;;;; Some implementations have variables that control how long and how
;;;; deep lists are printed. If you are using psd with a Scheme that
;;;; is not supported and you are having problems, this is a
;;;; potential cause.
;;;;

;(set! print-length -1)
;(set! print-depth -1)
