(herald sparcbuild)
#|

To build a new system from sources:

1. You should be in a directory with sources and tsystem as subdirectories
   Execute the shell script in tsystem/envset
2. Start up tsystem/xt and load this file into orbit-env
3. (compile-support) and (exit)
4. Start up tsystem/xt again and load this file into orbit-env
5. (compile-sources) and (link-t '(tsystem new)) and (exit)
6. cd tsystem; linkt new.o new; cd ..
7. tsystem/new is a T without compiler. Start up new with a large heap.
8. ((*value t-implementation-env 'load-and-suspend-system) '(tsystem new) t)
   (exit)
9. cd tsystem; linkt new.o new    That's it.

|#

;;; Build compiler early binding environment

(*define user-env 'compile-support
(lambda ()
(create-support '(t3_primops spconstants) '(t3_primops spconstants))
(load '(t3_primops spconstants t) orbit-env)
(orbit-sparc-setup 't3_primops)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_primops spprimops)   '(t3_primops spprimops))
(create-support '(t3_primops sparith)     '(t3_primops sparith))
(create-support '(t3_primops locations)    '(t3_primops locations))
(create-support '(t3_primops splow)       '(t3_primops splow))
(create-support '(t3_primops predicates)       '(t3_primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_primops open)    '(t3_primops open))
(create-support '(t3_primops aliases) '(t3_primops aliases))
(create-support '(t3_primops carcdr)  '(t3_primops carcdr))
(create-support '(t3_primops spgenarith)  '(t3_primops spgenarith))))

;;; compile compiler code in early binding environment, runtime system

(*define user-env 'compile-sources
(lambda ()
(set (orbit-syntax-table) primop-syntax-table)
(comfile '(t3_primops base))
(compile-primop-source '(t3_primops spprimops   si))
(compile-primop-source '(t3_primops sparith     si))
(compile-primop-source '(t3_primops locations    si))
(compile-primop-source '(t3_primops splow       si))
(compile-primop-source '(t3_primops spgenarith    si))
(set *compile-primops?* nil)
(set (table-entry *modules* 'bignum) '(osys risc_bignum))
(load-quietly '(t3_primops spconstants t) orbit-env)
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(orbit-sparc-init 't3_primops)
;(set primop/computed-goto (table-entry primop-table 'computed-goto))
(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
(load '(osys sparc_files) orbit-env)
(comsys 't)
(comfile '(link defs))
(comfile '(link linker))
(comfile '(link sparc_link))
(comfile '(link lp_table))
(comfile '(link suspend))
(comfile '(link sparcsuspend))
(comfile '(tscheme scheme))
(comfile '(tscheme syntax))
(comfile '(tscheme system))
(comfile '(tscheme runtime))
(comfile '(tscheme compiler))
(set (tc-syntax-table) (env-syntax-table orbit-env))
(comfile '(front_end spfix))
(walk comfile
      (append *orbit-files*
	      *top-files*
	      *front-files*
;	      '((front_end computed_goto))
	      *back-end-files*
	      *orbit-sparc-files*
	      *tas-sparc-files*))))


(define (load-linker . system)
  (let* ((system (if (null? system) 
                     ((*value t-implementation-env 'machine-type) 
                      ((*value t-implementation-env 'local-machine)))
                     (car system)))
         (link-env (make-locale orbit-env 'link-env)))
    (*define standard-env 'link-env link-env)
    (load '(link defs )         link-env)
    (load '(link linker )       link-env)
    (load 
     '(link sparc_link)
     link-env)
    (load '(t3_primops spconstants t)  link-env)
    (*define standard-env  'link
	     (lambda (files outfile)
	       (set (repl-results) nil)
	       (gc)
	       ((*value link-env 'link) files outfile)))))

(*define user-env 'link-t
(lambda (file)
(load-linker)
(load '(osys sparc_files) orbit-env)
(link *t-system* file)))


