(herald april)




(define (figure-pushfr is n)
  (xcond ((fx= n 0) (return is 0))
         ((fx< n *slots*)
	 (return `((,risc/store () l ,link-reg (reg-offset ,fp ,frame/link))
		   (,sparc/jmpl () (reg-offset ,get-frame 0) ,extra)
		   (,april/ldsf () (reg-offset ,fp ,frame/free) ,fp)
		   ,@is)
		 3))))
#|
	(else
	 (return
	  `((,march/jumpl () (reg-offset ,nil-reg ,slink/make-stack-block)
			  ,extra ,top-tag)
	    (,march/move () (lit . ,(fx+ (fx- n *real-registers*) 1))
			 ,*first-stack-register*)
	    (,march/pushfr () (lit . 0) ,link-reg ,SN-1 ,top-tag)
	    ,@is)
	  3))))
|#
(define (figure-popfr is n)
  (cond ((fx= n 0) (return is 0))
	(else
	 (return `((,risc/load () (reg-offset ,fp ,frame/cont) ,fp)
		   (,risc/load () (reg-offset ,fp ,frame/link) ,link-reg)
		   ,@is)
		 2))))



#|
(define call-lazy-future?
  (node-field call-node? node-stuff-4 'call-lazy-future?))

(define (create-call-node n exits)
  (let ((node (create-node call-node?)))
    (set (call-proc+args node) (make-empty-node-list n))
    (set (call-exits node) exits)
    (set (call-complexity node) nil)
    (set (call-hoisted-cont node) nil)
    (set (call-lazy-future? node) nil)
    node))

(define-local-syntax (define-compiler-syntax pattern vars . body)
  (let* ((name (car pattern))
         (sym (concatenate-symbol 'syntax/ name))
         (exp (generate-symbol 'exp)))
    `(let ((descr (syntax-table-entry (env-syntax-table t-implementation-env)
                                      ',name)))
       (set (syntax-table-entry primitive-syntax-table ',name) descr)
       (set (table-entry primitive-handler-table descr)
            (lambda (,exp . ,vars)
              (ignorable . ,vars)
              (destructure ((,(cdr pattern) (cdr ,exp)))
                ,@body)))
       (define ,sym descr))))

(define-compiler-syntax (future exp) (syntax shape)
  (receive  (node c-parent c-role) (->node exp syntax shape)
    (if (call-node? node)
	(set (call-lazy-future? node) '#t))
    (return node c-parent c-role)))

(define (allocate-known-call node proc)
  (receive (cont moved)
    (xselect (lambda-strategy proc)
      ((strategy/label) (allocate-label-call node proc))
      ((strategy/heap) (allocate-known-heap-call node proc)))
    (if (call-in-body? proc node)
	(cond (cont
	       (generate-save-jump-and-link proc (call-lazy-future? node))
	       (restore-live-registers-and-continue moved cont))
	      (else 
	       (generate-jump proc)
	       (clear-slots)))
	(cond (cont
	       (if (call-lazy-future? node)
		   (generate-lazy-future-prologue))
	       (generate-save-avoid-jump-and-link proc (call-lazy-future? node))
	       (restore-live-registers-and-continue moved cont))
	      (else 
	       (generate-avoid-jump proc)
	       (clear-slots))))))

(define (generate-labels node)        
  (destructure (((cont master) (call-args node)))
    (destructure (((body . procs) (call-args (lambda-body master))))
      (xselect (lambda-strategy master)
        ((strategy/heap)
         (generate-heap-labels node body procs))                            
        ((strategy/label)))
      (cond ((and (lambda-node? cont)
		  (eq? (lambda-strategy cont) strategy/stack))
	     (let* ((cont-saved (save-live-registers cont node))
		    (hv (lambda-self-var *heap-env*))
		    (live (if (or (register-loc hv) (temp-loc hv))
			      (cons hv (lambda-live body))
			      (lambda-live body)))
		    (main-saved (kill-cont-vars-and-save node live)))
	       (generate-save-jump-and-link body '#f) ;no lazy future
	       (emit-stack-template cont)
	       (restore-live-registers-and-continue cont-saved cont)
	       (emit-tag body)
	       (clear-slots)
	       (walk (lambda (pair) (mark (car pair) (cdr pair))) main-saved)
	       (maybe-allocate-red-frame *lambda*)
	       (allocate-call (lambda-body body)))) ;body will deallocate
	    (else
	     (allocate-call (lambda-body body)))))))

(define (allocate-general-call node)
  (let* ((cont ((call-arg 1) node))
	 (out? (lambda-node? cont)))
    (let ((moved (if out? (save-live-registers cont node) nil)))
    (parallel-assign-general node)
    (cond (out?
	   (generate-general-call-and-link (reference-variable (call-proc node))
					   (fx- (length (call-args node)) 1)
					   (call-lazy-future? node))
	   (restore-live-registers-and-continue moved cont))
	  (else
	  (maybe-deallocate-red-frame *lambda*)
	  (generate-general-call (reference-variable (call-proc node))
				  (fx- (length (call-args node)) 1))
	   (clear-slots))))))

(define (generate-save-jump-and-link l future?)
  (cond (future?
	 (lazy-future (pcrel l))
	 (emit march/lzfr))
	(else
	 (emit march/jumpl (pcrel l) link-reg top-tag))))

(define generate-save-avoid-jump-and-link generate-save-jump-and-link)


(define (generate-general-call-and-link proc-var n-args future?)
  (generate-move (machine-num (fx+ n-args 1)) NARGS)
  (cond ((and (or (variable-binder proc-var)
		  (var-is-vcell? proc-var)))
	 (cond (future?
		(lazy-future (reg-offset pc slink/icall))
		(emit march/lzfr))
	       (else
		(emit march/jumpl (reg-offset pc slink/icall) link-reg top-tag))))
	(else
         (generate-move (reg-offset P 0) extra)
	 (cond (future?
		(lazy-future (reg-offset extra 0))
		(emit lzfr))
	       (else
		(emit march/jumpl (reg-offset extra 0) link-reg top-tag))))))
    
(define (lazy-future ro)
  (emit march/st FP (reg-offset LFT frame/lf-next))
  (emit march/st LFT (reg-offset FP frame/lf-prev))
  (emit march/move FP LFT)
  (emit march/lzfc ro)
  (emit march/lzfr))

(define march/lzfc
  (object (lambda (bv i reg-offset)
	    (set (vref bv i)
		 (march-instruction opcode/lzfc 0 (r->num (cadr reg-offset))
				    0
				    (imm-value (caddr reg-offset) i) top-tag)))
    ((instruction-as-string self i reg-offset)
     (format nil "lzfc ~a(~a)"
	     (imm-value (caddr reg-offset) i) (r->name (cadr reg-offset))))
    ((identification self) "lzfc")))
(define opcode/lzfc 'lzfc)


(define march/lzfr 
  (object (lambda (bv i)
	    (set (vref bv i)
		 (march-instruction opcode/lzfr 0 0 0 0 top-tag)))
    ((instruction-as-string self i)
     (format nil "lzfr"))
    ((identification self) "lzfr")))
(define opcode/lzfr 'lzfr)

|#