#! /bin/sh

# Runs a command after setting T source environment variables.
# If no command is given, it runs a shell.

# You define TSOURCES and TSYSTEM.
TSYSTEM=/usr/local/lib/tsystem
TSOURCES=./sources

RISC=${TSOURCES}
BUILD=${TSOURCES}/comp/build
ORBIT_TOP=${TSOURCES}/comp/top
TOP=${ORBIT_TOP}
FRONT_END=${TSOURCES}/comp/front_end
BACK_END=${TSOURCES}/comp/back_end
ASSEMBLER=${TSOURCES}/comp/assembler
T3_PRIMOPS=${TSOURCES}/comp/primops
PRIMOP_SOURCE=${TSOURCES}/comp/primops
PRIMOP_DEST=${TSOURCES}/comp/primops
OSYS=${TSOURCES}/sys
LINK=${TSOURCES}/link
TSCHEME=${TSOURCES}/scheme

# TMACHINE=sun3
# export TMACHINE
export TSYSTEM TSOURCES
export RISC BUILD TOP ORBIT_TOP FRONT_END BACK_END ASSEMBLER 
export T3_PRIMOPS PRIMOP_SOURCE PRIMOP_DEST OSYS LINK TSCHEME

if test "$1"
then
  exec "$@"
elif test "$SHELL"
then
  exec $SHELL
else
  exec /bin/sh
fi
