(herald unn32gen)
                             
;;; we can do unsafe things here once we set the foreign call cont
;;; assume foreign code has convention of returning a value in S0,
;;; S0 and S1 adjoined, or F0.

(define (generate-foreign-call node)                                   ;87/02/02
  (destructure (((#f foreign rep-list value-rep . args) (call-args node)))
    (emit n32/spri d SP (reg-offset TASK task/foreign-call-cont))
    (emit n32/spri d TASK (reg-offset nil-reg slink/current-task))
    (iterate loop ((args (reverse args)) 
                   (reps (map cadr (leaf-value rep-list)))
                   (count 0))
      (cond ((null? args)
             (walk (lambda (node) (kill (leaf-value node))) args)
             (let ((reg (->register 'pointer node (leaf-value foreign) '*)))
               (emit n32/movi d (reg-offset reg 6) reg)
               (emit n32/jsr (reg-offset reg 0))))
            ((eq? (car reps) 'rep/double) 
             (->register 'scratch node (leaf-value (car args)) S0) 
             (generate-push (reg-offset S0 6))
             (generate-push (reg-offset S0 2))
             (loop (cdr args) (cdr reps) (fx+ count 2)))
            (else
             (rep-push node (leaf-value (car args)) (car reps))
             (loop (cdr args) (cdr reps) (fx+ count 1)))))
    (emit n32/lpri d SP              (reg-offset TASK task/foreign-call-cont))
    (emit n32/movi d (machine-num 0) (reg-offset TASK task/foreign-call-cont))
    (case (leaf-value value-rep)
      ((rep/undefined ignore))
      ((rep/double)                                  ; value returned in F0
       (emit n32/movi d (machine-num 8) S0)            ; 2 words for double
       (emit n32/movi d (machine-num header/double-float) AN)
       (generate-slink-jump slink/make-extend)
       (n32emit (n32/movf 0          ; assembler's code for L (long float)
                          (r 0)      ; R0 emits same bits as F0 (kluge)
                          (->field-group (reg-offset AN 2))))
       (emit n32/movi d AN A1))                         ; return consed flonum
      (else
       (really-rep-convert node S0 (leaf-value value-rep) A1 'rep/pointer)))
    (generate-return 1)))

(define (rep-push node value to-rep)                                   ;87/02/09
  (cond ((addressable? value)
         (emit n32/movi d (value-with-rep value to-rep) (tos)))
        (else
         (let ((access (access-value node value))
               (from-rep (variable-rep value)))
           (cond ((eq? from-rep to-rep)
                  (emit n32/movi d access (tos)))
                 ((neq? (rep-size to-rep) size/long)
                  (emit n32/movi d (machine-num 0) (tos))
                  (really-rep-convert node access from-rep 
                                      (reg-offset SP 0) to-rep))
                 (else
                  (really-rep-convert node access from-rep (tos) to-rep))))))
  (increment-stack))

