(herald fix1)



(define (set-join-state node join lamb)
  (let ((p-ok? (not (join-point-contour-needed? join))))
    (lambda-queue lamb)
    (compute-label-arg-specs node lamb p-ok?)
    (let* ((-args (map car (join-point-arg-specs join)))
	   (args (if p-ok? `(,an ,@-args) `(,an ,p ,@-args)))
           (global '()))
      (iterate loop ((vars (join-point-env join)) (left '()))
        (cond ((null? vars)
               (do ((vars left (cdr vars)))
                   ((null? vars))
                 (let ((reg (get-free-register (car vars) args p-ok?)))
                   (push args reg)
                   (push global (cons reg (car vars))))))
              (else
               (let ((w (or (register-loc (car vars))
                            (temp-loc (car vars))
                            (likely-next-reg (car vars) lamb))))
                 (cond ((and (fixnum? w) 
                             (not (memq? w args)))
                        (push args w)
                        (push global (cons w (car vars)))
                        (loop (cdr vars) left))
                       ((register-loc (car vars))
                        => (lambda (reg)
                             (cond ((not (memq? reg args))
                                    (push args reg)
                                    (push global (cons reg (car vars)))
                                    (loop (cdr vars) left))
                                   (else
                                    (loop (cdr vars) (cons (car vars) left))))))
                       (else
                        (loop (cdr vars) (cons (car vars) left))))))))
      (or p-ok? (push global (cons P (join-point-contour join))))
      (set (join-point-global-registers join) global))))


(define (compute-label-arg-specs node label p-ok?)
  (receive (formals actuals) (if (continuation? label)
                                 (return (lambda-variables label)
                                         (call-args node))
                                 (return (cdr (lambda-variables label))
                                         (cdr (call-args node))))
  (iterate loop ((formals formals) (actuals actuals)
		 (args '()) (regs (if p-ok? (list AN) (list P AN))))
    (cond ((null? formals)
           (set (join-point-arg-specs (lambda-env label)) (reverse! args)))
          (else
      (let* ((w (likely-next-reg (car formals) label))
             (reg (cond ((and (fixnum? w)
			      (var-reg-compatable? (car formals) w)
			      (not (memq? w regs)))
			 w)
                        ((let ((reg (and (reference-node? (car actuals))
                                         (register-loc (leaf-value (car actuals))))))
                           (if (and reg
                                    (var-reg-compatable? (car formals) reg)
                                    (not (memq? reg regs)))
                               reg 
                               nil)))
                        (else
                         (get-free-register (car formals) regs p-ok?)))))
        (loop (cdr formals)                                    
              (cdr actuals)
              (cons (cons reg (variable-rep (car formals))) args)
              (cons reg regs))))))))

(define (var-reg-compatable? var reg)   
  (and (fxn= reg AN)
      (case (variable-rep var)
        ((rep/pointer)
         (select (variable-type var)
           ((type/fixnum type/char) '#t)
           (else (eq? (reg-type reg) 'pointer))))
        (else
         (eq? (reg-type reg) 'scratch)))))
                            
(define (variable-register-type var)
  (case (variable-rep var)
    ((rep/pointer) 
     (select (variable-type var)
       ((type/fixnum type/char) '*)
       (else 'pointer)))
    (else 'scratch)))
                  
  
(define (get-free-register var used p-ok?)
  (really-get-free-register (variable-register-type var) used nil p-ok?))

(define (really-get-free-register type used force? p-ok?)
  (xcase type
    ((pointer)
     (iterate loop ((i (if p-ok? P A1)))
       (cond ((fx>= i AN)               
              (cond (force?
                     (do ((j *real-registers* (fx+ j 1)))
                         ((if (fx>= j (fx+ *real-registers* *pointer-temps*))
                              (bug "ran out of registers in GET-FREE-REGISTER")
                              (not (memq? j used)))
                          j)))
                     (else 
                      (really-get-free-register type used t p-ok?))))
             ((memq? i used) (loop (fx+ i 1)))
             ((or force? (not (reg-node i))) i)
             (else (loop (fx+ i 1))))))                        
    ((scratch)
     (iterate loop ((i 0))
       (cond ((fx= i *scratch-registers*)
              (cond (force?
                     (do ((j (fx+ *real-registers* *pointer-temps*) (fx+ j 1)))
                         ((if (fx>= j *no-of-registers*)
                              (bug "ran out of registers in GET-FREE-REGISTER")
                              (not (memq? j used)))
                          j)))
                    (else
                     (really-get-free-register type used t p-ok?))))
             ((memq? i used) (loop (fx+ i 1)))
             ((or force? (not (reg-node i))) i)
             (else (loop (fx+ i 1))))))
    ((*)
     (iterate loop ((i 0))
       (cond ((and (not p-ok?) (fx= i P)) (loop A1))
             ((fx>= i AN)
              (cond (force?
                     (do ((j *real-registers* (fx+ j 1)))
                         ((if (fx>= j *no-of-registers*)
                              (bug "ran out of registers in GET-FREE-REGISTER")
                              (not (memq? j used)))
                          j)))
                    (else
                     (really-get-free-register type used t p-ok?))))
             ((memq? i used) (loop (fx+ i 1)))
             ((or force? (not (reg-node i))) i)
             (else (loop (fx+ i 1))))))))


(define (really-likely-next-reg var cont)
  (let ((refs (mem (lambda (x ref) 
                     (fx= (lambda-trace (node-parent (node-parent ref))) x))
                   (lambda-trace cont)
                   (variable-refs var))))
    (iterate loop ((refs refs))
      (if (null? refs)
          (variable-register-type var)
          (let* ((parent (node-parent (car refs)))
                 (proc (call-proc parent))
                 (number (call-arg-number (node-role (car refs)))))
            (cond ((primop-node? proc)
                   (cond ((primop.arg-specs (primop-value proc))
                          => (lambda (specs)
			       (let ((spec (nth specs (fx- (fx- number
							      (call-exits parent))
							      1))))
				 (if (eq? spec '*)
				     (loop (cdr refs))
				     spec))))
                         (else
                          (loop (cdr refs)))))
                  ((variable-known (leaf-value proc))
                   => (lambda (label)
                        (cond ((neq? (lambda-strategy label) strategy/label)
                               (fx- (fx+ number *scratch-registers*)
                                    (call-exits parent)))
                              ((join-point-arg-specs (lambda-env label))
                               => (lambda (args)
                                    (car (nth args
                                      (fx- (fx- number (call-exits parent)) 1)))))
                              (else (loop '())))))
                  (else
                   (fx- (fx+ number *scratch-registers*)
                        (call-exits parent)))))))))

