(herald annotation)

(lset *annotation* '())

(define (generate-init continuation)
  (bind ((*unit-literals* '())
         (*unit-variables* '())
         (*unit-closures* '())
         (*unit-templates* '())
         (*unit* nil) 
         (*annotation* '())
         (*registers* (vector-fill (make-vector *no-of-registers*) nil))
         (*lambda* nil)
         (*stack-pos* 0)
         (*locations* (make-table 'locations))
         (*lambda-queue* '()))
    (continuation)))

(define (allocate-registers node)
    (select (lambda-strategy node)
      ((strategy/stack strategy/heap)
       (push *annotation* node)
       (set *lambda* node)
       (emit-template node node))
      ((strategy/vframe strategy/ezclose)
       (set *lambda* (node-parent (node-parent node)))
       (emit-tag node))
      (else
       (set *lambda* (variable-binder (join-point-contour (lambda-env node))))
       (emit-tag node)))
    (initialize-registers node)
    (if (n-ary? node)
        (n-ary-setup node))
    (allocate-call (lambda-body node)))

(define (really-comfile in-filename out-filename)
    (receive (exp support syntax h)
             (read-file in-filename)
      (receive (comex infex annex)
               (compile exp support syntax in-filename h)
        (write-support-file infex out-filename)
        (write-object-file comex out-filename)
        (write-annotation-file annex out-filename)
        t)))

(define (really-compile exp syntax filename h)
  (receive (tree infex)
           (make-code-tree+support `(,syntax/lambda () ,exp) syntax)
    (receive (a b c)
             (analyze tree)
      (generate tree)
      (let* ((comex (create-comex filename h a b c (assemble)))
             (annex (create-annotation *annotation*)))
        (if (not *debug-flag*) (erase-all tree))
        (values comex infex annex)))))

(define (create-annotation ann)
  (map! lambda->annotation-entry (filter! annotate? ann)))

(define (annotate? l)
  (fx= (environment-cic-offset (lambda-env l)) 0))

(define (lambda->annotation-entry l)
  (cons (fixnum-ashr (fx+ (code-vector-offset l)  2) 2)
        (map (lambda (x) (variable-name (car x)))
             (cdr (closure-env (environment-closure (lambda-env l)))))))

(define (write-annotation-file annex file)
  (with-open-ports ((s (open (filename-with-type (->filename file) 'mann) 'dump)))
    (write s annex)))
