(##include "header.scm")

(##declare (not intr-checks))

;------------------------------------------------------------------------------

; Procedures to support multitasking

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; (##read-not-ready ind) is called when there is an attempt to read from a
; port that does not yet contain chars (i.e. the read would normally block).
; ##read-not-ready should always return -1.

(define (##read-not-ready ind)
  (if (###_kernel.preempt) ; block only if no other tasks to run
    (##os-file-block-read ind))
  -1)

; (##timer-interrupt) is called periodically, based on VIRTUAL (cpu) time.
; The interval is set by a call to (##os-set-timer-interval x), where 'x'
; is the time expressed in milliseconds.

(define (##timer-interrupt)
  (let loop ()
    (if (##os-poll-events) ; give control back to OS so it can poll events
      (loop)
      (###_kernel.preempt))))

(##os-set-timer-interval 40) ; 25 interrupts per second

; (##process-os-event event) is called when the OS has received an event that
; it wishes to pass back to the program.  The meaning of 'event' is OS
; dependent.  ##process-os-event should return #t to poll the next OS event
; immediately or #f to wait until the next timer interrupt.

(define (##process-os-event event)
  #f)

;------------------------------------------------------------------------------
