#ifdef __STDC__
#define MAKE_LBL(x,y)y##__##x
#else
#define QUOTE(x)x
#define MAKE_LBL(x,y)QUOTE(QUOTE(y)__)x
#endif

#ifdef hpux

#define OBJECT_FILE_BEGIN _object_file_begin: global _object_file_begin
#define OBJECT_FILE_END _object_file_end: global _object_file_end

#define DISP(r,n)    n(r)
#define INXW(r,i,n)  n(r,i.w)
#define PC_IND(lab)  LBL(lab)(%pc)
#define ALIGN2       lalign 2
#define ALIGN4       lalign 4
#define ALIGN8       lalign 8
#define SET(a,b)     set a,b
#define CONST(n)     LBL($consts)+(n*4)(%pc)
#define REG(x)       %x
#define IMM(x)       &x
#define PINC(r)      (r)+
#define PDEC(r)      -(r)
#define IND(r)       (r)
#define BYTE         byte
#define WORD         short
#define LONG         long
#define ASCIZ        asciz
#define movb         move.b
#define movw         move.w
#define movl         move.l
#define extl         ext.l
#define addw         add.w
#define addl         add.l
#define addqw        addq.w
#define addql        addq.l
#define subw         sub.w
#define subl         sub.l
#define subqw        subq.w
#define subql        subq.l
#define negl         neg.l
#define clrb         clr.b
#define clrl         clr.l
#define muluw        mulu.w
#define notw         not.w
#define andw         and.w
#define andl         and.l
#define aslw         asl.w
#define asll         asl.l
#define asrw         asr.w
#define asrl         asr.l
#define lsrw         lsr.w
#define lsrl         lsr.l
#define tstw         tst.w
#define tstl         tst.l
#define CMPW(x,y)    cmp.w y,x
#define CMPL(x,y)    cmp.l y,x
#define DBRA(r,lab)  dbra r,LBL(lab)
#define BRAS(lab)    bra.b LBL(lab)
#define BEQS(lab)    beq.b LBL(lab)
#define BEQW(lab)    beq.w LBL(lab)
#define BNES(lab)    bne.b LBL(lab)
#define BNEW(lab)    bne.w LBL(lab)
#define BMIS(lab)    bmi.b LBL(lab)
#define BMIW(lab)    bmi.w LBL(lab)
#define BPLS(lab)    bpl.b LBL(lab)
#define BPLW(lab)    bpl.w LBL(lab)
#define BLES(lab)    ble.b LBL(lab)
#define BLEW(lab)    ble.w LBL(lab)
#define BGES(lab)    bge.b LBL(lab)
#define BCCS(lab)    bcc.b LBL(lab)
#define BCSS(lab)    bcs.b LBL(lab)
#define BCSW(lab)    bcs.w LBL(lab)
#define BLSS(lab)    bls.b LBL(lab)
#define BGTS(lab)    bgt.b LBL(lab)
#define BGTW(lab)    bgt.w LBL(lab)
#define BLTS(lab)    blt.b LBL(lab)
#define BRAW(lab)    bra.w LBL(lab)
#define BSRW(lab)    bsr.w LBL(lab)

#define fmovel       fmov.l
#define FPCR         %fpcr
#define FPSR         %fpsr

#else

#define OBJECT_FILE_BEGIN _object_file_begin: .globl _object_file_begin
#define OBJECT_FILE_END _object_file_end: .globl _object_file_end

#define DISP(r,n)    r@(n:w)
#define INXW(r,i,n)  r@(n:w,i:w)
#define PC_IND(lab)  pc@(-2-(.-LBL(lab)):w)
#define ALIGN2       .even
#define ALIGN4       .=(.-_object_file_begin+3)/4*4
#define ALIGN8       .=(.-_object_file_begin+7)/8*8
#define SET(a,b)     a = b
#define CONST(n)     pc@((n*4)-2-(.-LBL($consts)):w)
#define REG(r)       r
#define IMM(x)       #x
#define PINC(r)      r@+
#define PDEC(r)      r@-
#define IND(r)       r@
#define BYTE         .byte
#define WORD         .word
#define LONG         .long
#define ASCIZ        .asciz
#define muluw        mulu
#define CMPW(x,y)    cmpw x,y
#define CMPL(x,y)    cmpl x,y
#define DBRA(r,lab)  dbra r,LBL(lab)
#define BRAS(lab)    BYTE 0x60,LBL(lab)-.-2
#define BEQS(lab)    BYTE 0x67,LBL(lab)-.-2
#define BEQW(lab)    WORD 0x6700,LBL(lab)-.-2
#define BNES(lab)    BYTE 0x66,LBL(lab)-.-2
#define BNEW(lab)    WORD 0x6600,LBL(lab)-.-2
#define BMIS(lab)    BYTE 0x6b,LBL(lab)-.-2
#define BMIW(lab)    WORD 0x6b00,LBL(lab)-.-2
#define BPLS(lab)    BYTE 0x6a,LBL(lab)-.-2
#define BPLW(lab)    WORD 0x6a00,LBL(lab)-.-2
#define BLES(lab)    BYTE 0x6f,LBL(lab)-.-2
#define BLEW(lab)    WORD 0x6f00,LBL(lab)-.-2
#define BGES(lab)    BYTE 0x6c,LBL(lab)-.-2
#define BCCS(lab)    BYTE 0x64,LBL(lab)-.-2
#define BCSS(lab)    BYTE 0x65,LBL(lab)-.-2
#define BCSW(lab)    WORD 0x6500,LBL(lab)-.-2
#define BLSS(lab)    BYTE 0x63,LBL(lab)-.-2
#define BGTS(lab)    BYTE 0x6e,LBL(lab)-.-2
#define BGTW(lab)    WORD 0x6e00,LBL(lab)-.-2
#define BLTS(lab)    BYTE 0x6d,LBL(lab)-.-2
#define BRAW(lab)    WORD 0x6000,LBL(lab)-.-2
#define BSRW(lab)    WORD 0x6100,LBL(lab)-.-2

#define FPCR         fpcr
#define FPSR         fpsr

	.data

#endif


#define PRIMITIVE(name)							\
%NEWLINE%	LONG PRIM_PROC+(INDEX_MASK*8)				\
%NEWLINE%	ASCIZ name						\
%NEWLINE%	ALIGN2

#define BEGIN(name)							\
%NEWLINE%	LONG PRIM_PROC_PREFIX					\
%NEWLINE%	WORD INDEX_MASK						\
%NEWLINE%	ASCIZ name						\
%NEWLINE%	ALIGN2							\
%NEWLINE%	WORD LBL($header)					\
%NEWLINE%	ALIGN8							\
%NEWLINE%	WORD LBL($code_len_tag)					\
%NEWLINE%LBL($entry):

#define CONSTS(n)							\
%NEWLINE%	ALIGN4							\
%NEWLINE%LBL($consts):							\
%NEWLINE%	WORD END_OF_CODE_TAG					\
%NEWLINE%	SET(LBL($nb_consts),n+2)
	
#define END								\
%NEWLINE%	LONG SCM_false						\
%NEWLINE%	LONG LBL($nb_consts)*8					\
%NEWLINE%	SET(LBL($code_len),LBL($consts)-LBL($entry))		\
%NEWLINE%	SET(LBL($code_len_tag),LBL($code_len)/2)		\
%NEWLINE%	SET(LBL($header),HEADER(LBL($nb_consts)*4)+LBL($code_len)-2)

#define HEADER(l)    ((l)+0x8000)
#define GLOB_OFFS(x) (((x)*8)-(MAX_NB_GLOBALS*10)-(NB_TRAPS*8)+0x8000)
#define TRAP_OFFS(x) (((x)-NB_TRAPS)*8+0x8000)
#define STAT_OFFS(x) (((x)-MAX_NB_STATS)*4)
#define SLOT(x)      ((x)*4)

#define RETURN(lab,fs,link)						\
%NEWLINE%	ALIGN8							\
%NEWLINE%	LONG	0						\
%NEWLINE%	WORD	fs*4						\
%NEWLINE%	WORD	(fs-link)*4					\
%NEWLINE%	WORD	-0x8002-(.-LBL($entry))				\
%NEWLINE%LBL(lab)

#define RETURN_LAZY(lab,size,fs,link)					\
%NEWLINE%	ALIGN8							\
%NEWLINE%	LONG	size						\
%NEWLINE%	WORD	fs*4						\
%NEWLINE%	WORD	(fs-link)*4					\
%NEWLINE%	WORD	-0x8002-(.-LBL($entry))				\
%NEWLINE%LBL(lab)

#define SUBPROC(lab)							\
%NEWLINE%	ALIGN8							\
%NEWLINE%	WORD	-0x8002-(.-LBL($entry))				\
%NEWLINE%LBL(lab)

#define WRONG_NB_ARGS(x,n,lab)						\
%NEWLINE%	jsr DISP(TABLE_REG,TRAP_OFFS(x))			\
%NEWLINE%	WORD n							\
%NEWLINE%	WORD .-LBL(lab)

#define TRAP(x,lab,fs,link)						\
%NEWLINE%	BRAS(	lab)						\
%NEWLINE%	nop							\
%NEWLINE%	ALIGN8							\
%NEWLINE%LBL(lab):							\
%NEWLINE%	jsr DISP(TABLE_REG,TRAP_OFFS(x))			\
%NEWLINE%	WORD	fs*4						\
%NEWLINE%	WORD	(fs-link)*4					\
%NEWLINE%	WORD	-0x8002-(.-LBL($entry))

#define GET_TRAP_RETURN(nb_args)					\
%NEWLINE%	GET_TRAP_RET(nb_args)					\
%NEWLINE%	addql	IMM(SCM_type_PROCEDURE),DTEMP1

#define GET_TRAP_RET(nb_args)						\
%NEWLINE%	moveq	IMM(11+(nb_args*2)),DTEMP1			\
%NEWLINE%	addl	PINC(SP),DTEMP1					\
%NEWLINE%	andw	IMM(-8),DTEMP1

#define MOVE_ARGS_TO_STACK(arg_count)					\
%NEWLINE%	movw	arg_count,DTEMP1				\
%NEWLINE%	BPLS(	not_1_arg)					\
%NEWLINE%	moveq	IMM(1),DTEMP1		/* 1 arg passed */	\
%NEWLINE%	movl	PVM1_REG,PDEC(SP)				\
%NEWLINE%	BRAS(	args_pushed)					\
%NEWLINE%LBL(not_1_arg):						\
%NEWLINE%	BNES(	not_1_or_2_args)				\
%NEWLINE%	moveq	IMM(2),DTEMP1		/* 2 args passed */	\
%NEWLINE%	movl	PVM1_REG,PDEC(SP)				\
%NEWLINE%	movl	PVM2_REG,PDEC(SP)				\
%NEWLINE%	BRAS(	args_pushed)					\
%NEWLINE%LBL(not_1_or_2_args):						\
%NEWLINE%	subqw	IMM(1),DTEMP1					\
%NEWLINE%	BEQS(	args_pushed)					\
%NEWLINE%	movl	PVM1_REG,PDEC(SP)	/* 3 or more args passed */\
%NEWLINE%	movl	PVM2_REG,PDEC(SP)				\
%NEWLINE%	movl	PVM3_REG,PDEC(SP)				\
%NEWLINE%LBL(args_pushed):

#define RESET_STACK							\
%NEWLINE%	movl	DISP(PSTATE_REG,SLOT(STACK_TOP)),SP		\
%NEWLINE%	movl	DISP(PSTATE_REG,SLOT(Q_TOP)),LTQ_TAIL_REG	\
%NEWLINE%	movl	SP,PDEC(LTQ_TAIL_REG)				\
%NEWLINE%	movl	LTQ_TAIL_REG,DISP(PSTATE_REG,SLOT(LTQ_HEAD)) 	\
%NEWLINE%	movl	DISP(PSTATE_REG,SLOT(Q_BOT)),ATEMP1		\
%NEWLINE%	movl	SP,PINC(ATEMP1)					\
%NEWLINE%	movl	ATEMP1,DISP(PSTATE_REG,SLOT(DEQ_TAIL))		\
%NEWLINE%	movl	ATEMP1,DISP(PSTATE_REG,SLOT(DEQ_HEAD))

#define MAKE_TEMP_TASK							\
%NEWLINE%	movl	FALSE_REG,PDEC(HEAP_REG) /* Make legitimacy PH */ \
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	movl	NULL_REG,PDEC(HEAP_REG)				\
%NEWLINE%	lea	DISP(HEAP_REG,SCM_type_PLACEHOLDER-4),ATEMP2	\
%NEWLINE%	movl	ATEMP2,PDEC(HEAP_REG)				\
%NEWLINE%	movl	FALSE_REG,PDEC(HEAP_REG) /* Make sync PH */	\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	movl	NULL_REG,PDEC(HEAP_REG)				\
%NEWLINE%	lea	DISP(HEAP_REG,SCM_type_PLACEHOLDER-4),ATEMP1	\
%NEWLINE%	movl	ATEMP1,PDEC(HEAP_REG)				\
%NEWLINE%	clrl	PDEC(HEAP_REG) /* Make task */			\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	movl	ATEMP1,PDEC(HEAP_REG)				\
%NEWLINE%	movl	ATEMP1,PDEC(HEAP_REG)				\
%NEWLINE%	movl	ATEMP2,PDEC(HEAP_REG)				\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	clrl	PDEC(HEAP_REG)					\
%NEWLINE%	movl	IMM(TASK_SIZE*0x400+(SCM_subtype_TASK*8)),PDEC(HEAP_REG) \
%NEWLINE%	lea	DISP(HEAP_REG,SCM_type_SUBTYPED),ATEMP1		\
%NEWLINE%	movl	ATEMP1,DISP(PSTATE_REG,SLOT(TEMP_TASK))

#define ALLOC_FRAME							\
%NEWLINE%	moveq	IMM(0),DTEMP1					\
%NEWLINE%	movw	DISP(PVM0_REG,-6),DTEMP1			\
%NEWLINE%	addql	IMM(8),DTEMP1					\
%NEWLINE%	movl	DTEMP1,PVM1_REG					\
%NEWLINE%	addw	IMM(11),PVM1_REG				\
%NEWLINE%	andw	IMM(-8),PVM1_REG				\
%NEWLINE%	subl	PVM1_REG,HEAP_REG				\
%NEWLINE%	asll	IMM(8),DTEMP1					\
%NEWLINE%	movb	IMM(SCM_subtype_FRAME*8),DTEMP1			\
%NEWLINE%	movl	DTEMP1,IND(HEAP_REG)

#ifdef STATS

#define STAT(x)								\
%NEWLINE%	addql IMM(1),DISP(PSTATE_REG,STAT_OFFS(x))

#define STAT_N(x,n)							\
%NEWLINE%	addql IMM(n),DISP(PSTATE_REG,STAT_OFFS(x))

#define STAT_DTEMP1(x)							\
%NEWLINE%	addl  DTEMP1,DISP(PSTATE_REG,STAT_OFFS(x))

#else

#define STAT(x)
#define STAT_N(x,n)
#define STAT_DTEMP1(x)

#endif

#ifdef butterfly

#define ATOMCTA16 0 = a0, mask/incr = d1, adr = d0
#define ATOMADD32 1
#define ATOMAND32 2
#define ATOMIOR32 3

#define DO_ATOMIC							\
%NEWLINE%	trap IMM(0xe)

#define DO_BTRANSFER							\
%NEWLINE%	trap IMM(0xc)

#define DO_GETRTC							\
%NEWLINE%	trap IMM(0xd)

#define ADD_TO_DTEMP1()							\
%NEWLINE%					/* d0 = address, d1 = value */\
%NEWLINE%	movw	IMM(ATOMADD32),PVM0_REG	/* a0 = atomadd32 command   */\
%NEWLINE%	DO_ATOMIC			/* d0,a0,a1 not preserved   */

#define READ_AND_CLEAR_DTEMP1						\
%NEWLINE%					/* d0 = address             */\
%NEWLINE%	movw	IMM(ATOMAND32),PVM0_REG	/* a0 = atomand32 command   */\
%NEWLINE%	moveq	IMM(0),PVM1_REG		/* d1 = mask                */\
%NEWLINE%	DO_ATOMIC			/* d0,a0,a1 not preserved   */

#define READ_AND_SET_DTEMP1						\
%NEWLINE%					/* d0 = address             */\
%NEWLINE%	movw	IMM(ATOMIOR32),PVM0_REG	/* a0 = atomior32 command   */\
%NEWLINE%	moveq	IMM(-1),PVM1_REG	/* d1 = mask                */\
%NEWLINE%	DO_ATOMIC			/* d0,a0,a1 not preserved   */

#define LOCK_ATEMP1(lab)						\
%NEWLINE% 	movl	ATEMP1,PVM4_REG					\
%NEWLINE%LBL(lab):							\
%NEWLINE%	movw	IMM(ATOMIOR32),PVM0_REG	/* a0 = atomior32 command   */\
%NEWLINE%	movl	PVM4_REG,DTEMP1		/* d0 = address             */\
%NEWLINE%	moveq	IMM(-1),PVM1_REG	/* d1 = mask                */\
%NEWLINE%	DO_ATOMIC			/* d0,a0,a1 not preserved   */\
%NEWLINE%	CMPL(	DTEMP1,PVM1_REG)				\
%NEWLINE%	BEQS(	lab)						\
%NEWLINE%	movl	PVM4_REG,ATEMP1					\

#define LOCK_ATEMP2(lab)						\
%NEWLINE%LBL(lab):							\
%NEWLINE%	movw	IMM(ATOMIOR32),PVM0_REG	/* a0 = atomior32 command   */\
%NEWLINE%	movl	ATEMP2,DTEMP1		/* d0 = address             */\
%NEWLINE%	moveq	IMM(-1),PVM1_REG	/* d1 = mask                */\
%NEWLINE%	DO_ATOMIC			/* d0,a0,a1 not preserved   */\
%NEWLINE%	CMPL(	DTEMP1,PVM1_REG)				\
%NEWLINE%	BEQS(	lab)

#define BTRANSFER(lab)							\
%NEWLINE%	DO_BTRANSFER	/* a0 = src, d0 = dest, d1 = nb of bytes    */\
%NEWLINE%			/* d0,d1,a1 not preserved                   */

#ifdef ELOG

#define LOG(event_num,lab)						\
%NEWLINE%	DO_GETRTC	/* d0 = real time clock value */	\
%NEWLINE%	movl	DISP(PSTATE_REG,SLOT(ELOG_PTR)),ATEMP1		\
%NEWLINE%	CMPL(	DISP(PSTATE_REG,SLOT(ELOG_BOT)),ATEMP1)		\
%NEWLINE%	BEQS(	lab)						\
%NEWLINE%	movl	DTEMP1,PDEC(ATEMP1)				\
%NEWLINE%	movb	IMM(event_num),IND(ATEMP1)			\
%NEWLINE%	movl	ATEMP1,DISP(PSTATE_REG,SLOT(ELOG_PTR))		\
%NEWLINE%LBL(lab):

#define PREV_LOG(n,lab)							\
%NEWLINE%	DO_GETRTC	/* d0 = real time clock value */	\
%NEWLINE%	movl	DISP(PSTATE_REG,SLOT(ELOG_PTR)),ATEMP1		\
%NEWLINE%	CMPL(	DISP(PSTATE_REG,SLOT(ELOG_BOT)),ATEMP1)		\
%NEWLINE%	BEQS(	lab)						\
%NEWLINE%	movl	DTEMP1,PDEC(ATEMP1)				\
%NEWLINE%	movb	DISP(ATEMP1,4*n),IND(ATEMP1)			\
%NEWLINE%	movl	ATEMP1,DISP(PSTATE_REG,SLOT(ELOG_PTR))		\
%NEWLINE%LBL(lab):

#else

#define LOG(x,lab)
#define PREV_LOG(x,lab)

#endif

#else

#define ADD_TO_DTEMP1

#define READ_AND_CLEAR_DTEMP1						\
%NEWLINE%	movl	DTEMP1,ATEMP1					\
%NEWLINE%	movl	IND(ATEMP1),DTEMP1				\
%NEWLINE%	clrl	IND(ATEMP1)

#define READ_AND_SET_DTEMP1						\
%NEWLINE%	movl	DTEMP1,ATEMP1					\
%NEWLINE%	movl	IND(ATEMP1),DTEMP1				\
%NEWLINE%	movl	IMM(-1),IND(ATEMP1)

#define LOCK_ATEMP1(lab)						\
%NEWLINE%	movl	IND(ATEMP1),DTEMP1

#define LOCK_ATEMP2(lab)						\
%NEWLINE%	movl	IND(ATEMP2),DTEMP1

#define BTRANSFER(lab)							\
%NEWLINE%	movl	DTEMP1,ATEMP1					\
%NEWLINE%	lsrl	IMM(2),PVM1_REG					\
%NEWLINE%	subql	IMM(1),PVM1_REG					\
%NEWLINE%LBL(lab):							\
%NEWLINE%	movl	PINC(PVM0_REG),PINC(ATEMP1)			\
%NEWLINE%	DBRA(	PVM1_REG,lab)

#define LOG(x,lab)
#define PREV_LOG(x,lab)

#endif


/* Define SYNCHRONOUS_STEAL if thief waits for reply from victim */

#define SYNCHRONOUS_STEAL


/* Define DETERMINE_IS_STRICT if 'determine!' should touch its second arg */

#define DETERMINE_IS_STRICT


/*---------------------------------------------------------------------------*/

/* file: "_kernel.s" */

/*-----------------------------------------------------------------------------

GAMBIT kernel.

This file should be assembled with 'AS' to produce '_kernel.O'.
'kernel.O' is the first object file to be loaded into the system.  The
first object in the file (which must be a procedure) is responsible
for setting up the runtime context and running all the other modules
that were loaded.  This procedure is special because it uses the C
calling convention.

-----------------------------------------------------------------------------*/

#define PVM0_REG        REG(a0)
#define PVM1_REG        REG(d1)
#define PVM2_REG        REG(d2)
#define PVM3_REG        REG(d3)
#define PVM4_REG        REG(d4)
#define CLOSURE_REG     REG(d4)
#define INTR_TIMER_REG  REG(d5)
#define NULL_REG        REG(d6)
#define PLACEHOLDER_REG REG(d6)
#define FALSE_REG       REG(d7)
#define PAIR_REG        REG(d7)

#define DTEMP1          REG(d0)
#define ATEMP1          REG(a1)
#define ATEMP2          REG(a2)

#define HEAP_REG        REG(a3)
#define LTQ_TAIL_REG    REG(a4)
#define PSTATE_REG      REG(a5)
#define TABLE_REG       REG(a6)
#define SP              REG(a7)

/*---------------------------------------------------------------------------*/

OBJECT_FILE_BEGIN
	WORD	OFILE_VERSION_MAJOR
	WORD	OFILE_VERSION_MINOR

/*---------------------------------------------------------------------------*/

/*

*** This procedure is called from C as in:
***
*** kernel_startup( table, pstate, os_M68881 );

*/

#undef LBL
#define LBL(x)MAKE_LBL(00,x)

BEGIN("###_kernel")

	movl	CONST(0),PVM0_REG	/* jump to #_kernel.startup */
	jmp	IND(PVM0_REG)

	SET(C_A5,6)
	SET(C_A6,10)
	SET(C_SP,14)

	LONG	0	/* C's A5 register */
	LONG	0	/* C's A6 register */
	LONG	0	/* C's stack ptr */

CONSTS(1)
PRIMITIVE("###_kernel.startup")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(01,x)

BEGIN("###_kernel.trap_0")

/* global_jump */

	movl	IMM(SCM_false),FALSE_REG /* d7 was clobbered so restore it */

	movw	DTEMP1,PDEC(SP)		/* save argument count temporarily */
	movl	ATEMP1,DTEMP1

	addl	IMM((MAX_NB_GLOBALS*2)+(NB_TRAPS*8-0x8000)),DTEMP1
	subl	TABLE_REG,DTEMP1
	asll	IMM(2),DTEMP1
	addl	TABLE_REG,DTEMP1
	subl	IMM((MAX_NB_GLOBALS*10)+(NB_TRAPS*8-0x8000)),DTEMP1

	movl	DTEMP1,ATEMP1
	movl	PINC(ATEMP1),DTEMP1

	movl	DTEMP1,ATEMP2
	addql	IMM(SCM_type_PAIR-SCM_type_PROCEDURE),DTEMP1
	btst	DTEMP1,PAIR_REG
	BNES(	not_a_proc)

	movl	ATEMP2,IND(ATEMP1)	/* replace trap adr by procedure adr */
	movw	PINC(SP),DTEMP1		/* restore argument count and set flags */
	jmp	IND(ATEMP2)		/* jump to procedure */

LBL(not_a_proc):
	subql	IMM(4),ATEMP1		/* compute 'global variable index' */
	addl	IMM((MAX_NB_GLOBALS*10)+(NB_TRAPS*8-0x8000)),ATEMP1
	subl	TABLE_REG,ATEMP1

	MOVE_ARGS_TO_STACK(PINC(SP))

/* make room for 'global variable index' argument */

	movw	DTEMP1,PVM1_REG
	movl	SP,ATEMP2
	subql	IMM(4),SP
	BRAS(	loop_entry)
LBL(loop):
	movl	PINC(ATEMP2),DISP(ATEMP2,-8)
LBL(loop_entry):
	DBRA(	PVM1_REG,loop)

	movl	ATEMP1,DISP(ATEMP2,-4)
	addqw	IMM(1),DTEMP1

	movl	CONST(0),ATEMP1	/* apply ##exception.global-jump */
	movl	CONST(1),ATEMP2
	jmp	IND(ATEMP2)

CONSTS(2)
PRIMITIVE("##exception.global-jump")
PRIMITIVE("###_kernel.apply")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(02,x)

BEGIN("###_kernel.trap_1")

/* touch d0 */

	movl	DTEMP1,ATEMP2

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

LBL(touch):
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),DTEMP1
	CMPL(	ATEMP2,DTEMP1)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

#ifdef DETERMINE_IS_STRICT

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
LBL(determined):

#else

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	DTEMP1,PLACEHOLDER_REG
	BNES(	touched)
	movl	DTEMP1,ATEMP2
	BRAS(	touch)
LBL(touched):

#endif

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(03,x)

BEGIN("###_kernel.trap_2")

/* touch d1 */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

LBL(touch):
	movl	PVM1_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM1_REG
	CMPL(	ATEMP2,PVM1_REG)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

#ifdef DETERMINE_IS_STRICT

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
LBL(determined):

#else

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	PVM1_REG,PLACEHOLDER_REG
	BEQS(	touch)

#endif

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(04,x)

BEGIN("###_kernel.trap_3")

/* touch d2 */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

LBL(touch):
	movl	PVM2_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM2_REG
	CMPL(	ATEMP2,PVM2_REG)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

#ifdef DETERMINE_IS_STRICT

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
LBL(determined):

#else

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	PVM2_REG,PLACEHOLDER_REG
	BEQS(	touch)

#endif

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(05,x)

BEGIN("###_kernel.trap_4")

/* touch d3 */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

LBL(touch):
	movl	PVM3_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM3_REG
	CMPL(	ATEMP2,PVM3_REG)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

#ifdef DETERMINE_IS_STRICT

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
LBL(determined):

#else

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	PVM3_REG,PLACEHOLDER_REG
	BEQS(	touch)

#endif

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(06,x)

BEGIN("###_kernel.trap_5")

/* touch d4 */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

LBL(touch):
	movl	PVM4_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM4_REG
	CMPL(	ATEMP2,PVM4_REG)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

#ifdef DETERMINE_IS_STRICT

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
LBL(determined):

#else

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	PVM4_REG,PLACEHOLDER_REG
	BEQS(	touch)

#endif

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(07,x)

BEGIN("###_kernel.trap_6")

/* non_proc_jump */

	MOVE_ARGS_TO_STACK(DTEMP1)

/* make room for 'procedure' argument */

	movw	DTEMP1,PVM1_REG
	movl	SP,ATEMP2
	subql	IMM(4),SP
	BRAS(	loop_entry)
LBL(loop):
	movl	PINC(ATEMP2),DISP(ATEMP2,-8)
LBL(loop_entry):
	DBRA(	PVM1_REG,loop)

	movl	ATEMP1,DISP(ATEMP2,-4)	/* put 'procedure' argument */
	addqw	IMM(1),DTEMP1

	movl	CONST(0),ATEMP1	/* apply ##exception.non-proc-jump */
	movl	CONST(1),ATEMP2
	jmp	IND(ATEMP2)

CONSTS(2)
PRIMITIVE("##exception.non-proc-jump")
PRIMITIVE("###_kernel.apply")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(08,x)

BEGIN("###_kernel.trap_7")

/* rest_params */

	movl	PINC(SP),ATEMP1

	MOVE_ARGS_TO_STACK(DTEMP1)

/* we know that nb-args < min or nb-args >= nb-parms */

	CMPW(	IND(ATEMP1),DTEMP1)	/* nb-args < min ? */
	BLTS(	too_few_args)

/* build rest parameter */

	movl	NULL_REG,PVM1_REG	/* PVM1_REG = () */
	subw	DISP(ATEMP1,2),DTEMP1	/* DTEMP1 = nb of extra args */
	subqw	IMM(1),DTEMP1

LBL(next_arg):
	movl	PINC(SP),PDEC(HEAP_REG)	/* cons up the rest parameter list */
	movl	PVM1_REG,PDEC(HEAP_REG)	/* NOTE: no overflow possible due to */
	movl	HEAP_REG,PVM1_REG	/* limit on number of arguments */
	addql	IMM(4),PVM1_REG
	DBRA(	DTEMP1,next_arg)

	movw	DISP(ATEMP1,2),DTEMP1	/* get nb_parms-1 */
	BEQS(	return_parms)		/* if 1 parm, parms are ok */
	movl	PVM1_REG,PVM2_REG	/* else, must shuffle parameters */
	subqw	IMM(1),DTEMP1
	BEQS(	setup_parm1)		/* if 2 parms, only 1 parm to move */
	movl	PVM1_REG,PVM3_REG	/* rest parameter is in reg(3) */
	movl	PINC(SP),PVM2_REG	/* next to last parameter in reg(2) */

LBL(setup_parm1):
	movl	PINC(SP),PVM1_REG

LBL(return_parms):
	jmp	DISP(ATEMP1,6)		/* return from trap */

/* signal error */

LBL(too_few_args):
	addql	IMM(4),ATEMP1
	movw	IND(ATEMP1),PVM1_REG
	extl	PVM1_REG
	addl	PVM1_REG,ATEMP1

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(09,x)

BEGIN("###_kernel.trap_8")

/* rest_params_closed */

	movl	PINC(SP),ATEMP1

	MOVE_ARGS_TO_STACK(DTEMP1)

/* we know that nb-args < min or nb-args >= nb-parms */

	CMPW(	IND(ATEMP1),DTEMP1)	/* nb-args < min ? */
	BLTS(	too_few_args)

/* build rest parameter */

	movl	NULL_REG,PVM1_REG	/* PVM1_REG = () */
	subw	DISP(ATEMP1,2),DTEMP1	/* DTEMP1 = nb of extra args */
	subqw	IMM(1),DTEMP1

LBL(next_arg):
	movl	PINC(SP),PDEC(HEAP_REG)	/* cons up the rest parameter list */
	movl	PVM1_REG,PDEC(HEAP_REG)	/* NOTE: no overflow possible due to */
	movl	HEAP_REG,PVM1_REG	/* limit on number of arguments */
	addql	IMM(4),PVM1_REG
	DBRA(	DTEMP1,next_arg)

	movw	DISP(ATEMP1,2),DTEMP1	/* get nb_parms-1 */
	BEQS(	return_parms)		/* if 1 parm, parms are ok */
	movl	PVM1_REG,PVM2_REG	/* else, must shuffle parameters */
	subqw	IMM(1),DTEMP1
	BEQS(	setup_parm1)		/* if 2 parms, only 1 parm to move */
	movl	PVM1_REG,PVM3_REG	/* rest parameter is in reg(3) */
	movl	PINC(SP),PVM2_REG	/* next to last parameter in reg(2) */

LBL(setup_parm1):
	movl	PINC(SP),PVM1_REG

LBL(return_parms):
	jmp	DISP(ATEMP1,4)		/* return from trap */

/* signal error */

LBL(too_few_args):
	movl	PVM4_REG,ATEMP1

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(10,x)

BEGIN("###_kernel.trap_9")

/* wrong_nb_arg1 */

	movl	DTEMP1,ATEMP2

	movl	PINC(SP),ATEMP1		/* get pointer to procedure */
	addql	IMM(2),ATEMP1
	movw	IND(ATEMP1),DTEMP1
	extl	DTEMP1
	addl	DTEMP1,ATEMP1

	MOVE_ARGS_TO_STACK(ATEMP2)

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(11,x)

BEGIN("###_kernel.trap_10")

/* wrong_nb_arg1_closed */

	movl	CLOSURE_REG,ATEMP1
	addql	IMM(4),SP		/* discard trap address */

	MOVE_ARGS_TO_STACK(DTEMP1)

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(12,x)

BEGIN("###_kernel.trap_11")

/* wrong_nb_arg2 */

	movl	DTEMP1,ATEMP2

	movl	PINC(SP),ATEMP1		/* get pointer to procedure */
	addql	IMM(4),ATEMP1
	movw	IND(ATEMP1),DTEMP1
	extl	DTEMP1
	addl	DTEMP1,ATEMP1

	MOVE_ARGS_TO_STACK(ATEMP2)

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(13,x)

BEGIN("###_kernel.trap_12")

/* wrong_nb_arg2_closed */

	movl	CLOSURE_REG,ATEMP1
	addql	IMM(4),SP		/* discard trap address */

	MOVE_ARGS_TO_STACK(DTEMP1)

	movl	CONST(0),ATEMP2	/* jump to ###_kernel.wrong-nb-arg */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.wrong-nb-arg")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(14,x)

BEGIN("###_kernel.trap_13")

/* heap_alloc1 */

	moveq	IMM(0),DTEMP1

	movl	CONST(0),ATEMP2		/* jump to ###_kernel.trap_14 */
	jmp	IND(ATEMP2)

CONSTS(1)
PRIMITIVE("###_kernel.trap_14")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(15,x)

BEGIN("###_kernel.trap_14")

/* heap_alloc2 */

	addl	DTEMP1,HEAP_REG		/* restore correct heap ptr */
	movl	DTEMP1,ATEMP2

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PDEC(SP)

	movl	PVM0_REG,PDEC(SP)
	movl	PVM1_REG,PDEC(SP)
	movl	PVM2_REG,PDEC(SP)
	movl	PVM3_REG,PDEC(SP)
	movl	PVM4_REG,PDEC(SP)
	movl	ATEMP2,PDEC(SP)
	BRAS(	gc_and_allocate)

RETURN(gc_and_allocate,7,1):

	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1	/* jump to ##gc */
	moveq	IMM(1),DTEMP1	/* passing 0 argument */
	jmp	IND(ATEMP1)
RETURN(ret,7,1):

/* Is there a heap overflow with the current heap margin? */

	movl	PINC(SP),DTEMP1

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space and check heap overflow */
	BCSS(	overflow_on_alloc)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG)
	BCCS(	allocated)
LBL(overflow_on_alloc):
	addl	DTEMP1,HEAP_REG	/* restore correct heap ptr */
	movl	DTEMP1,PDEC(SP)

LBL(overflow):

/* Then use a smaller heap margin and signal a heap overflow */

	movl	DISP(PSTATE_REG,SLOT(HEAP_MARGIN)),DTEMP1
	BEQS(	fatal_overflow)

	subl	DTEMP1,DISP(PSTATE_REG,SLOT(HEAP_LIM))
	moveq	IMM(0),DTEMP1
	movl	DTEMP1,DISP(PSTATE_REG,SLOT(HEAP_MARGIN))

/* continuation must be discarded... */

	RESET_STACK

	movl	CONST(2),PVM0_REG

	movl	CONST(1),ATEMP1	/* jump to ##exception.heap-overflow proc */
	moveq	IMM(1),DTEMP1	/* passing 0 argument */
	jmp	IND(ATEMP1)

LBL(fatal_overflow):

	RESET_STACK

	movl	CONST(2),PVM0_REG

	movl	CONST(3),ATEMP1
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)

LBL(allocated):

/* Check to see if we can grow the heap margin */

	movl	DISP(PSTATE_REG,SLOT(HEAP_LIM)),DTEMP1
	subl	DISP(PSTATE_REG,SLOT(HEAP_MARGIN)),DTEMP1
	addl	DISP(PSTATE_REG,SLOT(HEAP_MAX_MARGIN)),DTEMP1
	CMPL(	DTEMP1,HEAP_REG)
	BCSS(	cant_grow)

	movl	DTEMP1,DISP(PSTATE_REG,SLOT(HEAP_LIM))
	movl	DISP(PSTATE_REG,SLOT(HEAP_MAX_MARGIN)),DISP(PSTATE_REG,SLOT(HEAP_MARGIN))

LBL(cant_grow):
	movl	PINC(SP),PVM4_REG
	movl	PINC(SP),PVM3_REG
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM0_REG
	rts

CONSTS(4)
PRIMITIVE("##gc")
PRIMITIVE("##exception.heap-overflow")
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("##fatal-heap-overflow")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(16,x)

BEGIN("###_kernel.trap_15")

/* closure_alloc */

	movl	DTEMP1,ATEMP2

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PDEC(SP)

	movl	ATEMP2,DTEMP1
	movl	DTEMP1,PDEC(SP)

	addl	IMM(CLOSURE_BLOCK_LENGTH+CACHE_LINE_LENGTH),DTEMP1
	subl	DTEMP1,HEAP_REG
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG) /* heap overflow */
	BCCS(	ok)

	TRAP(heap_alloc2_trap,alloc,2,1)

LBL(ok):
	movl	HEAP_REG,DTEMP1
	addl	IMM(CACHE_LINE_LENGTH),DTEMP1
	andw	IMM(-CACHE_LINE_LENGTH),DTEMP1
	movl	DTEMP1,ATEMP1
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(CLOSURE_LIM))
	addl	IMM(CLOSURE_BLOCK_LENGTH),ATEMP1
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(CLOSURE_PTR))

	addl	PINC(SP),ATEMP1

/* init closure block: */

	movl	IMM(0x80080000+JSR_OP),DTEMP1
	lea	PC_IND(closure_trampoline),ATEMP2
	BRAS(	loop_entry)
LBL(loop):
	subql	IMM(CACHE_LINE_LENGTH-8),ATEMP1
	movl	ATEMP2,PDEC(ATEMP1)
	movl	DTEMP1,PDEC(ATEMP1)
LBL(loop_entry):
	CMPL(	ATEMP1,HEAP_REG)
	BLTS(	loop)

	movl	DISP(PSTATE_REG,SLOT(FLUSH_WRITES)),PDEC(SP)
	jsr	DISP(TABLE_REG,TRAP_OFFS(C_TRAP_trap))

	movl	DISP(PSTATE_REG,SLOT(CLOSURE_PTR)),ATEMP2

	rts

LBL(closure_trampoline):
	movl	IND(SP),ATEMP1
	movl	PDEC(ATEMP1),ATEMP1
	jmp	IND(ATEMP1)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(17,x)

BEGIN("###_kernel.trap_16")

/* delay_future */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

/* Allocate special "DELAY" frame. */

	moveq	IMM(0),DTEMP1
	movw	DISP(PVM0_REG,-6),DTEMP1	/* get fs */
	addql	IMM(8),DTEMP1
	addw	IMM(11+PH_SIZE*4),DTEMP1
	andw	IMM(-8),DTEMP1
	subl	DTEMP1,HEAP_REG

/* Check need to GC. */

	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG)
	BCCS(	space_allocated)
LBL(gc_needed):
	movl	PVM0_REG,PDEC(SP)
	TRAP(heap_alloc2_trap,alloc,1,1)
	movl	PINC(SP),PVM0_REG

LBL(space_allocated):
	addw	IMM(PH_SIZE*4),HEAP_REG

	moveq	IMM(0),DTEMP1
	movw	DISP(PVM0_REG,-6),DTEMP1
	addql	IMM(8),DTEMP1
	asll	IMM(8),DTEMP1
	movb	IMM(SCM_subtype_VECTOR*8),DTEMP1
	movl	DTEMP1,IND(HEAP_REG)

/* Copy the frame. */

	lsrl	IMM(8),DTEMP1
	lsrl	IMM(2),DTEMP1
	subql	IMM(3),DTEMP1

	moveq	IMM(0),PVM1_REG
	movw	DISP(PVM0_REG,-4),PVM1_REG	/* get link */
	movl	INXW(SP,PVM1_REG,0),ATEMP2
	asll	IMM(1),PVM1_REG

	lea	DISP(HEAP_REG,SLOT(1)),ATEMP1
	movl	PVM0_REG,PINC(ATEMP1)
	movl	PVM1_REG,PINC(ATEMP1)
LBL(copy_loop):
	movl	PINC(SP),PINC(ATEMP1)
	DBRA(	DTEMP1,copy_loop)

/* Make placeholder. */

	lea	DISP(HEAP_REG,SCM_type_SUBTYPED),ATEMP1
	movl	FALSE_REG,PDEC(HEAP_REG)
	movl	ATEMP1,PDEC(HEAP_REG)
	movl	NULL_REG,PDEC(HEAP_REG)
	lea	DISP(HEAP_REG,SCM_type_PLACEHOLDER-4),ATEMP1
	movl	ATEMP1,PDEC(HEAP_REG)

/* Return placeholder. */

	movl	ATEMP1,PVM1_REG

	jmp	IND(ATEMP2)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(18,x)

BEGIN("###_kernel.trap_17")

/* eager_future */

	GET_TRAP_RETURN(0)
	movl	DTEMP1,PVM0_REG

/* Add a lazy future frame below current frame */

	moveq	IMM(0),DTEMP1
	movw	DISP(PVM0_REG,-4),DTEMP1	/* get link */
	movl	INXW(SP,DTEMP1,0),ATEMP1
	lea	PC_IND(ret),ATEMP2
	movl	ATEMP2,INXW(SP,DTEMP1,0)

	movw	DISP(PVM0_REG,-6),DTEMP1	/* get fs */
	asrw	IMM(2),DTEMP1
	movl	SP,ATEMP2
	subql	IMM(8),SP
	subqw	IMM(1),DTEMP1
LBL(loop):
	movl	PINC(ATEMP2),DISP(ATEMP2,-12)
	DBRA(	DTEMP1,loop)

	movl	ATEMP1,PDEC(ATEMP2)
	lea	PC_IND(ret),ATEMP1
	movl	ATEMP1,PDEC(ATEMP2)

	movl	ATEMP2,PDEC(LTQ_TAIL_REG)

/* Call ###_kernel.preempt */

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)

RETURN_LAZY(ret,100,2,1):
	WORD	ADDQL_4_A4

	addql	IMM(4),SP
	rts

CONSTS(1)
PRIMITIVE("###_kernel.preempt")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(19,x)

BEGIN("###_kernel.trap_18")

	BRAS(	$entry)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(20,x)

BEGIN("###_kernel.trap_19")

	BRAS(	$entry)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(21,x)

BEGIN("###_kernel.trap_20")

	BRAS(	$entry)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(22,x)

BEGIN("###_kernel.trap_21")

	BRAS(	$entry)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(23,x)

BEGIN("###_kernel.trap_22")

/* C_TRAP */

	movl	REG(a4),PDEC(SP)
	movl	REG(a3),PDEC(SP)
	movl	REG(a2),PDEC(SP)
	movl	REG(a1),PDEC(SP)
	movl	REG(a0),PDEC(SP)
	movl	DISP(SP,4+SLOT(5)),REG(a0)
	movl	REG(d7),PDEC(SP)
	movl	REG(d6),PDEC(SP)
	movl	REG(d5),PDEC(SP)
	movl	REG(d4),PDEC(SP)
	movl	REG(d3),PDEC(SP)
	movl	REG(d2),PDEC(SP)
	movl	REG(d1),PDEC(SP)
	movl	REG(d0),PDEC(SP)

	movl	SP,DISP(PSTATE_REG,SLOT(STACK_PTR))

	movl	CONST(0),REG(a2)
	movl	DISP(REG(a2),C_A5),REG(a5)	/* restore C's registers */
	movl	DISP(REG(a2),C_A6),REG(a6)
	movl	DISP(REG(a2),C_SP),SP

	jsr	IND(REG(a0))			/* call C procedure */

	movl	CONST(0),REG(a2)
	movl	DISP(REG(a2),C_SP),ATEMP1	/* get TABLE_REG & PSTATE_REG */
	movl	DISP(ATEMP1,4),TABLE_REG	/* restore Scheme context */
	movl	DISP(ATEMP1,8),PSTATE_REG

	movl	DISP(PSTATE_REG,SLOT(STACK_PTR)),SP

	movl	PINC(SP),REG(d0)
	movl	PINC(SP),REG(d1)
	movl	PINC(SP),REG(d2)
	movl	PINC(SP),REG(d3)
	movl	PINC(SP),REG(d4)
	movl	PINC(SP),REG(d5)
	movl	PINC(SP),REG(d6)
	movl	PINC(SP),REG(d7)
	movl	PINC(SP),REG(a0)
	movl	PINC(SP),REG(a1)
	movl	PINC(SP),REG(a2)
	movl	PINC(SP),REG(a3)
	movl	PINC(SP),REG(a4)

	movl	PINC(SP),IND(SP)

	rts

CONSTS(1)
PRIMITIVE("###_kernel")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(24,x)

BEGIN("###_kernel.trap_23")

/* C_CALL */

	movl	CONST(0),REG(a2)
	movl	DISP(REG(a2),C_SP),ATEMP2

	movl	IMM(SCM_marker),PDEC(ATEMP2)

	tstw	DTEMP1
	BMIS(	passed_1arg)
	BEQS(	passed_2args)

	subqw	IMM(3),DTEMP1
	BMIS(	move_remaining_args)

	movl	PVM3_REG,PDEC(ATEMP2)
	subqw	IMM(1),DTEMP1
LBL(passed_2args):
	movl	PVM2_REG,PDEC(ATEMP2)
	subqw	IMM(1),DTEMP1
LBL(passed_1arg):
	movl	PVM1_REG,PDEC(ATEMP2)
	subqw	IMM(1),DTEMP1

LBL(move_remaining_args):
	addqw	IMM(2),DTEMP1
	BRAS(	loop_entry)
LBL(loop):
	movl	PINC(SP),PDEC(ATEMP2)
LBL(loop_entry):
	DBRA(	DTEMP1,loop)

	movl	PVM0_REG,PDEC(SP)		/* save Scheme context */
	pea	PC_IND(default_return_proc)

	movl	SP,DISP(PSTATE_REG,SLOT(STACK_PTR))
	movl	LTQ_TAIL_REG,DISP(PSTATE_REG,SLOT(LTQ_TAIL))
	movl	HEAP_REG,DISP(PSTATE_REG,SLOT(HEAP_PTR))

	movl	ATEMP2,SP

	movl	ATEMP1,ATEMP2

	LOG(EVENT_C_CALL,log1)

	movl	CONST(0),REG(a1)
	movl	DISP(REG(a1),C_A5),REG(a5)	/* restore C's registers */
	movl	DISP(REG(a1),C_A6),REG(a6)

	jsr	IND(ATEMP2)			/* call C procedure */

	movl	DTEMP1,PVM1_REG			/* get result */

	movl	CONST(0),REG(a2)
	movl	DISP(REG(a2),C_SP),ATEMP1	/* get TABLE_REG & PSTATE_REG */
	movl	DISP(ATEMP1,4),TABLE_REG	/* restore Scheme context */
	movl	DISP(ATEMP1,8),PSTATE_REG
	movl	DISP(PSTATE_REG,SLOT(STACK_PTR)),SP
	movl	DISP(PSTATE_REG,SLOT(HEAP_PTR)),HEAP_REG
	movl	DISP(PSTATE_REG,SLOT(LTQ_TAIL)),LTQ_TAIL_REG

	moveq	IMM(0),INTR_TIMER_REG		/* check interrupts as soon as possible */
	movl	IMM(SCM_null),NULL_REG
	movl	IMM(SCM_false),FALSE_REG

	moveq	IMM(0),PVM2_REG
	moveq	IMM(0),PVM3_REG
	moveq	IMM(0),PVM4_REG

	PREV_LOG(2,log2)

	movl	PINC(SP),ATEMP1
	movl	PINC(SP),PVM0_REG
	moveq	IMM(-1),DTEMP1
	jmp	IND(ATEMP1)

SUBPROC(default_return_proc):
	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(25,x)

BEGIN("###_kernel.interrupt")

/* intr */

	GET_TRAP_RET(0)
	movl	DTEMP1,ATEMP1

/* Clear interrupt flag. */

	movl	DISP(PSTATE_REG,SLOT(STACK_LIM)),IND(PSTATE_REG)

/* Check if steal request. */

	movl	DISP(PSTATE_REG,SLOT(INTR_STEAL)),DTEMP1
	BEQS(	not_steal)

/* Check if anything to steal. */

	CMPL(	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),LTQ_TAIL_REG)
	BNES(	steal)

#ifdef SYNCHRONOUS_STEAL
	movl	DTEMP1,ATEMP2
	clrl	DISP(ATEMP2,SLOT(STEAL_TASK))
#endif
	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
	clrl	DISP(PSTATE_REG,SLOT(LTQ_WORK))

LBL(not_steal):
	CMPL(	DISP(PSTATE_REG,SLOT(STACK_LIM)),SP)
	BCSW(	check_other_intrs1)

	movl	DISP(PSTATE_REG,SLOT(INTR_OTHER)),DTEMP1
	BNEW(	check_other_intrs1)

LBL(quick_return):
	jmp	DISP(ATEMP1,SCM_type_PROCEDURE)

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

LBL(steal):
	movl	DTEMP1,ATEMP2
	pea	DISP(ATEMP1,SCM_type_PROCEDURE)

	LOG(EVENT_STEALING,log1)

	movl	PVM0_REG,PDEC(SP)
	movl	PVM1_REG,PDEC(SP)
	movl	PVM2_REG,PDEC(SP)
	movl	PVM3_REG,PDEC(SP)
	movl	PVM4_REG,PDEC(SP)

	movl	ATEMP2,PVM4_REG
	movl	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),ATEMP1

	movl	IND(ATEMP1),DTEMP1
	subl	IND(LTQ_TAIL_REG),DTEMP1
	addl	IMM((TASK_SIZE+1)+(PH_SIZE*2)+4),DTEMP1
	asll	IMM(2),DTEMP1

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for frames and check heap */
	BCSS(	gc_needed)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG) /* overflow */
	BCCS(	space_allocated)
LBL(gc_needed):

	movl	DTEMP1,PDEC(SP)
	PREV_LOG(2,log2)
	TRAP(heap_alloc2_trap,alloc,7,1)

/* Check if there is still something to steal. */

	CMPL(	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),LTQ_TAIL_REG)
	BNES(	task_still_available)
	movl	PVM4_REG,ATEMP1
#ifdef SYNCHRONOUS_STEAL
	clrl	DISP(ATEMP1,SLOT(STEAL_TASK))
#endif
	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
	addql	IMM(4),SP
	BRAS(	check_other_intrs2)

LBL(task_still_available):
	LOG(EVENT_STEALING,log3)
	movl	PINC(SP),DTEMP1

LBL(space_allocated):
	addl	DTEMP1,HEAP_REG

/* At this point, we know that there is at least one task on the LTQ and */
/* that there is enough free space on the heap to copy the frames.       */

/* Transfer one task to workq. */

	movl	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),ATEMP1
	movl	IND(ATEMP1),PVM3_REG
	pea	PC_IND(task_transferred)
	movl	CONST(1),ATEMP2
	jmp	IND(ATEMP2)
LBL(task_transferred):
	moveq	IMM(0),PVM1_REG
	movl	PVM1_REG,PVM0_REG
	movl	PVM1_REG,PVM3_REG

	PREV_LOG(2,log4)

	BRAS(	check_other_intrs2)

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

LBL(check_other_intrs1):
	pea	DISP(ATEMP1,SCM_type_PROCEDURE)
	movl	PVM0_REG,PDEC(SP)
	movl	PVM1_REG,PDEC(SP)
	movl	PVM2_REG,PDEC(SP)
	movl	PVM3_REG,PDEC(SP)
	movl	PVM4_REG,PDEC(SP)

LBL(check_other_intrs2):
	clrl	DISP(PSTATE_REG,SLOT(INTR_OTHER))

/* Check if there was a stack overflow. */

	CMPL(	DISP(PSTATE_REG,SLOT(STACK_LIM)),SP)
	BCCS(	stack_checked)

	moveq	IMM(0),DTEMP1
	movl	DTEMP1,DISP(PSTATE_REG,SLOT(STACK_MARGIN))

	movl	DISP(PSTATE_REG,SLOT(STACK_BOT)),DTEMP1
	addl	IMM(SLOT(STACK_ALLOCATION_FUDGE)),DTEMP1
	addl	DISP(PSTATE_REG,SLOT(STACK_MARGIN)),DTEMP1
	movl	DTEMP1,DISP(PSTATE_REG,SLOT(STACK_LIM))

	lea	PC_IND(ret1),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret1,6,1):

	movl	DISP(PSTATE_REG,SLOT(STACK_MAX_MARGIN)),DISP(PSTATE_REG,SLOT(STACK_MARGIN))

	movl	DISP(PSTATE_REG,SLOT(STACK_BOT)),DTEMP1
	addl	IMM(SLOT(STACK_ALLOCATION_FUDGE)),DTEMP1
	addl	DISP(PSTATE_REG,SLOT(STACK_MARGIN)),DTEMP1
	movl	DTEMP1,DISP(PSTATE_REG,SLOT(STACK_LIM))

LBL(stack_checked):

/* Check each of the interrupt flags in turn. */

	tstl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	BEQS(	ret2)
	clrl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	lea	PC_IND(ret2),PVM0_REG
	movl	CONST(2),ATEMP1	/* Call ##barrier */
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)
RETURN(ret2,6,1):

	tstl	DISP(PSTATE_REG,SLOT(INTR_TIMER))
	BEQS(	ret3)
	clrl	DISP(PSTATE_REG,SLOT(INTR_TIMER))
	lea	PC_IND(ret3),PVM0_REG
	movl	CONST(3),ATEMP1	/* Call ##exception.timer-interrupt */
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)
RETURN(ret3,6,1):

	tstl	DISP(PSTATE_REG,SLOT(INTR_USER))
	BEQS(	ret4)
	clrl	DISP(PSTATE_REG,SLOT(INTR_USER))
	lea	PC_IND(ret4),PVM0_REG
	movl	CONST(4),ATEMP1	/* Call ##exception.user-interrupt */
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)
RETURN(ret4,6,1):

	movl	PINC(SP),PVM4_REG
	movl	PINC(SP),PVM3_REG
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM0_REG

	rts

CONSTS(5)
PRIMITIVE("###_kernel.flush-stack")
PRIMITIVE("###_kernel.transfer-task-from-ltq")
PRIMITIVE("##barrier")
PRIMITIVE("##exception.timer-interrupt")
PRIMITIVE("##exception.user-interrupt")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(26,x)

BEGIN("###_kernel.apply")

	tstw	DTEMP1			/* how many arguments to pass? */
	BEQS(	pass_0arg)
	subqw	IMM(2),DTEMP1
	BMIS(	pass_1arg)
	BEQS(	pass_2args)

	movl	PINC(SP),PVM3_REG
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	addqw	IMM(3),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with >= 3 args) */

LBL(pass_0arg):
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with no arg) */

LBL(pass_1arg):
	movl	PINC(SP),PVM1_REG
	moveq	IMM(-1),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with 1 arg) */

LBL(pass_2args):
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	moveq	IMM(0),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with 2 args) */

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(27,x)

BEGIN("###_kernel.wrong-nb-arg")

/* make room for 'procedure' argument */

	movw	DTEMP1,PVM1_REG
	movl	SP,ATEMP2
	subql	IMM(4),SP
	BRAS(	loop_entry)
LBL(loop):
	movl	PINC(ATEMP2),DISP(ATEMP2,-8)
LBL(loop_entry):
	DBRA(	PVM1_REG,loop)

	movl	ATEMP1,DISP(ATEMP2,-4)	/* put 'procedure' argument */
	addqw	IMM(1),DTEMP1

	movl	CONST(0),ATEMP1	/* apply ##exception.wrong-nb-arg */
	movl	CONST(1),ATEMP2
	jmp	IND(ATEMP2)

CONSTS(2)
PRIMITIVE("##exception.wrong-nb-arg")
PRIMITIVE("###_kernel.apply")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(28,x)

BEGIN("###_kernel.preempt")

	CMPL(	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),LTQ_TAIL_REG)
	BNES(	there_are_other_tasks)

	CMPL(	DISP(PSTATE_REG,SLOT(WORKQ_TAIL)),NULL_REG)
	BNES(	there_are_other_tasks)

	movl	IMM(SCM_true),PVM1_REG	/* no other tasks to switch to */
	jmp	IND(PVM0_REG)

LBL(there_are_other_tasks):

	LOG(EVENT_PREEMPT,log1)

	movl	PVM0_REG,PDEC(SP)

/* Call ###_kernel.transfer-all-tasks-from-ltq. */

	pea	PC_IND(ret1)
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret1,1,1):

/* Call ###_kernel.transfer-stack-to-heap. */

/* ###_kernel.transfer-all-tasks-from-ltq has reserved enough */
/* space, so no GC check required.                            */

	pea	PC_IND(ret2)
	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)
LBL(ret2):

/* Save state of current task. */

	movl	DISP(PSTATE_REG,SLOT(CURRENT_TASK)),ATEMP1

	movl	IND(SP),PVM0_REG
	movl	PVM0_REG,DISP(ATEMP1,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED)
	movl	PVM2_REG,DISP(ATEMP1,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED)
	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),DISP(ATEMP1,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED)
	movl	FALSE_REG,DISP(ATEMP1,SLOT(TASK_VALUE)+4-SCM_type_SUBTYPED)

#ifdef foo

	movl	FALSE_REG,DISP(ATEMP1,SLOT(TASK_LOCKO)+4-SCM_type_SUBTYPED)
LBL(lock_task):
	tstl	DISP(ATEMP1,SLOT(TASK_LOCKV)+4-SCM_type_SUBTYPED)
	BNES(	lock_task)

	clrl	DISP(ATEMP1,SLOT(TASK_STATUS)+4-SCM_type_SUBTYPED)

	clrl	DISP(ATEMP1,SLOT(TASK_LOCKO)+4-SCM_type_SUBTYPED)

#endif

/* Add task to workq. */

	movl	ATEMP1,PDEC(HEAP_REG)

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))
LBL(lock_workq):
	tstl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKV))
	BNES(	lock_workq)

	movl	DISP(PSTATE_REG,SLOT(WORKQ_TAIL)),ATEMP1
	CMPL(	ATEMP1,NULL_REG)
	BNES(	non_empty_queue)
	movl	HEAP_REG,DISP(PSTATE_REG,SLOT(WORKQ_HEAD))
	BRAS(	fix_tail)
LBL(non_empty_queue):
	movl	HEAP_REG,PDEC(ATEMP1)
LBL(fix_tail):
	movl	HEAP_REG,DISP(PSTATE_REG,SLOT(WORKQ_TAIL))

	movl	NULL_REG,PDEC(HEAP_REG)

	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

/* Go idle. */

	movl	CONST(2),ATEMP1
	jmp	IND(ATEMP1)

CONSTS(3)
PRIMITIVE("###_kernel.transfer-all-tasks-from-ltq")
PRIMITIVE("###_kernel.transfer-stack-to-heap")
PRIMITIVE("###_kernel.idle")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(29,x)

BEGIN("###_kernel.idle")

	LOG(EVENT_IDLE,log1)

	RESET_STACK

/* Try removing task from our own workq. */

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))
LBL(lock_workq1):
	tstl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKV))
	BNES(	lock_workq1)

	movl	DISP(PSTATE_REG,SLOT(WORKQ_HEAD)),ATEMP1
	CMPL(	ATEMP1,NULL_REG)
	BEQS(	empty_queue1)
	movl	PDEC(ATEMP1),ATEMP2
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(WORKQ_HEAD))
	CMPL(	ATEMP2,NULL_REG)
	BNES(	done1)
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(WORKQ_TAIL))
LBL(done1):

	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

/* Check if task is already running. */

	movl	DISP(ATEMP1,SLOT(1)),ATEMP1

#ifdef foo

	lea	DISP(ATEMP1,SLOT(TASK_LOCKV)+4-SCM_type_SUBTYPED),ATEMP1
LBL(lock_task):
	LOCK_ATEMP1(lock)
	tstl	DISP(ATEMP1,SLOT(TASK_LOCKO-TASK_LOCKV))
	BEQS(	task_locked)
	clrl	IND(ATEMP1)
	BRAS(	lock_task)

LBL(task_already_running):
	clrl	IND(ATEMP1)
	BRAS(	our_workq_empty)

LBL(task_locked):
	tstl	DISP(ATEMP1,SLOT(TASK_STATUS-TASK_LOCKV))
	BNES(	task_already_running)

	movl	PSTATE_REG,DISP(ATEMP1,SLOT(TASK_STATUS-TASK_LOCKV))
	clrl	IND(ATEMP1)

	lea	DISP(ATEMP1,-(SLOT(TASK_LOCKV)+4-SCM_type_SUBTYPED)),ATEMP1

#endif

	BRAW(	resume_task)

LBL(empty_queue1):
	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

LBL(our_workq_empty):

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(CURRENT_TASK))
	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))

#ifdef SYNCHRONOUS_STEAL

/* Prevent other processors from trying to steal from us. */

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(INTR_LOCKO))
LBL(lock_intr1):
	tstl	DISP(PSTATE_REG,SLOT(INTR_LOCKV))
	BNES(	lock_intr1)

	tstl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
	BEQS(	no_steal)
	movl	DISP(PSTATE_REG,SLOT(INTR_STEAL)),ATEMP1
	clrl	DISP(ATEMP1,SLOT(STEAL_TASK))
LBL(no_steal):

	movl	PSTATE_REG,DISP(PSTATE_REG,SLOT(INTR_STEAL))
	clrl	DISP(PSTATE_REG,SLOT(INTR_LOCKO))

#endif

LBL(try_to_steal_from_other_workq):
	movl	DISP(PSTATE_REG,SLOT(STEAL_SCAN)),PVM2_REG

LBL(setup_scan_ptr):
	lea	DISP(PSTATE_REG,SLOT(PS+MAX_NB_PROC)),ATEMP2
	addl	PVM2_REG,ATEMP2

LBL(next_processor):
	subql	IMM(4),PVM2_REG
	BLEW(	scan_done)

LBL(check_workq):
	movl	PDEC(ATEMP2),ATEMP1
	CMPL(	DISP(ATEMP1,SLOT(WORKQ_HEAD)),NULL_REG)
	BEQW(	empty_queue3)

	lea	DISP(ATEMP1,SLOT(WORKQ_LOCKV)),ATEMP1
LBL(lock_workq2):
	LOCK_ATEMP1(lock1)
	tstl	DISP(ATEMP1,SLOT(WORKQ_LOCKO-WORKQ_LOCKV))
	BEQS(	workq_locked)
	clrl	IND(ATEMP1)
	BRAS(	lock_workq2)
LBL(workq_locked):
	movl	DISP(ATEMP1,SLOT(WORKQ_HEAD-WORKQ_LOCKV)),PVM0_REG
	CMPL(	PVM0_REG,NULL_REG)
	BEQS(	empty_queue2)
	movl	PDEC(PVM0_REG),ATEMP2
	movl	ATEMP2,DISP(ATEMP1,SLOT(WORKQ_HEAD-WORKQ_LOCKV))
	CMPL(	ATEMP2,NULL_REG)
	BNES(	done2)
	movl	ATEMP2,DISP(ATEMP1,SLOT(WORKQ_TAIL-WORKQ_LOCKV))
LBL(done2):

	clrl	IND(ATEMP1)

	movl	PVM2_REG,DISP(PSTATE_REG,SLOT(STEAL_SCAN))

	movl	DISP(PVM0_REG,SLOT(1)),ATEMP1

#ifdef SYNCHRONOUS_STEAL
	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
#endif

LBL(resume_task):

/* Resume task. */

	movl	ATEMP1,DISP(PSTATE_REG,SLOT(CURRENT_TASK))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))
	movl	DISP(ATEMP1,SLOT(TASK_VALUE)+4-SCM_type_SUBTYPED),PVM1_REG

	movl	PVM1_REG,PVM0_REG
	movl	PVM1_REG,PVM2_REG
	movl	PVM1_REG,PVM3_REG
	movl	PVM1_REG,PVM4_REG

	LOG(EVENT_WORKING,log2)

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)

LBL(empty_queue2):
	clrl	IND(ATEMP1)
	lea	DISP(ATEMP1,-SLOT(WORKQ_LOCKV)),ATEMP1
LBL(empty_queue3):

/* Check if any work on LTQ. */

	tstl	DISP(ATEMP1,SLOT(LTQ_WORK))
	BEQW(	next_processor)

#ifdef SYNCHRONOUS_STEAL

/* Check if victim is in the process of responding to a steal. */

	tstl	DISP(ATEMP1,SLOT(INTR_STEAL))
	BNEW(	next_processor)

	lea	DISP(ATEMP1,SLOT(INTR_LOCKV)),ATEMP1
LBL(lock_intr2):
	LOCK_ATEMP1(lock2)
	tstl	DISP(ATEMP1,SLOT(INTR_LOCKO-INTR_LOCKV))
	BEQS(	intr_locked)
	clrl	IND(ATEMP1)
	BRAS(	lock_intr2)
LBL(intr_locked):
	tstl	DISP(ATEMP1,SLOT(INTR_STEAL-INTR_LOCKV))
	BEQS(	request_steal)
	clrl	IND(ATEMP1)

#else

	movl	PSTATE_REG,DISP(ATEMP1,SLOT(INTR_STEAL))
	movl	IMM(-1),IND(ATEMP1)

#endif

	BRAW(	next_processor)

/* Send steal message to victim. */

LBL(request_steal):
	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(STEAL_TASK))
	movl	PSTATE_REG,DISP(ATEMP1,SLOT(INTR_STEAL-INTR_LOCKV))
	clrl	IND(ATEMP1)
	lea	DISP(ATEMP1,-SLOT(INTR_LOCKV)),ATEMP1
	movl	IMM(-1),IND(ATEMP1)

/* Wait for response. */

	movl	PVM2_REG,DISP(PSTATE_REG,SLOT(STEAL_SCAN))

LBL(wait):
	tstl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	BEQS(	ret3)
	clrl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	lea	PC_IND(ret3),PVM0_REG
	movl	PVM0_REG,PVM1_REG
	movl	PVM0_REG,PVM2_REG
	movl	PVM0_REG,PVM3_REG
	movl	PVM0_REG,PVM4_REG
	movl	CONST(1),ATEMP1	/* Call ##barrier */
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)
RETURN(ret3,0,0):
	movl	DISP(PSTATE_REG,SLOT(STEAL_TASK)),ATEMP1
	CMPL(	ATEMP1,FALSE_REG)
	BEQS(	wait)

	movl	ATEMP1,DTEMP1
	BEQW(	try_to_steal_from_other_workq)

	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
	BRAW(	resume_task)

LBL(scan_done):
	movl	DISP(PSTATE_REG,SLOT(NB_PROCESSORS)),PVM2_REG
	asrl	IMM(1),PVM2_REG
	movl	PVM2_REG,DISP(PSTATE_REG,SLOT(STEAL_SCAN))

	tstl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	BEQS(	ret4)
	clrl	DISP(PSTATE_REG,SLOT(INTR_BARRIER))
	lea	PC_IND(ret4),PVM0_REG
	movl	PVM0_REG,PVM1_REG
	movl	PVM0_REG,PVM2_REG
	movl	PVM0_REG,PVM3_REG
	movl	PVM0_REG,PVM4_REG
	movl	CONST(1),ATEMP1	/* Call ##barrier */
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)
RETURN(ret4,0,0):

	BRAW(	try_to_steal_from_other_workq)

CONSTS(2)
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("##barrier")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(30,x)

BEGIN("###_kernel.determine!")

#ifdef DETERMINE_IS_STRICT
	btst	PVM2_REG,PLACEHOLDER_REG
	BNES(	touched)
	movl	PVM0_REG,PDEC(SP)
	movl	PVM1_REG,PDEC(SP)
	TRAP(TOUCH_trap+2,touch,2,1)
	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM0_REG
LBL(touched):
#endif

	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
	
CONSTS(1)
PRIMITIVE("###_kernel.non-strict-determine!")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(31,x)

BEGIN("###_kernel.non-strict-determine!")

	movl	PVM0_REG,PDEC(SP)

	LOG(EVENT_DETERMINE,log1)

	btst	PVM1_REG,PLACEHOLDER_REG
	BNES(	already_determined)

	movl	PVM1_REG,ATEMP2
	lea	DISP(ATEMP2,SLOT(PH_QUEUE)-SCM_type_PLACEHOLDER),ATEMP2

	LOCK_ATEMP2(lock1)

	CMPL(	DTEMP1,FALSE_REG)
	BNES(	undetermined)
	movl	DTEMP1,IND(ATEMP2)

LBL(already_determined):
	PREV_LOG(2,log2)
	movl	PINC(SP),PVM0_REG
	movl	CONST(0),ATEMP1	/* jump to ##exception.placeholder-already-determined */
	moveq	IMM(1),DTEMP1	/* passing 0 argument */
	jmp	IND(ATEMP1)

LBL(undetermined):
	movl	PVM2_REG,DISP(ATEMP2,SLOT(PH_VALUE-PH_QUEUE))

	movl	FALSE_REG,IND(ATEMP2)

/* DTEMP1 is list of tasks to restart. */

	btst	DTEMP1,PAIR_REG
	BNES(	tasks_restarted)

	movl	DTEMP1,PVM4_REG
LBL(next_task):
	movl	DTEMP1,ATEMP2

/* Setup task's return value. */

	movl	IND(ATEMP2),ATEMP1
	movl	PVM2_REG,DISP(ATEMP1,SLOT(TASK_VALUE)+4-SCM_type_SUBTYPED)

	movl	DISP(ATEMP2,SLOT(-1)),DTEMP1
	btst	DTEMP1,PAIR_REG
	BEQS(	next_task)

/* Add tasks to workq. */

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))
LBL(lock_workq):
	tstl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKV))
	BNES(	lock_workq)

	movl	DISP(PSTATE_REG,SLOT(WORKQ_TAIL)),ATEMP1
	CMPL(	ATEMP1,NULL_REG)
	BNES(	non_empty_queue)
	movl	PVM4_REG,DISP(PSTATE_REG,SLOT(WORKQ_HEAD))
	BRAS(	fix_tail)
LBL(non_empty_queue):
	movl	PVM4_REG,PDEC(ATEMP1)
LBL(fix_tail):
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(WORKQ_TAIL))

	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

LBL(tasks_restarted):
	movl	PVM2_REG,PVM1_REG
	movl	PVM2_REG,PVM4_REG
	movl	PINC(SP),PVM0_REG

	PREV_LOG(2,log3)

	jmp	IND(PVM0_REG)	

CONSTS(1)
PRIMITIVE("##exception.placeholder-already-determined")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(32,x)

BEGIN("###_kernel.determine!-then-idle")

	movl	PVM0_REG,PDEC(SP)

#ifdef DETERMINE_IS_STRICT
	btst	PVM2_REG,PLACEHOLDER_REG
	BNES(	touched)
	movl	PVM1_REG,PDEC(SP)
	TRAP(TOUCH_trap+2,touch,2,1)
	movl	PINC(SP),PVM1_REG
LBL(touched):
#endif

	LOG(EVENT_DETERMINE,log1)

	btst	PVM1_REG,PLACEHOLDER_REG
	BNES(	already_determined)

	movl	PVM1_REG,ATEMP2
	lea	DISP(ATEMP2,SLOT(PH_QUEUE)-SCM_type_PLACEHOLDER),ATEMP2

	LOCK_ATEMP2(lock1)

	CMPL(	DTEMP1,FALSE_REG)
	BNES(	undetermined)
	movl	DTEMP1,IND(ATEMP2)

LBL(already_determined):
	PREV_LOG(2,log2)
	movl	PINC(SP),PVM0_REG
	movl	CONST(2),ATEMP1	/* jump to ##exception.placeholder-already-determined */
	moveq	IMM(1),DTEMP1	/* passing 0 argument */
	jmp	IND(ATEMP1)

LBL(undetermined):
	movl	PINC(SP),PVM0_REG

	movl	PVM2_REG,DISP(ATEMP2,SLOT(PH_VALUE-PH_QUEUE))

	movl	FALSE_REG,IND(ATEMP2)

/* DTEMP1 is list of tasks to restart. */

	btst	DTEMP1,PAIR_REG
	BNES(	no_task_to_restart)

	movl	DTEMP1,ATEMP2
	movl	IND(ATEMP2),PVM3_REG
	movl	PDEC(ATEMP2),DTEMP1
	btst	DTEMP1,PAIR_REG
	BNES(	tasks_restarted)

	movl	DTEMP1,PVM4_REG
LBL(next_task):
	movl	DTEMP1,ATEMP2

/* Setup task's return value. */

	movl	IND(ATEMP2),ATEMP1
	movl	PVM2_REG,DISP(ATEMP1,SLOT(TASK_VALUE)+4-SCM_type_SUBTYPED)

	movl	DISP(ATEMP2,SLOT(-1)),DTEMP1
	btst	DTEMP1,PAIR_REG
	BEQS(	next_task)

/* Add tasks to workq. */

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))
LBL(lock_workq):
	tstl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKV))
	BNES(	lock_workq)

	movl	DISP(PSTATE_REG,SLOT(WORKQ_TAIL)),ATEMP1
	CMPL(	ATEMP1,NULL_REG)
	BNES(	non_empty_queue)
	movl	PVM4_REG,DISP(PSTATE_REG,SLOT(WORKQ_HEAD))
	BRAS(	fix_tail)
LBL(non_empty_queue):
	movl	PVM4_REG,PDEC(ATEMP1)
LBL(fix_tail):
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(WORKQ_TAIL))

	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

LBL(tasks_restarted):

/* Resume task. */

	movl	PVM3_REG,ATEMP1
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(CURRENT_TASK))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	DISP(ATEMP1,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))

	movl	PVM2_REG,PVM1_REG
	movl	PVM1_REG,PVM0_REG
	movl	PVM1_REG,PVM3_REG
	movl	PVM1_REG,PVM4_REG

	LOG(EVENT_WORKING,log3)

	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)

LBL(no_task_to_restart):
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)

CONSTS(3)
PRIMITIVE("###_kernel.idle")
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("##exception.placeholder-already-determined")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(33,x)

BEGIN("###_kernel.touch-undetermined-placeholder")

	movl	PVM0_REG,PDEC(SP)
	movl	ATEMP2,PVM4_REG

/* Check if the placeholder was generated by a DELAY. */

	tstl	DISP(ATEMP2,SLOT(PH_DELAY)-SCM_type_PLACEHOLDER)
	BEQS(	not_delay_ph2)

	lea	DISP(ATEMP2,SLOT(PH_QUEUE)-SCM_type_PLACEHOLDER),ATEMP2

	LOCK_ATEMP2(lock1)

	movl	DISP(ATEMP2,SLOT(PH_DELAY)-SLOT(PH_QUEUE)),PVM1_REG
	BEQS(	not_delay_ph1)

	clrl	DISP(ATEMP2,SLOT(PH_DELAY)-SLOT(PH_QUEUE))
	movl	DTEMP1,IND(ATEMP2)

	movl	PVM4_REG,PDEC(SP)

/* Restore delayed computation. */

	subql	IMM(SCM_type_SUBTYPED),PVM1_REG
	movl	PVM1_REG,ATEMP1

	movl	PINC(ATEMP1),DTEMP1
	lsrl	IMM(8),DTEMP1
	subql	IMM(8),DTEMP1
	subl	DTEMP1,SP
	lsrl	IMM(2),DTEMP1

	movl	PINC(ATEMP1),PVM0_REG
	movl	PINC(ATEMP1),PVM1_REG
	lsrl	IMM(1),PVM1_REG
	subql	IMM(1),DTEMP1
	movl	SP,ATEMP2
LBL(copy):
	movl	PINC(ATEMP1),PINC(ATEMP2)
	DBRA(	DTEMP1,copy)

	lea	PC_IND(ret1),ATEMP1
	movl	ATEMP1,INXW(SP,PVM1_REG,0)

	PREV_LOG(2,log1)

	movl	PVM2_REG,PVM1_REG
	jmp	IND(PVM0_REG)
RETURN(ret1,2,1):

	movl	PVM1_REG,PVM2_REG
	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM0_REG

	movl	CONST(4),ATEMP1	/* jump to ###_kernel.determine! */
	jmp	IND(ATEMP1)

LBL(not_delay_ph1):
	movl	DTEMP1,IND(ATEMP2)

LBL(not_delay_ph2):

/* Call ###_kernel.transfer-all-tasks-from-ltq. */

	pea	PC_IND(ret2)
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret2,2,1):

/* Call ###_kernel.transfer-stack-to-heap. */

/* ###_kernel.transfer-all-tasks-from-ltq has reserved enough */
/* space, so no GC check required.                            */

	pea	PC_IND(ret3)
	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)
LBL(ret3):

/* Save state of current task. */

	movl	DISP(PSTATE_REG,SLOT(CURRENT_TASK)),ATEMP1

	movl	IND(SP),PVM0_REG
	movl	PVM0_REG,DISP(ATEMP1,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED)
	movl	PVM2_REG,DISP(ATEMP1,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED)
	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),DISP(ATEMP1,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED)
	movl	FALSE_REG,DISP(ATEMP1,SLOT(TASK_VALUE)+4-SCM_type_SUBTYPED)

	movl	ATEMP1,PDEC(HEAP_REG)
	movl	HEAP_REG,PVM3_REG

/* Final check for determinedness. */

	btst	PVM4_REG,PLACEHOLDER_REG
	BNES(	already_determined)

	movl	PVM4_REG,ATEMP2
	lea	DISP(ATEMP2,SLOT(PH_QUEUE)-SCM_type_PLACEHOLDER),ATEMP2

	LOCK_ATEMP2(lock2)

	CMPL(	DTEMP1,FALSE_REG)
	BNES(	undetermined)

	movl	DTEMP1,IND(ATEMP2)
	movl	DISP(ATEMP2,SLOT(PH_VALUE-PH_QUEUE)),PVM4_REG

LBL(already_determined):
	addql	IMM(4),HEAP_REG

/* Resume task. */

	movl	DISP(PSTATE_REG,SLOT(CURRENT_TASK)),ATEMP2
	movl	DISP(ATEMP2,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	DISP(ATEMP2,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	DISP(ATEMP2,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED),DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))

	RESET_STACK

	movl	PVM4_REG,PVM0_REG
	movl	PVM4_REG,PVM1_REG
	movl	PVM4_REG,PVM2_REG
	movl	PVM4_REG,PVM3_REG

	PREV_LOG(2,log2)

	movl	CONST(3),ATEMP1
	jmp	IND(ATEMP1)

LBL(undetermined):
	movl	DTEMP1,PDEC(HEAP_REG)
	movl	PVM3_REG,IND(ATEMP2)

/* Go idle. */

	movl	CONST(2),ATEMP1
	jmp	IND(ATEMP1)

CONSTS(5)
PRIMITIVE("###_kernel.transfer-all-tasks-from-ltq")
PRIMITIVE("###_kernel.transfer-stack-to-heap")
PRIMITIVE("###_kernel.idle")
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("###_kernel.determine!")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(34,x)

BEGIN("###_kernel.transfer-task-from-ltq")

/* On entry:                                             */
/*   top of stack = exit address                         */
/*   PVM3_REG = stack base                               */
/*   ATEMP1 = LTQ_HEAD                                   */

/* On exit:                                              */
/*   PVM2_REG, PVM3_REG, PVM4_REG preserved              */
/*   PVM0_REG, PVM1_REG, DTEMP1, ATEMP1, ATEMP2 modified */

/* It is assumed that:                                                 */
/*   - there is at least one lazy task on the lazy task queue          */
/*   - no GC will be required (there is enough free space in the heap) */

/* First, we must decide how many lazy tasks will be grouped together */
/* to form the parent task.                                           */

	moveq	IMM(100),DTEMP1	/* total 'size' to grab */

	movl	PDEC(ATEMP1),ATEMP2
	movl	IND(ATEMP2),PVM0_REG
	subw	DISP(PVM0_REG,-8),DTEMP1
	BLSS(	found_split_point)
LBL(loop1):
	CMPL(	LTQ_TAIL_REG,ATEMP1)
	BEQS(	found_split_point)
	movl	PDEC(ATEMP1),ATEMP2
	movl	IND(ATEMP2),PVM0_REG
	subw	DISP(PVM0_REG,-8),DTEMP1
	BCCS(	loop1)
	addql	IMM(4),ATEMP1
	movl	IND(ATEMP1),ATEMP2
	movl	IND(ATEMP2),PVM0_REG
LBL(found_split_point):
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(LTQ_HEAD))

/* Now, we must replace the child's return address with the 'restore-parent' */
/* return address.  Because we don't really know where the return address    */
/* is (but we do know its value) we must scan the child's stack until we     */
/* have found the address.                                                   */

LBL(loop2):
	CMPL(	PDEC(ATEMP2),PVM0_REG)
	BNES(	loop2)

	movl	CONST(0),IND(ATEMP2)
	movl	IND(ATEMP1),ATEMP2

/* Next, we must find the dynamic environment of the parent. */

	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),PDEC(SP) /*guard*/
	movl	DISP(PSTATE_REG,SLOT(DEQ_TAIL)),PVM0_REG
	movl	SP,IND(PVM0_REG)

	movl	DISP(PSTATE_REG,SLOT(DEQ_HEAD)),PVM0_REG
LBL(loop3):
	CMPL(	PINC(PVM0_REG),ATEMP2)
	BCSS(	loop3)

	subql	IMM(4),PVM0_REG
	movl	PVM0_REG,DISP(PSTATE_REG,SLOT(DEQ_HEAD))

/* Setup parent task. */

	movl	DISP(PSTATE_REG,SLOT(TEMP_TASK)),ATEMP1
	movl	IND(PVM0_REG),PVM0_REG
	movl	IND(PVM0_REG),DISP(ATEMP1,SLOT(TASK_CONT_DYN_ENV)+4-SCM_type_SUBTYPED)
	movl	IND(ATEMP2),PVM0_REG
	movl	PVM0_REG,DISP(ATEMP1,SLOT(TASK_CONT_RET)+4-SCM_type_SUBTYPED)

	addql	IMM(4),SP

/* Allocate first frame of continuation. */

	ALLOC_FRAME

	clrl	DISP(HEAP_REG,SLOT(1))

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG

	movl	PVM1_REG,DISP(ATEMP1,SLOT(TASK_CONT_FRAME)+4-SCM_type_SUBTYPED)

/* Make child's continuation frame. */

	subql	IMM(4),HEAP_REG
	movl	PVM0_REG,PDEC(HEAP_REG)
	movl	ATEMP1,PDEC(HEAP_REG)
	movl	IMM(8),PDEC(HEAP_REG)
	movl	PVM1_REG,PDEC(HEAP_REG)
	movl	IMM(4*0x400+(SCM_subtype_FRAME*8)),PDEC(HEAP_REG)
	pea	DISP(HEAP_REG,SCM_type_SUBTYPED)

/* Check were parent task should go. */

	tstl	DISP(PSTATE_REG,SLOT(INTR_STEAL))

#ifdef SYNCHRONOUS_STEAL
	BNES(	give_to_thief)
#else
	BEQS(	intr_steal_reset)
	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
LBL(intr_steal_reset):
#endif

/* Add parent task to workq. */

	movl	DISP(HEAP_REG,SLOT(3)),PDEC(HEAP_REG)

	movl	FALSE_REG,DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))
LBL(lock_workq):
	tstl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKV))
	BNES(	lock_workq)

	movl	DISP(PSTATE_REG,SLOT(WORKQ_TAIL)),ATEMP1
	CMPL(	ATEMP1,NULL_REG)
	BNES(	non_empty_queue)
	movl	HEAP_REG,DISP(PSTATE_REG,SLOT(WORKQ_HEAD))
	BRAS(	fix_tail)
LBL(non_empty_queue):
	movl	HEAP_REG,PDEC(ATEMP1)
LBL(fix_tail):
	movl	HEAP_REG,DISP(PSTATE_REG,SLOT(WORKQ_TAIL))

	movl	NULL_REG,PDEC(HEAP_REG)

	clrl	DISP(PSTATE_REG,SLOT(WORKQ_LOCKO))

#ifdef SYNCHRONOUS_STEAL
	BRAS(	copy_other_frames)

/* Give task to thief processor. */

LBL(give_to_thief):
	movl	DISP(PSTATE_REG,SLOT(INTR_STEAL)),ATEMP1
	movl	DISP(HEAP_REG,SLOT(3)),DISP(ATEMP1,SLOT(STEAL_TASK))
	clrl	DISP(PSTATE_REG,SLOT(INTR_STEAL))
#endif

/* Copy other frames. */

LBL(copy_other_frames):
	movl	PVM1_REG,ATEMP1

LBL(next_frame):

/* DTEMP1=frame_header, PVM0_REG=ret, ATEMP2=stack_frame, ATEMP1=heap_frame */

	lsrl	IMM(8),DTEMP1
	lsrl	IMM(2),DTEMP1
	subql	IMM(3),DTEMP1

	addql	IMM(8-SCM_type_SUBTYPED),ATEMP1

	moveq	IMM(0),PVM1_REG
	movw	DISP(PVM0_REG,-4),PVM1_REG	/* get link */
	asll	IMM(1),PVM1_REG
	movl	ATEMP1,PVM0_REG

	movl	PVM1_REG,PINC(ATEMP1)
	lsrl	IMM(1),PVM1_REG
LBL(copy_loop):
	movl	PINC(ATEMP2),PINC(ATEMP1)
	DBRA(	DTEMP1,copy_loop)

	CMPL(	ATEMP2,PVM3_REG)
	BEQS(	frames_copied)

	movl	PVM0_REG,ATEMP1
	movl	INXW(PVM0_REG,PVM1_REG,SLOT(1)),PVM0_REG

	ALLOC_FRAME

	clrl	DISP(HEAP_REG,SLOT(1))

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG
	movl	PVM1_REG,PDEC(ATEMP1)
	movl	PVM1_REG,ATEMP1

	BRAS(	next_frame)

LBL(frames_copied):
	movl	DISP(PSTATE_REG,SLOT(PARENT_RET)),INXW(PVM0_REG,PVM1_REG,SLOT(1))
	movl	DISP(PSTATE_REG,SLOT(PARENT_FRAME)),PDEC(PVM0_REG)

/* Setup new parent continuation. */

	lea	PC_IND(child_ret),ATEMP1
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	PINC(SP),DISP(PSTATE_REG,SLOT(PARENT_FRAME))

/* Return. */

	MAKE_TEMP_TASK

	rts

/* This is the code that is run every time the child's continuation is */
/* returned from.                                                      */

RETURN(child_ret,2,1):

/* First, check if this is the first return from the child. */

	movl	IND(SP),ATEMP2		/* ATEMP2 = parent task */
	movl	PVM1_REG,IND(SP)
	movl	ATEMP2,DTEMP1
	addl	IMM(SLOT(TASK_SYNC_PH)+4-SCM_type_SUBTYPED),DTEMP1
	READ_AND_CLEAR_DTEMP1
	btst	DTEMP1,PLACEHOLDER_REG
	BNES(	not_first_ret)

/* If it is the first return, determine the synchronization placeholder */
/* and propagate the legitimacy.                                        */

	movl	DTEMP1,PDEC(SP)

	movl	DISP(ATEMP2,SLOT(TASK_LEGIT)+4-SCM_type_SUBTYPED),PVM1_REG

/* Legitimacy placeholders can be determined with placeholders.        */
/* So, it is wise to chase the placeholder before doing the determine. */

LBL(next):
	btst	PVM1_REG,PLACEHOLDER_REG
	BNES(	end_of_chase)
	movl	PVM1_REG,ATEMP1
	movl	DISP(ATEMP1,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM1_REG
	CMPL(	ATEMP1,PVM1_REG)
	BNES(	next)

LBL(end_of_chase):
	movl	DISP(PSTATE_REG,SLOT(CURRENT_TASK)),ATEMP2
	movl	DISP(ATEMP2,SLOT(TASK_LEGIT)+4-SCM_type_SUBTYPED),PVM2_REG

	lea	PC_IND(ret),PVM0_REG
	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret,3,1):

	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM0_REG
	movl	CONST(2),ATEMP1
	jmp	IND(ATEMP1)

LBL(not_first_ret):
	movl	PINC(SP),PVM1_REG
	rts

CONSTS(3)
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("###_kernel.non-strict-determine!")
PRIMITIVE("###_kernel.determine!-then-idle")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(35,x)

BEGIN("###_kernel.transfer-all-tasks-from-ltq")

/* On entry:                                     */
/*   top of stack = exit address                 */

/* On exit:                                      */
/*   ATEMP1 = LTQ_HEAD                           */
/*   PVM3_REG = stack base                       */
/*   PVM2_REG, PVM4_REG preserved                */
/*   PVM0_REG, PVM1_REG, DTEMP1, ATEMP2 modified */

/* We must make sure that there is enough free space for all the frames (so  */
/* that we can avoid to check for GC on every one).  If each frame is copied */
/* independently, the heap space required could be as much as 4 times the    */
/* space used on the stack plus a certain amount for every lazy task.        */

	movl	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),ATEMP1
	movl	IND(ATEMP1),DTEMP1
	subl	SP,DTEMP1
	asll	IMM(2),DTEMP1

	subl	LTQ_TAIL_REG,ATEMP1
	movl	ATEMP1,PVM1_REG
	muluw	IMM((TASK_SIZE+1)+(PH_SIZE*2)+PAIR_SIZE+6),PVM1_REG

	addl	PVM1_REG,DTEMP1
	andw	IMM(-8),DTEMP1

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for frames and check heap */
	BCSS(	do_gc)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG) /* overflow */
	BCCS(	enough_space)
LBL(do_gc):
	moveq	IMM(0),PVM1_REG
	movl	DTEMP1,PDEC(SP)
	TRAP(heap_alloc2_trap,alloc,2,1)
	movl	PINC(SP),DTEMP1

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for frames and check heap */
	BCSS(	stack_overflow)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG) /* overflow */
	BCCS(	enough_space)
LBL(stack_overflow):
	addl	DTEMP1,HEAP_REG

/* continuation must be discarded... */

	RESET_STACK

	movl	CONST(2),PVM0_REG

	movl	CONST(1),ATEMP1	/* jump to ##exception.stack-overflow proc */
	moveq	IMM(1),DTEMP1	/* passing 0 argument */
	jmp	IND(ATEMP1)

LBL(enough_space):
	addl	DTEMP1,HEAP_REG

/* At this point, we know that there is enough free space on the heap to */
/* copy the frames.                                                      */

/* Transfer all tasks to workq. */

LBL(loop):
	movl	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),ATEMP1
	movl	IND(ATEMP1),PVM3_REG
	CMPL(	LTQ_TAIL_REG,ATEMP1)
	BEQS(	tasks_transferred)

	pea	PC_IND(loop)
	movl	CONST(0),ATEMP2
	jmp	IND(ATEMP2)

LBL(tasks_transferred):
	rts

CONSTS(3)
PRIMITIVE("###_kernel.transfer-task-from-ltq")
PRIMITIVE("##exception.stack-overflow")
PRIMITIVE("###_kernel.restore-parent")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(36,x)

BEGIN("###_kernel.transfer-stack-to-heap")

/* On entry:                                                       */
/*   top of stack = exit address                                   */
/*   next on stack = continuation's return address                 */
/*   PVM3_REG = stack base                                         */

/* On exit:                                                        */
/*   top of stack = continuation's return address                  */
/*   PVM2_REG = continuation's first frame                         */
/*   PVM4_REG preserved                                            */
/*   PVM0_REG, PVM1_REG, PVM3_REG, DTEMP1, ATEMP1, ATEMP2 modified */

/* It is assumed that:                                                 */
/*   - no GC will be required (there is enough free space in the heap) */
/*   - there are no tasks on the stack                                 */

	subql	IMM(8),PVM3_REG
	CMPL(	SP,PVM3_REG)
	BNES(	non_empty_stack)

	movl	DISP(PSTATE_REG,SLOT(PARENT_RET)),DISP(SP,SLOT(1))
	movl	DISP(PSTATE_REG,SLOT(PARENT_FRAME)),PVM2_REG

	rts

LBL(non_empty_stack):
	addql	IMM(8),PVM3_REG

	lea	DISP(SP,SLOT(1)),ATEMP2
	movl	PINC(ATEMP2),PVM0_REG

/* Allocate first frame of continuation. */

	ALLOC_FRAME

/* HEAP_REG = ptr to frame header, DTEMP1 = frame header */

	lea	DISP(HEAP_REG,SCM_type_SUBTYPED),ATEMP1
	movl	ATEMP1,PVM2_REG

/* Copy other frames. */

LBL(next_frame):

/* DTEMP1=frame_header, PVM0_REG=ret, ATEMP2=stack_frame, ATEMP1=heap_frame */

	lsrl	IMM(8),DTEMP1
	lsrl	IMM(2),DTEMP1
	subql	IMM(3),DTEMP1

	addql	IMM(8-SCM_type_SUBTYPED),ATEMP1

	moveq	IMM(0),PVM1_REG
	movw	DISP(PVM0_REG,-4),PVM1_REG	/* get link */
	asll	IMM(1),PVM1_REG
	movl	ATEMP1,PVM0_REG

	movl	PVM1_REG,PINC(ATEMP1)
	lsrl	IMM(1),PVM1_REG
LBL(copy_loop):
	movl	PINC(ATEMP2),PINC(ATEMP1)
	DBRA(	DTEMP1,copy_loop)

	CMPL(	ATEMP2,PVM3_REG)
	BEQS(	frames_copied)

	movl	PVM0_REG,ATEMP1
	movl	INXW(PVM0_REG,PVM1_REG,SLOT(1)),PVM0_REG

	ALLOC_FRAME

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG
	movl	PVM1_REG,PDEC(ATEMP1)
	movl	PVM1_REG,ATEMP1

	BRAS(	next_frame)

LBL(frames_copied):
	movl	DISP(PSTATE_REG,SLOT(PARENT_RET)),INXW(PVM0_REG,PVM1_REG,SLOT(1))
	movl	DISP(PSTATE_REG,SLOT(PARENT_FRAME)),PDEC(PVM0_REG)

	rts

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(37,x)

BEGIN("###_kernel.flush-stack")

	movl	PVM0_REG,PDEC(SP)

/* Call ###_kernel.transfer-all-tasks-from-ltq. */

	pea	PC_IND(ret1)
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret1,1,1):

/* Call ###_kernel.transfer-stack-to-heap. */

/* ###_kernel.transfer-all-tasks-from-ltq has reserved enough */
/* space, so no GC check required.                            */

	pea	PC_IND(ret2)
	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)
LBL(ret2):

/* Setup 'hidden' parent continuation. */

	movl	IND(SP),PVM0_REG
	movl	PVM0_REG,DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	PVM2_REG,DISP(PSTATE_REG,SLOT(PARENT_FRAME))

/* Reset stack structure to original setup. */

	RESET_STACK

	moveq	IMM(0),PVM1_REG
	movl	PVM1_REG,PVM2_REG
	movl	PVM1_REG,PVM3_REG

	movl	CONST(2),PVM0_REG
	jmp	IND(PVM0_REG)

CONSTS(3)
PRIMITIVE("###_kernel.transfer-all-tasks-from-ltq")
PRIMITIVE("###_kernel.transfer-stack-to-heap")
PRIMITIVE("###_kernel.restore-parent")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(38,x)

BEGIN("##call-with-current-continuation")

	BMIS(	passed_1arg)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,1,$entry)

LBL(passed_1arg):

	movl	PVM1_REG,PVM4_REG
	movl	PVM0_REG,PDEC(SP)

/* Call ###_kernel.transfer-all-tasks-from-ltq. */

	pea	PC_IND(ret1)
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret1,1,1):

/* Call ###_kernel.transfer-stack-to-heap. */

/* ###_kernel.transfer-all-tasks-from-ltq has reserved enough */
/* space, so no GC check required.                            */

	pea	PC_IND(ret2)
	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)
LBL(ret2):

/* Setup 'hidden' parent continuation. */

	movl	IND(SP),PVM0_REG
	movl	PVM0_REG,DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	PVM2_REG,DISP(PSTATE_REG,SLOT(PARENT_FRAME))

/* Reset stack structure to original setup. */

	RESET_STACK

	movl	CONST(2),PDEC(SP)

	moveq	IMM(0),PVM1_REG
	movl	PVM1_REG,PVM3_REG

/* Allocate closure for 'first-class' continuation. */

	movl	DISP(PSTATE_REG,SLOT(CLOSURE_PTR)),ATEMP2
	moveq	IMM(32),DTEMP1
	subl	DTEMP1,ATEMP2
	CMPL(	DISP(PSTATE_REG,SLOT(CLOSURE_LIM)),ATEMP2)
	BCCS(	closure_allocated)

	moveq	IMM(0),PVM1_REG
	TRAP(closure_alloc_trap,closure_alloc,1,1)

LBL(closure_allocated):
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(CLOSURE_PTR))

/* Init closure. */

	movw	IMM(0x8010),PINC(ATEMP2)
	movl	ATEMP2,PVM1_REG
	addql	IMM(2),ATEMP2
	lea	PC_IND(closure),ATEMP1
	movl	ATEMP1,PINC(ATEMP2)
	movl	PVM0_REG,PINC(ATEMP2)
	movl	PVM2_REG,PINC(ATEMP2)
	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),IND(ATEMP2)

	movl	PINC(SP),PVM0_REG

	movl	PVM4_REG,ATEMP1
	moveq	IMM(-1),DTEMP1
	jmp	IND(ATEMP1)

/* This code is executed when the 'first-class' continuation is restored. */

SUBPROC(closure):
	movl	PINC(SP),CLOSURE_REG
	subql	IMM(6),CLOSURE_REG
	tstw	DTEMP1

	BMIS(	closure_was_passed_1arg)

	WRONG_NB_ARGS(wrong_nb_arg1_closed_trap,1,closure)

LBL(closure_was_passed_1arg):

/* Call ###_kernel.transfer-all-tasks-from-ltq. */

	CMPL(	DISP(PSTATE_REG,SLOT(LTQ_HEAD)),LTQ_TAIL_REG)
	BEQS(	tasks_transferred)

	movl	PVM0_REG,PDEC(SP)
	movl	PVM1_REG,PDEC(SP)
	pea	PC_IND(ret3)
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)
RETURN(ret3,2,1):
	movl	PINC(SP),PVM1_REG
	movl	PINC(SP),PVM0_REG
	moveq	IMM(0),PVM2_REG
	movl	PVM2_REG,PVM3_REG

LBL(tasks_transferred):

/* Setup 'hidden' parent continuation. */

	movl	CLOSURE_REG,ATEMP1
	movl	DISP(ATEMP1,6),DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	DISP(ATEMP1,10),DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	DISP(ATEMP1,14),DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))

/* Reset stack structure to original setup. */

	RESET_STACK

/* Restore parent continuation. */

	movl	CONST(2),ATEMP1
	jmp	IND(ATEMP1)

CONSTS(3)
PRIMITIVE("###_kernel.transfer-all-tasks-from-ltq")
PRIMITIVE("###_kernel.transfer-stack-to-heap")
PRIMITIVE("###_kernel.restore-parent")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(39,x)

BEGIN("###_kernel.restore-parent")

	movl	PVM0_REG,ATEMP2
	movl	PVM1_REG,DISP(PSTATE_REG,SLOT(TEMP1))

	movl	DISP(PSTATE_REG,SLOT(PARENT_FRAME)),PVM0_REG

	subql	IMM(SCM_type_SUBTYPED),PVM0_REG
	movl	PINC(PVM0_REG),PVM1_REG
	lsrl	IMM(8),PVM1_REG

LBL(wait):
	movl	PINC(PVM0_REG),DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	BNES(	copy_frame)
	subql	IMM(4),PVM0_REG
	BRAS(	wait)
LBL(copy_frame):

/* copy frame */

#ifdef RESTORE_PARENT_USING_BTRANSFER

	subql	IMM(4),PVM1_REG		/* PVM1_REG = length of frame + 4 */
	subl	PVM1_REG,SP		/* allocate space on stack */
	movl	SP,DTEMP1
	BTRANSFER(copy)
	movl	PINC(SP),DTEMP1		/* get link index */

#else

	subql	IMM(8),PVM1_REG		/* PVM1_REG = length of frame */
	subl	PVM1_REG,SP		/* allocate space on stack */
	movl	SP,ATEMP1
	movl	PINC(PVM0_REG),DTEMP1	/* get link index */

	lsrl	IMM(2),PVM1_REG
	subql	IMM(1),PVM1_REG
LBL(loop):
	movl	PINC(PVM0_REG),PINC(ATEMP1)
	DBRA(	PVM1_REG,loop)

#endif

	lsrl	IMM(1),DTEMP1

	movl	ATEMP2,PVM0_REG
	movl	DISP(PSTATE_REG,SLOT(TEMP1)),PVM1_REG

	movl	DISP(PSTATE_REG,SLOT(PARENT_RET)),ATEMP2

	movl	INXW(SP,DTEMP1,0),DISP(PSTATE_REG,SLOT(PARENT_RET))
	lea	PC_IND($entry),ATEMP1
	movl	ATEMP1,INXW(SP,DTEMP1,0)

	movl	PVM1_REG,DTEMP1 /* Required for the case of a return from a touch of d0 */

	CMPW(	IMM(ADDQL_4_A4),IND(ATEMP2))
	BEQS(	return_lazy)
	jmp	IND(ATEMP2)
LBL(return_lazy):
	jmp	DISP(ATEMP2,2)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(40,x)

BEGIN("##apply")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM1_REG,ATEMP1
	movl	PVM2_REG,PVM3_REG

	moveq	IMM(0),DTEMP1
	BRAS(	loop_entry)

/* copy values from list to the stack */

LBL(loop):
	movl	PVM3_REG,ATEMP2
	movl	IND(ATEMP2),PDEC(SP)	/* push car to the stack */
	movl	PDEC(ATEMP2),PVM3_REG	/* get cdr */

	addqw	IMM(1),DTEMP1
	CMPW(	IMM(MAX_NB_ARGS),DTEMP1)
	BGTS(	max_args_reached)

LBL(loop_entry):
	btst	PVM3_REG,PAIR_REG	/* pair? */
	BEQS(	loop)

	moveq	IMM(0),INTR_TIMER_REG	/* check interrupts as soon as possible */

	tstw	DTEMP1			/* how many arguments to pass? */
	BEQS(	pass_0arg)
	subqw	IMM(2),DTEMP1
	BMIS(	pass_1arg)
	BEQS(	pass_2args)

	movl	PINC(SP),PVM3_REG
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	addqw	IMM(3),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with >= 3 args) */

LBL(pass_0arg):
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with no arg) */

LBL(pass_1arg):
	movl	PINC(SP),PVM1_REG
	moveq	IMM(-1),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with 1 arg) */

LBL(pass_2args):
	movl	PINC(SP),PVM2_REG
	movl	PINC(SP),PVM1_REG
	moveq	IMM(0),DTEMP1
	jmp	IND(ATEMP1)		/* jump to procedure (with 2 args) */

LBL(max_args_reached):
	aslw	IMM(2),DTEMP1
	addw	DTEMP1,SP		/* restore original SP */

	movl	CONST(0),ATEMP1		/* jump to ##exception.apply-arg-limit */
	moveq	IMM(0),DTEMP1		/* passing 2 arguments */
	jmp	IND(ATEMP1)

CONSTS(1)
PRIMITIVE("##exception.apply-arg-limit")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(41,x)

BEGIN("##global-var")

	BMIS(	passed_1arg)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,1,$entry)

LBL(passed_1arg):
	movl	PVM1_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(SYMBOL_GLOBAL)+4-SCM_type_SUBTYPED),PVM1_REG

	CMPL(	PVM1_REG,FALSE_REG)
	BEQS(	alloc_glob)

	jmp	IND(PVM0_REG)

LBL(alloc_glob):
	movl	DISP(TABLE_REG,GLOB_OFFS(GLOBAL_VAR_COUNT)),ATEMP1
	movl	ATEMP1,PVM1_REG
	addql	IMM(8),ATEMP1
	CMPL(	IMM(MAX_NB_GLOBALS*8),ATEMP1)
	BLES(	ok)

	movl	FALSE_REG,PVM1_REG
	jmp	IND(PVM0_REG)

LBL(ok):
	movl	ATEMP1,DISP(TABLE_REG,GLOB_OFFS(GLOBAL_VAR_COUNT))
	movl	PVM1_REG,DISP(ATEMP2,SLOT(SYMBOL_GLOBAL)+4-SCM_type_SUBTYPED)

	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(42,x)

BEGIN("##global-var-ref")

	BMIS(	passed_1arg)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,1,$entry)

LBL(passed_1arg):
	movl	PVM1_REG,ATEMP1
	addl	TABLE_REG,ATEMP1
	subl	IMM((NB_TRAPS*8-0x8000)+(MAX_NB_GLOBALS*10)),ATEMP1

	movl	IND(ATEMP1),PVM1_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(43,x)

BEGIN("##global-var-set!")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM1_REG,DTEMP1
	asrl	IMM(2),DTEMP1
	addl	TABLE_REG,DTEMP1
	subl	IMM(NB_TRAPS*8-0x8000),DTEMP1
	subl	IMM(MAX_NB_GLOBALS*2),DTEMP1

	movl	PVM1_REG,ATEMP1
	addl	TABLE_REG,ATEMP1
	subl	IMM(NB_TRAPS*8-0x8000),ATEMP1
	subl	IMM(MAX_NB_GLOBALS*10),ATEMP1

	movl	PVM2_REG,PINC(ATEMP1)
	movl	DTEMP1,IND(ATEMP1)

	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(44,x)

BEGIN("##make-vector")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM1_REG,DTEMP1
	asrl	IMM(1),DTEMP1
	addl	IMM(11),DTEMP1
	andw	IMM(-8),DTEMP1	/* DTEMP1 = total bytes needed for vector */

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for vector and check heap overflow */
	BCSS(	gc)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG)
	BCCS(	ok)
LBL(gc):
	movl	PVM0_REG,PDEC(SP)
	TRAP(heap_alloc2_trap,alloc1,1,1)
	movl	PINC(SP),PVM0_REG

LBL(ok):
	movl	PVM1_REG,DTEMP1
	asll	IMM(7),DTEMP1
	movb	IMM(SCM_subtype_VECTOR*8),DTEMP1
	movl	DTEMP1,IND(HEAP_REG)

/* init vector: */

	movl	PVM1_REG,DTEMP1
	asrl	IMM(1),DTEMP1
	lea	DISP(HEAP_REG,4),ATEMP1
LBL(loop):
	movl	PVM2_REG,PINC(ATEMP1)
	subql	IMM(4),DTEMP1
	BGTS(	loop)

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG

	jmp	IND(PVM0_REG)		/* return to caller */

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(45,x)

BEGIN("##make-string")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM1_REG,DTEMP1
	asrl	IMM(3),DTEMP1
	addl	IMM(11),DTEMP1
	andw	IMM(-8),DTEMP1	/* DTEMP1 = total bytes needed for string */

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for string and check heap overflow */
	BCSS(	gc)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG)
	BCCS(	ok)
LBL(gc):
	movl	PVM0_REG,PDEC(SP)
	TRAP(heap_alloc2_trap,alloc1,1,1)
	movl	PINC(SP),PVM0_REG

LBL(ok):
	movl	PVM1_REG,DTEMP1
	asll	IMM(5),DTEMP1
	movb	IMM(SCM_subtype_STRING*8),DTEMP1
	movl	DTEMP1,IND(HEAP_REG)

/* init string: */

	movl	PVM2_REG,DTEMP1
	asrw	IMM(3),DTEMP1
	andw	IMM(0xff),DTEMP1
	movw	DTEMP1,ATEMP2
	aslw	IMM(8),DTEMP1
	addw	ATEMP2,DTEMP1
	movw	DTEMP1,ATEMP2
	swap	DTEMP1
	movw	ATEMP2,DTEMP1
	movl	DTEMP1,ATEMP2		/* ATEMP2 = initial value of chars */

	movl	PVM1_REG,DTEMP1
	asrl	IMM(3),DTEMP1
	lea	DISP(HEAP_REG,4),ATEMP1
LBL(loop):
	movl	ATEMP2,PINC(ATEMP1)
	subql	IMM(4),DTEMP1
	BGTS(	loop)

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG

	jmp	IND(PVM0_REG)		/* return to caller */

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(46,x)

BEGIN("##make-vector16")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM1_REG,DTEMP1
	asrl	IMM(2),DTEMP1
	addl	IMM(11),DTEMP1
	andw	IMM(-8),DTEMP1	/* DTEMP1 = total bytes needed for vector */

	CMPL(	DTEMP1,HEAP_REG)
	subl	DTEMP1,HEAP_REG	/* allocate space for vector and check heap overflow */
	BCSS(	gc)
	CMPL(	DISP(PSTATE_REG,SLOT(HEAP_LIM)),HEAP_REG)
	BCCS(	ok)
LBL(gc):
	movl	PVM0_REG,PDEC(SP)
	TRAP(heap_alloc2_trap,alloc1,1,1)
	movl	PINC(SP),PVM0_REG

LBL(ok):
	movl	PVM1_REG,DTEMP1
	asll	IMM(6),DTEMP1
	movb	IMM(SCM_subtype_STRING*8),DTEMP1
	movl	DTEMP1,IND(HEAP_REG)

/* init vector: */

	movl	PVM2_REG,DTEMP1
	asrl	IMM(3),DTEMP1
	movw	DTEMP1,ATEMP2
	swap	DTEMP1
	movw	ATEMP2,DTEMP1
	movl	DTEMP1,ATEMP2		/* ATEMP2 = initial value of words */

	movl	PVM1_REG,DTEMP1
	asrl	IMM(2),DTEMP1
	lea	DISP(HEAP_REG,4),ATEMP1
LBL(loop):
	movl	ATEMP2,PINC(ATEMP1)
	subql	IMM(4),DTEMP1
	BGTS(	loop)

	movl	HEAP_REG,PVM1_REG
	addql	IMM(SCM_type_SUBTYPED),PVM1_REG

	jmp	IND(PVM0_REG)		/* return to caller */

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(47,x)

BEGIN("##dynamic-env-bind")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):

/* save current dynamic environment */

	movl	PVM0_REG,PDEC(SP)
	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),PDEC(SP)

/* set new dynamic environment */

	movl	PVM1_REG,DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))

/* push dynamic environment marker (only if none other pushed for this future) */

	movl	DISP(PSTATE_REG,SLOT(DEQ_TAIL)),ATEMP2
	movl	ATEMP2,PVM0_REG
	movl	PDEC(PVM0_REG),PVM0_REG
	movl	IND(LTQ_TAIL_REG),ATEMP1
	CMPL(	ATEMP1,PVM0_REG)
	BCSS(	pushed)
	movl	SP,PINC(ATEMP2)
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(DEQ_TAIL))
LBL(pushed):

	lea	PC_IND(ret),PVM0_REG
	movl	PVM2_REG,ATEMP1
	moveq	IMM(1),DTEMP1
	jmp	IND(ATEMP1)

RETURN(ret,2,1):

/* pop dynamic environment marker */

	movl	DISP(PSTATE_REG,SLOT(DEQ_TAIL)),ATEMP2
	movl	PDEC(ATEMP2),ATEMP1
	CMPL(	ATEMP1,SP)
	BNES(	popped)
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(DEQ_TAIL))
LBL(popped):

/* restore current dynamic environment */

	movl	PINC(SP),DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))
	rts

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(48,x)

BEGIN("##dynamic-env-ref")

	CMPW(	IMM(1),DTEMP1)
	BEQS(	passed_0arg)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,0,$entry)

LBL(passed_0arg):
	movl	DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV)),PVM1_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(49,x)

BEGIN("##atomic-set-car!")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM0_REG,PVM4_REG
	movl	PVM1_REG,DTEMP1
	andw	IMM(-8),DTEMP1
	addql	IMM(4),DTEMP1
	movl	DTEMP1,ATEMP2

	LOCK_ATEMP2(lock)

	movl	PVM2_REG,IND(ATEMP2)
	movl	DTEMP1,PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(50,x)

BEGIN("##atomic-set-cdr!")

	BEQS(	passed_2args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,2,$entry)

LBL(passed_2args):
	movl	PVM0_REG,PVM4_REG
	movl	PVM1_REG,DTEMP1
	andw	IMM(-8),DTEMP1
	movl	DTEMP1,ATEMP2

	LOCK_ATEMP2(lock)

	movl	PVM2_REG,IND(ATEMP2)
	movl	DTEMP1,PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(51,x)

BEGIN("##atomic-set-car-if-eq?!")

	CMPW(	IMM(4),DTEMP1)
	BEQS(	passed_3args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,3,$entry)

LBL(passed_3args):
	movl	PVM0_REG,PVM4_REG
	movl	PVM1_REG,DTEMP1
	andw	IMM(-8),DTEMP1
	addql	IMM(4),DTEMP1
	movl	DTEMP1,ATEMP2

	LOCK_ATEMP2(lock)

	CMPL(	DTEMP1,PVM3_REG)
	BNES(	not_eq)

	movl	PVM2_REG,IND(ATEMP2)
	movl	IMM(SCM_true),PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

LBL(not_eq):
	movl	DTEMP1,IND(ATEMP2)
	movl	FALSE_REG,PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(52,x)

BEGIN("##atomic-set-cdr-if-eq?!")

	CMPW(	IMM(4),DTEMP1)
	BEQS(	passed_3args)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,3,$entry)

LBL(passed_3args):
	movl	PVM0_REG,PVM4_REG
	movl	PVM1_REG,DTEMP1
	andw	IMM(-8),DTEMP1
	movl	DTEMP1,ATEMP2

	LOCK_ATEMP2(lock)

	CMPL(	DTEMP1,PVM3_REG)
	BNES(	not_eq)

	movl	PVM2_REG,IND(ATEMP2)
	movl	IMM(SCM_true),PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

LBL(not_eq):
	movl	DTEMP1,IND(ATEMP2)
	movl	FALSE_REG,PVM1_REG
	movl	PVM4_REG,PVM0_REG
	jmp	IND(PVM0_REG)

CONSTS(0)
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(53,x)

BEGIN("##touch-legitimacy")

	CMPW(	IMM(1),DTEMP1)
	BEQS(	passed_0arg)

	WRONG_NB_ARGS(wrong_nb_arg1_trap,0,$entry)

LBL(passed_0arg):
	movl	DISP(PSTATE_REG,SLOT(CURRENT_TASK)),ATEMP1
	movl	DISP(ATEMP1,SLOT(TASK_LEGIT)+4-SCM_type_SUBTYPED),PVM1_REG

/* touch legitimacy placeholder */

	btst	PVM1_REG,PLACEHOLDER_REG
	BEQS(	touch)
	jmp	IND(PVM0_REG)

LBL(touch):
	movl	PVM1_REG,ATEMP2
	movl	DISP(ATEMP2,SLOT(PH_VALUE)-SCM_type_PLACEHOLDER),PVM1_REG
	CMPL(	ATEMP2,PVM1_REG)
	BNES(	determined)

	LOG(EVENT_TOUCH_UNDET,log1)

/* legitimacy placeholders can be determined to placeholders, so must chase */

	movl	PVM0_REG,PDEC(SP)
	lea	PC_IND(ret),PVM0_REG
	movl	CONST(0),ATEMP1
	jmp	IND(ATEMP1)	/* jump to ###_kernel.touch-undetermined-placeholder */
RETURN(ret,1,1):
	movl	PINC(SP),PVM0_REG
LBL(determined):
	btst	PVM1_REG,PLACEHOLDER_REG
	BEQS(	touch)

	jmp	IND(PVM0_REG)

CONSTS(1)
PRIMITIVE("###_kernel.touch-undetermined-placeholder")
END

/*---------------------------------------------------------------------------*/

#undef LBL
#define LBL(x)MAKE_LBL(54,x)

BEGIN("###_kernel.startup")

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Save registers needed by C: */

	movl	CONST(0),REG(a2)
	movl	REG(a5),DISP(REG(a2),C_A5)
	movl	REG(a6),DISP(REG(a2),C_A6)
	movl	SP,DISP(REG(a2),C_SP)

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Get parameters: */

	movl	DISP(SP,4),TABLE_REG	/* always = ptr to glob/code table */
	movl	DISP(SP,8),PSTATE_REG	/* always = ptr to processor state */

	movl	DISP(SP,12),DTEMP1	/* init 68881 coprocessor */
	BEQS(	no_68881)
	fmovel	IMM(0),FPSR
	fmovel	IMM(0),FPCR
LBL(no_68881):

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Setup registers: */

	moveq	IMM(0),INTR_TIMER_REG

	movl	IMM(SCM_null),NULL_REG
	movl	IMM(SCM_false),FALSE_REG

	movl	DISP(PSTATE_REG,SLOT(HEAP_PTR)),HEAP_REG

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Setup stack structure: */

	movl	DISP(PSTATE_REG,SLOT(STACK_BOT)),DTEMP1
	addl	IMM(SLOT(STACK_ALLOCATION_FUDGE)),DTEMP1
	addl	DISP(PSTATE_REG,SLOT(STACK_MARGIN)),DTEMP1
	movl	DTEMP1,DISP(PSTATE_REG,SLOT(STACK_LIM))

	movl	IMM(-1),DISP(PSTATE_REG,SLOT(INTR_FLAG))

	RESET_STACK

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Start processors: */

	MAKE_TEMP_TASK

	movl	DISP(PSTATE_REG,SLOT(ID)),DTEMP1
	BEQS(	processor0)

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Startup other processors: */

	movl	CONST(1),ATEMP1
	jmp	IND(ATEMP1)

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

/* Startup processor 0: */

LBL(processor0):

/* Make root task. */

	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	movl	IMM(SCM_true),PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	movl	IMM(TASK_SIZE*0x400+(SCM_subtype_TASK*8)),PDEC(HEAP_REG)
	lea	DISP(HEAP_REG,SCM_type_SUBTYPED),ATEMP1

	movl	ATEMP1,DISP(PSTATE_REG,SLOT(CURRENT_TASK))

/* Make root continuation. */

	movl	FALSE_REG,PDEC(HEAP_REG)
	clrl	PDEC(HEAP_REG)
	movl	FALSE_REG,PDEC(HEAP_REG)
	movl	IMM(3*0x400+SCM_subtype_FRAME*8),PDEC(HEAP_REG)
	lea	DISP(HEAP_REG,SCM_type_SUBTYPED),ATEMP2

	lea	PC_IND(root_continuation),ATEMP1
	movl	ATEMP1,DISP(PSTATE_REG,SLOT(PARENT_RET))
	movl	ATEMP2,DISP(PSTATE_REG,SLOT(PARENT_FRAME))
	movl	NULL_REG,DISP(PSTATE_REG,SLOT(CURRENT_DYN_ENV))
	movl	CONST(2),PVM0_REG

/* Clear PVM registers. */

	moveq	IMM(0),PVM1_REG
	movl	PVM1_REG,PVM2_REG
	movl	PVM1_REG,PVM3_REG
	movl	PVM1_REG,PVM4_REG

	LOG(EVENT_WORKING,log1)

	movl	CONST(3),ATEMP1		/* jump to ##STARTUP proc */
	moveq	IMM(1),DTEMP1		/* passing 0 argument */
	jmp	IND(ATEMP1)

RETURN(root_continuation,1,1):
	movl	CONST(0),REG(a2)	/* restore C's context */
	movl	DISP(REG(a2),C_A5),REG(a5)
	movl	DISP(REG(a2),C_A6),REG(a6)
	movl	DISP(REG(a2),C_SP),SP

	rts

CONSTS(4)
PRIMITIVE("###_kernel")
PRIMITIVE("###_kernel.idle")
PRIMITIVE("###_kernel.restore-parent")
PRIMITIVE("##startup")
END

/*---------------------------------------------------------------------------*/

OBJECT_FILE_END
