/* Included by os.c */

/* ANSI-C stuff */

#include "struct.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>

#ifdef hpux
#define hpux_cachectl /* Remove if using HPUX-7.0 or earlier */
#endif


static clock_t start_real_time;


void os_quit()
{ exit(0);
}


long os_nb_processors()
{ return 1;
}


long os_fork_on_processors( n )
long n;
{ return 0;
}


static char *malloc8( length ) /* alloc of blocks starting at an octuple adr */
long length;
{ char *ptr;
  ptr = (char *)malloc( length+7 );
  if (ptr != NULL) ptr = (char *) ceiling8(ptr); /* get octuple addr. */
  return ptr;
}


char *os_shared_malloc8( len, processor )
long len;
long processor;
{ return (char *)malloc8( len );
}


char *os_shared_copy_malloc8( len_share, len_copy, processor )
long len_share, len_copy;
long processor;
{ long aligned_len_share = ceiling8( len_share );
  long len = aligned_len_share + len_copy;
  char *ptr = malloc8( len );
  if (ptr != NULL) ptr = ptr + aligned_len_share - len_share;
  return ptr;
}


void os_block_copy( src, dst, len )
char *src, *dst;
long len;
{ register char *p1 = src, *p2 = dst;
  register long i = len;
  while (i > 0) { *(p2++) = *(p1++); i--; }
}


#ifdef hpux_cachectl
#include <sys/cache.h>
#endif


void os_flush_caches()
{
#ifdef NeXT
  asm("trap #2");
#else
#ifdef hpux_cachectl
  cachectl( CC_IPURGE, NULL, NULL );
#else

#define INSTR_CACHE_LENGTH_IN_K 64
#define DATA_CACHE_LENGTH_IN_K  8

  short *start = (short *)pstate->heap_old;
  short *p = start;
  long i;

  for (i=((long)INSTR_CACHE_LENGTH_IN_K)*K/2-1; i>0; i--) *p++ = NOP_OP;
  *p++ = RTS_OP;
  for (i=((long)DATA_CACHE_LENGTH_IN_K)*K/2; i>0; i--) *p++ = 0;

  ((void (*)())start)();

#endif
#endif
}


void os_flush_writes()
{
#ifdef NeXT
  asm("trap #2");
#else
#ifdef hpux_cachectl
  cachectl( CC_IPURGE, NULL, NULL );
#endif
#endif
}


long os_clock()
{ return clock() - start_real_time;
}


long os_real_time_clock()
{ return clock() - start_real_time;
}


long os_clock_to_msec( ticks )
long ticks;
{ return ticks * 1000 / CLOCKS_PER_SEC;
}


void os_cpu_times( buf )
long *buf;
{ buf[0] = (clock() - start_real_time) * 1000 / CLOCKS_PER_SEC;
  buf[1] = 0;
}


long os_ticks_to_msec( ticks )
long ticks;
{ return ticks * 1000 / CLOCKS_PER_SEC;
}


static void (*intr_action)();
static void (*timer_action)();
static void (*io_action)();
static void (*fatal_action)();


static void fatal_signal( pc, sp, kind )
long pc, sp;
char *kind;
{ os_warn( "Fatal signal %s, terminating...\n", (long)kind );
  os_quit();
}


static void signal_trap( sig )
int sig;
{ long pc = 0, sp = 0;
  char *kind;
  void (*action)();
  if (sig == SIGINT)
  { signal(SIGINT, signal_trap);
    intr_action( pc, sp, "SIGINT" );
    return;
  }
  switch (sig)
  { case SIGABRT: kind = "SIGABRT"; break;
    case SIGILL:  kind = "SIGILL";  break;
    case SIGFPE:  kind = "SIGFPE";  break;
    case SIGSEGV: kind = "SIGSEGV"; break;
    case SIGTERM: kind = "SIGTERM"; break;
    default:      kind = "???";     break;
  }
  action = fatal_action;
  fatal_action = fatal_signal;
  signal( sig, signal_trap );
  action( pc, sp, kind );
}


void os_install_trap_handlers( intr_proc, timer_proc, io_proc, fatal_proc )
void (*intr_proc)();
void (*timer_proc)();
void (*io_proc)();
void (*fatal_proc)();
{ intr_action = intr_proc;
  timer_action = timer_proc;
  io_action = io_proc;
  signal(SIGINT, signal_trap);
  signal(SIGFPE, SIG_IGN);
  if (fatal_proc != (void (*)())0)
  { fatal_action = fatal_proc;
    signal(SIGABRT,signal_trap);
    signal(SIGILL, signal_trap);
    signal(SIGSEGV,signal_trap);
    signal(SIGTERM,signal_trap);
  }
  else
    fatal_action = fatal_signal;
}


long os_poll_events( result )
long *result;
{ return 0;
}


char *os_expand_filename( str )
char *str;
{ return str;
}


static long file_open( name, flags )
char *name;
char *flags;
{ FILE *f;
  f = fopen( name, flags );
  if (f == NULL)
    return -1;
  else
    return (long)f;
}


OS_FILE os_file_open_input( name )
char *name;
{ return (OS_FILE)file_open( name, "r" );
}


OS_FILE os_file_open_output( name )
char *name;
{ return (OS_FILE)file_open( name, "w" );
}


long os_file_length( f )
OS_FILE f;
{ fpos_t pos;
  long len;
  if (fgetpos( (FILE *)f, &pos ) != 0) return -1;
  if (fseek( (FILE *)f, 0, SEEK_END ) != 0) return -1;
  len = ftell( (FILE *)f );
  if (fsetpos( (FILE *)f, &pos ) != 0) return -1;
  return len;
}


long os_file_read_ready( f )
OS_FILE f;
{ return 1;
}


long os_file_read( f, ptr, n )
OS_FILE f;
char *ptr;
long n;
{ if (!os_file_read_ready( f ))
    return -1;
  else
    return fread( ptr, (size_t)1, (size_t)n, (FILE *)f );
}


long os_file_write( f, ptr, n )
OS_FILE f;
char *ptr;
long n;
{ return fwrite( ptr, (size_t)1, (size_t)n, (FILE *)f );
}


long os_file_close( f )
OS_FILE f;
{ return fclose( (FILE *)f );
}


void os_file_block_read( f )
OS_FILE f;
{
}


extern void os_set_timer_interval( interval )
long interval;
{
}


void os_profil( buff, bufsiz, offset, shift )
short *buff;
long bufsiz, offset;
long shift;
{
}


static void os_notify_gc_begin_internal()
{
}


static void os_notify_gc_end_internal()
{
}


extern void main_gambit();


static int main_internal( argc, argv, envp )
int argc;
char *argv[], *envp[];
{ os_stdin  = (OS_FILE)stdin;
  os_stdout = (OS_FILE)stdout;
  os_stderr = (OS_FILE)stderr;

  start_real_time = clock();

  main_gambit( argc, argv, envp );

  return 0;
}


/*---------------------------------------------------------------------------*/
