 /*  -*- Mode: C;  -*-
 * File: exc_test1.c
 * Author: Heinz Schmidt (hws@ICSI.Berkeley.EDU)
 * Copyright (C) International Computer Science Institute, 1991
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** FUNCTION: Exception handling tests.
 **
 ** RELATED PACKAGES: ~/sather/C/time_.c if benchmarks are uncommented.
 **
 ** compile: cc -g -I. exc_test1.c -o exc
 ** run:     exc 123 63
 **          exc 123 64
 **          exc 10000 9999
 **          exc 10000 4544
 **          exc 17  19
 **          exc 17000 0
 ** HISTORY:
 ** Last edited: Mar 22 16:47 1992 (hws)
 ** Created: Feb 15 11:46 1992 (hws)
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
 */

#include "all_.h"

/* Stub for testing 
 * Types 2 3 5 7 11 13 17       IS_A_DES_OF=inherits+ ,i.e.,transitive
 *      2                       NOTE: upper triangle 0, types non-zero
 *      3                                   
 *      7  x
 *     11
 *     13
 *     17  x   x  x 
 *     ------------------
 * For simplicity (in this example, not Sather) we take a simple
 * formula for IS_A_DES_OF    A is_a B iff B is a factor of A/2
 */

#define IS_A_DES_OF(i,j) i==0?0:j%2==0?((j/2)%i)==0:0

int how_many,to_where,what;
	
void handle_n(n) /* even numbered as polytypes, odd as monotype matches */
     int n;
{
  if (n==1) {
    printf("\nFrame %d of %d. Going to throw to handler matching %d.\n",
	   n, how_many, to_where);
    EH_THROW_TYPE(to_where,what);
  } else {
    unsigned int Random = rand();
    int may_skip = Random&(Random<<1)&(Random<<2)&(Random<<3)&(Random<<4)&0200;
    --n;
    if (may_skip) {
      printf("%d ",n);
      handle_n(n);
    } else {
      if (n%2==0) {
	EH_CATCH(-n,err,
		 handle_n(n),
		 printf("Handler %d for Object %d\nReturn: ",-n,(int)err)
		 );
      } else {
	EH_CATCH(n,err,
		 handle_n(n),
		 printf("Handler %d for Object %d\nReturn: ",n,(int)err)
		 )
	};
    };
    printf(" %d",n);
  };
};

void main(argc,argv)
     int argc;
     char *argv[];
{ 
  printf("CALL <that_many_hdlrs> <to_which_to_return> <what_to_return>\n");
  printf("Handlers will be setup in alternating and decreasing order. In this example\n");
  printf("negative even types are supposed to be supertypes of all their factors smaller\n");
  printf("than the negative even type's half.\n");
  printf("Randomly skipped handlers for frames: ");
  what=atoi(argv[3]);
  to_where=atoi(argv[2]);
  how_many=atoi(argv[1]);
  if (how_many > 0) {
    handle_n(how_many)  ;
  } else { 
    printf("\nSorry but there should be some recursion. Increase <that_many_hdlrs>."); 
  };
  printf("\n");
};

  
/* EOF */

