/* * Last edited: Mar 30 00:14 1992 (hws) */
/* File: sather/sys/C/all_.h
   Author: Stephen M. Omohundro.
   Machine independent conversion: Jeff Bilmes

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.

   Include file for all Sather generated code.
 */ 

#ifndef SATHER_RT_
#define SATHER_RT_

#ifdef sequent
#define SHARED_DATA_ shared
#define PRIVATE_DATA_ private
#endif /* sequent */

#ifdef sparc
#define SHARED_DATA_
#define PRIVATE_DATA_
#endif /* sparc */

/* Generic pointer */
typedef char *ptr;
/* Sather boolean type */
typedef char bool;
/* and real */
typedef float real;

/* To enhance portability, we define names for Sather types and base voids. */
#define S_int_VOID_ 0
#define S_float_VOID_ 0.0
#define S_double_VOID_ ((double)0.0)
#define S_char_VOID_ ((char)0)
#define S_bool_VOID_ ((char)0)
#define S_ptr_VOID_ ((ptr)NULL)

typedef void (*ROUTINE_)();
typedef int SATHER_INT_;
typedef ptr SATHER_OBJ_;
typedef float SATHER_REAL_;
typedef double SATHER_DOUBLE_;
typedef char SATHER_CHAR_;
typedef char SATHER_BOOL_;

/* Union type for dispatched value */
union dtype_ {
  int intval__;			/* Attribute offsets */
  int* intptr__;		/* Pointers to constants/shareds */
  char* charptr__;
  float* floatptr__;
  ptr* ptrptr__;
  int (*fn_int__)();		/* Function pointers */
  char (*fn_char__)();
  float (*fn_float__)();
  double (*fn_double__)();
  ptr (*fn_ptr__)();
  void (*fn_void__)();
};

/* Accessor to different union fields */
#define INTVAL_(v) ((v).intval__)

#define INTPTR_(v) (*((v).intptr__))
#define CHARPTR_(v) (*((v).charptr__))
#define FLOATPTR_(v) (*((v).floatptr__))
#define DOUBLEPTR_(v) (*((v).doubleptr__))
#define PTRPTR_(v) (*((v).ptrptr__))

/* Dispatched functions returning different types */
#define IFN_(fn) (*((fn).fn_int__))
#define CFN_(fn) (*((fn).fn_char__))
#define FFN_(fn) (*((fn).fn_float__))
#define DFN_(fn) (*((fn).fn_double__))
#define PFN_(fn) (*((fn).fn_ptr__))
#define VFN_(fn) (*((fn).fn_void__))

/* Default initial value for any data */
#ifndef NULL
#define NULL 0
#endif

/* Since we are quitting, we do not have to save on a function call. */
extern err_quit_();
extern void arr_out_of_bound_();
extern void type_mismatch_();
extern ptr err_in_file_;

#define VOID_OBJ_ERR_    1	/* Void object access */
#define INVALD_CLS_ERR_  2	/* Invalid class number */
#define NO_ATTR_TAB_ERR_ 3	/* Missing attribute table */
#define ILL_DISP_ERR_    4	/* Illegal dispatch */
#define MISS_DISP_ERR_   5	/* Missing dispatch */
#define INVALD_ATTR_ERR_ 6	/* Invalid attribute */
#define DISP_NEW_ERR_    7	/* Error with new on dispatched object */
#define ARR_BOUND_ERR_   8	/* Error with new on dispatched object */
#define B_FILE_MISSING_ERR_ 9   /* Missing file for browser */
#define NO_FEAT_TAB_ERR_ 10     /* Missing feature table */
#define INVALD_FEAT_ERR_ 11     /* Feature does not exist in class */
#define TYPE_MISMATCH_ERR_ 12   /* Types do not conform */ 
#define NO_DES_TAB_ERR_ 13     /* Missing descendent table */

#define VOID_ERR_MSG_    "Attribute access to void object\n"
#define INVALD_CLS_MSG_  "Class number (%d) out of range\n"
#define NO_ATTR_TAB_MSG_ "Class #%d attribute table missing\n"
#define ILL_DISP_MSG_    "Illegal dispatch reference, class %d, name index %d\n"
#define MISS_DISP_MSG_   "Missing dispatch reference, class %d, name index %d\n"
#define INVALD_ATTR_MSG_ "Attribute #%d out of range in class %d, name index %d\n"
#define DISP_NEW_MSG_    "Wrong number of args (%d) for dispatched \"new\"\n"
#define ARR_BOUND_MSG_   "Value of index %d is %d and is out of bound (=%d)\n"
#define B_FILE_MISSING_MSG_ "Missing browser file; Check compiler option\n"
#define NO_FEAT_TAB_MSG_ "Class #%d feature table missing\n"
#define INVALD_FEAT_MSG_ "Illegal feature (index=%d) in class #%d\n"
#define TYPE_MISMATCH_MSG_ "Type #%d does not conform to type #%d\n"
#define NO_DES_TAB_MSG_ "Class #%d descendent table missing\n"

extern ptr safe_generic_new_();
extern ptr safe_new_();
extern ptr safe_new1_();
extern ptr safe_new2_();
extern ptr safe_new3_();
extern ptr safe_new4_();
extern int safe_get_dispatch_();
extern int safe_ob_base_size_();
extern int safe_ob_arr_dim_();
extern int safe_ob_arr_ctype_();
extern int safe_ob_attr_num_();
extern int safe_ob_attr_ctype_();
extern int safe_ob_attr_offset_();

extern int safe_cl_feat_num_();
extern int safe_cl_ctype_();
extern int safe_cl_arr_satype_();
extern int safe_cl_fullname_();	/* C string address. */
extern int safe_cl_feat_name_();
extern int safe_cl_feat_cat_();
extern int safe_cl_feat_satype_();

/* support for MIRROR class */
extern char safe_arr_type_is_basic();
extern int safe_arr_d_size();
extern ptr safe_arr_str_val();
extern ptr safe_arr_val();
extern char safe_set_arr_str_val();
extern char safe_f_basic();
extern ptr safe_f_val();
extern ptr safe_f_str_val();
extern char safe_set_f_str_val();


#define VOID_TST_(x,ln) {if ((x)==S_ptr_VOID_) err_quit_(VOID_OBJ_ERR_,ln);}
#define ARR_BOUND_TST_(i,x,bound,ln) \
{if (((x) < 0) || ((x) >= (bound))) arr_out_of_bound_(i,x,bound,ln);}

/* The type tag of an object. */
#define TYPE_(o) (*((int *)(o)))

/* C types */
#define CTYPE_PTR_ 1
#define CTYPE_CHAR_ 2
#define CTYPE_INT_ 3
#define CTYPE_FLOAT_ 4
#define CTYPE_DOUBLE_ 5

/* categories of features */
#define F_ATTRIBUTE 1
#define F_ROUTINE   2
#define F_SHARED    3
#define F_CONSTANT  4

/* Make key for hash table */
#define DISPATCH_KEY_(c,n) ((((unsigned int)n)<<14)+c)

/* shorthand size of data types in C */
#define SC_ sizeof(char)
#define SS_ sizeof(short)
#define SI_ sizeof(int)
#define SL_ sizeof(long)
#define SF_ sizeof(float)
#define SD_ sizeof(double)
#define SP_ sizeof(ptr)

/* The size in bytes of the ctypes 1,2,3,4,5
 1 => ptr
 2 => char
 3 => int
 4 => float
 5 => double */

#define ctype_size_(c) ((c)==CTYPE_PTR_?  \
			   SP_:           \
			 ((c)==CTYPE_CHAR_? \
			   SC_:             \
			 ((c)==CTYPE_INT_?  \
			   SI_:             \
			 ((c)==CTYPE_FLOAT_?   \
			   SF_:                \
			  /* else */ SD_))))

#define CATT_(ob,off) (*((char *)((ob)+(off))))
#define IATT_(ob,off) (*((int *)((ob)+(off))))
#define FATT_(ob,off) (*((float *)((ob)+(off))))
#define DATT_(ob,off) (*((double *)((ob)+(off))))
#define PATT_(ob,off) (*((ptr *)((ob)+(off))))

/* definitions for array access from C:
** to use (for example, to get to element i,j,k,l of a double 4d array p
** do: (note, last index in ARR macros is for uniformity).
**        DATT_(p,ARR4_(p,i,j,k,l)+SD_*l);
*/
#define ARR1_(ob_,indx1_) \
	 (ob_base_size_(TYPE_(ob_)) + 1*SI_)

#define ARR2_(ob_,indx1_,indx2_) \
	 IATT_((ob_), \
	       ob_base_size_(TYPE_(ob_)) + 2*SI_ + (SI_ * (indx1_)))

#define ARR3_(ob_,indx1_,indx2_,indx3_) \
	 IATT_((ob_), \
	       IATT_((ob_), \
		     ob_base_size_(TYPE_(ob_)) + 3*SI_ + (SI_ * (indx1_))) \
	       + (SI_ * (indx2_)))

#define ARR4_(ob_,indx1_,indx2_,indx3_,indx4_) \
	 IATT_((ob_), \
	       IATT_((ob_), \
		     IATT_((ob_), \
			   ob_base_size_(TYPE_(ob_)) + 4*SI_ + (SI_ * (indx1_))) \
		     + (SI_ * (indx2_))) \
	       + (SI_ * (indx3_)))

/* array dimension sizes from C */
#define ARRD1_(ob_) \
    (*((int *)((ptr)(ob_)+ob_base_size_(TYPE_(ob_)))))
#define ARRD2_(ob_) \
    (*((int *)((ptr)(ob_)+SI_+ob_base_size_(TYPE_(ob_)))))
#define ARRD3_(ob_) \
    (*((int *)((ptr)(ob_)+2*SI_+ob_base_size_(TYPE_(ob_)))))
#define ARRD4_(ob_) \
    (*((int *)((ptr)(ob_)+3*SI_+ob_base_size_(TYPE_(ob_)))))

/* convert string object to C char* string. Macro form. */
#define STR2C_(p) (char*)((char*)(p)+2*SI_)

/* Access to attr_table_. This is actually defined in main.c */
#ifndef SATHER_ATTR_
extern int num_classes_;
extern int* attr_table_[];
#define SATHER_ATTR_
#endif

#define ob_base_size_(i) (attr_table_[i][0])
#define ob_arr_dim_(i) (attr_table_[i][1])
#define ob_arr_ctype_(i) (attr_table_[i][2])
#define ob_attr_num_(i) (attr_table_[i][3])
#define ob_attr_ctype_(i,j) (attr_table_[i][4+j])
#define ob_attr_offset_(i,j) (attr_table_[i][4+ob_attr_num_(i)+j])

/* Access to dispatch_table_. */
#ifndef SATHER_DISPATCH_ 
extern int dispatch_table_size_;
extern int dispatch_table_[];
extern int get_dispatch_();	/* given cls and nm returns value. */
extern int ob_get_dispatch_();	/* given cls and nm returns value. */
#define SATHER_DISPATCH_
#endif

/* Make sure glt is type of ob and glv holds val for nm. */
#define cache_dispatch_(ob,nm,glt,glv) \
if(TYPE_(ob)!=glt) {glt=TYPE_(ob); glv=get_dispatch_(glt,nm);}

/* Similar to "cache_dispatch_" but for use in "f.expr" (f:$OB). */
#define ob_cache_dispatch_(ob,nm,glt,glv) \
if(TYPE_(ob)!=glt) {glt=TYPE_(ob); glv=ob_get_dispatch_(glt,nm);}

/* Same as above but for array references. glv holds base size. */
#define array_dispatch_(ob,glt,glv) \
if(TYPE_(ob)!=glt) {glt=TYPE_(ob); glv=ob_base_size_(glt);}

/* These have to be implemented as macros because temporary variables
   are updated. */
#define safe_cache_dispatch_(ob,nm,glt,glv,ln) \
if (TYPE_(ob)!=glt) {glt=TYPE_(ob); glv=safe_get_dispatch_(glt,nm,ln);}

/* Support for 'assert' statement */
#include <stdio.h>
/* 
NOTE:
-----
This macro definition is preprocessor-dependent. 
*/ 
#define assert_(x,ln,file) {if (!(x)) {printf("ASSERTION \"x\" fails at line %d in \"%s\"\n",ln,file);}}

#define SATHER_STR_(t,s,v,st) \
static struct { int tp_; int sz_; char st_[s]; } v = { t, s, st }
#define SATHER_STR1_(t,s,v,st) \
struct { int tp_; int sz_; char st_[s]; } v = { t, s, st }

#define dcHashGet_ HASH_TAB_hashGet_
#define dcHashInsert_ HASH_TAB_hashInsert_
#define dcHashInit_ HASH_TAB_hashInit_

/* Runtime support routines */
extern int OB_ici;
extern int ARRAY_ici;
extern int ARRAY2_ici;
extern int ARRAY3_ici;
extern int ARRAY4_ici;
extern int BOOL_ici;
extern int C_ici;
extern int CHAR_ici;
extern int DOUBLE_ici;
extern int ERR_ici;
extern int FILE_ici;
extern int IN_ici;
extern int INT_ici;
extern int OUT_ici;
extern int REAL_ici;
extern int SELF_TYPE_ici;
extern int STR_ici;
extern int STR_CURSOR_ici;
extern int SYS_ici;
extern int FOB_ici;
extern int UNDEFINE_ici;
extern int MONITOR_ici;
extern int MONITOR0_ici;
extern int LAST_PREDEF_ici;

extern rt_init_();
extern ptr generic_new_();
extern ptr new_();
extern ptr new1_();
extern ptr new2_();
extern ptr new3_();
extern ptr new4_();
extern ptr copy_();
extern ptr extend1_();
extern ptr extend2_();
extern ptr extend3_();
extern ptr extend4_();
extern ptr deep_copy_();
extern int get_dispatch_();
extern int atomic_p_();
extern int type_();

/* Conversion between Sather and C strings */
extern ptr str_ptr_();
extern ptr makestr_();

#ifndef SATHER_SYS_
#define SATHER_SYS_

extern int* feat_table_[];

#define cl_feat_num_(i) (feat_table_[i][0])
#define cl_ctype_(i) (feat_table_[i][1])
#define cl_arr_satype_(i) (feat_table_[i][2])
#define cl_fullname_(i) (feat_table_[i][3])
#define cl_feat_name_(i,j) (feat_table_[i][4 + j])
#define cl_feat_cat_(i,j) (feat_table_[i][4 + cl_feat_num_(i) + j])
#define cl_feat_satype_(i,j) (feat_table_[i][4 + (2 * cl_feat_num_(i)) + j])

/* Initialized as C strings */
extern char* prog_name_;
extern char* prog_dir_;
extern int** des_relation_;

extern int max_name_index_;

#endif

/* If GC is on, and user calls "malloc" or "calloc", things may get messed up. 
   NOTE: "malloc", "realloc", "free" are provided in "interface.c". */
#ifdef GC_
#define alloca gc_malloc
#define malloc(n) gc_malloc(n)
#define calloc(m,n) gc_malloc((m)*(n))
#define realloc(ptr,size) gc_realloc((ptr),(size))
#define free(ptr) gc_free((ptr))
extern char* gc_malloc();
extern char* gc_malloc_atomic();
extern char* gc_realloc();
/* Since allocation of envi vars uses malloc, sather calls setenv_, putenv_.
** sys/C/envivars_ provides a gc_malloc'ing version of these routines if
** GC_ is on. Moreover it provides a non mallocing version of setenv, putenv
** if these are not supported on some hosts. Are they?  (3/92 hws)
*/
#  define putenv(env) (putenv_(env))
#  define setenv(env) (setenv_(env))
extern int putenv_();
extern int setenv_();
#endif


/* Oct 27 1991:
   Support for stack-trace in "-chk" option. 
   Information is per-thread in the parallel version. */
extern ptr *filenames_stk_;
extern ptr *classnames_stk_;
extern ptr *routinenames_stk_;
extern int tracestk_ptr_;
extern int tracestk_size_;
extern void alloc_more_tracestk_();
extern void display_tracestk_();

#define DEFAULT_TRACESTK_SIZE_ 15
#define RESTORE_EXEC_INFO_ ((tracestk_ptr_)--)
#define UPDATE_EXEC_INFO_(fn,cn,rn)  {         \
     if (tracestk_ptr_ >= tracestk_size_) {    \
        alloc_more_tracestk_();                \
     }                                         \
     filenames_stk_[tracestk_ptr_] = fn;       \
     classnames_stk_[tracestk_ptr_] = cn;      \
     routinenames_stk_[tracestk_ptr_] = rn;    \
     tracestk_ptr_++;                          \
}


/*
  Runtime type checking
  Author: Chu-Cheow Lim
  Date: Nov 30 1990
*/
extern char safe_is_a_des_of_();
extern int bit_i_[];
extern curr_rt_type_;
extern int* des_table_[];  /* Whether a class is a descendent of another */

/* There is no need to check for void object, because if the runtime
   checks are on, void object test code would have been generated to
   execute before the type-checking code. */

/* **********  MACHINE DEPENDANT **********  */
#define BITS_PER_CHAR 8
/* num of bits in an integer */
#define IBITS (sizeof(int)*BITS_PER_CHAR) 
#define IS_A_DES_OF_(i,j) ((bit_i_[(i)%IBITS] & des_table_[j][(i)/IBITS]) != 0)

/* Reserve a range of numbers (0-10) for void objects.  The reason is described
   in "~clim/l/sather/scomp/rt_typecheck.note" */

/* We have two different type-checking macros, one for dispatched type and
   the other for non-dispatched type. */
#define TYPECHK1_(obj,j,ln) \
{if ((((int)obj) >= 0) && (((int)obj) <= 10)) {} \
else { \
  curr_rt_type_ = TYPE_(obj); \
  if (curr_rt_type_!=(j)) \
     type_mismatch_(curr_rt_type_,j,ln); \
     } \
}

#define TYPECHK2_(obj,j,ln) \
{if ((((int)obj) >= 0) && (((int)obj) <= 10)) {} \
else { \
  curr_rt_type_ = TYPE_(obj); \
  if ((curr_rt_type_!=-(j)) && (!(IS_A_DES_OF_(curr_rt_type_,-(j))))) \
     type_mismatch_(curr_rt_type_,-(j),ln); \
     } \
}


/* This is a copy of except_.h to simplify dependencies, DO NOT CHANGE THINGS HERE.
 * #include "except_.h"
 */

 /*  -*- Mode: C;  -*-
 * File: except_.h
 * Author: Heinz Schmidt (hws@ICSI.Berkeley.EDU)
 * Copyright (C) International Computer Science Institute, 1991
 *
 * COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
 * and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
 * LICENSE contained in the file: "sather/doc/license.txt" of the Sather
 * distribution. The license is also available from ICSI, 1947 Center
 * St., Suite 600, Berkeley CA 94704, USA. 
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** FUNCTION: Exception handling based on catch and throw.
 **  This is written as a basis for several implementations including C and
 **  C++, so that the macros can be easily used where Sather is used to
 **  prototype C++ classes. Once the C++ exception handling is out there,
 **  the mechanism below can be adapted to run on top of that.
 **  Usage outside Sather see comment below.
 **
 ** RELATED PACKAGES: ./exc_test*.c
 **
 ** HISTORY:
 ** Last edited: Mar 29 16:44 1992 (hws)
 ** Created: Sun Jun 30 15:01:52 1991 (hws)
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
 */

#ifndef EXCEPT_H
#define EXCEPT_H

#include <setjmp.h>

/* int setjmp(env)
 *     jmp_buf env;
 *     
 * void longjmp(env, val)
 *     jmp_buf env;
 *     int val;  
 */

/* 
 * One exception handler "frame" portion holds this, allocated on stack.
 * Per thread info, here global.
 */

struct EH_frame {
        jmp_buf exc_buf;
        int     exc_type;              /* mono > 0 ; poly < 0 */
        ptr     exc_prev;
};

ptr EH_last_frame;;

/* TEH1 = dynamic chaining + (pop_to_nxt_hdl_if_non_matching*; longjmp).
 *        rather than        (longjmp; pop_to_nxt_hdlr_if_non_matching)*
 * TEH2 = array of TEH1 chains, justified in process control where bad things
 * can get worse fast.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Usage:
 * EH_CATCH(TYPE,OBJ,
 *          TRY,             
 *          HDLR);           
 * EH_THROW(TYPE,OBJ);       
 *
 * TYPE is the tag to which the exception is raised, i.e., an int code.
 *      a positive tag matches just this type.
 *      a negative tag matches this type or one of its subtypes matches.
 * OBJ is a ptr to a user defined error object (describing the error), raised
 *      by EH_THROW, and received and used in HDLR code of the EH_CATCH.
 * TRY is the normal block of code.
 * HDLR the handler block of code that takes control when an error occurs in TRY.
 *
 * The dynamic handler chain is on the stack. Each frame pointing
 * to the previous handler and holding sufficient information to find the
 * right handler without longjmp. Only when a match is found we do the
 * expensive longjmp. Note that Sather code relies on type-safety of
 * of this code. In the C or C++ use of these macros the TYPE codes must
 * be chosen appropriately to guarantee similar type safety. We suggest
 * a table of EXCEPTION TYPES and a 2D BIT ARRAY representation of the
 * subtype relation for these few types (IS_A_DES_OF_).
 */

/* To be able to abort, we need to restore the system handler, then only raise
 * the exception. The final exit should never be reached, but who knows...
 */

void eh_restore_sigquit();

#define EH_ABORT(TYPE,OBJ,MSG) \
  { fprintf(stderr, "Unhandled exception \"%d\" of type \"%d\". %s.\n",OBJ,TYPE,MSG); \
    eh_restore_sigquit; \
    exit(1);\
   }

#define EH_CATCH(TYPE,OBJ,TRY,HDLR)\
      { struct EH_frame exc_cur;             \
        exc_cur.exc_type=TYPE;               \
        exc_cur.exc_prev=EH_last_frame;      \
        EH_last_frame=(ptr)&exc_cur;         \
        if (!(int)(OBJ=(ptr)setjmp((&exc_cur)->exc_buf))){   \
           {TRY;}                            \
	   EH_last_frame=exc_cur.exc_prev;   \
        } else {                             \
	   EH_last_frame=exc_cur.exc_prev;   \
           {HDLR;}                           \
        }; }

/* Note: for the the C++ use you may want to use EH_THROW_TYPE to pass
 * a tag explicitly. For Sather we want to allow polymorphic throws.
 */

#define EH_THROW_TYPE(TYPE,OBJ)              \
       {struct EH_frame *exc;                \
        for (exc=(struct EH_frame *)EH_last_frame;\
             ((int)exc)!=0;                  \
             exc=(struct EH_frame *)(exc->exc_prev)){\
           if (EH_MATCH(exc,(TYPE))){          \
              longjmp(exc->exc_buf,(int)(OBJ));     \
           };\
        };\
        EH_ABORT(TYPE,OBJ,"Broken using EH_THROW_TYPE under program control"); }

/* Evaluate OBJ once only! */

#define EH_THROW(OBJ)  \
        { int EH_OBJ = (int)(OBJ); \
	    { if (EH_OBJ == 0) \
		{ EH_ABORT(0,0,"Broken using EH_THROW on void object."); \
		} else { \
		  int EH_TYPE = TYPE_((ptr)EH_OBJ); \
		  if (EH_TYPE == 0) \
		    { EH_ABORT(0,EH_OBJ,"Broken using EH_THROW on void type"); \
		    } else { \
		      EH_THROW_TYPE(EH_TYPE,EH_OBJ); \
		    }  \
		}      \
	    }          \
	}

#define EH_MONO(EXC) ((EXC)->exc_type)>0
#define EH_DES_MATCH(EXC,TYPE) (EH_MONO(EXC))?0:(IS_A_DES_OF_(TYPE,-((EXC)->exc_type)))
#define EH_MATCH(EXC,TYPE) (TYPE)==(EXC)->exc_type?1:EH_DES_MATCH(EXC,TYPE)

#endif
/* EOF except_.h */

#endif

