/* * Last edited: May 24 00:51 1991 (bilmes) */
/*
**
** C functions and variables to provide lower level gdb functions
**    to Sather.
**
*/

#include <setjmp.h>

#include "defs.h"
#include "all_.h"

/*
 *  For dep.sa
 */ 

extern jmp_buf to_top_level;

int callGdbExecFileCommand(str)
     ptr str;
{
  if (str) {
    if (!setjmp(to_top_level)) {
      exec_file_command(STR2C_(str),1);
      return 1;
    } else
      return 0;
  }
  return 0;
}
     
int callGdbSymbolFileCommand(str)
     ptr str;
{
  if (str) {
    if (!setjmp(to_top_level)) {
      symbol_file_command(STR2C_(str),1);
      return 1;
    } else
      return 0;
  }  
  return 0;
}
     
int callGdbCoreFileCommand(str)
     ptr str;
{
  if (str) {
    if (!setjmp(to_top_level)) {
      core_file_command(STR2C_(str),1);
      return 1;
    } else
      return 0;
  }  
  return 0;
}
     
int callDSYS_init(str)
     ptr str;
{
  if (!setjmp(to_top_level)) {
    dsys_init();
    return 1;
  } else
    return 0;
}  


/*
 * for main.sa
 */

void callGdbInitializeAllFiles()
{
  initialize_all_files();
}

void callGdbMain()
{
  gdbMain(0,0);
}



/*
 * for readline.sa
 */


ptr
callGnuReadLine(prompt)
  ptr prompt;
{
  char *res;
  char *readline();
  ptr p;
  res = readline(STR2C_(prompt));
  p =  (ptr)makestr_(res);
  free(res);
  return p;
}

void
callGnuAddHistory(str)
     ptr str;
{
  add_history(STR2C_(str));
}

