/* * Last edited: Mar 16 21:59 1992 (hws) */
/* File: sather/C/timer.c
   Author: Chu-Cheow Lim
   Created: Mon Dec 10 14:25:23 1990
   Copyright (C) International Computer Science Institute, 1990

  COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
  and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
  LICENSE contained in the file: "sather/doc/license.txt" of the Sather
  distribution. The license is also available from ICSI, 1947 Center
  St., Suite 600, Berkeley CA 94704, USA.
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   $Id: timer.c,v 1.3 91/05/31 10:14:22 bilmes Exp $
   Provides support for keeping track of both user and system time.
*/

#include "all_.h"

#ifdef SCO
#include <sys/select.h>
#endif

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include "c_names_.h"

#if defined(hpux)
/* From Jean-Jacques Moreau's msg of 13 Aug 91.
 *  I have ported Sather to an HP9000s300 running HP-UX 7.05. To the best of
 *  my understanding, the port should also work on s800 and on machines running
 *  the new HP-UX 8.0.
 * 
 *  Note that the compiler includes bin.$ARCH/time_.o
 *  which has the work arounds.
 * 
 */

#include <unistd.h>

extern int getrusage (who, rusage)
     int who;
     struct rusage *rusage;

extern pid_t wait4 (pid, status, options, rusage)
     pid_t pid;
     int *status;
     int options;
     struct rusage *rusage;

#endif


ptr timer_c_create();

ptr timer_create()
{
  struct rusage ru;
  double utime, stime;

  getrusage(RUSAGE_SELF, &ru);
  utime = ru.ru_utime.tv_sec + 0.000001 * ru.ru_utime.tv_usec;
  stime = ru.ru_stime.tv_sec + 0.000001 * ru.ru_stime.tv_usec;
  return (timer_c_create(0, utime, stime));
}


ptr report_timer(cid)
int cid;
{
  struct rusage ru;
  int statusp;
  double utime, stime;
  int pid;
#ifdef mips
  pid = wait3( &statusp, 0, &ru);
#else
#  if defined(hpux) || defined(sequent)
  pid = wait3( &statusp, 0, &ru);
#  else
  pid = wait4(cid, &statusp, 0, &ru);
#  endif
#endif
  if (cid == pid) {
    utime = ru.ru_utime.tv_sec + 0.000001 * ru.ru_utime.tv_usec;
    stime = ru.ru_stime.tv_sec + 0.000001 * ru.ru_stime.tv_usec;
    return (timer_c_create(0, utime, stime));
  }
  return 0;
}
