/* HISTORY:
 ** Last edited: Mar 30 03:26 1992 (hws)
 **  Mar 15 11:58 1992 (hws): integrated exceptions from local compiler.
 **  Nov 27 08:06 1991 (hws): eliminated '=' sign in alias notation.
/*
/* YACC (or Bison or BYACC) grammar for the version of Sather written in 
   Sather. Tries to do minimal work in parser (eg. uses IDENTIFIER as
   high up as possible, etc.)

  COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
  and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
  LICENSE contained in the file: "sather/doc/license.txt" of the Sather
  distribution. The license is also available from ICSI, 1947 Center
  St., Suite 600, Berkeley CA 94704, USA.

  $Id: ssather.y,v 1.5 91/05/31 10:14:00 bilmes Exp $
*/
%{
#include <stdio.h>
#include "all_.h"

extern ptr id_exprob_create();
extern ptr char_const_exprob_create();
extern ptr int_const_exprob_create();
extern ptr real_const_exprob_create();
extern ptr bool_const_exprob_create();
extern ptr str_const_exprob_create();

extern ptr op_exprob_create_unary();
extern ptr op_exprob_create_binary();

extern ptr aref_exprob_create();
extern ptr id_args_exprob_create();
extern ptr expr_args_exprob_create();
extern ptr typespec_args_exprob_create();

extern ptr exprob_put_name();

extern ptr lst_exprob_create();
extern ptr lst_exprob_push();
extern ptr lst_exprob_append();
extern ptr lst_stmtob_create();
extern ptr lst_stmtob_push();
extern ptr lst_stmtob_append();
extern ptr lst_when_stmtob_create();
extern ptr lst_when_stmtob_push();
extern ptr lst_declob_create();
extern ptr lst_declob_append();
extern ptr lst_typeob_create();
extern ptr lst_typeob_push();
extern ptr lst_featob_create();
extern ptr lst_featob_append();
extern ptr lst_featob_push();

extern ptr lst_int_create();
extern ptr lst_int_push();

extern ptr debug_stmtob_create();
extern ptr assert_stmtob_create();
extern ptr when_stmtob_create();
extern ptr switch_stmtob_create();
extern ptr loop_stmtob_create();
extern ptr elsif_stmtob_create();
extern ptr except_stmtob_create();
extern ptr cond_stmtob_create();
extern ptr assign_stmtob_create();
extern ptr call_stmtob_create();
extern ptr break_stmtob_create();
extern ptr return_stmtob_create();

extern ptr local_decl_stmtob_create();
extern ptr local_decl_stmtob_create_lst();

extern ptr simple_typeob_create();
extern ptr dispatch_typeob_create();
extern ptr param_typeob_create();

extern ptr const_decl_featob_create_lst();
extern ptr shared_decl_featob_create_lst();
extern ptr attr_decl_featob_create_lst();
extern ptr param_declob_create_lst();

extern ptr cinh_featob_create();
extern ptr rout_featob_create();
extern ptr alias_featob_create();

extern ptr any_declob_create();
extern int any_declob_ith_name();
extern ptr any_declob_get_type_spec();

extern ptr main_process_classdef();
extern ptr classob_table_install();
extern ptr classob_create();
extern ptr lst_featob_mark_private();

extern ptr globals_classes_defs();

extern int str_table_index_of_str();
extern ptr str_table_at_index();
extern ptr str_buffer_create();
extern ptr str_buffer_strval();
extern char str_buffer_equal();
extern ptr str_buffer_terminate();
extern int str_buffer_length();
extern void str_buffer_init();
extern ptr str_buffer_push();
extern char str_buffer_pop();

extern int globals_curr_lineno;

/*
  Partial list of Sather constants used in "lexer.h".
  Refer to Sather definitions in "constants.sa".
*/

#define ALIAS_IND 62
#define AND_IND 1
#define ASSERT_IND 2
#define BREAK_IND 3
#define CLASS_IND 4
#define CONSTANT_IND 5
#define DEBUG_IND 6
#define ELSE_IND 7
#define ELSIF_IND 8
#define END_IND 9
#define EXCEPT_IND 60
#define FALSE_IND 35 
#define IF_IND 10
/*#define INLINE_IND 11*/
#define IS_IND 12
#define LOOP_IND 13
#define NOT_IND 14
#define OR_IND 15
#define PRIVATE_IND 16
#define RETURN_IND 17
#define SHARED_IND 18
#define SWITCH_IND 19
#define THEN_IND 20
#define TRUE_IND 36
#define UNTIL_IND 21
#define WHEN_IND 22

#define NOT_OP_IND 1
#define LT_OP_IND 2
#define GT_OP_IND 3
#define LE_OP_IND 4
#define GE_OP_IND 5
#define EQ_OP_IND 6
#define NE_OP_IND 7
#define AND_OP_IND 8
#define OR_OP_IND 9
#define UMINUS_OP_IND 10
#define UPLUS_OP_IND 11
#define EXP_OP_IND 12
#define PLUS_OP_IND 13
#define MINUS_OP_IND 14
#define MULT_OP_IND 15
#define DIVIDE_OP_IND 16

%}

%union{
int lnno;                       /* the current Sather line number  */
int ind;			/* the index into the string table */
ptr val;			/* a pointer to a syntactic object */
}

%type <val> opt_type_vars ident_list feature_list feature type_spec
%type <val> type_spec_list var_dec single_var_dec mult_ident_list
%type <val> shared_attr_dec var_dec_list routine_dec alias_dec alias_list statement_list block statement
%type <val> local_dec assignment conditional elsif_part else_part loop switch
%type <val> when_part assert debug call arg_vals exp_list expr /* kexpr kexp_list */
%type <val> cexpr nexpr aref const_attr_dec
%type <lnno> getlnno

/* Modifications: added (hws) */
%token ALIAS ASSERT BREAK CLASS CONSTANT DEBUG ELSE ELSIF END EXCEPT IF IS
/*%token INLINE */
%token LOOP PRIVATE RETURN SHARED SWITCH THEN UNTIL WHEN ASSIGN CREF
%token <val> CHAR_CONST INT_CONST REAL_CONST
/* The old version returns a string associated with STR_CONST. */
%token <ind> STR_CONST
%token <ind> BOOL_CONST
%token <ind> IDENTIFIER

%left OR
%left  AND
%left '=' NE
%nonassoc LE '<' '>' GE
%left '+' '-'
%left '*' '/'
/*
%right '^'
*/
%right NOT
%left '.'
%nonassoc NO_OP
%right UNARY

%%
class_list:			/* Empty */
  | class			/* One class */
  | class_list ';'		/* Extra semi-colon */
  | class_list ';' class	/* Several classes */
  | class_list ';' error ';'
                                /* YACC will print an error msg */
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
class: CLASS IDENTIFIER opt_type_vars IS feature_list END
    { main_process_classdef(0, classob_create(NULL,$2,$3,$5)); }
  | CLASS IDENTIFIER error IS feature_list END
                                /* YACC will print an error msg */
    { main_process_classdef(0, classob_create(NULL,$2,NULL,$5)); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
opt_type_vars:			/* Might not be any */
    { $$ = (ptr)NULL; }
  | '{'  ident_list '}'
    { $$ = $2; }
  | '{' error '}'
                                /* YACC will print an error msg */
    { $$ = (ptr)NULL; }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
ident_list: IDENTIFIER		/* Comma separated identifiers */
    { $$ = (ptr)lst_int_push(lst_int_create(NULL,5),$1); }
  | ident_list ',' IDENTIFIER
    { $$ = (ptr)lst_int_push($1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
feature_list:
    feature			/* One feature */
    { $$ = (ptr)$1; }           /* NOTE: A list of features is returned by
				   "feature". */
  | feature_list ';'		/* Extra semi-colon */
    { $$ = (ptr)$1; }

  | feature_list ';' feature  	/* Several features */
    { $$ = (ptr)lst_featob_append($1,$3); }
  | feature_list ';' error ';'
                                /* YACC will print an error msg */
    { $$ = (ptr)$1; }
  |		                /* Empty */
    { $$ = (ptr)lst_featob_create(NULL,5); }	
                                /* If NULL would get pimped by feature * /
;

/* 
  Modifications: Removed feature inheritance
                 Added attribute initializers (hws)
  Sather-To-C Mapping: DONE

  !* Each kind of feature returns a list of features.  The reason
  for this is because "var_dec", "shared_attr_dec", "const_attr_dec"
  all returns a list of $FEATOB.
*/
feature: type_spec		/* Inherited class */
    { $$ = (ptr)lst_featob_push(lst_featob_create(NULL,1),
				cinh_featob_create(NULL,$1)); }

  | var_dec			/* Attribute */
    { $$ = (ptr)attr_decl_featob_create_lst(NULL,$1,NULL);}		    

  | var_dec ASSIGN expr		/* Initialized attribute */
    { $$ = (ptr)attr_decl_featob_create_lst(NULL,$1,$3);}
    
  | routine_dec			/* Routine */
    { $$ = (ptr)lst_featob_push(lst_featob_create(NULL,1),
				$1); }		    

  | shared_attr_dec		/* Shared attribute */
    { $$ = (ptr)$1; }		    

  | const_attr_dec		/* Constant attribute */
    { $$ = (ptr)$1; }

  | ALIAS alias_list		/* Alias features */
    { $$ = (ptr)$2; }

  | PRIVATE ALIAS alias_list /* Private alias features */
    { $$ = (ptr)$3; 
      lst_featob_mark_private($$); }

  | PRIVATE var_dec		/* Private attribute */
    { $$ = (ptr)attr_decl_featob_create_lst(NULL,$2,NULL);  
      lst_featob_mark_private($$); }

  | PRIVATE var_dec ASSIGN expr	/* Private initialized attribute */
    { $$ = (ptr)attr_decl_featob_create_lst(NULL,$2,$4);  
      lst_featob_mark_private($$); }

  | PRIVATE routine_dec		/* Private routine */
    { $$ = (ptr)lst_featob_push(lst_featob_create(NULL,1),
				$2); 
      lst_featob_mark_private($$); }		    

  | PRIVATE shared_attr_dec	/* Private shared attribute */
    { $$ = (ptr)$2;
      lst_featob_mark_private($$); }		   
  | PRIVATE  const_attr_dec	/* Private constant attribute */
    { $$ = (ptr)$2;
      lst_featob_mark_private($$); }		    
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
alias_list: alias_dec             /* Alias definition */
    { $$ = (ptr)lst_featob_push(lst_featob_create(NULL,1),$1); }
  | alias_list ',' alias_dec
    { $$ = (ptr)lst_featob_push($1,$3); }
;

alias_dec: IDENTIFIER getlnno IDENTIFIER       /* Alias feature: newname is oldname */
    { $$ = (ptr)alias_featob_create(NULL,$1,$3,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
type_spec: IDENTIFIER		          /* Simple name */
    { $$ = (ptr)simple_typeob_create(NULL,$1); }
  | '$' type_spec		          /* Dispatched type */
    { $$ = (ptr)dispatch_typeob_create(NULL,$2); }
  | IDENTIFIER '{' type_spec_list '}'     /* Parameterized type */
    { $$ = (ptr)param_typeob_create(NULL,$1,$3); }
  | IDENTIFIER '{'  error '}'
                                          /* YACC will print an error msg */
    { $$ = (ptr)simple_typeob_create(NULL,$1); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
type_spec_list: type_spec	     /* Just one */
    { $$ = (ptr)lst_typeob_push(lst_typeob_create(NULL,5),$1); }
  | type_spec_list ',' type_spec     /* Comma separated list */
    { $$ = (ptr)lst_typeob_push($1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
var_dec: single_var_dec		/* Single variable declaration (so can 
                                   use in routine) */
    { $$ = (ptr)$1; }
  | mult_ident_list ':' type_spec 
                                /* Declaration of set of variables */
    { $$ = (ptr)any_declob_create(NULL,$1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
single_var_dec: IDENTIFIER ':' type_spec
    { $$ = (ptr)any_declob_create(NULL,
			       lst_int_push(lst_int_create(NULL,1),$1),
			       $3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
mult_ident_list: ident_list ',' IDENTIFIER 
                                    /* More than one elements in list */
    { $$ = (ptr)lst_int_push($1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
shared_attr_dec: SHARED var_dec   /* Uninitialized shared attribute */
    { $$ = (ptr)shared_decl_featob_create_lst(NULL,$2,NULL); }
  | SHARED var_dec ASSIGN expr    /* Initialized shared attribute */
    { $$ = (ptr)shared_decl_featob_create_lst(NULL,$2,$4); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE

  This production is used only for parameter declarations.
*/
var_dec_list: var_dec		/* One declaration */
    { $$ = (ptr)param_declob_create_lst(NULL,$1); }
  | var_dec_list ';'		/* Extra semi-colon */
    { $$ = (ptr)$1; }
  | var_dec_list ';' var_dec	/* Several declarations */
    { $$ = (ptr)lst_declob_append($1,param_declob_create_lst(NULL,$3)); }
;

/* 
  Modifications: 
  Sather-To-C Mapping: 
*/
routine_dec: IDENTIFIER IS getlnno block getlnno END 
    { $$ = (ptr)rout_featob_create(NULL,$1,NULL,NULL,$4,$3,$5); }
  | IDENTIFIER '(' var_dec_list ')' IS getlnno block getlnno END
    { $$ = (ptr)rout_featob_create(NULL,$1,$3,NULL,$7,$6,$8); }
  | single_var_dec IS getlnno block getlnno END
    { $$ = (ptr)rout_featob_create(NULL,
				any_declob_ith_name($1,0),
				NULL,
				any_declob_get_type_spec($1),
				$4,
				$3,$5); }
  | IDENTIFIER '(' var_dec_list ')' ':' type_spec IS getlnno block getlnno END
    { $$ = (ptr)rout_featob_create(NULL,$1,$3,$6,$9,$8,$10); }
/*
  | INLINE IDENTIFIER IS block END
    { $$ = (ptr)rout_featob_create(NULL,$2,NULL,NULL,$4,1); }
  | INLINE IDENTIFIER '(' var_dec_list ')' IS block END
    { $$ = (ptr)rout_featob_create(NULL,$2,$4,NULL,$7,1); }
  | INLINE IDENTIFIER ':' type_spec IS block END
    { $$ = (ptr)rout_featob_create(NULL,$2,NULL,$4,$6,1); }
  | INLINE IDENTIFIER '(' var_dec_list ')' ':' type_spec IS block END
    { $$ = (ptr)rout_featob_create(NULL,$2,$4,$7,$9,1); }
*/
;

/* 
  Modifications: 
  1.  Syntax for "constant" constructs now follow "shared" constructs
      except that initialization is compulsory.

  Sather-To-C Mapping: DONE
*/
const_attr_dec: CONSTANT var_dec ASSIGN expr
    { $$ = (ptr)const_decl_featob_create_lst(NULL,$2,$4); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
block:
    IDENTIFIER getlnno IS block END
    { $$ = (ptr)$4; exprob_put_name($$,$1); }
  | statement_list /* without exception handler */
    { $$ = (ptr)$1; }
  | block EXCEPT getlnno '(' single_var_dec ')' THEN statement_list /* with handler */
    { $$ = (ptr)lst_stmtob_push(lst_stmtob_create(NULL,1),
			      except_stmtob_create(NULL,$1,$8,$5,$3)); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
statement_list:
    statement		  	   /* One statement */
    { $$ = (ptr)lst_stmtob_push(lst_stmtob_create(NULL,5),$1); }
  | local_dec		  	   /* Local declaration */
    { $$ = (ptr)local_decl_stmtob_create_lst(NULL,$1); }
  | statement_list ';'		   /* Extra semi-colon */
    { $$ = (ptr)$1; }
  | statement_list ';' statement   /* Several statements  */
    { $$ = (ptr)lst_stmtob_push($1,$3); }
  | statement_list ';' local_dec   
    { $$ = (ptr)lst_stmtob_append($1,local_decl_stmtob_create_lst(NULL,$3)); }
  | statement_list ';' error ';'
                                   /* YACC will print an error msg */
    { $$ = $1; }
  |			           /* Empty */
    { $$ = (ptr)lst_stmtob_create(NULL,5); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
  Local declaration is not reduced to statement first, because we
  need to expand local declaration into a list of declaration nodes,
  unlike other kinds of statements which are directly added.
*/
statement: IDENTIFIER
    { $$ = (ptr)call_stmtob_create(NULL,
				id_exprob_create(NULL,
					      $1)); }
  | assignment			
    { $$ = (ptr)$1; }
  | conditional
    { $$ = (ptr)$1; }
  | loop
    { $$ = (ptr)$1; }
  | switch
    { $$ = (ptr)$1; }
  | BREAK		/* Exit current block */
    { $$ = (ptr)break_stmtob_create(NULL,NULL); }
	     /* Exit named block */
  /*  | BREAK IDENTIFIER
    { $$ = (ptr)break_stmtob_create(NULL,NULL); 
      exprob_put_name($$,$2); } */
  | expr BREAK                  /* Exceptional exit from current block */
    { $$ = (ptr)break_stmtob_create(NULL,$1); }
  /* Exceptional exit from named block  */
  /* | expr BREAK IDENTIFIER       
    { $$ = (ptr)break_stmtob_create(NULL,$1); 
      exprob_put_name($$,$3); } */
  | RETURN			/* Return statement */
    { $$ = (ptr)return_stmtob_create(NULL); }
  | call
    { $$ = (ptr)call_stmtob_create(NULL,$1); }
  | assert
    { $$ = (ptr)$1; }
  | debug
    { $$ = (ptr)$1; }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
  Currently a LOCAL_DECL_STMTOB contains a list of names.  The
    expansion is done when pushed into the statement list.
*/
local_dec: var_dec		/* Uninitialized */
    { $$ = (ptr)local_decl_stmtob_create(NULL,$1,NULL); }
  | var_dec ASSIGN expr	        /* Initialized */
    { $$ = (ptr)local_decl_stmtob_create(NULL,$1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
assignment: expr getlnno ASSIGN expr        /* Check L-value during semantics */
    { $$ = (ptr)assign_stmtob_create(NULL,$1,$4,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
conditional: 
    IF getlnno expr THEN block 
    elsif_part else_part END
    { $$ = (ptr)cond_stmtob_create(NULL,$3,$5,$6,$7,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
elsif_part:			/* Empty */
    { $$ = (ptr)lst_stmtob_create(NULL, 5); }
  | elsif_part ELSIF getlnno expr THEN block 
    { $$ = (ptr)lst_stmtob_push($1,elsif_stmtob_create(NULL,$4,$6,$3)); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: NA
*/
else_part:
    ELSE block
    { $$ = (ptr)$2; }
  |			/* Empty */
    { $$ = (ptr)NULL; };

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
loop: 
   UNTIL getlnno expr LOOP block END
   { $$ = (ptr)loop_stmtob_create(NULL,$3,$5,$2); }
  | 
   LOOP getlnno block END
   { $$ = (ptr)loop_stmtob_create(NULL,NULL,$3,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
switch: SWITCH getlnno expr when_part else_part END
    { $$ = (ptr)switch_stmtob_create(NULL,$3,$4,$5,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
when_part:
    when_part WHEN exp_list THEN block
    { $$ = (ptr)lst_when_stmtob_push($1,when_stmtob_create(NULL,$3,$5)); }
  |			/* Empty */
    { $$ = (ptr)lst_when_stmtob_create(NULL, 5);}     
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
assert: ASSERT getlnno '(' IDENTIFIER ')' expr END
  { $$ = (ptr)assert_stmtob_create(NULL, $4,$6,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
debug: DEBUG getlnno '(' IDENTIFIER ')' block END
  { $$ = (ptr)debug_stmtob_create(NULL, $4,$6,$2); }
;

/* 
  Modifications: 
  Sather-To-C Mapping: 
*/
call: 
    IDENTIFIER '(' exp_list ')'
    { $$ = (ptr)id_args_exprob_create(NULL,
				   $1,
				   $3); }
/*  |
    IDENTIFIER '(' exp_list ',' kexp_list ')'
    { $$ = (ptr)id_args_exprob_create(NULL,
				   $1,
				   $3); } */

  | cexpr '.' IDENTIFIER arg_vals 
                                  /* Routine call on computed objects */
    { $$ = (ptr)expr_args_exprob_create(NULL,
				     $1,
				     $3,
				     $4); }
  | type_spec CREF IDENTIFIER arg_vals 
                                  /* Routine call in another class */
    { $$ = (ptr)typespec_args_exprob_create(NULL,
					 $1,
					 $3,
					 $4); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: NA
*/
arg_vals:
    '(' exp_list ')'		/* List of argument values */
    { $$ = (ptr)$2; }
  |			        /* Empty */
    { $$ = NULL; };

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
exp_list: expr		/* One expressions */
    { $$ = (ptr)lst_exprob_push(lst_exprob_create(NULL, -1),$1); }
  | exp_list ',' expr	/* Several expressions */
    { $$ = (ptr)lst_exprob_push($1,$3); }
  | exp_list ',' error ','
                        /* YACC will print an error msg */
    { $$ = $1; }
;

/*
  Added for improved initialization protocol (hws)
  Sather-To-C Mapping: NA
*/


/* kexp_list: kexpr           */  /* One expression */ /*
     { $$ = (ptr)lst_exprob_push(lst_exprob_create(NULL, -1),$1); }
  | kexp_list ',' kexpr	*/ /* Several expressions */ /*
    { $$ = (ptr)lst_exprob_push($1,$3); }
  | kexp_list ',' error ','
                       */ /* YACC will print an error msg */ /*
    { $$ = $1; }
; 

kexpr: IDENTIFIER ':' expr       */ /* keyword parameter passing for new */ /* 
                                 */ /* can perhaps be extended more generally later */ /* 
        { $$=$3; 
	  exprob_put_name($$,$1); }
; */

/* 
  Modifications: NONE
  Sather-To-C Mapping: NA
*/
expr: cexpr			/* Callable expr can apply . or [] to it */
    { $$=$1; }
  | nexpr			/* Noncallable expresssion */
    { $$=$1; }
;

/* 
   Modifications:
   1.  Added BOOL_CONST

   Sather-To-C Mapping : DONE
*/
cexpr: 
    IDENTIFIER		/* Callable expression */
    { $$ = (ptr)id_exprob_create(NULL, $1); }
  | CHAR_CONST
    { $$ = (ptr)char_const_exprob_create(NULL, $1); }
  | INT_CONST
    { $$ = (ptr)int_const_exprob_create(NULL, $1); }
  | REAL_CONST
    { $$ = (ptr)real_const_exprob_create(NULL, $1); }
  | BOOL_CONST
    { $$ = (ptr)bool_const_exprob_create(NULL, $1); }
  | STR_CONST
    { $$ = (ptr)str_const_exprob_create(NULL, $1); }
  | call		
    { $$ = (ptr)$1; }
  | aref		
    { $$ = (ptr)$1; }
  | '(' expr ')'
    { $$ = $2; }
  | '(' error ')'                 
                                /* YACC will print an error msg */
    { $$ = (ptr)int_const_exprob_create(NULL, "0"); }
;


/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
nexpr: NOT expr
    { $$ = (ptr)op_exprob_create_unary(NULL,NOT_OP_IND,$2); }
  | expr '<' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,LT_OP_IND,$1,$3); }
  | expr '>' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,GT_OP_IND,$1,$3); }
  | expr LE expr
    { $$ = (ptr)op_exprob_create_binary(NULL,LE_OP_IND,$1,$3); }
  | expr GE expr
    { $$ = (ptr)op_exprob_create_binary(NULL,GE_OP_IND,$1,$3); }
  | expr '=' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,EQ_OP_IND,$1,$3); }
  | expr NE expr
    { $$ = (ptr)op_exprob_create_binary(NULL,NE_OP_IND,$1,$3); }
  | expr AND expr
    { $$ = (ptr)op_exprob_create_binary(NULL,AND_OP_IND,$1,$3); }
  | expr OR expr
    { $$ = (ptr)op_exprob_create_binary(NULL,OR_OP_IND,$1,$3); }
  | '-' expr      %prec UNARY
    { $$ = (ptr)op_exprob_create_unary(NULL,UMINUS_OP_IND,$2); }
  | '+' expr      %prec UNARY
    { $$ = (ptr)op_exprob_create_unary(NULL,UPLUS_OP_IND,$2); }
/*
  | expr '^' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,EXP_OP_IND,$1,$3); }
*/
  | expr '+' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,PLUS_OP_IND,$1,$3); }
  | expr '-' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,MINUS_OP_IND,$1,$3); }
  | expr '*' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,MULT_OP_IND,$1,$3); }
  | expr '/' expr
    { $$ = (ptr)op_exprob_create_binary(NULL,DIVIDE_OP_IND,$1,$3); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
*/
aref: cexpr '[' exp_list ']'	/* Array reference */
    { $$ = (ptr)aref_exprob_create(NULL,$1,$3); }
  | '[' exp_list ']'		/* Reference to self when of array type */
    { $$ = (ptr)aref_exprob_create(NULL,NULL,$2); }
;

/* 
  Modifications: NONE
  Sather-To-C Mapping: DONE
  A Rule that simply provides the current line number.
  Other Rules use this so that they may store the line number before the
  Sather construct they represent (e.g. to store the line number of the beginning
  of an until statement rather than the end).
*/
getlnno:
   { $$ = (int)globals_curr_lineno; }
;

/* end of grammar */
%%
#include "lexer.h"


