package Algorithm::Easing::Elastic;

use Moo;

use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if ($t == 0) {
        return $b;
    }

    if (($t /= $d) == 1) {
        return $b + $c;
    }

    my $p = $d * 0.3;
    my $a = $c;
    my $s = $p / 4;

    my $post_fix = $a * $self->pow(2, 10 * ($t -= 1));
    return -($post_fix * sin(($t * $d - $s) * ( 2 * pi)/ $p )) + $b;
}

sub ease_out {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if ($t==0) {
        return $b;
    }

    if (($t /= $d) == 1) {
        return $b + $c;
    }

    my $p = $d * 0.3;
    my $a = $c;
    my $s = $p / 4;

    return ($a * $self->pow(2, -10 * $t) * sin(($t * $d - $s) * (2 * pi) / $p ) + $c + $b);
}

sub ease_both {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if ($t == 0) {
        return $b;
    }

    if (($t /= $d / 2) == 2) {
        return $b + $c;
    }

    my $p = $d * (0.3 * 1.5);
    my $a = $c;
    my $s = $p / 4;

    if ($t < 1) {
        my $post_fix = $a * $self->pow(2,10 * ($t-=1));
        return -0.5*($post_fix * sin(($t * $d - $s) * (2 * pi) / $p )) + $b;
    }

    my $post_fix =  $a * $self->pow(2,-10 * ($t-=1));
    return $post_fix * sin(($t * $d - $s) * (2 * pi)/$p ) * 0.5 + $c + $b;
}

1;

__END__
