package Algorithm::Easing::Circular;

use Moo;

use Math::Complex;
use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return -$c * ( sqrt(1 - ($t /= $d) * $t) - 1) + $b;
}

sub ease_out  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return $c * sqrt(1 - ($t = $t / $d - 1) * $t) + $b;
}

sub ease_both  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if (($t /= $d / 2) < 1) {
        return -$c / 2 * (sqrt(1 - $t * $t) - 1) + $b;
    }

    return $c / 2 * (sqrt(1 - $t * ($t -= 2)) + 1) + $b;
}

1;

__END__
