use Test::More;

use Data::Integer 0.000 qw(natint_bits);
use Data::Float 0.000 qw(have_nan significand_bits);

plan skip_all => "tests not designed for these word sizes"
	unless natint_bits == 32 && significand_bits == 52;
plan tests => 11881;
require_ok "Scalar::Number";
Scalar::Number->import(qw(sclnum_val_cmp));

my @values = (
	# around -2^54
	-18014398509481988,
	-18014398509481984,
	-18014398509481982,
	-18014398509481980,

	# around -2^53
	-9007199254740994,
	-9007199254740992,
	-9007199254740991,
	-9007199254740990,

	# around -2^52
	-4503599627370497,
	-4503599627370496,
	-4503599627370495.5,
	-4503599627370495,
	-4503599627370494.5,
	-4503599627370494,

	# around -2^51
	-2251799813685249.5,
	-2251799813685249,
	-2251799813685248.5,
	-2251799813685248,
	-2251799813685247.5,
	-2251799813685247,
	-2251799813685246.5,
	-2251799813685246,

	# around -2^33
	-8589934593.5,
	-8589934593,
	-8589934592.5,
	-8589934592,
	-8589934591.5,
	-8589934591,
	-8589934590.5,
	-8589934590,

	# around -2^32
	-4294967297.5,
	-4294967297,
	-4294967296.5,
	-4294967296,
	-4294967295.5,
	-4294967295,
	-4294967294.5,
	-4294967294,

	# around -2^31
	-2147483649.5,
	-2147483649,
	-2147483648.5,
	-2147483648,
	-2147483647.5,
	-2147483647,
	-2147483646.5,
	-2147483646,

	# around -2^24
	-16777217.5,
	-16777217,
	-16777216.5,
	-16777216,
	-16777215.5,
	-16777215,
	-16777214.5,
	-16777214,

	# around +2^24
	+16777214,
	+16777214.5,
	+16777215,
	+16777215.5,
	+16777216,
	+16777216.5,
	+16777217,
	+16777217.5,

	# around +2^31
	+2147483646,
	+2147483646.5,
	+2147483647,
	+2147483647.5,
	+2147483648,
	+2147483648.5,
	+2147483649,
	+2147483649.5,

	# around +2^32
	+4294967294,
	+4294967294.5,
	+4294967295,
	+4294967295.5,
	+4294967296,
	+4294967296.5,
	+4294967297,
	+4294967297.5,

	# around +2^33
	+8589934590,
	+8589934590.5,
	+8589934591,
	+8589934591.5,
	+8589934592,
	+8589934592.5,
	+8589934593,
	+8589934593.5,

	# around +2^51
	+2251799813685246,
	+2251799813685246.5,
	+2251799813685247,
	+2251799813685247.5,
	+2251799813685248,
	+2251799813685248.5,
	+2251799813685249,
	+2251799813685249.5,

	# around +2^52
	+4503599627370494,
	+4503599627370494.5,
	+4503599627370495,
	+4503599627370495.5,
	+4503599627370496,
	+4503599627370497,

	# around +2^53
	+9007199254740990,
	+9007199254740991,
	+9007199254740992,
	+9007199254740994,

	# around +2^54
	+18014398509481980,
	+18014398509481982,
	+18014398509481984,
	+18014398509481988,
);

SKIP: {
	skip "NaN not available", 216 unless have_nan;
	my $nan = &{"Data::Float::nan"};
	foreach(@values) {
		is sclnum_val_cmp($nan, $_), undef;
		is sclnum_val_cmp($_, $nan), undef;
	}
}

for(my $ia = @values; $ia--; ) {
	for(my $ib = @values; $ib--; ) {
		SKIP: {
			my $a = $values[$ia];
			my $b = $values[$ib];
			skip "special value not available", 1
				unless defined($a) && defined($b);
			is sclnum_val_cmp($a, $b), ($ia <=> $ib);
		}
	}
}
