package Data::Faker::Name;
use vars qw($VERSION); $VERSION = '0.10_03';
use base 'Data::Faker';

=head1 NAME

Data::Faker::Name - Data::Faker plugin

=head1 SYNOPSIS AND USAGE

See L<Data::Faker>

=head1 DATA PROVIDERS

=over 4

=item name

Return a fake person's name (first and last possibly with suffixes such as Jr
or PhD).

=cut

__PACKAGE__->register_plugin(
	name => [
		'$name_prefix $first_name $last_name',
		'$first_name $last_name $name_suffix',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
		'$first_name $last_name',
	],
);

=item name_suffix

Return a random name suffix (Jr., Sr., I, II, III, MD, PhD, etc.)

=cut

__PACKAGE__->register_plugin(
	name_suffix => [qw/Jr. Sr. I II III IV V MD DDS PhD DVM/],
);

=item name_prefix

Return a random name prefix (Mr., Mrs., Dr., etc.)

=cut

__PACKAGE__->register_plugin(
	name_prefix => [qw/Mr. Mrs. Ms. Miss Dr./],
);

=item last_name

Return a fake persons last name (mostly english names.)

=cut

__PACKAGE__->register_plugin(
	last_name => [qw(
		Abbott Abernathy Abshire Adams Altenwerth Anderson Ankunding Armstrong
		Auer Aufderhar Bahringer Bailey Balistreri Barrows Bartell Bartoletti
		Barton Bashirian Batz Bauch Baumbach Bayer Beahan Beatty Bechtelar
		Becker Bednar Beer Beier Berge Bergnaum Bergstrom Bernhard Bernier
		Bins Blanda Blick Block Bode Boehm Bogan Bogisich Borer Bosco Botsford
		Boyer Boyle Bradtke Brakus Braun Breitenberg Brekke Brown Bruen
		Buckridge Carroll Carter Cartwright Casper Cassin Champlin Christiansen
		Cole Collier Collins Conn Connelly Conroy Considine Corkery Cormier
		Corwin Cremin Crist Crona Cronin Crooks Cruickshank Cummerata Cummings
		Dach D'Amore Daniel Dare Daugherty Davis Deckow Denesik Dibbert Dickens
		Dicki Dickinson Dietrich Donnelly Dooley Douglas Doyle DuBuque Durgan
		Ebert Effertz Eichmann Emard Emmerich Erdman Ernser Fadel Fahey Farrell
		Fay Feeney Feest Feil Ferry Fisher Flatley Frami Franecki Friesen
		Fritsch Funk Gaylord Gerhold Gerlach Gibson Gislason Gleason Gleichner
		Glover Goldner Goodwin Gorczany Gottlieb Goyette Grady Graham Grant
		Green Greenfelder Greenholt Grimes Gulgowski Gusikowski Gutkowski
		Gutmann Haag Hackett Hagenes Hahn Haley Halvorson Hamill Hammes Hand
		Hane Hansen Harber Harris Hartmann Harvey Hauck Hayes Heaney Heathcote
		Hegmann Heidenreich Heller Herman Hermann Hermiston Herzog Hessel
		Hettinger Hickle Hilll Hills Hilpert Hintz Hirthe Hodkiewicz Hoeger
		Homenick Hoppe Howe Howell Hudson Huel Huels Hyatt Jacobi Jacobs
		Jacobson Jakubowski Jaskolski Jast Jenkins Jerde Jewess Johns Johnson
		Johnston Jones Kassulke Kautzer Keebler Keeling Kemmer Kerluke
		Kertzmann Kessler Kiehn Kihn Kilback King Kirlin Klein Kling Klocko
		Koch Koelpin Koepp Kohler Konopelski Koss Kovacek Kozey Krajcik Kreiger
		Kris Kshlerin Kub Kuhic Kuhlman Kuhn Kulas Kunde Kunze Kuphal Kutch
		Kuvalis Labadie Lakin Lang Langosh Langworth Larkin Larson Leannon
		Lebsack Ledner Leffler Legros Lehner Lemke Lesch Leuschke Lind Lindgren
		Littel Little Lockman Lowe Lubowitz Lueilwitz Luettgen Lynch Macejkovic
		Maggio Mann Mante Marks Marquardt Marvin Mayer Mayert McClure McCullough
		McDermott McGlynn McKenzie McLaughlin Medhurst Mertz Metz Miller Mills
		Mitchell Moen Mohr Monahan Moore Morar Morissette Mosciski Mraz Mueller
		Muller Murazik Murphy Murray Nader Nicolas Nienow Nikolaus Nitzsche
		Nolan Oberbrunner O'Connell O'Conner O'Hara O'Keefe O'Kon Okuneva Olson
		Ondricka O'Reilly Orn Ortiz Osinski Pacocha Padberg Pagac Parisian
		Parker Paucek Pfannerstill Pfeffer Pollich Pouros Powlowski Predovic
		Price Prohaska Prosacco Purdy Quigley Quitzon Rath Ratke Rau Raynor
		Reichel Reichert Reilly Reinger Rempel Renner Reynolds Rice Rippin
		Ritchie Robel Roberts Rodriguez Rogahn Rohan Rolfson Romaguera Roob
		Rosenbaum Rowe Ruecker Runolfsdottir Runolfsson Runte Russel Rutherford
		Ryan Sanford Satterfield Sauer Sawayn Schaden Schaefer Schamberger
		Schiller Schimmel Schinner Schmeler Schmidt Schmitt Schneider Schoen
		Schowalter Schroeder Schulist Schultz Schumm Schuppe Schuster Senger
		Shanahan Shields Simonis Sipes Skiles Smith Smitham Spencer Spinka
		Sporer Stamm Stanton Stark Stehr Steuber Stiedemann Stokes Stoltenberg
		Stracke Streich Stroman Strosin Swaniawski Swift Terry Thiel Thompson
		Tillman Torp Torphy Towne Toy Trantow Tremblay Treutel Tromp Turcotte
		Turner Ullrich Upton Vandervort Veum Volkman Von VonRueden Waelchi
		Walker Walsh Walter Ward Waters Watsica Weber Wehner Weimann Weissnat
		Welch West White Wiegand Wilderman Wilkinson Will Williamson Willms
		Windler Wintheiser Wisoky Wisozk Witting Wiza Wolf Wolff Wuckert Wunsch
		Wyman Yost Yundt Zboncak Zemlak Ziemann Zieme Zulauf
	)],
);

=item first_name

Return a fake persons first name (mostly english names).

=cut

__PACKAGE__->register_plugin(
	first_name => [qw(
		Aaliyah Aaron Abagail Abbey Abbie Abbigail Abby Abdiel Abdul Abdullah
		Abe Abel Abelardo Abigail Abigale Abigayle Abner Abraham Ada Adah
		Adalberto Adaline Adam Adan Addie Addison Adela Adelbert Adele Adelia
		Adeline Adell Adella Adelle Aditya Adolf Adolfo Adolph Adolphus Adonis
		Adrain Adrian Adriana Adrianna Adriel Adrien Adrienne Afton Aglae Agnes
		Agustin Agustina Ahmad Ahmed Aida Aidan Aiden Aileen Aimee Aisha Aiyana
		Akeem Al Alaina Alan Alana Alanis Alanna Alayna Alba Albert Alberta
		Albertha Alberto Albin Albina Alda Alden Alec Aleen Alejandra
		Alejandrin Alek Alena Alene Alessandra Alessandro Alessia Aletha Alex
		Alexa Alexander Alexandra Alexandre Alexandrea Alexandria Alexandrine
		Alexandro Alexane Alexanne Alexie Alexis Alexys Alexzander Alf Alfonso
		Alfonzo Alford Alfred Alfreda Alfredo Ali Alia Alice Alicia Alisa Alisha
		Alison Alivia Aliya Aliyah Aliza Alize Allan Allen Allene Allie Allison
		Ally Alphonso Alta Althea Alva Alvah Alvena Alvera Alverta Alvina Alvis
		Alyce Alycia Alysa Alysha Alyson Alysson Amalia Amanda Amani Amara Amari
		Amaya Amber Ambrose Amelia Amelie Amely America Americo Amie Amina Amir
		Amira Amiya Amos Amparo Amy Amya Ana Anabel Anabelle Anahi Anais
		Anastacio Anastasia Anderson Andre Andreane Andreanne Andres Andrew Andy
		Angel Angela Angelica Angelina Angeline Angelita Angelo Angie Angus
		Anibal Anika Anissa Anita Aniya Aniyah Anjali Anna Annabel Annabell
		Annabelle Annalise Annamae Annamarie Anne Annetta Annette Annie Ansel
		Ansley Anthony Antoinette Antone Antonetta Antonette Antonia Antonietta
		Antonina Antonio Antwan Antwon Anya April Ara Araceli Aracely Arch
		Archibald Ardella Arden Ardith Arely Ari Ariane Arianna Aric Ariel
		Arielle Arjun Arlene Arlie Arlo Armand Armando Armani Arnaldo Arne Arno
		Arnold Arnoldo Arnulfo Aron Art Arthur Arturo Arvel Arvid Arvilla
		Aryanna Asa Asha Ashlee Ashleigh Ashley Ashly Ashlynn Ashton Ashtyn
		Asia Assunta Astrid Athena Aubree Aubrey Audie Audra Audreanne Audrey
		August Augusta Augustine Augustus Aurelia Aurelie Aurelio Aurore Austen
		Austin Austyn Autumn Ava Avery Avis Axel Ayana Ayden Ayla Aylin Baby
		Bailee Bailey Barbara Barney Baron Barrett Barry Bart Bartholome Barton
		Baylee Beatrice Beau Beaulah Bell Bella Belle Ben Benedict Benjamin
		Bennett Bennie Benny Benton Berenice Bernadette Bernadine Bernard
		Bernardo Berneice Bernhard Bernice Bernie Berniece Bernita Berry Bert
		Berta Bertha Bertram Bertrand Beryl Bessie Beth Bethany Bethel Betsy
		Bette Bettie Betty Bettye Beulah Beverly Bianka Bill Billie Billy Birdie
		Blair Blaise Blake Blanca Blanche Blaze Bo Bobbie Bobby Bonita Bonnie
		Boris Boyd Brad Braden Bradford Bradley Bradly Brady Braeden Brain
		Brandi Brando Brandon Brandt Brandy Brandyn Brannon Branson Brant
		Braulio Braxton Brayan Breana Breanna Breanne Brenda Brendan Brenden
		Brendon Brenna Brennan Brennon Brent Bret Brett Bria Brian Briana
		Brianne Brice Bridget Bridgette Bridie Brielle Brigitte Brionna Brisa
		Britney Brittany Brock Broderick Brody Brook Brooke Brooklyn Brooks
		Brown Bruce Bryana Bryce Brycen Bryon Buck Bud Buddy Buford Bulah
		Burdette Burley Burnice Buster Cade Caden Caesar Caitlyn Cale Caleb
		Caleigh Cali Calista Callie Camden Cameron Camila Camilla Camille Camren
		Camron Camryn Camylle Candace Candelario Candice Candida Candido Cara
		Carey Carissa Carlee Carleton Carley Carli Carlie Carlo Carlos Carlotta
		Carmel Carmela Carmella Carmelo Carmen Carmine Carol Carolanne Carole
		Carolina Caroline Carolyn Carolyne Carrie Carroll Carson Carter Cary
		Casandra Casey Casimer Casimir Casper Cassandra Cassandre Cassidy
		Cassie Catalina Caterina Catharine Catherine Cathrine Cathryn Cathy
		Cayla Ceasar Cecelia Cecil Cecile Cecilia Cedrick Celestine Celestino
		Celia Celine Cesar Chad Chadd Chadrick Chaim Chance Chandler Chanel
		Chanelle Charity Charlene Charles Charley Charlie Charlotte Chase
		Chasity Chauncey Chaya Chaz Chelsea Chelsey Chelsie Chesley Chester
		Chet Cheyanne Cheyenne Chloe Chris Christ Christa Christelle Christian
		Christiana Christina Christine Christop Christophe Christopher Christy
		Chyna Ciara Cicero Cielo Cierra Cindy Citlalli Clair Claire Clara
		Clarabelle Clare Clarissa Clark Claud Claude Claudia Claudie Claudine
		Clay Clemens Clement Clementina Clementine Clemmie Cleo Cleora Cleta
		Cletus Cleve Cleveland Clifford Clifton Clint Clinton Clotilde Clovis
		Cloyd Clyde Coby Cody Colby Cole Coleman Colin Colleen Collin Colt
		Colten Colton Columbus Concepcion Conner Connie Connor Conor Conrad
		Constance Constantin Consuelo Cooper Cora Coralie Corbin Cordelia
		Cordell Cordia Cordie Corene Corine Cornelius Cornell Corrine Cortez
		Cortney Cory Coty Courtney Coy Craig Crawford Creola Cristal Cristian
		Cristina Cristobal Cristopher Cruz Crystal Crystel Cullen Curt Curtis
		Cydney Cynthia Cyril Cyrus Dagmar Dahlia Daija Daisha Daisy Dakota
		Dale Dallas Dallin Dalton Damaris Dameon Damian Damien Damion Damon
		Dan Dana Dandre Dane D'angelo Dangelo Danial Daniela Daniella Danielle
		Danika Dannie Danny Dante Danyka Daphne Daphnee Daphney Darby Daren
		Darian Dariana Darien Dario Darion Darius Darlene Daron Darrel Darrell
		Darren Darrick Darrin Darrion Darron Darryl Darwin Daryl Dashawn Dasia
		Dave David Davin Davion Davon Davonte Dawn Dawson Dax Dayana Dayna Dayne
		Dayton Dean Deangelo Deanna Deborah Declan Dedric Dedrick Dee Deion
		Deja Dejah Dejon Dejuan Delaney Delbert Delfina Delia Delilah Dell
		Della Delmer Delores Delpha Delphia Delphine Delta Demarco Demarcus
		Demario Demetris Demetrius Demond Dena Denis Dennis Deon Deondre
		Deontae Deonte Dereck Derek Derick Deron Derrick Deshaun Deshawn Desiree
		Desmond Dessie Destany Destin Destinee Destiney Destini Destiny Devan
		Devante Deven Devin Devon Devonte Devyn Dewayne Dewitt Dexter Diamond
		Diana Dianna Diego Dillan Dillon Dimitri Dina Dino Dion Dixie Dock Dolly
		Dolores Domenic Domenica Domenick Domenico Domingo Dominic Dominique
		Don Donald Donato Donavon Donna Donnell Donnie Donny Dora Dorcas Dorian
		Doris Dorothea Dorothy Dorris Dortha Dorthy Doug Douglas Dovie Doyle
		Drake Drew Duane Dudley Dulce Duncan Durward Dustin Dusty Dwight Dylan
		Earl Earlene Earline Earnest Earnestine Easter Easton Ebba Ebony Ed Eda
		Edd Eddie Eden Edgar Edgardo Edison Edmond Edmund Edna Eduardo Edward
		Edwardo Edwin Edwina Edyth Edythe Effie Efrain Efren Eileen Einar Eino
		Eladio Elaina Elbert Elda Eldon Eldora Eldred Eldridge Eleanora Eleanore
		Eleazar Electa Elena Elenor Elenora Eleonore Elfrieda Eli Elian Eliane
		Elias Eliezer Elijah Elinor Elinore Elisa Elisabeth Elise Eliseo Elisha
		Elissa Eliza Elizabeth Ella Ellen Ellie Elliot Elliott Ellis Ellsworth
		Elmer Elmira Elmo Elmore Elna Elnora Elody Eloisa Eloise Elouise Eloy
		Elroy Elsa Else Elsie Elta Elton Elva Elvera Elvie Elvis Elwin Elwyn
		Elyse Elyssa Elza Emanuel Emelia Emelie Emely Emerald Emerson Emery Emie
		Emil Emile Emilia Emiliano Emilie Emilio Emily Emma Emmalee Emmanuel
		Emmanuelle Emmet Emmett Emmie Emmitt Emmy Emory Ena Enid Enoch Enola
		Enos Enrico Enrique Ephraim Era Eriberto Eric Erica Erich Erick Ericka
		Erik Erika Erin Erling Erna Ernest Ernestina Ernestine Ernesto Ernie
		Ervin Erwin Eryn Esmeralda Esperanza Esta Esteban Estefania Estel Estell
		Estella Estelle Estevan Esther Estrella Etha Ethan Ethel Ethelyn Ethyl
		Ettie Eudora Eugene Eugenia Eula Eulah Eulalia Euna Eunice Eusebio Eva
		Evalyn Evan Evangeline Evans Eve Eveline Evelyn Everardo Everett
		Everette Evert Evie Ewald Ewell Ezekiel Ezequiel Ezra Fabian Fabiola
		Fae Fannie Fanny Fatima Faustino Fausto Favian Fay Faye Federico Felicia
		Felicita Felicity Felipa Felipe Felix Felton Fermin Fern Fernando Ferne
		Fidel Filiberto Filomena Finn Fiona Flavie Flavio Fleta Fletcher Flo
		Florence Florencio Florian Florida Florine Flossie Floy Floyd Ford
		Forest Forrest Foster Frances Francesca Francesco Francis Francisca
		Francisco Franco Frank Frankie Franz Fred Freda Freddie Freddy Frederic
		Frederick Frederik Frederique Fredrick Fredy Freeda Freeman Freida Frida
		Frieda Friedrich Fritz Furman Gabe Gabriel Gabriella Gabrielle Gaetano
		Gage Gail Gardner Garett Garfield Garland Garnet Garnett Garret Garrett
		Garrick Garrison Garry Garth Gaston Gavin Gay Gayle Gaylord Gene General
		Genesis Genevieve Gennaro Genoveva Geo Geoffrey George Georgette
		Georgiana Georgianna Geovanni Geovanny Geovany Gerald Geraldine Gerard
		Gerardo Gerda Gerhard Germaine German Gerry Gerson Gertrude Gia Gianni
		Gideon Gilbert Gilberto Gilda Giles Gillian Gina Gino Giovani Giovanna
		Giovanni Giovanny Gisselle Giuseppe Gladyce Gladys Glen Glenda Glenna
		Glennie Gloria Godfrey Golda Golden Gonzalo Gordon Grace Gracie Graciela
		Grady Graham Grant Granville Grayce Grayson Green Greg Gregg Gregoria
		Gregorio Gregory Greta Gretchen Greyson Griffin Grover Guadalupe Gudrun
		Guido Guillermo Guiseppe Gunnar Gunner Gus Gussie Gust Gustave Guy Gwen
		Gwendolyn Hadley Hailee Hailey Hailie Hal Haleigh Haley Halie Halle
		Hallie Hank Hanna Hannah Hans Hardy Harley Harmon Harmony Harold
		Harrison Harry Harvey Haskell Hassan Hassie Hattie Haven Hayden Haylee
		Hayley Haylie Hazel Hazle Heath Heather Heaven Heber Hector Heidi Helen
		Helena Helene Helga Hellen Helmer Heloise Henderson Henri Henriette
		Henry Herbert Herman Hermann Hermina Herminia Herminio Hershel Herta
		Hertha Hester Hettie Hilario Hilbert Hilda Hildegard Hillard Hillary
		Hilma Hilton Hipolito Hiram Hobart Holden Hollie Hollis Holly Hope
		Horace Horacio Hortense Hosea Houston Howard Howell Hoyt Hubert Hudson
		Hugh Hulda Humberto Hunter Hyman Ian Ibrahim Icie Ida Idell Idella
		Ignacio Ignatius Ike Ila Ilene Iliana Ima Imani Imelda Immanuel Imogene
		Ines Irma Irving Irwin Isaac Isabel Isabell Isabella Isabelle Isac
		Isadore Isai Isaiah Isaias Isidro Ismael Isobel Isom Israel Issac Itzel
		Iva Ivah Ivory Ivy Izabella Izaiah Jabari Jace Jacey Jacinthe Jacinto
		Jack Jackeline Jackie Jacklyn Jackson Jacky Jaclyn Jacquelyn Jacques
		Jacynthe Jada Jade Jaden Jadon Jadyn Jaeden Jaida Jaiden Jailyn Jaime
		Jairo Jakayla Jake Jakob Jaleel Jalen Jalon Jalyn Jamaal Jamal Jamar
		Jamarcus Jamel Jameson Jamey Jamie Jamil Jamir Jamison Jammie Jan Jana
		Janae Jane Janelle Janessa Janet Janice Janick Janie Janis Janiya Jannie
		Jany Jaquan Jaquelin Jaqueline Jared Jaren Jarod Jaron Jarred Jarrell
		Jarret Jarrett Jarrod Jarvis Jasen Jasmin Jason Jasper Jaunita Javier
		Javon Javonte Jay Jayce Jaycee Jayda Jayde Jayden Jaydon Jaylan Jaylen
		Jaylin Jaylon Jayme Jayne Jayson Jazlyn Jazmin Jazmyn Jazmyne Jean
		Jeanette Jeanie Jeanne Jed Jedediah Jedidiah Jeff Jefferey Jeffery
		Jeffrey Jeffry Jena Jenifer Jennie Jennifer Jennings Jennyfer Jensen
		Jerad Jerald Jeramie Jeramy Jerel Jeremie Jeremy Jermain Jermaine
		Jermey Jerod Jerome Jeromy Jerrell Jerrod Jerrold Jerry Jess Jesse
		Jessica Jessie Jessika Jessy Jessyca Jesus Jett Jettie Jevon Jewel
		Jewell Jillian Jimmie Jimmy Jo Joan Joana Joanie Joanne Joannie Joanny
		Joany Joaquin Jocelyn Jodie Jody Joe Joel Joelle Joesph Joey Johan
		Johann Johanna Johathan John Johnathan Johnathon Johnnie Johnny Johnpaul
		Johnson Jolie Jon Jonas Jonatan Jonathan Jonathon Jordan Jordane Jordi
		Jordon Jordy Jordyn Jorge Jose Josefa Josefina Joseph Josephine Josh
		Joshua Joshuah Josiah Josiane Josianne Josie Josue Jovan Jovani Jovanny
		Jovany Joy Joyce Juana Juanita Judah Judd Jude Judge Judson Judy Jules
		Julia Julian Juliana Julianne Julie Julien Juliet Julio Julius June
		Junior Junius Justen Justice Justina Justine Juston Justus Justyn
		Juvenal Juwan Kacey Kaci Kacie Kade Kaden Kadin Kaela Kaelyn Kaia Kailee
		Kailey Kailyn Kaitlin Kaitlyn Kale Kaleb Kaleigh Kaley Kali Kallie
		Kameron Kamille Kamren Kamron Kamryn Kane Kara Kareem Karelle Karen Kari
		Kariane Karianne Karina Karine Karl Karlee Karley Karli Karlie Karolann
		Karson Kasandra Kasey Kassandra Katarina Katelin Katelyn Katelynn
		Katharina Katherine Katheryn Kathleen Kathlyn Kathryn Kathryne Katlyn
Katlynn
Katrina
Katrine
Kattie
Kavon
Kay
Kaya
Kaycee
Kayden
Kayla
Kaylah
Kaylee
Kayleigh
Kayley
Kayli
Kaylie
Kaylin
Keagan
Keanu
Keara
Keaton
Keegan
Keeley
Keely
Keenan
Keira
Keith
Kellen
Kelley
Kelli
Kellie
Kelly
Kelsi
Kelsie
Kelton
Kelvin
Ken
Kendall
Kendra
Kendrick
Kenna
Kennedi
Kennedy
Kenneth
Kennith
Kenny
Kenton
Kenya
Kenyatta
Kenyon
Keon
Keshaun
Keshawn
Keven
Kevin
Kevon
Keyon
Keyshawn
Khalid
Khalil
Kian
Kiana
Kianna
Kiara
Kiarra
Kiel
Kiera
Kieran
Kiley
Kim
Kimberly
King
Kip
Kira
Kirk
Kirsten
Kirstin
Kitty
Kobe
Koby
Kody
Kolby
Kole
Korbin
Korey
Kory
Kraig
Kris
Krista
Kristian
Kristin
Kristina
Kristofer
Kristoffer
Kristopher
Kristy
Krystal
Krystel
Krystina
Kurt
Kurtis
Kyla
Kyle
Kylee
Kyleigh
Kyler
Kylie
Kyra
Lacey
Lacy
Ladarius
Lafayette
Laila
Laisha
Lamar
Lambert
Lamont
Lance
Landen
Lane
Laney
Larissa
Laron
Larry
Larue
Laura
Laurel
Lauren
Laurence
Lauretta
Lauriane
Laurianne
Laurie
Laurine
Laury
Lauryn
Lavada
Lavern
Laverna
Laverne
Lavina
Lavinia
Lavon
Lavonne
Lawrence
Lawson
Layla
Layne
Lazaro
Lea
Leann
Leanna
Leanne
Leatha
Leda
Lee
Leif
Leila
Leilani
Lela
Lelah
Leland
Lelia
Lempi
Lemuel
Lenna
Lennie
Lenny
Lenora
Lenore
Leo
Leola
Leon
Leonard
Leonardo
Leone
Leonel
Leonie
Leonor
Leonora
Leopold
Leopoldo
Leora
Lera
Lesley
Leslie
Lesly
Lessie
Lester
Leta
Letha
Letitia
Levi
Lew
Lewis
Lexi
Lexie
Lexus
Lia
Liam
Liana
Libbie
Libby
Lila
Lilian
Liliana
Liliane
Lilla
Lillian
Lilliana
Lillie
Lilly
Lily
Lilyan
Lina
Lincoln
Linda
Lindsay
Lindsey
Linnea
Linnie
Linwood
Lionel
Lisa
Lisandro
Lisette
Litzy
Liza
Lizeth
Lizzie
Llewellyn
Lloyd
Logan
Lois
Lola
Lolita
Loma
Lon
London
Lonie
Lonnie
Lonny
Lonzo
Lora
Loraine
Loren
Lorena
Lorenz
Lorenza
Lorenzo
Lori
Lorine
Lorna
Lottie
Lou
Louie
Louisa
Lourdes
Louvenia
Lowell
Loy
Loyal
Loyce
Lucas
Luciano
Lucie
Lucienne
Lucile
Lucinda
Lucio
Lucious
Lucius
Lucy
Ludie
Ludwig
Lue
Luella
Luigi
Luis
Luisa
Lukas
Lula
Lulu
Luna
Lupe
Lura
Lurline
Luther
Luz
Lyda
Lydia
Lyla
Lynn
Lyric
Lysanne
Mabel
Mabelle
Mable
Mac
Macey
Maci
Macie
Mack
Mackenzie
Macy
Madaline
Madalyn
Maddison
Madeline
Madelyn
Madelynn
Madge
Madie
Madilyn
Madisen
Madison
Madisyn
Madonna
Madyson
Mae
Maegan
Maeve
Mafalda
Magali
Magdalen
Magdalena
Maggie
Magnolia
Magnus
Maia
Maida
Maiya
Major
Makayla
Makenna
Makenzie
Malachi
Malcolm
Malika
Malinda
Mallie
Mallory
Malvina
Mandy
Manley
Manuel
Manuela
Mara
Marc
Marcel
Marcelina
Marcelino
Marcella
Marcelle
Marcellus
Marcelo
Marcia
Marco
Marcos
Marcus
Margaret
Margarete
Margarett
Margaretta
Margarette
Margarita
Marge
Margie
Margot
Margret
Marguerite
Maria
Mariah
Mariam
Marian
Mariana
Mariane
Marianna
Marianne
Mariano
Maribel
Marie
Mariela
Marielle
Marietta
Marilie
Marilou
Marilyne
Marina
Mario
Marion
Marisa
Marisol
Maritza
Marjolaine
Marjorie
Marjory
Mark
Markus
Marlee
Marlen
Marlene
Marley
Marlin
Marlon
Marques
Marquis
Marquise
Marshall
Marta
Martin
Martina
Martine
Marty
Marvin
Mary
Maryam
Maryjane
Maryse
Mason
Mateo
Mathew
Mathias
Mathilde
Matilda
Matilde
Matt
Matteo
Mattie
Maud
Maude
Maudie
Maureen
Maurice
Mauricio
Maurine
Maverick
Mavis
Max
Maxie
Maxime
Maximilian
Maximillia
Maximillian
Maximo
Maximus
Maxine
Maxwell
May
Maya
Maybell
Maybelle
Maye
Maymie
Maynard
Mayra
Mazie
Mckayla
Mckenna
Mckenzie
Meagan
Meaghan
Meda
Megane
Meggie
Meghan
Mekhi
Melany
Melba
Melisa
Melissa
Mellie
Melody
Melvin
Melvina
Melyna
Melyssa
Mercedes
Meredith
Merl
Merle
Merlin
Merritt
Mertie
Mervin
Meta
Mia
Micaela
Micah
Michael
Michaela
Michale
Micheal
Michel
Michele
Michelle
Miguel
Mikayla
Mike
Mikel
Milan
Miles
Milford
Miller
Millie
Milo
Milton
Mina
Minerva
Minnie
Miracle
Mireille
Mireya
Misael
Missouri
Misty
Mitchel
Mitchell
Mittie
Modesta
Modesto
Mohamed
Mohammad
Mohammed
Moises
Mollie
Molly
Mona
Monica
Monique
Monroe
Monserrat
Monserrate
Montana
Monte
Monty
Morgan
Moriah
Morris
Mortimer
Morton
Mose
Moses
Moshe
Mossie
Mozell
Mozelle
Muhammad
Muriel
Murl
Murphy
Murray
Mustafa
Mya
Myah
Mylene
Myles
Myra
Myriam
Myrl
Myrna
Myron
Myrtice
Myrtie
Myrtis
Myrtle
Nadia
Nakia
Name
Nannie
Naomi
Naomie
Napoleon
Narciso
Nash
Nasir
Nat
Natalia
Natalie
Natasha
Nathan
Nathanael
Nathanial
Nathaniel
Nathen
Nayeli
Neal
Ned
Nedra
Neha
Neil
Nelda
Nella
Nelle
Nellie
Nels
Nelson
Neoma
Nestor
Nettie
Neva
Newell
Newton
Nia
Nicholas
Nicholaus
Nichole
Nick
Nicklaus
Nickolas
Nico
Nicola
Nicolas
Nicole
Nicolette
Nigel
Nikita
Nikki
Nikko
Niko
Nikolas
Nils
Nina
Noah
Noble
Noe
Noel
Noelia
Noemi
Noemie
Noemy
Nola
Nolan
Nona
Nora
Norbert
Norberto
Norene
Norma
Norris
Norval
Norwood
Nova
Novella
Nya
Nyah
Nyasia
Obie
Oceane
Ocie
Octavia
Oda
Odell
Odessa
Odie
Ofelia
Okey
Ola
Olaf
Ole
Olen
Oleta
Olga
Olin
Oliver
Ollie
Oma
Omari
Omer
Ona
Onie
Opal
Ophelia
Ora
Oral
Oran
Oren
Orie
Orin
Orion
Orland
Orlando
Orlo
Orpha
Orrin
Orval
Orville
Osbaldo
Osborne
Oscar
Osvaldo
Oswald
Oswaldo
Otha
Otho
Otilia
Otis
Ottilie
Ottis
Otto
Ova
Owen
Ozella
Pablo
Paige
Palma
Pamela
Pansy
Paolo
Paris
Parker
Pascale
Pasquale
Pat
Patience
Patricia
Patrick
Patsy
Pattie
Paul
Paula
Pauline
Paxton
Payton
Pearl
Pearlie
Pearline
Pedro
Peggie
Penelope
Percival
Percy
Perry
Pete
Peter
Petra
Peyton
Philip
Phoebe
Phyllis
Pierce
Pierre
Pietro
Pink
Pinkie
Piper
Polly
Porter
Precious
Presley
Preston
Price
Prince
Princess
Priscilla
Providenci
Prudence
Queen
Queenie
Quentin
Quincy
Quinn
Quinten
Quinton
Rachael
Rachel
Rachelle
Rae
Raegan
Rafael
Rafaela
Raheem
Rahsaan
Rahul
Raina
Raleigh
Ralph
Ramiro
Ramon
Ramona
Randal
Randall
Randi
Randy
Ransom
Raoul
Raphael
Raphaelle
Raquel
Rashad
Rashawn
Rasheed
Raul
Raven
Ray
Raymond
Raymundo
Reagan
Reanna
Reba
Rebeca
Rebecca
Rebeka
Rebekah
Reece
Reed
Reese
Regan
Reggie
Reginald
Reid
Reilly
Reina
Reinhold
Remington
Rene
Renee
Ressie
Reta
Retha
Retta
Reuben
Reva
Rex
Rey
Reyes
Reymundo
Reyna
Reynold
Rhea
Rhett
Rhianna
Rhiannon
Rhoda
Ricardo
Richard
Richie
Richmond
Rick
Rickey
Rickie
Ricky
Rico
Rigoberto
Riley
Rita
River
Robb
Robbie
Robert
Roberta
Roberto
Robin
Robyn
Rocio
Rocky
Rod
Roderick
Rodger
Rodolfo
Rodrick
Rodrigo
Roel
Rogelio
Roger
Rogers
Rolando
Rollin
Roma
Romaine
Roman
Ron
Ronaldo
Ronny
Roosevelt
Rory
Rosa
Rosalee
Rosalia
Rosalind
Rosalinda
Rosalyn
Rosamond
Rosanna
Rosario
Roscoe
Rose
Rosella
Roselyn
Rosemarie
Rosemary
Rosendo
Rosetta
Rosie
Rosina
Roslyn
Ross
Rossie
Rowan
Rowena
Rowland
Roxane
Roxanne
Roy
Royal
Royce
Rozella
Ruben
Rubie
Ruby
Rubye
Rudolph
Rudy
Rupert
Russ
Russel
Russell
Rusty
Ruth
Ruthe
Ruthie
Ryan
Ryann
Ryder
Rylan
Rylee
Ryleigh
Ryley
Sabina
Sabrina
Sabryna
Sadie
Sadye
Sage
Saige
Sallie
Sally
Salma
Salvador
Salvatore
Sam
Samanta
Samantha
Samara
Samir
Sammie
Sammy
Samson
Sandra
Sandrine
Sandy
Sanford
Santa
Santiago
Santina
Santino
Santos
Sarah
Sarai
Sarina
Sasha
Saul
Savanah
Savanna
Savannah
Savion
Scarlett
Schuyler
Scot
Scottie
Scotty
Seamus
Sean
Sebastian
Sedrick
Selena
Selina
Selmer
Serena
Serenity
Seth
Shad
Shaina
Shakira
Shana
Shane
Shanel
Shanelle
Shania
Shanie
Shaniya
Shanna
Shannon
Shanny
Shanon
Shany
Sharon
Shaun
Shawn
Shawna
Shaylee
Shayna
Shayne
Shea
Sheila
Sheldon
Shemar
Sheridan
Sherman
Sherwood
Shirley
Shyann
Shyanne
Sibyl
Sid
Sidney
Sienna
Sierra
Sigmund
Sigrid
Sigurd
Silas
Sim
Simeon
Simone
Sincere
Sister
Skye
Skyla
Skylar
Sofia
Soledad
Solon
Sonia
Sonny
Sonya
Sophia
Sophie
Spencer
Stacey
Stacy
Stan
Stanford
Stanley
Stanton
Stefan
Stefanie
Stella
Stephan
Stephania
Stephanie
Stephany
Stephen
Stephon
Sterling
Steve
Stevie
Stewart
Stone
Stuart
Summer
Sunny
Susan
Susana
Susanna
Susie
Suzanne
Sven
Syble
Sydnee
Sydney
Sydni
Sydnie
Sylvan
Sylvester
Sylvia
Tabitha
Tad
Talia
Talon
Tamara
Tamia
Tania
Tanner
Tanya
Tara
Taryn
Tate
Tatum
Tatyana
Taurean
Tavares
Taya
Taylor
Teagan
Ted
Telly
Terence
Teresa
Terrance
Terrell
Terrence
Terrill
Terry
Tess
Tessie
Tevin
Thad
Thaddeus
Thalia
Thea
Thelma
Theo
Theodora
Theodore
Theresa
Therese
Theresia
Theron
Thomas
Thora
Thurman
Tia
Tiana
Tianna
Tiara
Tierra
Tiffany
Tillman
Timmothy
Timmy
Timothy
Tina
Tito
Titus
Tobin
Toby
Tod
Tom
Tomas
Tomasa
Tommie
Toney
Toni
Tony
Torey
Torrance
Torrey
Toy
Trace
Tracey
Tracy
Travis
Travon
Tre
Tremaine
Tremayne
Trent
Trenton
Tressa
Tressie
Treva
Trever
Trevion
Trevor
Trey
Trinity
Trisha
Tristian
Tristin
Triston
Troy
Trudie
Trycia
Trystan
Turner
Twila
Tyler
Tyra
Tyree
Tyreek
Tyrel
Tyrell
Tyrese
Tyrique
Tyshawn
Tyson
Ubaldo
Ulices
Ulises
Una
Unique
Urban
Uriah
Uriel
Ursula
Vada
Valentin
Valentina
Valentine
Valerie
Vallie
Van
Vance
Vanessa
Vaughn
Veda
Velda
Vella
Velma
Velva
Vena
Verda
Verdie
Vergie
Verla
Verlie
Vern
Verna
Verner
Vernice
Vernie
Vernon
Verona
Veronica
Vesta
Vicenta
Vicente
Vickie
Vicky
Victor
Victoria
Vida
Vidal
Vilma
Vince
Vincent
Vincenza
Vincenzo
Vinnie
Viola
Violet
Violette
Virgie
Virgil
Virginia
Virginie
Vita
Vito
Viva
Vivian
Viviane
Vivianne
Vivien
Vivienne
Vladimir
Wade
Waino
Waldo
Walker
Wallace
Walter
Walton
Wanda
Ward
Warren
Watson
Wava
Waylon
Wayne
Webster
Weldon
Wellington
Wendell
Wendy
Werner
Westley
Weston
Whitney
Wilber
Wilbert
Wilburn
Wiley
Wilford
Wilfred
Wilfredo
Wilfrid
Wilhelm
Wilhelmine
Will
Willa
Willard
William
Willie
Willis
Willow
Willy
Wilma
Wilmer
Wilson
Wilton
Winfield
Winifred
Winnifred
Winona
Winston
Woodrow
Wyatt
Wyman
Xander
Xavier
Xzavier
Yadira
Yasmeen
Yasmin
Yasmine
Yazmin
Yesenia
Yessenia
Yolanda
Yoshiko
Yvette
Yvonne
Zachariah
Zachary
Zachery
Zack
Zackary
Zackery
Zakary
Zander
Zane
Zaria
Zechariah
Zelda
Zella
Zelma
Zena
Zetta
Zion
Zita
Zoe
Zoey
Zoie
Zoila
Zola
Zora
Zula
	)],
);

=back

=head1 SEE ALSO

L<Data::Faker>

=head1 AUTHOR

Jason Kohles, E<lt>email@jasonkohles.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2004-2005 by Jason Kohles

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
