use v6;

use JSON::Fast;

sub build(:$caption, :@head, :@rows) {
    note "Building $*role-name";
    {
        say 'use v6;';
        say "# generated by: $*PROGRAM-NAME {@*ARGS}";
        say '';
        say "#| PDF 32000-1:2008 " ~ $_ with $caption;
        my @pod;
        say "role $*role-name \{";
        for @rows {
            my ($entry, $type, $desc) = .list;
            next if $entry ~~ /:i'other'|'any'/;
            $entry = $entry.trim;
            $entry ~~ s:s/ '(' .* ')'//;
            @pod.push: %( :$entry, :$type, :$desc );

            if $entry ~~ /:s^ <ident> $/ {
                say "    method $entry \{...\};";
            }
            else {
                say "    \$?ROLE.^add_method({$entry.perl}, method \{...\});";
            }
        }
        say '}';

        # 2nd pass. output POD
        if @pod {
            say '';
            say '=begin pod';
            say '';
            say '=head1 Methods (Entries)';

            for @pod -> % ( :$entry!, :$type, :$desc ) {
                say '';
                say "=head2 $entry [$type]";
                say "- $_" with $desc;
            }
            say '';
            say '=end pod';
        }
    }
}

multi sub grok(Str :$name!, :@data, :attr($)) {
    $name => [ @data.map: {|grok(|$_)} ];
}

# Build.pm can also be run standalone 
sub MAIN(IO() $json, Str :$*role-name!) {
    my $ast = from-json($json.IO.slurp);
    build( |$ast<table>);
}
