use v6;
# generated by: ../../etc/make-modules.p6 --role-name=ISO_32000::OPI_version_1_3 ../tables/OPI_version_1_3_entries.html

#| PDF 32000-1:2008 Table 369 – Entries in a version 1.3 OPI dictionary
role ISO_32000::OPI_version_1_3 {
    method Type {...};
    method Version {...};
    method F {...};
    method ID {...};
    method Comments {...};
    method Size {...};
    method CropRect {...};
    method CropFixed {...};
    method Position {...};
    method Resolution {...};
    method ColorType {...};
    method Color {...};
    method Tint {...};
    method Overprint {...};
    method ImageType {...};
    method GrayMap {...};
    method Transparency {...};
    method Tags {...};

=begin pod

=head1 Methods (Entries)

=head2 Type [name]
- (Optional) The type of PDF object that this dictionary describes; if present, is OPIfor an OPI dictionary.

=head2 Version [number]
- (Required) The version of OPI to which this dictionary refers; is the number 1.3 (not the name 1.3, as in an OPI version dictionary).

=head2 F [file specification]
- %ALDImageFilename
(Required) The external file containing the image corresponding to this proxy.

=head2 ID [byte string]
- %ALDImageID
(Optional) An identifying string denoting the image.

=head2 Comments [text string]
- %ALDObjectComments
(Optional) A human-readable comment, typically containing instructions or suggestions to the operator of the OPI server on how to handle the image.

=head2 Size [array]
- %ALDImageDimensions
(Required) An array of two integers of the form
[ pixelsWide pixelsHigh ]
specifying the dimensions of the image in pixels.

=head2 CropRect [rectangle]
- %ALDImageCropRect
(Required) An array of four integers of the form
[ left top right bottom ]
specifying the portion of the image to be used.

=head2 CropFixed [array]
- %ALDImageCropFixed
(Optional) An array with the same form and meaning as CropRect, but expressed in real numbers instead of integers. Default value: the value of CropRect.

=head2 Position [array]
- %ALDImagePosition
(Required) An array of eight numbers of the form
[ ll x ll y ul x ul y ur x ur y lr x lr y ]
specifying the location on the page of the cropped image, where (ll x , ll y ) are the user space coordinates of the lower-left corner, (ul x , ul y ) are those of the upper-left corner, (ur x , ur y ) are those of the upper-right corner, and (lr x , lr y ) are those of the lower-right corner. The specified coordinates shall define a parallelogram; that is, they shall satisfy the conditions
ul x ll x ur x lr x
and
ul y ll y ur y lr y
The combination of Position and CropRectdetermines the image’s scaling, rotation, reflection, and skew.

=head2 Resolution [array]
- %ALDImageResolution
(Optional) An array of two numbers of the form
[ horizRes vertRes ]
specifying the resolution of the image in samples per inch.

=head2 ColorType [name]
- %ALDImageColorType
(Optional) The type of colour specified by the Color entry. Valid values are Process, Spot, and Separation. Default value: Spot.

=head2 Color [array]
- %ALDImageColor
(Optional) An array of four numbers and a byte string of the form
[ C M Y K colorName ]
specifying the value and name of the colour in which the image is to be rendered. The values of C, M, Y, and K shall all be in the range 0.0 to 1.0. Default value: [ 0.0 0.0 0.0 1.0 ( Black )].

=head2 Tint [number]
- %ALDImageTint
(Optional) A number in the range 0.0 to 1.0 specifying the concentration of the colour specified by Color in which the image is to be rendered. Default value: 1.0.

=head2 Overprint [boolean]
- %ALDImageOverprint
(Optional) A flag specifying whether the image is to overprint (true) or knock out (false) underlying marks on other separations. Default value: false.

=head2 ImageType [array]
- %ALDImageType
(Optional) An array of two integers of the form
[ samples bits ]
specifying the number of samples per pixel and bits per sample in the image.

=head2 GrayMap [array]
- %ALDImageGrayMap
(Optional) An array of 2n integers in the range 0 to 65,535 (where n is the number of bits per sample) recording changes made to the brightness or contrast of the image.

=head2 Transparency [boolean]
- %ALDImageTransparency
(Optional) A flag specifying whether white pixels in the image is treated as transparent. Default value: true.

=head2 Tags [array]
- %ALDImageAsciiTag< NNN >
(Optional) An array of pairs of the form
[ tagNum1 tagText1 … tagNumn tagTextn ]
where each tagNum is an integer representing a TIFF tag number and each tagText is an ASCII string representing the corresponding ASCII tag value.

=end pod
}
