use v6;
#  -- DO NOT EDIT --
# generated by: ../LibXML-p6/etc/generator.p6 --mod=LibXSLT --lib=XSLT etc/libxslt-api.xml

unit module LibXSLT::Native::Gen::xsltInternals;
# internal data structures, constants and functions:
#    Internal data structures, constants and functions used by the XSLT engine. They are not part of the API or ABI, i.e. they can change without prior notice, use carefully. 
use LibXML::Native::Defs :xmlCharP;
use LibXSLT::Native::Defs :$lib;

enum xsltErrorSeverityType is export (
    XSLT_ERROR_SEVERITY_ERROR => 0,
    XSLT_ERROR_SEVERITY_WARNING => 1,
);

enum xsltOutputType is export (
    XSLT_OUTPUT_HTML => 1,
    XSLT_OUTPUT_TEXT => 2,
    XSLT_OUTPUT_XML => 0,
);

enum xsltStyleType is export (
    XSLT_FUNC_APPLYIMPORTS => 11,
    XSLT_FUNC_APPLYTEMPLATES => 13,
    XSLT_FUNC_ATTRIBUTE => 5,
    XSLT_FUNC_ATTRSET => 27,
    XSLT_FUNC_CALLTEMPLATE => 12,
    XSLT_FUNC_CHOOSE => 14,
    XSLT_FUNC_COMMENT => 6,
    XSLT_FUNC_COPY => 1,
    XSLT_FUNC_COPYOF => 8,
    XSLT_FUNC_DOCUMENT => 17,
    XSLT_FUNC_ELEMENT => 4,
    XSLT_FUNC_EXTENSION => 22,
    XSLT_FUNC_FALLBACK => 24,
    XSLT_FUNC_FOREACH => 16,
    XSLT_FUNC_IF => 15,
    XSLT_FUNC_INCLUDE => 26,
    XSLT_FUNC_LITERAL_RESULT_ELEMENT => 28,
    XSLT_FUNC_MESSAGE => 25,
    XSLT_FUNC_NUMBER => 10,
    XSLT_FUNC_OTHERWISE => 23,
    XSLT_FUNC_PARAM => 19,
    XSLT_FUNC_PI => 7,
    XSLT_FUNC_SORT => 2,
    XSLT_FUNC_TEXT => 3,
    XSLT_FUNC_UNKOWN_FORWARDS_COMPAT => 29,
    XSLT_FUNC_VALUEOF => 9,
    XSLT_FUNC_VARIABLE => 20,
    XSLT_FUNC_WHEN => 21,
    XSLT_FUNC_WITHPARAM => 18,
);

enum xsltTransformState is export (
    XSLT_STATE_ERROR => 1,
    XSLT_STATE_OK => 0,
    XSLT_STATE_STOPPED => 2,
);

class xsltCompilerCtxt is repr('CStruct') {
    has Pointer $.errorCtxt; # * used for error/warning reports; e.g. XSLT_ERROR_SEVERITY_WARNING
    has xsltErrorSeverityType $.errSeverity;
    has int32 $.warnings; # TODO: number of warnings found at compilation
    has int32 $.errors; # TODO: number of errors found at compilation
    has xmlDict $.dict;
    has xsltStylesheet $.style;
    has int32 $.simplified; # whether this is a simplified stylesheet TODO: structured/unstructured error contexts.
    has int32 $.depth; # Current depth of processing
    has xsltCompilerNodeInfo $.inode;
    has xsltCompilerNodeInfo $.inodeList;
    has xsltCompilerNodeInfo $.inodeLast;
    has xsltPointerList $.tmpList; # * The XSLT version as specified by the stylesheet's root element. *
    has int32 $.isInclude;
    has int32 $.hasForwardsCompat; # whether forwards-compatible mode was used in a parsing episode
    has int32 $.maxNodeInfos; # TEMP TODO: just for the interest
    has int32 $.maxLREs; # * In order to keep the old behaviour, applying strict rules of * the spec can be turned off. This has effect only on special * mechanisms like whitespace-stripping in the stylesheet. *
    has int32 $.strict;
    has xsltPrincipalStylesheetData $.psData;
    has xsltStyleItemUknown $.unknownItem;
    has int32 $.hasNsAliases; # Indicator if there was an xsl:namespace-alias.
    has xsltNsAlias $.nsAliases;
    has xsltVarInfo $.ivars; # Storage of local in-scope variables/params.
    has xsltVarInfo $.ivar; # topmost local variable/param.
    method ParseAnyXSLTElem(xmlNode $elem --> int32) is native(XSLT) is symbol('xsltParseAnyXSLTElem') {*}
    method ParseSequenceConstructor(xmlNode $cur) is native(XSLT) is symbol('xsltParseSequenceConstructor') {*}
}

class xsltCompilerNodeInfo is repr('CStruct') {
    has xsltCompilerNodeInfo $.next;
    has xsltCompilerNodeInfo $.prev;
    has xmlNode $.node;
    has int32 $.depth;
    has xsltTemplate $.templ; # The owning template
    has int32 $.category; # XSLT element, LR-element or extension element
    has xsltStyleType $.type;
    has xsltElemPreComp $.item; # The compiled information The current in-scope namespaces
    has xsltNsListContainer $.inScopeNs; # The current excluded result namespaces
    has xsltPointerList $.exclResultNs; # The current extension instruction namespaces
    has xsltPointerList $.extElemNs; # The current info for literal result elements.
    has xsltStyleItemLRElementInfo $.litResElemInfo; # * Set to 1 if in-scope namespaces changed, *  or excluded result namespaces changed, *  or extension element namespaces changed. * This will trigger creation of new infos *  for literal result elements. *
    has int32 $.nsChanged;
    has int32 $.preserveWhitespace;
    has int32 $.stripWhitespace;
    has int32 $.isRoot; # whether this is the stylesheet's root node
    has int32 $.forwardsCompat; # whether forwards-compatible mode is enabled whether the content of an extension element was processed
    has int32 $.extContentHandled; # the type of the current child
    has xsltStyleType $.curChildType;
}

class xsltDecimalFormat is repr('CStruct') {
    has xsltDecimalFormat $.next; # chained list
    has xmlCharP $.name; # Used for interpretation of pattern
    has xmlCharP $.digit;
    has xmlCharP $.patternSeparator; # May appear in result
    has xmlCharP $.minusSign;
    has xmlCharP $.infinity;
    has xmlCharP $.noNumber; # Not-a-number Used for interpretation of pattern and may appear in result
    has xmlCharP $.decimalPoint;
    has xmlCharP $.grouping;
    has xmlCharP $.percent;
    has xmlCharP $.permille;
    has xmlCharP $.zeroDigit;
    has xmlCharP $.nsUri;
    method FormatNumberConversion(xmlCharP $format, num64 $number, xmlChar ** $result --> xmlXPathError) is native(XSLT) is symbol('xsltFormatNumberConversion') {*}
}

class xsltDocument is repr('CStruct') {
    has xsltDocument $.next; # documents are kept in a chained list
    has int32 $.main; # is this the main document
    has xmlDoc $.doc; # the parsed document
    has Pointer $.keys; # key tables storage
    has xsltDocument $.includes; # subsidiary includes
    has int32 $.preproc; # pre-processing already done
    has int32 $.nbKeysComputed;
    method FreeDocumentKeys() is native(XSLT) is symbol('xsltFreeDocumentKeys') {*}
}

class xsltEffectiveNs is repr('CStruct') {
    has xsltEffectiveNs $.nextInStore; # storage next
    has xsltEffectiveNs $.next; # next item in the list
    has xmlCharP $.prefix;
    has xmlCharP $.nsName; # * Indicates if eclared on the literal result element; dunno if really * needed. *
    has int32 $.holdByElem;
}

class xsltElemPreComp is repr('CStruct') {
    has xsltElemPreComp $.next; # next item in the global chained list held by xsltStylesheet.
    has xsltStyleType $.type; # type of the element
    has xsltTransformFunction $.func; # handling function
    has xmlNode $.inst; # the node in the stylesheet's tree corresponding to this item end of common part
    has xsltElemPreCompDeallocator $.free; # the deallocator
    method Init(xsltStylesheet $style, xmlNode $inst, xsltTransformFunction $function, xsltElemPreCompDeallocator $freeFunc) is native(XSLT) is symbol('xsltInitElemPreComp') {*}
}

class xsltKeyDef is repr('CStruct') {
    has xsltKeyDef $.next;
    has xmlNode $.inst;
    has xmlCharP $.name;
    has xmlCharP $.nameURI;
    has xmlCharP $.match;
    has xmlCharP $.use;
    has xmlXPathCompExpr $.comp;
    has xmlXPathCompExpr $.usecomp;
    has xmlNsPtr * $.nsList; # the namespaces in scope
    has int32 $.nsNr; # the number of namespaces in scope
}

class xsltKeyTable is repr('CStruct') {
    has xsltKeyTable $.next;
    has xmlCharP $.name;
    has xmlCharP $.nameURI;
    has xmlHashTable $.keys;
}

class xsltNsAlias is repr('CStruct') {
    has xsltNsAlias $.next; # next in the list
    has xmlNs $.literalNs;
    has xmlNs $.targetNs;
    has xmlDoc $.docOfTargetNs;
}

class xsltNsList is repr('CStruct') {
    has xsltNsList $.next; # next in the list
    has xmlNs $.ns;
}

class xsltNsListContainer is repr('CStruct') {
    has xmlNsPtr * $.list;
    has int32 $.totalNumber;
    has int32 $.xpathNumber;
}

class xsltNsMap is repr('CStruct') {
    has xsltNsMap $.next; # next in the list
    has xmlDoc $.doc;
    has xmlNode $.elem; # the element holding the ns-decl
    has xmlNs $.ns; # the xmlNs structure holding the XML namespace name
    has xmlCharP $.origNsName; # the original XML namespace name
    has xmlCharP $.newNsName; # the mapped XML namespace name
    method RestoreDocumentNamespaces(xmlDoc $doc --> int32) is native(XSLT) is symbol('xsltRestoreDocumentNamespaces') {*}
}

class xsltPointerList is repr('CStruct') {
    has void ** $.items;
    has int32 $.number;
    has int32 $.size;

    our sub Create(int32 $initialSize --> xsltPointerList) is native(XSLT) is symbol('xsltPointerListCreate') {*}

    method AddSize(Pointer $item, int32 $initialSize --> int32) is native(XSLT) is symbol('xsltPointerListAddSize') {*}
    method Clear() is native(XSLT) is symbol('xsltPointerListClear') {*}
    method Free() is native(XSLT) is symbol('xsltPointerListFree') {*}
}

class xsltPrincipalStylesheetData is repr('CStruct') {
    has xmlDict $.namespaceDict; # * Global list of in-scope namespaces. *
    has xsltPointerList $.inScopeNamespaces; # * Global list of information for [xsl:]excluded-result-prefixes. *
    has xsltPointerList $.exclResultNamespaces; # * Global list of information for [xsl:]extension-element-prefixes. *
    has xsltPointerList $.extElemNamespaces;
    has xsltEffectiveNs $.effectiveNs; # * Namespace name map to get rid of string comparison of namespace names. *
    has xsltNsMap $.nsMap;
}

class xsltRuntimeExtra is repr('CStruct') {
    has Pointer $.info; # pointer to the extra data
    has xmlFreeFunc $.deallocate; # pointer to the deallocation routine
}

class xsltStackElem is repr('CStruct') {
    has xsltStackElem $.next; # chained list
    has xsltStylePreComp $.comp; # the compiled form
    has int32 $.computed; # was the evaluation done
    has xmlCharP $.name; # the local part of the name QName
    has xmlCharP $.nameURI; # the URI part of the name QName
    has xmlCharP $.select; # the eval string
    has xmlNode $.tree; # the sequence constructor if no eval string or the location
    has xmlXPathObject $.value; # The value if computed
    has xmlDoc $.fragment; # The Result Tree Fragments (needed for XSLT 1.0) which are bound to the variable's lifetime.
    has int32 $.level; # the depth in the tree; -1 if persistent (e.g. a given xsl:with-param)
    has xsltTransformContext $.context; # The transformation context; needed to cache the variables
    has int32 $.flags;
    method FreeStackElemList() is native(XSLT) is symbol('xsltFreeStackElemList') {*}
}

class xsltStyleBasicEmptyItem is repr('CPointer') {
}

class xsltStyleBasicExpressionItem is repr('CStruct') {
    has xmlCharP $.select; # TODO: Change this to "expression".
    has xmlXPathCompExpr $.comp; # TODO: Change this to compExpr.
}

class xsltStyleBasicItemVariable is repr('CStruct') {
    has xmlCharP $.select;
    has xmlXPathCompExpr $.comp;
    has xmlCharP $.name;
    has int32 $.has_name;
    has xmlCharP $.ns;
    has int32 $.has_ns;
}

class xsltStyleItemApplyTemplates is repr('CStruct') {
    has xmlCharP $.mode; # apply-templates
    has xmlCharP $.modeURI; # apply-templates
    has xmlCharP $.select; # sort, copy-of, value-of, apply-templates
    has xmlXPathCompExpr $.comp; # a precompiled XPath expression TODO: with-params
}

class xsltStyleItemAttribute is repr('CStruct') {
    has xmlCharP $.name;
    has int32 $.has_name;
    has xmlCharP $.ns;
    has xmlCharP $.nsPrefix;
    has int32 $.has_ns;
}

class xsltStyleItemCallTemplate is repr('CStruct') {
    has xsltTemplate $.templ; # call-template
    has xmlCharP $.name; # element, attribute, pi
    has int32 $.has_name; # element, attribute, pi
    has xmlCharP $.ns; # element
    has int32 $.has_ns; # element TODO: with-params
}

class xsltStyleItemCopy is repr('CStruct') {
    has xmlCharP $.use; # copy, element
    has int32 $.has_use; # copy, element
}

class xsltStyleItemDocument is repr('CStruct') {
    has int32 $.ver11; # assigned: in xsltDocumentComp; read: nowhere; TODO: Check if we need.
    has xmlCharP $.filename; # document URL
    has int32 $.has_filename;
}

class xsltStyleItemElement is repr('CStruct') {
    has xmlCharP $.use;
    has int32 $.has_use;
    has xmlCharP $.name;
    has int32 $.has_name;
    has xmlCharP $.ns;
    has xmlCharP $.nsPrefix;
    has int32 $.has_ns;
}

class xsltStyleItemExtElement is repr('CStruct') {
    has xsltElemPreComp $.item;
}

class xsltStyleItemIf is repr('CStruct') {
    has xmlCharP $.test; # if
    has xmlXPathCompExpr $.comp; # a precompiled XPath expression
}

class xsltStyleItemInclude is repr('CStruct') {
    has xsltDocument $.include;
}

class xsltStyleItemLRElementInfo is repr('CStruct') {
    has xsltEffectiveNs $.effectiveNs;
}

class xsltStyleItemMessage is repr('CStruct') {
    has int32 $.terminate;
}

class xsltStyleItemNumber is repr('CStruct') {
    has xsltNumberData $.numdata; # number
}

class xsltStyleItemOtherwise is repr('CPointer') {
}

class xsltStyleItemPI is repr('CStruct') {
    has xmlCharP $.name;
    has int32 $.has_name;
}

class xsltStyleItemParam is repr('CStruct') {
    has xmlCharP $.select;
    has xmlXPathCompExpr $.comp;
    has xmlCharP $.name;
    has int32 $.has_name;
    has xmlCharP $.ns;
    has int32 $.has_ns;
}

class xsltStyleItemSort is repr('CStruct') {
    has xmlCharP $.stype; # sort
    has int32 $.has_stype; # sort
    has int32 $.number; # sort
    has xmlCharP $.order; # sort
    has int32 $.has_order; # sort
    has int32 $.descending; # sort
    has xmlCharP $.lang; # sort
    has int32 $.has_lang; # sort
    has xsltLocale $.locale; # sort
    has xmlCharP $.case_order; # sort
    has int32 $.lower_first; # sort
    has xmlCharP $.use;
    has int32 $.has_use;
    has xmlCharP $.select; # sort, copy-of, value-of, apply-templates
    has xmlXPathCompExpr $.comp; # a precompiled XPath expression
}

class xsltStyleItemText is repr('CStruct') {
    has int32 $.noescape; # text
}

class xsltStyleItemUknown is repr('CPointer') {
}

class xsltStyleItemValueOf is repr('CStruct') {
    has xmlCharP $.select;
    has xmlXPathCompExpr $.comp; # a precompiled XPath expression
    has int32 $.noescape;
}

class xsltStyleItemWhen is repr('CStruct') {
    has xmlCharP $.test;
    has xmlXPathCompExpr $.comp;
}

class xsltStylePreComp is repr('CStruct') {
    has xsltElemPreComp $.next; # chained list
    has xsltStyleType $.type; # type of the element
    has xsltTransformFunction $.func; # handling function
    has xmlNode $.inst; # * Pre computed values. *
    has xmlCharP $.stype; # sort
    has int32 $.has_stype; # sort
    has int32 $.number; # sort
    has xmlCharP $.order; # sort
    has int32 $.has_order; # sort
    has int32 $.descending; # sort
    has xmlCharP $.lang; # sort
    has int32 $.has_lang; # sort
    has xsltLocale $.locale; # sort
    has xmlCharP $.case_order; # sort
    has int32 $.lower_first; # sort
    has xmlCharP $.use; # copy, element
    has int32 $.has_use; # copy, element
    has int32 $.noescape; # text
    has xmlCharP $.name; # element, attribute, pi
    has int32 $.has_name; # element, attribute, pi
    has xmlCharP $.ns; # element
    has int32 $.has_ns; # element
    has xmlCharP $.mode; # apply-templates
    has xmlCharP $.modeURI; # apply-templates
    has xmlCharP $.test; # if
    has xsltTemplate $.templ; # call-template
    has xmlCharP $.select; # sort, copy-of, value-of, apply-templates
    has int32 $.ver11; # document
    has xmlCharP $.filename; # document URL
    has int32 $.has_filename; # document
    has xsltNumberData $.numdata; # number
    has xmlXPathCompExpr $.comp; # a precompiled XPath expression
    has xmlNsPtr * $.nsList; # the namespaces in scope
    has int32 $.nsNr; # the number of namespaces in scope
}

class xsltStylesheet is repr('CStruct') {
    has xsltStylesheet $.parent;
    has xsltStylesheet $.next;
    has xsltStylesheet $.imports;
    has xsltDocument $.docList; # * General data on the style sheet document. *
    has xmlDoc $.doc; # the parsed XML stylesheet
    has xmlHashTable $.stripSpaces; # the hash table of the strip-space and preserve space elements
    has int32 $.stripAll; # strip-space * (1) preserve-space * (-1)
    has xmlHashTable $.cdataSection; # * Global variable or parameters. *
    has xsltStackElem $.variables; # * Template descriptions. *
    has xsltTemplate $.templates; # the ordered list of templates
    has Pointer $.templatesHash; # hash table or wherever compiled templates information is stored
    has Pointer $.rootMatch; # template based on /
    has Pointer $.keyMatch; # template based on key()
    has Pointer $.elemMatch; # template based on *
    has Pointer $.attrMatch; # template based on @*
    has Pointer $.parentMatch; # template based on ..
    has Pointer $.textMatch; # template based on text()
    has Pointer $.piMatch; # template based on processing-instruction()
    has Pointer $.commentMatch; # * Namespace aliases. * NOTE: Not used in the refactored code. *
    has xmlHashTable $.nsAliases; # * Attribute sets. *
    has xmlHashTable $.attributeSets; # * Namespaces. * TODO: Eliminate this. *
    has xmlHashTable $.nsHash; # the set of namespaces in use: ATTENTION: This is used for execution of XPath expressions; unfortunately it restricts the stylesheet to have distinct prefixes. TODO: We need to get rid of this. *
    has Pointer $.nsDefs; # * Key definitions. *
    has Pointer $.keys; # * Output related stuff. *
    has xmlCharP $.method; # the output method
    has xmlCharP $.methodURI; # associated namespace if any
    has xmlCharP $.version; # version string
    has xmlCharP $.encoding; # encoding string
    has int32 $.omitXmlDeclaration; # * Number formatting. *
    has xsltDecimalFormat $.decimalFormat;
    has int32 $.standalone; # standalone = "yes" | "no"
    has xmlCharP $.doctypePublic; # doctype-public string
    has xmlCharP $.doctypeSystem; # doctype-system string
    has int32 $.indent; # should output being indented
    has xmlCharP $.mediaType; # * Precomputed blocks. *
    has xsltElemPreComp $.preComps; # list of precomputed blocks
    has int32 $.warnings; # number of warnings found at compilation
    has int32 $.errors; # number of errors found at compilation
    has xmlCharP $.exclPrefix; # last excluded prefixes
    has xmlChar ** $.exclPrefixTab; # array of excluded prefixes
    has int32 $.exclPrefixNr; # number of excluded prefixes in scope
    has int32 $.exclPrefixMax; # size of the array
    has Pointer $._private; # * Extensions. *
    has xmlHashTable $.extInfos; # the extension data
    has int32 $.extrasNr; # * For keeping track of nested includes *
    has xsltDocument $.includes; # * dictionary: shared between stylesheet, context and documents. *
    has xmlDict $.dict; # * precompiled attribute value templates. *
    has Pointer $.attVTs; # * if namespace-alias has an alias for the default stylesheet prefix * NOTE: Not used in the refactored code. *
    has xmlCharP $.defaultAlias; # * bypass pre-processing (already done) (used in imports) *
    has int32 $.nopreproc; # * all document text strings were internalized *
    has int32 $.internalized; # * Literal Result Element as Stylesheet c.f. section 2.3 *
    has int32 $.literal_result; # * The principal stylesheet *
    has xsltStylesheet $.principal; # * Compilation context used during compile-time. *
    has xsltCompilerCtxt $.compCtxt; # TODO: Change this to (void *).
    has xsltPrincipalStylesheetData $.principalData; # * Forwards-compatible processing *
    has int32 $.forwards_compatible;
    has xmlHashTable $.namedTemplates; # hash table of named templates
    has xmlXPathContext $.xpathCtxt;

    our sub xsltLoadStylesheetPI(xmlDoc $doc --> xsltStylesheet) is native(XSLT) is export {*}
    our sub New( --> xsltStylesheet) is native(XSLT) is symbol('xsltNewStylesheet') {*}
    our sub xsltParseStylesheetDoc(xmlDoc $doc --> xsltStylesheet) is native(XSLT) is export {*}
    our sub xsltParseStylesheetFile(xmlCharP $filename --> xsltStylesheet) is native(XSLT) is export {*}
    our sub xsltParseStylesheetImportedDoc(xmlDoc $doc, xsltStylesheet $parentStyle --> xsltStylesheet) is native(XSLT) is export {*}

    method AddKey(xmlCharP $name, xmlCharP $nameURI, xmlCharP $match, xmlCharP $use, xmlNode $inst --> int32) is native(XSLT) is symbol('xsltAddKey') {*}
    method AddTemplate(xsltTemplate $cur, xmlCharP $mode, xmlCharP $modeURI --> int32) is native(XSLT) is symbol('xsltAddTemplate') {*}
    method AllocateExtra( --> int32) is native(XSLT) is symbol('xsltAllocateExtra') {*}
    method Apply(xmlDoc $doc, const char ** $params --> xmlDoc) is native(XSLT) is symbol('xsltApplyStylesheet') {*}
    method ApplyStylesheetUser(xmlDoc $doc, const char ** $params, Str $output, FILE * $profile, xsltTransformContext $userCtxt --> xmlDoc) is native(XSLT) is symbol('xsltApplyStylesheetUser') {*}
    method CheckExtPrefix(xmlCharP $URI --> int32) is native(XSLT) is symbol('xsltCheckExtPrefix') {*}
    method CheckExtURI(xmlCharP $URI --> int32) is native(XSLT) is symbol('xsltCheckExtURI') {*}
    method CleanupTemplates() is native(XSLT) is symbol('xsltCleanupTemplates') {*}
    method CompileAttr(xmlAttr $attr) is native(XSLT) is symbol('xsltCompileAttr') {*}
    method DecimalFormatGetByName(xmlCharP $name --> xsltDecimalFormat) is native(XSLT) is symbol('xsltDecimalFormatGetByName') {*}
    method DecimalFormatGetByQName(xmlCharP $nsUri, xmlCharP $name --> xsltDecimalFormat) is native(XSLT) is symbol('xsltDecimalFormatGetByQName') {*}
    method DocumentComp(xmlNode $inst, xsltTransformFunction $function --> xsltElemPreComp) is native(XSLT) is symbol('xsltDocumentComp') {*}
    method EvalStaticAttrValueTemplate(xmlNode $inst, xmlCharP $name, xmlCharP $ns, Pointer[int32] $found --> xmlCharP) is native(XSLT) is symbol('xsltEvalStaticAttrValueTemplate') {*}
    method FreeAttributeSetsHashes() is native(XSLT) is symbol('xsltFreeAttributeSetsHashes') {*}
    method FreeExts() is native(XSLT) is symbol('xsltFreeExts') {*}
    method FreeKeys() is native(XSLT) is symbol('xsltFreeKeys') {*}
    method FreeNamespaceAliasHashes() is native(XSLT) is symbol('xsltFreeNamespaceAliasHashes') {*}
    method FreeStyleDocuments() is native(XSLT) is symbol('xsltFreeStyleDocuments') {*}
    method FreeStylePreComps() is native(XSLT) is symbol('xsltFreeStylePreComps') {*}
    method Free() is native(XSLT) is symbol('xsltFreeStylesheet') {*}
    method FreeTemplateHashes() is native(XSLT) is symbol('xsltFreeTemplateHashes') {*}
    method GetCNsProp(xmlNode $node, xmlCharP $name, xmlCharP $nameSpace --> xmlCharP) is native(XSLT) is symbol('xsltGetCNsProp') {*}
    method GetExtInfo(xmlCharP $URI --> xmlHashTable) is native(XSLT) is symbol('xsltGetExtInfo') {*}
    method GetQNameURI2(xmlNode $node, const xmlChar ** $name --> xmlCharP) is native(XSLT) is symbol('xsltGetQNameURI2') {*}
    method LoadStyleDocument(xmlCharP $URI --> xsltDocument) is native(XSLT) is symbol('xsltLoadStyleDocument') {*}
    method NamespaceAlias(xmlNode $node) is native(XSLT) is symbol('xsltNamespaceAlias') {*}
    method NewElemPreComp(xmlNode $inst, xsltTransformFunction $function --> xsltElemPreComp) is native(XSLT) is symbol('xsltNewElemPreComp') {*}
    method NewStyleDocument(xmlDoc $doc --> xsltDocument) is native(XSLT) is symbol('xsltNewStyleDocument') {*}
    method NewTransformContext(xmlDoc $doc --> xsltTransformContext) is native(XSLT) is symbol('xsltNewTransformContext') {*}
    method NextImport( --> xsltStylesheet) is native(XSLT) is symbol('xsltNextImport') {*}
    method ParseGlobalParam(xmlNode $cur) is native(XSLT) is symbol('xsltParseGlobalParam') {*}
    method ParseGlobalVariable(xmlNode $cur) is native(XSLT) is symbol('xsltParseGlobalVariable') {*}
    method ParseStylesheetAttributeSet(xmlNode $cur) is native(XSLT) is symbol('xsltParseStylesheetAttributeSet') {*}
    method ParseStylesheetImport(xmlNode $cur --> int32) is native(XSLT) is symbol('xsltParseStylesheetImport') {*}
    method ParseStylesheetInclude(xmlNode $cur --> int32) is native(XSLT) is symbol('xsltParseStylesheetInclude') {*}
    method ParseStylesheetOutput(xmlNode $cur) is native(XSLT) is symbol('xsltParseStylesheetOutput') {*}
    method ParseStylesheetProcess(xmlDoc $doc --> xsltStylesheet) is native(XSLT) is symbol('xsltParseStylesheetProcess') {*}
    method ParseStylesheetUser(xmlDoc $doc --> int32) is native(XSLT) is symbol('xsltParseStylesheetUser') {*}
    method ParseTemplateContent(xmlNode $templ) is native(XSLT) is symbol('xsltParseTemplateContent') {*}
    method PreComputeExtModuleElement(xmlNode $inst --> xsltElemPreComp) is native(XSLT) is symbol('xsltPreComputeExtModuleElement') {*}
    method Profile(xmlDoc $doc, const char ** $params, FILE * $output --> xmlDoc) is native(XSLT) is symbol('xsltProfileStylesheet') {*}
    method RegisterExtPrefix(xmlCharP $prefix, xmlCharP $URI --> int32) is native(XSLT) is symbol('xsltRegisterExtPrefix') {*}
    method ResolveStylesheetAttributeSet() is native(XSLT) is symbol('xsltResolveStylesheetAttributeSet') {*}
    method Run(xmlDoc $doc, const char ** $params, Str $output, xmlSAXHandler $SAX, xmlOutputBuffer $IObuf --> int32) is native(XSLT) is symbol('xsltRunStylesheet') {*}
    method RunStylesheetUser(xmlDoc $doc, const char ** $params, Str $output, xmlSAXHandler $SAX, xmlOutputBuffer $IObuf, FILE * $profile, xsltTransformContext $userCtxt --> int32) is native(XSLT) is symbol('xsltRunStylesheetUser') {*}
    method ShutdownExts() is native(XSLT) is symbol('xsltShutdownExts') {*}
    method StyleGetExtData(xmlCharP $URI --> Pointer) is native(XSLT) is symbol('xsltStyleGetExtData') {*}
    method StylePreCompute(xmlNode $inst) is native(XSLT) is symbol('xsltStylePreCompute') {*}
    method StyleStylesheetLevelGetExtData(xmlCharP $URI --> Pointer) is native(XSLT) is symbol('xsltStyleStylesheetLevelGetExtData') {*}
    method XPathCompile(xmlCharP $str --> xmlXPathCompExpr) is native(XSLT) is symbol('xsltXPathCompile') {*}
    method XPathCompileFlags(xmlCharP $str, int32 $flags --> xmlXPathCompExpr) is native(XSLT) is symbol('xsltXPathCompileFlags') {*}
}

class xsltTemplate is repr('CStruct') {
    has xsltTemplate $.next; # chained list sorted by priority
    has xsltStylesheet $.style; # the containing stylesheet
    has xmlCharP $.match; # the matching string
    has float $.priority; # as given from the stylesheet, not computed
    has xmlCharP $.name; # the local part of the name QName
    has xmlCharP $.nameURI; # the URI part of the name QName
    has xmlCharP $.mode; # the local part of the mode QName
    has xmlCharP $.modeURI; # the URI part of the mode QName
    has xmlNode $.content; # the template replacement value
    has xmlNode $.elem; # * TODO: @inheritedNsNr and @inheritedNs won't be used in the *  refactored code. *
    has int32 $.inheritedNsNr; # number of inherited namespaces
    has xmlNsPtr * $.inheritedNs; # inherited non-excluded namespaces Profiling information
    has int32 $.nbCalls; # the number of time the template was called
    has ulong $.time; # the time spent in this template
    has Pointer $.params; # xsl:param instructions
    has int32 $.templNr; # Nb of templates in the stack
    has int32 $.templMax; # Size of the templtes stack
    has xsltTemplatePtr * $.templCalledTab; # templates called
    has Pointer[int32] $.templCountTab; # .. and how often
    method xslAddCall(xmlNode $source --> int32) is native(XSLT) {*}
}

class xsltTransformCache is repr('CStruct') {
    has xmlDoc $.RVT;
    has int32 $.nbRVT;
    has xsltStackElem $.stackItems;
    has int32 $.nbStackItems;
    has int32 $.dbgCachedRVTs;
    has int32 $.dbgReusedRVTs;
    has int32 $.dbgCachedVars;
    has int32 $.dbgReusedVars;
}

class xsltTransformContext is repr('CStruct') {
    has xsltStylesheet $.style; # the stylesheet used
    has xsltOutputType $.type; # the type of output
    has xsltTemplate $.templ; # the current template
    has int32 $.templNr; # Nb of templates in the stack
    has int32 $.templMax; # Size of the templtes stack
    has xsltTemplatePtr * $.templTab; # the template stack
    has xsltStackElem $.vars; # the current variable list
    has int32 $.varsNr; # Nb of variable list in the stack
    has int32 $.varsMax; # Size of the variable list stack
    has xsltStackElemPtr * $.varsTab; # the variable list stack
    has int32 $.varsBase; # * Extensions *
    has xmlHashTable $.extFunctions; # the extension functions
    has xmlHashTable $.extElements; # the extension elements
    has xmlHashTable $.extInfos; # the extension data
    has xmlCharP $.mode; # the current mode
    has xmlCharP $.modeURI; # the current mode URI
    has xsltDocument $.docList; # the document list
    has xsltDocument $.document; # the current source document; can be NULL if an RTF
    has xmlNode $.node; # the current node being processed
    has xmlNodeSet $.nodeList; # the current node list xmlNodePtr current;   the node
    has xmlDoc $.output; # the resulting document
    has xmlNode $.insert; # the insertion node
    has xmlXPathContext $.xpathCtxt; # the XPath context
    has xsltTransformState $.state; # * Global variables *
    has xmlHashTable $.globalVars; # the global variables and params
    has xmlNode $.inst; # the instruction in the stylesheet
    has int32 $.xinclude; # should XInclude be processed
    has Str $.outputFile; # the output URI if known
    has int32 $.profile; # is this run profiled
    has long $.prof; # the current profiled value
    has int32 $.profNr; # Nb of templates in the stack
    has int32 $.profMax; # Size of the templtaes stack
    has long * $.profTab; # the profile template stack
    has Pointer $._private; # user defined data
    has int32 $.extrasNr; # the number of extras used
    has int32 $.extrasMax; # the number of extras allocated
    has xsltRuntimeExtra $.extras; # extra per runtime information
    has xsltDocument $.styleList; # the stylesheet docs list
    has Pointer $.sec; # the security preferences if any
    has xmlGenericErrorFunc $.error; # a specific error handler
    has Pointer $.errctx; # context for the error handler
    has xsltSortFunc $.sortfunc; # * handling of temporary Result Value Tree * (XSLT 1.0 term: "Result Tree Fragment") *
    has xmlDoc $.tmpRVT; # list of RVT without persistance
    has xmlDoc $.persistRVT; # list of persistant RVTs
    has int32 $.ctxtflags; # * Speed optimization when coalescing text nodes *
    has xmlCharP $.lasttext; # last text node content
    has int32 $.lasttsize; # last text node size
    has int32 $.lasttuse; # * Per Context Debugging *
    has int32 $.debugStatus; # the context level debug status
    has unsigned long * $.traceCode; # pointer to the variable holding the mask
    has int32 $.parserOptions; # * dictionary: shared between stylesheet, context and documents. *
    has xmlDict $.dict;
    has xmlDoc $.tmpDoc; # * all document text strings are internalized *
    has int32 $.internalized;
    has int32 $.nbKeys;
    has int32 $.hasTemplKeyPatterns;
    has xsltTemplate $.currentTemplateRule; # the Current Template Rule
    has xmlNode $.initialContextNode;
    has xmlDoc $.initialContextDoc;
    has xsltTransformCache $.cache;
    has Pointer $.contextVariable; # the current variable item
    has xmlDoc $.localRVT; # list of local tree fragments; will be freed when the instruction which created the fragment exits
    has xmlDoc $.localRVTBase; # Obsolete
    has int32 $.keyInitLevel; # Needed to catch recursive keys issues
    has int32 $.depth; # Needed to catch recursions
    has int32 $.maxTemplateDepth;
    has int32 $.maxTemplateVars;
    has ulong $.opLimit;
    has ulong $.opCount;

    our sub XPathGet(xmlXPathParserContext $ctxt --> xsltTransformContext) is native(XSLT) is symbol('xsltXPathGetTransformContext') {*}

    method AddStackElemList(xsltStackElem $elems --> int32) is native(XSLT) is symbol('xsltAddStackElemList') {*}
    method AllocateExtraCtxt( --> int32) is native(XSLT) is symbol('xsltAllocateExtraCtxt') {*}
    method ApplyAttributeSet(xmlNode $node, xmlNode $inst, xmlCharP $attrSets) is native(XSLT) is symbol('xsltApplyAttributeSet') {*}
    method ApplyImports(xmlNode $contextNode, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltApplyImports') {*}
    method ApplyOneTemplate(xmlNode $contextNode, xmlNode $list, xsltTemplate $templ, xsltStackElem $params) is native(XSLT) is symbol('xsltApplyOneTemplate') {*}
    method ApplyStripSpaces(xmlNode $node) is native(XSLT) is symbol('xsltApplyStripSpaces') {*}
    method ApplyTemplates(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltApplyTemplates') {*}
    method AttrListTemplateProcess(xmlNode $target, xmlAttr $attrs --> xmlAttr) is native(XSLT) is symbol('xsltAttrListTemplateProcess') {*}
    method AttrTemplateProcess(xmlNode $target, xmlAttr $attr --> xmlAttr) is native(XSLT) is symbol('xsltAttrTemplateProcess') {*}
    method AttrTemplateValueProcess(xmlCharP $str --> xmlCharP) is native(XSLT) is symbol('xsltAttrTemplateValueProcess') {*}
    method AttrTemplateValueProcessNode(xmlCharP $str, xmlNode $inst --> xmlCharP) is native(XSLT) is symbol('xsltAttrTemplateValueProcessNode') {*}
    method Attribute(xmlNode $contextNode, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltAttribute') {*}
    method CallTemplate(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltCallTemplate') {*}
    method Choose(xmlNode $contextNode, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltChoose') {*}
    method Comment(xmlNode $node, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltComment') {*}
    method ComputeSortResult(xmlNode $sort --> xmlXPathObjectPtr *) is native(XSLT) is symbol('xsltComputeSortResult') {*}
    method Copy(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltCopy') {*}
    method CopyNamespace(xmlNode $elem, xmlNs $ns --> xmlNs) is native(XSLT) is symbol('xsltCopyNamespace') {*}
    method CopyNamespaceList(xmlNode $node, xmlNs $cur --> xmlNs) is native(XSLT) is symbol('xsltCopyNamespaceList') {*}
    method CopyOf(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltCopyOf') {*}
    method CopyTextString(xmlNode $target, xmlCharP $string, int32 $noescape --> xmlNode) is native(XSLT) is symbol('xsltCopyTextString') {*}
    method CreateRVT( --> xmlDoc) is native(XSLT) is symbol('xsltCreateRVT') {*}
    method Debug(xmlNode $node, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltDebug') {*}
    method DefaultSortFunction(xmlNodePtr * $sorts, int32 $nbsorts) is native(XSLT) is symbol('xsltDefaultSortFunction') {*}
    method DoSortFunction(xmlNodePtr * $sorts, int32 $nbsorts) is native(XSLT) is symbol('xsltDoSortFunction') {*}
    method DocumentElem(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltDocumentElem') {*}
    method Element(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltElement') {*}
    method EvalAVT(Pointer $avt, xmlNode $node --> xmlCharP) is native(XSLT) is symbol('xsltEvalAVT') {*}
    method EvalAttrValueTemplate(xmlNode $inst, xmlCharP $name, xmlCharP $ns --> xmlCharP) is native(XSLT) is symbol('xsltEvalAttrValueTemplate') {*}
    method EvalGlobalVariables( --> int32) is native(XSLT) is symbol('xsltEvalGlobalVariables') {*}
    method EvalOneUserParam(xmlCharP $name, xmlCharP $value --> int32) is native(XSLT) is symbol('xsltEvalOneUserParam') {*}
    method EvalTemplateString(xmlNode $contextNode, xmlNode $inst --> xmlCharP) is native(XSLT) is symbol('xsltEvalTemplateString') {*}
    method EvalUserParams(const char ** $params --> int32) is native(XSLT) is symbol('xsltEvalUserParams') {*}
    method EvalXPathPredicate(xmlXPathCompExpr $comp, xmlNsPtr * $nsList, int32 $nsNr --> int32) is native(XSLT) is symbol('xsltEvalXPathPredicate') {*}
    method EvalXPathString(xmlXPathCompExpr $comp --> xmlCharP) is native(XSLT) is symbol('xsltEvalXPathString') {*}
    method EvalXPathStringNs(xmlXPathCompExpr $comp, int32 $nsNr, xmlNsPtr * $nsList --> xmlCharP) is native(XSLT) is symbol('xsltEvalXPathStringNs') {*}
    method ExtElementLookup(xmlCharP $name, xmlCharP $URI --> xsltTransformFunction) is native(XSLT) is symbol('xsltExtElementLookup') {*}
    method ExtensionInstructionResultFinalize( --> int32) is native(XSLT) is symbol('xsltExtensionInstructionResultFinalize') {*}
    method ExtensionInstructionResultRegister(xmlXPathObject $obj --> int32) is native(XSLT) is symbol('xsltExtensionInstructionResultRegister') {*}
    method FindDocument(xmlDoc $doc --> xsltDocument) is native(XSLT) is symbol('xsltFindDocument') {*}
    method FindElemSpaceHandling(xmlNode $node --> int32) is native(XSLT) is symbol('xsltFindElemSpaceHandling') {*}
    method FindTemplate(xmlCharP $name, xmlCharP $nameURI --> xsltTemplate) is native(XSLT) is symbol('xsltFindTemplate') {*}
    method FlagRVTs(xmlXPathObject $obj, Pointer $val --> int32) is native(XSLT) is symbol('xsltFlagRVTs') {*}
    method ForEach(xmlNode $contextNode, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltForEach') {*}
    method FreeCtxtExts() is native(XSLT) is symbol('xsltFreeCtxtExts') {*}
    method FreeDocuments() is native(XSLT) is symbol('xsltFreeDocuments') {*}
    method FreeGlobalVariables() is native(XSLT) is symbol('xsltFreeGlobalVariables') {*}
    method FreeRVTs() is native(XSLT) is symbol('xsltFreeRVTs') {*}
    method Free() is native(XSLT) is symbol('xsltFreeTransformContext') {*}
    method GetExtData(xmlCharP $URI --> Pointer) is native(XSLT) is symbol('xsltGetExtData') {*}
    method GetKey(xmlCharP $name, xmlCharP $nameURI, xmlCharP $value --> xmlNodeSet) is native(XSLT) is symbol('xsltGetKey') {*}
    method GetNamespace(xmlNode $cur, xmlNs $ns, xmlNode $out --> xmlNs) is native(XSLT) is symbol('xsltGetNamespace') {*}
    method GetPlainNamespace(xmlNode $cur, xmlNs $ns, xmlNode $out --> xmlNs) is native(XSLT) is symbol('xsltGetPlainNamespace') {*}
    method GetProfileInformation( --> xmlDoc) is native(XSLT) is symbol('xsltGetProfileInformation') {*}
    method GetSpecialNamespace(xmlNode $invocNode, xmlCharP $nsName, xmlCharP $nsPrefix, xmlNode $target --> xmlNs) is native(XSLT) is symbol('xsltGetSpecialNamespace') {*}
    method GetTemplate(xmlNode $node, xsltStylesheet $style --> xsltTemplate) is native(XSLT) is symbol('xsltGetTemplate') {*}
    method If(xmlNode $contextNode, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltIf') {*}
    method InitAllDocKeys( --> int32) is native(XSLT) is symbol('xsltInitAllDocKeys') {*}
    method InitCtxtExts( --> int32) is native(XSLT) is symbol('xsltInitCtxtExts') {*}
    method InitCtxtKey(xsltDocument $idoc, xsltKeyDef $keyDef --> int32) is native(XSLT) is symbol('xsltInitCtxtKey') {*}
    method InitCtxtKeys(xsltDocument $idoc) is native(XSLT) is symbol('xsltInitCtxtKeys') {*}
    method LoadDocument(xmlCharP $URI --> xsltDocument) is native(XSLT) is symbol('xsltLoadDocument') {*}
    method LocalVariablePop(int32 $limitNr, int32 $level) is native(XSLT) is symbol('xsltLocalVariablePop') {*}
    method LocalVariablePush(xsltStackElem $variable, int32 $level --> int32) is native(XSLT) is symbol('xsltLocalVariablePush') {*}
    method MatchPattern(xmlNode $node, xmlCharP $pattern, xmlDoc $ctxtdoc, xmlNode $ctxtnode --> int32) is native(XSLT) is symbol('xsltMatchPattern') {*}
    method Message(xmlNode $node, xmlNode $inst) is native(XSLT) is symbol('xsltMessage') {*}
    method NeedElemSpaceHandling( --> int32) is native(XSLT) is symbol('xsltNeedElemSpaceHandling') {*}
    method NewDocument(xmlDoc $doc --> xsltDocument) is native(XSLT) is symbol('xsltNewDocument') {*}
    method Number(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltNumber') {*}
    method NumberFormat(xsltNumberData $data, xmlNode $node) is native(XSLT) is symbol('xsltNumberFormat') {*}
    method ParseStylesheetCallerParam(xmlNode $inst --> xsltStackElem) is native(XSLT) is symbol('xsltParseStylesheetCallerParam') {*}
    method ParseStylesheetParam(xmlNode $cur) is native(XSLT) is symbol('xsltParseStylesheetParam') {*}
    method ParseStylesheetVariable(xmlNode $inst) is native(XSLT) is symbol('xsltParseStylesheetVariable') {*}
    method PrintError(xsltStylesheet $style, xmlNode $node) is native(XSLT) is symbol('xsltPrintErrorContext') {*}
    method ProcessOneNode(xmlNode $contextNode, xsltStackElem $withParams) is native(XSLT) is symbol('xsltProcessOneNode') {*}
    method ProcessingInstruction(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltProcessingInstruction') {*}
    method QuoteOneUserParam(xmlCharP $name, xmlCharP $value --> int32) is native(XSLT) is symbol('xsltQuoteOneUserParam') {*}
    method QuoteUserParams(const char ** $params --> int32) is native(XSLT) is symbol('xsltQuoteUserParams') {*}
    method RegisterAllElement() is native(XSLT) is symbol('xsltRegisterAllElement') {*}
    method RegisterExtElement(xmlCharP $name, xmlCharP $URI, xsltTransformFunction $function --> int32) is native(XSLT) is symbol('xsltRegisterExtElement') {*}
    method RegisterExtFunction(xmlCharP $name, xmlCharP $URI, xmlXPathFunction $function --> int32) is native(XSLT) is symbol('xsltRegisterExtFunction') {*}
    method RegisterExtras() is native(XSLT) is symbol('xsltRegisterExtras') {*}
    method RegisterLocalRVT(xmlDoc $RVT --> int32) is native(XSLT) is symbol('xsltRegisterLocalRVT') {*}
    method RegisterPersistRVT(xmlDoc $RVT --> int32) is native(XSLT) is symbol('xsltRegisterPersistRVT') {*}
    method RegisterTmpRVT(xmlDoc $RVT --> int32) is native(XSLT) is symbol('xsltRegisterTmpRVT') {*}
    method ReleaseRVT(xmlDoc $RVT) is native(XSLT) is symbol('xsltReleaseRVT') {*}
    method SaveProfiling(FILE * $output) is native(XSLT) is symbol('xsltSaveProfiling') {*}
    method SetCtxtParseOptions(int32 $options --> int32) is native(XSLT) is symbol('xsltSetCtxtParseOptions') {*}
    method SetCtxtSortFunc(xsltSortFunc $handler) is native(XSLT) is symbol('xsltSetCtxtSortFunc') {*}
    method SetTransformErrorFunc(Pointer $ctx, xmlGenericErrorFunc $handler) is native(XSLT) is symbol('xsltSetTransformErrorFunc') {*}
    method ShutdownCtxtExts() is native(XSLT) is symbol('xsltShutdownCtxtExts') {*}
    method Sort(xmlNode $node, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltSort') {*}
    method TemplateProcess(xmlNode $node --> xmlNodePtr *) is native(XSLT) is symbol('xsltTemplateProcess') {*}
    method TestCompMatchList(xmlNode $node, xsltCompMatch $comp --> int32) is native(XSLT) is symbol('xsltTestCompMatchList') {*}
    method Text(xmlNode $node, xmlNode $inst, xsltElemPreComp $comp) is native(XSLT) is symbol('xsltText') {*}
    method Error(xsltStylesheet $style, xmlNode $node, Str $msg, ... $...) is native(XSLT) is symbol('xsltTransformError') {*}
    method ValueOf(xmlNode $node, xmlNode $inst, xsltElemPreComp $castedComp) is native(XSLT) is symbol('xsltValueOf') {*}
    method VariableLookup(xmlCharP $name, xmlCharP $ns_uri --> xmlXPathObject) is native(XSLT) is symbol('xsltVariableLookup') {*}
}

class xsltVarInfo is repr('CStruct') {
    has xsltVarInfo $.next; # next in the list
    has xsltVarInfo $.prev;
    has int32 $.depth; # the depth in the tree
    has xmlCharP $.name;
    has xmlCharP $.nsName;
}

our sub xsltFreeAVTList(Pointer $avt) is native(XSLT) is export {*}
our sub xsltIsBlank(xmlCharP $str --> int32) is native(XSLT) is export {*}
our sub xsltUninit() is native(XSLT) is export {*}
