#!perl -T
use warnings; use strict;
use Test::More;
use Test::Exception;
use Test::Builder;
use Elive::StandardV2;
use Elive::StandardV2::Session;

use lib '.';
use t::Elive::StandardV2;

my $t = Test::Builder->new();

my $class = 'Elive::StandardV2::Session' ;

use Carp;
use Scalar::Util;
use Try::Tiny;

my $MODULE = 'Test::Taint';
eval "use $MODULE";
plan skip_all => "$MODULE not available for taint tests"
    if $@;

plan tests => 12;
#
# restrict our user tests to the mock connections. Live updates
# are just to dangerous. There is also the possibility that the
# live site is running LDAP, in which case user access becomes
# read only.
#

SKIP: {

    my $skippable = 12;

    my %result = t::Elive::StandardV2->test_connection();
    my $auth = $result{auth};

    skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    my $connection_class = $result{class};
    my $connection = $connection_class->connect(@$auth);
    Elive::StandardV2->connection($connection);

    taint_checking_ok();

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    my $session_name_untainted = 'test session, generated by t/soap-taint-mode.t(' . t::Elive::StandardV2::generate_id() . ')';
    taint( my $session_name_tainted = $session_name_untainted);

    my %session_data = (
	sessionName => $session_name_untainted,
	creatorId => $connection->user,
	startTime =>  $session_start . '000',
	endTime => $session_end . '000',
	permissionsOn => 1,
	chairList => [$connection->user],
    );

    my $session;

    lives_ok( sub {$session = $class->insert(\%session_data);},
	     'insert with no tainted data - lives');

    $session_data{sessionName} = $session_name_tainted;
    dies_ok( sub {$session = $class->insert(\%session_data);},
	     'insert with tainted Str data - dies');

    isa_ok($session, $class, 'session');

    my $chair_notes_untainted = 'this is a test';
    taint(my $chair_notes_tainted = $chair_notes_untainted);

    my %update_data = (
	chairNotes => $chair_notes_tainted,
	);

    dies_ok(sub {$session->update(\%update_data)}, 'update with tainted Str data - dies');

    $update_data{chairNotes} = $chair_notes_untainted;

    lives_ok(sub {$session->update(\%update_data)}, 'update with no tainted data - lives');

    my $session_id = $session->sessionId;

    $session = undef;

    my $sessions;

    dies_ok (sub {$sessions = Elive::StandardV2::Session->list(filter => {sessionName => $session_name_tainted})},
	'List with tainted filter - dies');
  
    lives_ok (sub {$sessions = Elive::StandardV2::Session->list(filter => {sessionName => $session_name_untainted})},
	'List with untainted filter - lives');
  
    is(scalar @$sessions, 1, 'list returns unique session');

    is( try {$sessions->[0]->sessionId}, $session_id, 'listed sessionId as expected');
    $sessions = undef;

    ok ($session = Elive::StandardV2::Session->retrieve([$session_id]),
	'Refetch of session');

    lives_ok(sub {$session->delete},'session deletion - lives');

}

Elive::StandardV2->disconnect;
