use strict;
use warnings;

package Software::License::GPL_3::or_later;

our $VERSION = '0.003'; # VERSION
# ABSTRACT: Add-on for Software::License module providing "or any later" clause to GPL_3

use parent 'Software::License::GPL_3';

sub name { $_[ 0 ]->SUPER::name() . ', or any later' };
sub version { '3+'; };
    #   Cannot call `SUPER::version` here because it returns "or.later".

1;

=pod

=encoding UTF-8

=head1 NAME

Software::License::GPL_3::or_later - Add-on for Software::License module providing "or any later" clause to GPL_3

=head1 VERSION

version 0.003

=head1 DESCRIPTION

C<Software::License::GPL_3::or_later> is a subclass of L<Software::License::GPL_3>. It overrides
few parent methods:

=over 4

=item C<name>

    appends ", or any later" clause to the parent license name;

=item C<version>

    appends "+" to the parent license version;

=item C<notice>

    returns copyright statement and standard GNU 3-paragraph license notice (see the section
    L<COPYRIGHT AND LICENSE> below).

=back

See documentation on L<Software::License> for a general description of class interface.

=head1 AUTHOR

Van de Bugger <van.de.bugger@liamg.moc>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 Van de Bugger

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

__DATA__
__NOTICE__
Copyright (C) {{$self->year}} {{$self->holder}}

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
__END__

# end of file #
