#!./perl -t

BEGIN {
    chdir 't';
    @INC = '../lib';
    require './test.pl';
}

plan tests => 11;

my $Perl = which_perl();

my $warning;
local $SIG{__WARN__} = sub { $warning = join "\n", @_; };
my $Tmsg = 'while running with -t switch';

is( ${^TAINT}, -1, '${^TAINT} == -1' );

my $out = `$Perl -le "print q(Hello)"`;
is( $out, "Hello\n",                      '`` worked' );
like( $warning, qr/^Insecure .* $Tmsg/, '    taint warn' );

{
    no warnings 'taint';
    $warning = '';
    my $out = `$Perl -le "print q(Hello)"`;
    is( $out, "Hello\n",                      '`` worked' );
    is( $warning, '',                       '   no warnings "taint"' );
}

# Get ourselves a tainted variable.
$file = $0;
$file =~ s/.*/some.tmp/;
ok( open(FILE, ">", "$file"),   'open >' ) or DIE $!;
print FILE "Stuff\n";
close FILE;
like( $warning, qr/^Insecure dependency in open $Tmsg/, 'open > taint warn' );
ok( -e $file,   '   file written' );

unlink($file);
like( $warning, qr/^Insecure dependency in unlink $Tmsg/,
                                                  'unlink() taint warn' );
ok( !-e $file,  'unlink worked' );

ok( !$^W,   "-t doesn't enable regular warnings" );
