/*  -*- buffer-read-only: t -*-
 *
 *    proto.h
 *
 *    Copyright (C) 1993, 1994, 1995, 1996, 1997, 1998, 1999,
 *    2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by embed.pl from data in embed.fnc, embed.pl,
 * pp.sym, intrpvar.h, and perlvars.h.
 * Any changes made here will be lost!
 *
 * Edit those files and run 'make regen_headers' to effect changes.
 */

START_EXTERN_C

#if defined(PERL_IMPLICIT_SYS)
PERL_CALLCONV PerlInterpreter*	perl_alloc_using(struct IPerlMem* m, struct IPerlMem* ms, struct IPerlMem* mp, struct IPerlEnv* e, struct IPerlStdIO* io, struct IPerlLIO* lio, struct IPerlDir* d, struct IPerlSock* s, struct IPerlProc* p)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4)
			__attribute__nonnull__(5)
			__attribute__nonnull__(6)
			__attribute__nonnull__(7)
			__attribute__nonnull__(8)
			__attribute__nonnull__(9);

#endif
PERL_CALLCONV PerlInterpreter*	perl_alloc(void);
PERL_CALLCONV void	perl_construct(PerlInterpreter* interp)
			__attribute__nonnull__(1);

PERL_CALLCONV int	perl_destruct(PerlInterpreter* interp)
			__attribute__nonnull__(1);

PERL_CALLCONV void	perl_free(PerlInterpreter* interp)
			__attribute__nonnull__(1);

PERL_CALLCONV int	perl_run(PerlInterpreter* interp)
			__attribute__nonnull__(1);

PERL_CALLCONV int	perl_parse(PerlInterpreter* interp, XSINIT_t xsinit, int argc, char** argv, char** env)
			__attribute__nonnull__(1);

PERL_CALLCONV bool	Perl_doing_taint(int argc, char** argv, char** env)
			__attribute__warn_unused_result__;

#if defined(USE_ITHREADS)
PERL_CALLCONV PerlInterpreter*	perl_clone(PerlInterpreter* interp, UV flags)
			__attribute__nonnull__(1);

#  if defined(PERL_IMPLICIT_SYS)
PERL_CALLCONV PerlInterpreter*	perl_clone_using(PerlInterpreter *interp, UV flags, struct IPerlMem* m, struct IPerlMem* ms, struct IPerlMem* mp, struct IPerlEnv* e, struct IPerlStdIO* io, struct IPerlLIO* lio, struct IPerlDir* d, struct IPerlSock* s, struct IPerlProc* p)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4)
			__attribute__nonnull__(5)
			__attribute__nonnull__(6)
			__attribute__nonnull__(7)
			__attribute__nonnull__(8)
			__attribute__nonnull__(9)
			__attribute__nonnull__(10)
			__attribute__nonnull__(11);

#  endif
#endif

PERL_CALLCONV Malloc_t	Perl_malloc(MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_calloc(MEM_SIZE elements, MEM_SIZE size)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_realloc(Malloc_t where, MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Free_t	Perl_mfree(Malloc_t where);
#if defined(MYMALLOC)
PERL_CALLCONV MEM_SIZE	Perl_malloced_size(void *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

#endif

PERL_CALLCONV void*	Perl_get_context(void)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_set_context(void *thx)
			__attribute__nonnull__(1);


END_EXTERN_C

/* functions with flag 'n' should come before here */
START_EXTERN_C
#  include "pp_proto.h"
PERL_CALLCONV SV*	Perl_amagic_call(pTHX_ SV* left, SV* right, int method, int dir)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_Gv_AMupdate(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV CV*	Perl_gv_handler(pTHX_ HV* stash, I32 id)
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_append_elem(pTHX_ I32 optype, OP* first, OP* last);
PERL_CALLCONV OP*	Perl_append_list(pTHX_ I32 optype, LISTOP* first, LISTOP* last);
PERL_CALLCONV I32	Perl_apply(pTHX_ I32 type, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_apply_attrs_string(pTHX_ const char *stashpv, CV *cv, const char *attrstr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_av_clear(pTHX_ AV* ar)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_av_delete(pTHX_ AV* ar, I32 key, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_av_exists(pTHX_ AV* ar, I32 key)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_av_extend(pTHX_ AV* ar, I32 key)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV AV*	Perl_av_fake(pTHX_ I32 size, SV** svp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV**	Perl_av_fetch(pTHX_ AV* ar, I32 key, I32 lval)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_av_fill(pTHX_ AV* ar, I32 fill)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_av_len(pTHX_ const AV* ar)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV AV*	Perl_av_make(pTHX_ I32 size, SV** svp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_av_pop(pTHX_ AV* ar)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_av_create_and_push(pTHX_ AV **const avp, SV *const val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_av_push(pTHX_ AV* ar, SV* val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_av_reify(pTHX_ AV* ar)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_av_shift(pTHX_ AV* ar)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV**	Perl_av_store(pTHX_ AV* ar, I32 key, SV* val)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_av_undef(pTHX_ AV* ar)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV**	Perl_av_create_and_unshift_one(pTHX_ AV **const avp, SV *const val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_av_unshift(pTHX_ AV* ar, I32 num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV**	Perl_av_arylen_p(pTHX_ AV* av)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_bind_match(pTHX_ I32 type, OP* left, OP* pat)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV OP*	Perl_block_end(pTHX_ I32 floor, OP* seq)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_block_gimme(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_block_start(pTHX_ int full)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_boot_core_UNIVERSAL(pTHX);
PERL_CALLCONV void	Perl_boot_core_PerlIO(pTHX);
PERL_CALLCONV void	Perl_call_list(pTHX_ I32 oldscope, AV* av_list)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_cando(pTHX_ Mode_t mode, bool effective, const Stat_t* statbufp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV U32	Perl_cast_ulong(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_cast_i32(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV IV	Perl_cast_iv(pTHX_ NV f)
			__attribute__warn_unused_result__;

PERL_CALLCONV UV	Perl_cast_uv(pTHX_ NV f)
			__attribute__warn_unused_result__;

#if !defined(HAS_TRUNCATE) && !defined(HAS_CHSIZE) && defined(F_FREESP)
PERL_CALLCONV I32	Perl_my_chsize(pTHX_ int fd, Off_t length)
			__attribute__warn_unused_result__;

#endif
PERL_CALLCONV OP*	Perl_convert(pTHX_ I32 optype, I32 flags, OP* o)
			__attribute__warn_unused_result__;

PERL_CALLCONV PERL_CONTEXT*	Perl_create_eval_scope(pTHX_ U32 flags);
PERL_CALLCONV void	Perl_croak(pTHX_ const char* pat, ...)
			__attribute__noreturn__
			__attribute__format__null_ok__(__printf__,pTHX_1,pTHX_2);

PERL_CALLCONV void	Perl_vcroak(pTHX_ const char* pat, va_list* args)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1);

#if defined(PERL_IMPLICIT_CONTEXT)
PERL_CALLCONV void	Perl_croak_nocontext(const char* pat, ...)
			__attribute__noreturn__
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV OP*	Perl_die_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV void	Perl_deb_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV char*	Perl_form_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV void	Perl_load_module_nocontext(U32 flags, SV* name, SV* ver, ...)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);

PERL_CALLCONV SV*	Perl_mess_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV void	Perl_warn_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV void	Perl_warner_nocontext(U32 err, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(2);

PERL_CALLCONV SV*	Perl_newSVpvf_nocontext(const char* pat, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

PERL_CALLCONV void	Perl_sv_catpvf_nocontext(SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV void	Perl_sv_setpvf_nocontext(SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV void	Perl_sv_catpvf_mg_nocontext(SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV void	Perl_sv_setpvf_mg_nocontext(SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV int	Perl_fprintf_nocontext(PerlIO* stream, const char* fmt, ...)
			__attribute__format__(__printf__,2,3)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV int	Perl_printf_nocontext(const char* fmt, ...)
			__attribute__format__(__printf__,1,2)
			__attribute__nonnull__(1);

#endif
PERL_CALLCONV void	Perl_cv_ckproto(pTHX_ const CV* cv, const GV* gv, const char* p)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_cv_ckproto_len(pTHX_ const CV* cv, const GV* gv, const char* p, const STRLEN len)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV CV*	Perl_cv_clone(pTHX_ CV* proto)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_gv_const_sv(pTHX_ GV* gv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_cv_const_sv(pTHX_ CV* cv)
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_op_const_sv(pTHX_ const OP* o, CV* cv)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_cv_undef(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_cx_dump(pTHX_ PERL_CONTEXT* cx)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_filter_add(pTHX_ filter_t funcp, SV* datasv);
PERL_CALLCONV void	Perl_filter_del(pTHX_ filter_t funcp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_filter_read(pTHX_ int idx, SV* buffer, int maxlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char**	Perl_get_op_descs(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV char**	Perl_get_op_names(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV const char*	Perl_get_no_modify(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32*	Perl_get_opargs(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV PPADDR_t*	Perl_get_ppaddr(pTHX)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV I32	Perl_cxinc(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_deb(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_vdeb(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_debprofdump(pTHX);
PERL_CALLCONV I32	Perl_debop(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_debstack(pTHX);
PERL_CALLCONV I32	Perl_debstackptrs(pTHX);
PERL_CALLCONV char*	Perl_delimcpy(pTHX_ char* to, const char* toend, const char* from, const char* fromend, int delim, I32* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_6);

PERL_CALLCONV void	Perl_delete_eval_scope(pTHX);
PERL_CALLCONV void	Perl_deprecate(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_deprecate_old(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_die(pTHX_ const char* pat, ...)
			__attribute__format__null_ok__(__printf__,pTHX_1,pTHX_2);

PERL_CALLCONV OP*	Perl_vdie(pTHX_ const char* pat, va_list* args);
PERL_CALLCONV OP*	Perl_die_where(pTHX_ const char* message, STRLEN msglen);
PERL_CALLCONV void	Perl_dounwind(pTHX_ I32 cxix);
/* PERL_CALLCONV bool	Perl_do_aexec(pTHX_ SV* really, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3); */

PERL_CALLCONV bool	Perl_do_aexec5(pTHX_ SV* really, SV** mark, SV** sp, int fd, int do_report)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV int	Perl_do_binmode(pTHX_ PerlIO *fp, int iotype, int mode)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_do_chop(pTHX_ SV* asv, SV* sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_do_close(pTHX_ GV* gv, bool not_implicit);
PERL_CALLCONV bool	Perl_do_eof(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);


#ifdef PERL_DEFAULT_DO_EXEC3_IMPLEMENTATION
/* PERL_CALLCONV bool	Perl_do_exec(pTHX_ const char* cmd)
			__attribute__nonnull__(pTHX_1); */

#else
PERL_CALLCONV bool	Perl_do_exec(pTHX_ const char* cmd)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(WIN32) || defined(__SYMBIAN32__)
PERL_CALLCONV int	Perl_do_aspawn(pTHX_ SV* really, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV int	Perl_do_spawn(pTHX_ char* cmd)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_do_spawn_nowait(pTHX_ char* cmd)
			__attribute__nonnull__(pTHX_1);

#endif
#if !defined(WIN32)
PERL_CALLCONV bool	Perl_do_exec3(pTHX_ const char* cmd, int fd, int do_report)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_do_execfree(pTHX);
#ifdef PERL_IN_DOIO_C
STATIC void	S_exec_failed(pTHX_ const char *cmd, int fd, int do_report)
			__attribute__nonnull__(pTHX_1);

#endif
#if defined(HAS_MSG) || defined(HAS_SEM) || defined(HAS_SHM)
PERL_CALLCONV I32	Perl_do_ipcctl(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV I32	Perl_do_ipcget(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV I32	Perl_do_msgrcv(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_do_msgsnd(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_do_semop(pTHX_ SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_do_shmio(pTHX_ I32 optype, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#endif
PERL_CALLCONV void	Perl_do_join(pTHX_ SV* sv, SV* del, SV** mark, SV** sp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV OP*	Perl_do_kv(pTHX);
/* PERL_CALLCONV bool	Perl_do_open(pTHX_ GV* gv, const char* name, I32 len, int as_raw, int rawmode, int rawperm, PerlIO* supplied_fp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

PERL_CALLCONV bool	Perl_do_open9(pTHX_ GV *gv, const char *name, I32 len, int as_raw, int rawmode, int rawperm, PerlIO *supplied_fp, SV *svs, I32 num)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_8);

PERL_CALLCONV bool	Perl_do_openn(pTHX_ GV *gv, const char *name, I32 len, int as_raw, int rawmode, int rawperm, PerlIO *supplied_fp, SV **svp, I32 num)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_do_print(pTHX_ SV* sv, PerlIO* fp)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_do_readline(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV I32	Perl_do_chomp(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_do_seek(pTHX_ GV* gv, Off_t pos, int whence);
PERL_CALLCONV void	Perl_do_sprintf(pTHX_ SV* sv, I32 len, SV** sarg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV Off_t	Perl_do_sysseek(pTHX_ GV* gv, Off_t pos, int whence)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV Off_t	Perl_do_tell(pTHX_ GV* gv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_do_trans(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV UV	Perl_do_vecget(pTHX_ SV* sv, I32 offset, I32 size)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_do_vecset(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_do_vop(pTHX_ I32 optype, SV* sv, SV* left, SV* right)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV OP*	Perl_dofile(pTHX_ OP* term, I32 force_builtin)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_dowantarray(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_dump_all(pTHX);
PERL_CALLCONV void	Perl_dump_eval(pTHX);
#if defined(DUMP_FDS)
PERL_CALLCONV void	Perl_dump_fds(pTHX_ char* s)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_dump_form(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_gv_dump(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_op_dump(pTHX_ const OP* arg)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_pmop_dump(pTHX_ PMOP* pm);
PERL_CALLCONV void	Perl_dump_packsubs(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_dump_sub(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_fbm_compile(pTHX_ SV* sv, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_fbm_instr(pTHX_ char* big, char* bigend, SV* littlesv, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV char*	Perl_find_script(pTHX_ const char *scriptname, bool dosearch, const char *const *const search_ext, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_force_list(pTHX_ OP* arg);
PERL_CALLCONV OP*	Perl_fold_constants(pTHX_ OP* arg)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_form(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_vform(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_free_tmps(pTHX);
PERL_CALLCONV OP*	Perl_gen_constant_list(pTHX_ OP* o);
#if !defined(HAS_GETENV_LEN)
PERL_CALLCONV char*	Perl_getenv_len(pTHX_ const char* key, unsigned long *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV void	Perl_get_db_sub(pTHX_ SV **svp, CV *cv)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_gp_free(pTHX_ GV* gv);
PERL_CALLCONV GP*	Perl_gp_ref(pTHX_ GP* gp);
PERL_CALLCONV GV*	Perl_gv_AVadd(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV GV*	Perl_gv_HVadd(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV GV*	Perl_gv_IOadd(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_gv_check(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_gv_efullname(pTHX_ SV* sv, const GV* gv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

/* PERL_CALLCONV void	Perl_gv_efullname3(pTHX_ SV* sv, const GV* gv, const char* prefix)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

PERL_CALLCONV void	Perl_gv_efullname4(pTHX_ SV* sv, const GV* gv, const char* prefix, bool keepmain)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV GV*	Perl_gv_fetchfile(pTHX_ const char* name)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV GV*	Perl_gv_fetchfile_flags(pTHX_ const char *const name, const STRLEN len, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV GV*	Perl_gv_fetchmeth(pTHX_ HV* stash, const char* name, STRLEN len, I32 level)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV GV*	Perl_gv_fetchmethod(pTHX_ HV* stash, const char* name)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV GV*	Perl_gv_fetchpv(pTHX_ const char* name, I32 add, I32 sv_type)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_gv_fullname4(pTHX_ SV* sv, const GV* gv, const char* prefix, bool keepmain)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV GP *	Perl_newGP(pTHX_ GV *const gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_gv_init(pTHX_ GV* gv, HV* stash, const char* name, STRLEN len, int multi)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_gv_name_set(pTHX_ GV* gv, const char *name, U32 len, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV HV*	Perl_gv_stashpv(pTHX_ const char* name, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HV*	Perl_gv_stashpvn(pTHX_ const char* name, U32 namelen, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HV*	Perl_gv_stashsv(pTHX_ SV* sv, I32 flags);
PERL_CALLCONV void	Perl_hv_clear(pTHX_ HV* tb);
PERL_CALLCONV HV *	Perl_hv_copy_hints_hv(pTHX_ HV *const ohv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_hv_delayfree_ent(pTHX_ HV* hv, HE* entry)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV SV*	Perl_hv_delete(pTHX_ HV* tb, const char* key, I32 klen, I32 flags)
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV SV*	Perl_hv_delete_ent(pTHX_ HV* tb, SV* key, I32 flags, U32 hash)
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV bool	Perl_hv_exists(pTHX_ HV* tb, const char* key, I32 klen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV bool	Perl_hv_exists_ent(pTHX_ HV* tb, SV* key, U32 hash)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV SV**	Perl_hv_fetch(pTHX_ HV* tb, const char* key, I32 klen, I32 lval)
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV HE*	Perl_hv_fetch_ent(pTHX_ HV* tb, SV* key, I32 lval, U32 hash)
			__attribute__nonnull__(pTHX_2); */

PERL_CALLCONV void*	Perl_hv_common(pTHX_ HV* tb, SV* keysv, const char* key, STRLEN klen, int flags, int action, SV* val, U32 hash);
PERL_CALLCONV void*	Perl_hv_common_key_len(pTHX_ HV *hv, const char *key, I32 klen_i32, const int action, SV *val, const U32 hash)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_hv_free_ent(pTHX_ HV* hv, HE* entryK)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_hv_iterinit(pTHX_ HV* tb)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_hv_iterkey(pTHX_ HE* entry, I32* retlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_hv_iterkeysv(pTHX_ HE* entry)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV HE*	Perl_hv_iternext(pTHX_ HV* tb)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV SV*	Perl_hv_iternextsv(pTHX_ HV* hv, char** key, I32* retlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV HE*	Perl_hv_iternext_flags(pTHX_ HV* tb, I32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_hv_iterval(pTHX_ HV* tb, HE* entry)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_hv_ksplit(pTHX_ HV* hv, IV newmax)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_hv_magic(pTHX_ HV* hv, GV* gv, int how)
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV SV**	Perl_hv_store(pTHX_ HV* tb, const char* key, I32 klen, SV* val, U32 hash); */
/* PERL_CALLCONV HE*	Perl_hv_store_ent(pTHX_ HV* tb, SV* key, SV* val, U32 hash); */
/* PERL_CALLCONV SV**	Perl_hv_store_flags(pTHX_ HV* tb, const char* key, I32 klen, SV* val, U32 hash, int flags); */
PERL_CALLCONV void	Perl_hv_undef(pTHX_ HV* tb);
PERL_CALLCONV I32	Perl_ibcmp(pTHX_ const char* a, const char* b, I32 len)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_ibcmp_locale(pTHX_ const char* a, const char* b, I32 len)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_ibcmp_utf8(pTHX_ const char* a, char **pe1, UV l1, const char* b, char **pe2, UV l2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV bool	Perl_ingroup(pTHX_ Gid_t testgid, bool effective)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_init_argv_symbols(pTHX_ int argc, char **argv)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_init_debugger(pTHX);
PERL_CALLCONV void	Perl_init_stacks(pTHX);
PERL_CALLCONV void	Perl_init_tm(pTHX_ struct tm *ptm)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV U32	Perl_intro_my(pTHX);
PERL_CALLCONV char*	Perl_instr(pTHX_ const char* big, const char* little)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_io_close(pTHX_ IO* io, bool not_implicit)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_invert(pTHX_ OP* cmd)
			__attribute__warn_unused_result__;

PERL_CALLCONV bool	Perl_is_gv_magical(pTHX_ const char *name, STRLEN len, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_is_lvalue_sub(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV U32	Perl_to_uni_upper_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32	Perl_to_uni_title_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV U32	Perl_to_uni_lower_lc(pTHX_ U32 c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alnum(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alnumc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_idfirst(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alpha(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_ascii(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_space(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_cntrl(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_graph(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_digit(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_upper(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_lower(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_print(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_punct(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_xdigit(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV UV	Perl_to_uni_upper(pTHX_ UV c, char *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV UV	Perl_to_uni_title(pTHX_ UV c, char *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV UV	Perl_to_uni_lower(pTHX_ UV c, char *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV UV	Perl_to_uni_fold(pTHX_ UV c, char *p, STRLEN *lenp)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV bool	Perl_is_uni_alnum_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alnumc_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_idfirst_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_alpha_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_ascii_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_space_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_cntrl_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_graph_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_digit_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_upper_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_lower_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_print_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_punct_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV bool	Perl_is_uni_xdigit_lc(pTHX_ UV c)
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV STRLEN	Perl_is_utf8_char(pTHX_ const char *p)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_string(pTHX_ const char *s, STRLEN len)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV bool	Perl_is_utf8_string_loc(pTHX_ const char *s, STRLEN len, const char **p)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV bool	Perl_is_utf8_string_loclen(pTHX_ const char *s, STRLEN len, const char **ep, STRLEN *el)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_alnum(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_alnumc(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_idfirst(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_idcont(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_alpha(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_ascii(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_space(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_cntrl(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_digit(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_graph(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_upper(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_lower(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_print(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_punct(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_xdigit(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_utf8_mark(pTHX_ const char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_jmaybe(pTHX_ OP* arg)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_keyword(pTHX_ const char* d, I32 len, bool all_keywords)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_leave_scope(pTHX_ I32 base);
PERL_CALLCONV void	Perl_lex_end(pTHX);
PERL_CALLCONV void	Perl_lex_start(pTHX_ SV* line, PerlIO *rsfp, bool new_filter);
PERL_CALLCONV void	Perl_op_null(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_op_clear(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_op_refcnt_lock(pTHX);
PERL_CALLCONV void	Perl_op_refcnt_unlock(pTHX);
PERL_CALLCONV OP*	Perl_linklist(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_list(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_listkids(pTHX_ OP* o);
PERL_CALLCONV void	Perl_load_module(pTHX_ U32 flags, SV* name, SV* ver, ...)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_vload_module(pTHX_ U32 flags, SV* name, SV* ver, va_list* args)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_localize(pTHX_ OP* arg, I32 lexical)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_looks_like_number(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV UV	Perl_grok_bin(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV UV	Perl_grok_hex(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV int	Perl_grok_number(pTHX_ const char *pv, STRLEN len, UV *valuep)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_grok_numeric_radix(pTHX_ const char **sp, const char *send)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_grok_oct(pTHX_ const char* start, STRLEN* len_p, I32* flags, NV *result)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV int	Perl_magic_clearenv(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_clear_all_env(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_clearhint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_clearpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_clearsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_existspack(pTHX_ SV* sv, const MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_freeregexp(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_freeovrld(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_get(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getarylen(pTHX_ SV* sv, const MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getdefelem(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getnkeys(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getpos(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_gettaint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getuvar(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_getvec(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV U32	Perl_magic_len(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_nextpack(pTHX_ SV* sv, MAGIC* mg, SV* key)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV U32	Perl_magic_regdata_cnt(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_regdatum_get(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_regdatum_set(pTHX_ SV* sv, MAGIC* mg)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_set(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setamagic(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setarylen(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_freearylen_p(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setbm(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setdbline(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setdefelem(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setenv(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_sethint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setisa(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setglob(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setmglob(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setnkeys(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setpack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setpos(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setregexp(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setsig(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_settaint(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setuvar(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setvec(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_setutf8(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_set_all_env(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV U32	Perl_magic_sizepack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_magic_wipepack(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_magicname(pTHX_ const char* sym, const char* name, I32 namlen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_markstack_grow(pTHX);
#if defined(USE_LOCALE_COLLATE)
PERL_CALLCONV int	Perl_magic_setcollxfrm(pTHX_ SV* sv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_mem_collxfrm(pTHX_ const char* s, STRLEN len, STRLEN* xlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

#endif
PERL_CALLCONV SV*	Perl_mess(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_vmess(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_qerror(pTHX_ SV* err)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sortsv(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t cmp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_sortsv_flags(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t cmp, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV int	Perl_mg_clear(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_mg_copy(pTHX_ SV* sv, SV* nsv, const char* key, I32 klen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_mg_localize(pTHX_ SV* sv, SV* nsv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV MAGIC*	Perl_mg_find(pTHX_ const SV* sv, int type)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_mg_free(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_mg_get(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV U32	Perl_mg_length(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_mg_magical(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_mg_set(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_mg_size(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_mini_mktime(pTHX_ struct tm *pm)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_mod(pTHX_ OP* o, I32 type);
PERL_CALLCONV int	Perl_mode_from_discipline(pTHX_ SV* discp);
PERL_CALLCONV const char*	Perl_moreswitches(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_my(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV NV	Perl_my_atof(pTHX_ const char *s)
			__attribute__nonnull__(pTHX_1);

#if (!defined(HAS_MEMCPY) && !defined(HAS_BCOPY)) || (!defined(HAS_MEMMOVE) && !defined(HAS_SAFE_MEMCPY) && !defined(HAS_SAFE_BCOPY))
PERL_CALLCONV char*	Perl_my_bcopy(const char* from, char* to, I32 len)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

#endif
#if !defined(HAS_BZERO) && !defined(HAS_MEMSET)
PERL_CALLCONV char*	Perl_my_bzero(char* loc, I32 len)
			__attribute__nonnull__(1);

#endif
PERL_CALLCONV void	Perl_my_exit(pTHX_ U32 status)
			__attribute__noreturn__;

PERL_CALLCONV void	Perl_my_failure_exit(pTHX)
			__attribute__noreturn__;

PERL_CALLCONV I32	Perl_my_fflush_all(pTHX);
PERL_CALLCONV Pid_t	Perl_my_fork(void);
PERL_CALLCONV void	Perl_atfork_lock(void);
PERL_CALLCONV void	Perl_atfork_unlock(void);
PERL_CALLCONV I32	Perl_my_lstat(pTHX);
#if !defined(HAS_MEMCMP) || !defined(HAS_SANE_MEMCMP)
PERL_CALLCONV I32	Perl_my_memcmp(const char* s1, const char* s2, I32 len)
			__attribute__pure__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

#endif
#if !defined(HAS_MEMSET)
PERL_CALLCONV void*	Perl_my_memset(char* loc, I32 ch, I32 len)
			__attribute__nonnull__(1);

#endif
PERL_CALLCONV I32	Perl_my_pclose(pTHX_ PerlIO* ptr);
PERL_CALLCONV PerlIO*	Perl_my_popen(pTHX_ const char* cmd, const char* mode)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV PerlIO*	Perl_my_popen_list(pTHX_ char* mode, int n, SV ** args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_my_setenv(pTHX_ const char* nam, const char* val);
PERL_CALLCONV I32	Perl_my_stat(pTHX);
PERL_CALLCONV char *	Perl_my_strftime(pTHX_ const char *fmt, int sec, int min, int hour, int mday, int mon, int year, int wday, int yday, int isdst)
			__attribute__nonnull__(pTHX_1);

#if defined(MYSWAP)
PERL_CALLCONV short	Perl_my_swap(pTHX_ short s)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV long	Perl_my_htonl(pTHX_ long l)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

PERL_CALLCONV long	Perl_my_ntohl(pTHX_ long l)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__pure__;

#endif
PERL_CALLCONV void	Perl_my_unexec(pTHX);
PERL_CALLCONV OP*	Perl_newANONLIST(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newANONHASH(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newANONSUB(pTHX_ I32 floor, OP* proto, OP* block);
PERL_CALLCONV OP*	Perl_newASSIGNOP(pTHX_ I32 flags, OP* left, I32 optype, OP* right)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newCONDOP(pTHX_ I32 flags, OP* first, OP* trueop, OP* falseop)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV CV*	Perl_newCONSTSUB(pTHX_ HV* stash, const char* name, SV* sv);
#ifdef PERL_MAD
PERL_CALLCONV OP*	Perl_newFORM(pTHX_ I32 floor, OP* o, OP* block);
#else
PERL_CALLCONV void	Perl_newFORM(pTHX_ I32 floor, OP* o, OP* block);
#endif
PERL_CALLCONV OP*	Perl_newFOROP(pTHX_ I32 flags, char* label, line_t forline, OP* sv, OP* expr, OP* block, OP* cont)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_5);

PERL_CALLCONV OP*	Perl_newGIVENOP(pTHX_ OP* cond, OP* block, PADOFFSET defsv_off)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_newLOGOP(pTHX_ I32 optype, I32 flags, OP* left, OP* right)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV OP*	Perl_newLOOPEX(pTHX_ I32 type, OP* label)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_newLOOPOP(pTHX_ I32 flags, I32 debuggable, OP* expr, OP* block)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newNULLLIST(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newOP(pTHX_ I32 optype, I32 flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_newPROG(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_newRANGE(pTHX_ I32 flags, OP* left, OP* right)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV OP*	Perl_newSLICEOP(pTHX_ I32 flags, OP* subscript, OP* listop)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newSTATEOP(pTHX_ I32 flags, char* label, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV CV*	Perl_newSUB(pTHX_ I32 floor, OP* o, OP* proto, OP* block);
PERL_CALLCONV CV *	Perl_newXS_flags(pTHX_ const char *name, XSUBADDR_t subaddr, const char *const filename, const char *const proto, U32 flags)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV CV*	Perl_newXS(pTHX_ const char* name, XSUBADDR_t f, const char* filename)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV AV*	Perl_newAV(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newAVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_newBINOP(pTHX_ I32 type, I32 flags, OP* first, OP* last)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newCVREF(pTHX_ I32 flags, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newGVOP(pTHX_ I32 type, I32 flags, GV* gv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV GV*	Perl_newGVgen(pTHX_ const char* pack)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_newGVREF(pTHX_ I32 type, OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newHVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HV*	Perl_newHV(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV HV*	Perl_newHVhv(pTHX_ HV* hv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV IO*	Perl_newIO(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newLISTOP(pTHX_ I32 type, I32 flags, OP* first, OP* last)
			__attribute__malloc__
			__attribute__warn_unused_result__;

#ifdef USE_ITHREADS
PERL_CALLCONV OP*	Perl_newPADOP(pTHX_ I32 type, I32 flags, SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);

#endif
PERL_CALLCONV OP*	Perl_newPMOP(pTHX_ I32 type, I32 flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newPVOP(pTHX_ I32 type, I32 flags, char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newRV(pTHX_ SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_newRV_noinc(pTHX_ SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_newSV(pTHX_ STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newSVREF(pTHX_ OP* o)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_newSVOP(pTHX_ I32 type, I32 flags, SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV SV*	Perl_newSViv(pTHX_ IV i)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVuv(pTHX_ UV u)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVnv(pTHX_ NV n)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpv(pTHX_ const char* s, STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvn(pTHX_ const char* s, STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVhek(pTHX_ const HEK *hek)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvn_share(pTHX_ const char* s, I32 len, U32 hash)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSVpvf(pTHX_ const char* pat, ...)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_vnewSVpvf(pTHX_ const char* pat, va_list* args)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_newSVrv(pTHX_ SV* rv, const char* classname)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_newSVsv(pTHX_ SV* old)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_newSV_type(pTHX_ svtype type)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newUNOP(pTHX_ I32 type, I32 flags, OP* first)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV OP*	Perl_newWHENOP(pTHX_ OP* cond, OP* block)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_newWHILEOP(pTHX_ I32 flags, I32 debuggable, LOOP* loop, I32 whileline, OP* expr, OP* block, OP* cont, I32 has_my)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV PERL_SI*	Perl_new_stackinfo(pTHX_ I32 stitems, I32 cxitems)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_scan_vstring(pTHX_ const char *vstr, const char *end, SV *sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV const char*	Perl_scan_version(pTHX_ const char *vstr, SV *sv, bool qv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_new_version(pTHX_ SV *ver)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_upg_version(pTHX_ SV *ver, bool qv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_vverify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_vnumify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_vnormal(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_vstringify(pTHX_ SV *vs)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_vcmp(pTHX_ SV *lvs, SV *rvs)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV PerlIO*	Perl_nextargv(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_ninstr(pTHX_ const char* big, const char* bigend, const char* little, const char* lend)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV OP*	Perl_oopsCV(pTHX_ OP* o)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_op_free(pTHX_ OP* arg);
#ifdef PERL_MAD
PERL_CALLCONV OP*	Perl_package(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

#else
PERL_CALLCONV void	Perl_package(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV PADOFFSET	Perl_pad_alloc(pTHX_ I32 optype, U32 tmptype);
PERL_CALLCONV PADOFFSET	Perl_allocmy(pTHX_ const char *const name)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV PADOFFSET	Perl_pad_findmy(pTHX_ const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV PADOFFSET	Perl_find_rundefsvoffset(pTHX);
PERL_CALLCONV OP*	Perl_oopsAV(pTHX_ OP* o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_oopsHV(pTHX_ OP* o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_pad_leavemy(pTHX);
PERL_CALLCONV SV*	Perl_pad_sv(pTHX_ PADOFFSET po);
PERL_CALLCONV void	Perl_pad_free(pTHX_ PADOFFSET po);
PERL_CALLCONV void	Perl_pad_reset(pTHX);
PERL_CALLCONV void	Perl_pad_swipe(pTHX_ PADOFFSET po, bool refadjust);
PERL_CALLCONV void	Perl_peep(pTHX_ OP* o);
PERL_CALLCONV PerlIO*	Perl_start_glob(pTHX_ SV* pattern, IO *io)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#if defined(USE_REENTRANT_API)
PERL_CALLCONV void	Perl_reentrant_size(pTHX);
PERL_CALLCONV void	Perl_reentrant_init(pTHX);
PERL_CALLCONV void	Perl_reentrant_free(pTHX);
PERL_CALLCONV void*	Perl_reentrant_retry(const char*, ...)
			__attribute__nonnull__(1);

#endif
PERL_CALLCONV void	Perl_call_atexit(pTHX_ ATEXIT_t fn, void *ptr);
PERL_CALLCONV I32	Perl_call_argv(pTHX_ const char* sub_name, I32 flags, char** argv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV I32	Perl_call_method(pTHX_ const char* methname, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_call_pv(pTHX_ const char* sub_name, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_call_sv(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_despatch_signals(pTHX);
PERL_CALLCONV OP *	Perl_doref(pTHX_ OP *o, I32 type, bool set_op_ref)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_eval_pv(pTHX_ const char* p, I32 croak_on_error)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_eval_sv(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_get_sv(pTHX_ const char* name, I32 create)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV AV*	Perl_get_av(pTHX_ const char* name, I32 create)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HV*	Perl_get_hv(pTHX_ const char* name, I32 create)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV CV*	Perl_get_cv(pTHX_ const char* name, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV CV*	Perl_get_cvn_flags(pTHX_ const char* name, STRLEN len, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_init_i18nl10n(pTHX_ int printwarn);
PERL_CALLCONV void	Perl_new_collate(pTHX_ const char* newcoll);
PERL_CALLCONV void	Perl_new_ctype(pTHX_ const char* newctype)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_new_numeric(pTHX_ const char* newcoll);
PERL_CALLCONV void	Perl_set_numeric_local(pTHX);
PERL_CALLCONV void	Perl_set_numeric_radix(pTHX);
PERL_CALLCONV void	Perl_set_numeric_standard(pTHX);
PERL_CALLCONV void	Perl_require_pv(pTHX_ const char* pv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_pack_cat(pTHX_ SV *cat, const char *pat, const char *patend, SV **beglist, SV **endlist, SV ***next_in_list, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5)
			__attribute__nonnull__(pTHX_6);

PERL_CALLCONV void	Perl_packlist(pTHX_ SV *cat, const char *pat, const char *patend, SV **beglist, SV **endlist)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

#ifdef PERL_USES_PL_PIDSTATUS
PERL_CALLCONV void	Perl_pidgone(pTHX_ Pid_t pid, int status);
#endif
PERL_CALLCONV void	Perl_pmflag(pTHX_ U32* pmfl, int ch)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_pmruntime(pTHX_ OP* pm, OP* expr, bool isreg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_pmtrans(pTHX_ OP* o, OP* expr, OP* repl)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_pop_scope(pTHX);
PERL_CALLCONV OP*	Perl_prepend_elem(pTHX_ I32 optype, OP* head, OP* tail);
PERL_CALLCONV void	Perl_push_scope(pTHX);
/* PERL_CALLCONV OP*	Perl_ref(pTHX_ OP* o, I32 type); */
PERL_CALLCONV OP*	Perl_refkids(pTHX_ OP* o, I32 type);
PERL_CALLCONV void	Perl_regdump(pTHX_ const regexp* r)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_pregexec(pTHX_ REGEXP * const prog, char* stringarg, char* strend, char* strbeg, I32 minend, SV* screamer, U32 nosave)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_6);

PERL_CALLCONV void	Perl_pregfree(pTHX_ struct regexp* r);
PERL_CALLCONV struct regexp*	Perl_reg_temp_copy(pTHX_ struct regexp* r)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_regfree_internal(pTHX_ REGEXP * const r);
PERL_CALLCONV char *	Perl_reg_stringify(pTHX_ MAGIC *mg, STRLEN *lp, U32 *flags, I32 *haseval)
			__attribute__nonnull__(pTHX_1);

#if defined(USE_ITHREADS)
PERL_CALLCONV void*	Perl_regdupe_internal(pTHX_ REGEXP * const r, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV REGEXP*	Perl_pregcomp(pTHX_ const SV * const pattern, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV REGEXP*	Perl_re_compile(pTHX_ const SV * const pattern, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_re_intuit_start(pTHX_ REGEXP * const rx, SV* sv, char* strpos, char* strend, const U32 flags, re_scream_pos_data *data)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV SV*	Perl_re_intuit_string(pTHX_ REGEXP * const rx)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_regexec_flags(pTHX_ REGEXP * const rx, char* stringarg, char* strend, char* strbeg, I32 minend, SV* screamer, void* data, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_6);

PERL_CALLCONV regnode*	Perl_regnext(pTHX_ regnode* p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV SV*	Perl_reg_named_buff(pTHX_ REGEXP * const rx, SV * const key, SV * const value, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_reg_named_buff_iter(pTHX_ REGEXP * const rx, const SV * const lastkey, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_reg_named_buff_fetch(pTHX_ REGEXP * const rx, SV * const namesv, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_reg_named_buff_exists(pTHX_ REGEXP * const rx, SV * const key, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_reg_named_buff_firstkey(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_reg_named_buff_nextkey(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_reg_named_buff_scalar(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_reg_named_buff_all(pTHX_ REGEXP * const rx, const U32 flags)
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV void	Perl_reg_numbered_buff_fetch(pTHX_ REGEXP * const rx, const I32 paren, SV * const sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_reg_numbered_buff_store(pTHX_ REGEXP * const rx, const I32 paren, SV const * const value)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_reg_numbered_buff_length(pTHX_ REGEXP * const rx, const SV * const sv, const I32 paren)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);


PERL_CALLCONV SV*	Perl_reg_qr_package(pTHX_ REGEXP * const rx)
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV void	Perl_regprop(pTHX_ const regexp *prog, SV* sv, const regnode* o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_repeatcpy(pTHX_ char* to, const char* from, I32 len, I32 count)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_rninstr(pTHX_ const char* big, const char* bigend, const char* little, const char* lend)
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV Sighandler_t	Perl_rsignal(pTHX_ int i, Sighandler_t t);
PERL_CALLCONV int	Perl_rsignal_restore(pTHX_ int i, Sigsave_t* t);
PERL_CALLCONV int	Perl_rsignal_save(pTHX_ int i, Sighandler_t t1, Sigsave_t* t2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV Sighandler_t	Perl_rsignal_state(pTHX_ int i);
PERL_CALLCONV void	Perl_rxres_free(pTHX_ void** rsp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_rxres_restore(pTHX_ void** rsp, REGEXP* prx)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_rxres_save(pTHX_ void** rsp, REGEXP* prx)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#if !defined(HAS_RENAME)
PERL_CALLCONV I32	Perl_same_dirent(pTHX_ const char* a, const char* b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV char*	Perl_savepv(pTHX_ const char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savepvn(pTHX_ const char* pv, I32 len)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savesharedpv(pTHX_ const char* pv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_savesharedpvn(pTHX_ const char *const pv, const STRLEN len)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_savesvpv(pTHX_ SV* sv)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_savestack_grow(pTHX);
PERL_CALLCONV void	Perl_savestack_grow_cnt(pTHX_ I32 need);
PERL_CALLCONV void	Perl_save_aelem(pTHX_ AV* av, I32 idx, SV **sptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV I32	Perl_save_alloc(pTHX_ I32 size, I32 pad);
PERL_CALLCONV void	Perl_save_aptr(pTHX_ AV** aptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV AV*	Perl_save_ary(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_bool(pTHX_ bool* boolp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_clearsv(pTHX_ SV** svp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_delete(pTHX_ HV* hv, char* key, I32 klen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_save_destructor(pTHX_ DESTRUCTORFUNC_NOCONTEXT_t f, void* p)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_save_destructor_x(pTHX_ DESTRUCTORFUNC_t f, void* p);
PERL_CALLCONV void	Perl_save_freesv(pTHX_ SV* sv);
PERL_CALLCONV void	Perl_save_freeop(pTHX_ OP* o);
PERL_CALLCONV void	Perl_save_freepv(pTHX_ char* pv);
PERL_CALLCONV void	Perl_save_generic_svref(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_generic_pvref(pTHX_ char** str)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_shared_pvref(pTHX_ char** str)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_gp(pTHX_ GV* gv, I32 empty)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HV*	Perl_save_hash(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_helem(pTHX_ HV* hv, SV *key, SV **sptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_save_hptr(pTHX_ HV** hptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_I16(pTHX_ I16* intp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_I32(pTHX_ I32* intp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_I8(pTHX_ I8* bytep)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_int(pTHX_ int* intp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_item(pTHX_ SV* item)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_iv(pTHX_ IV* iv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_list(pTHX_ SV** sarg, I32 maxsarg)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_long(pTHX_ long* longp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_mortalizesv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_nogv(pTHX_ GV* gv);
PERL_CALLCONV void	Perl_save_op(pTHX);
PERL_CALLCONV SV*	Perl_save_scalar(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_pptr(pTHX_ char** pptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_vptr(pTHX_ void* pptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_save_re_context(pTHX);
PERL_CALLCONV void	Perl_save_padsv(pTHX_ PADOFFSET off);
PERL_CALLCONV void	Perl_save_sptr(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_save_svref(pTHX_ SV** sptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_sawparens(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_scalar(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_scalarkids(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_scalarseq(pTHX_ OP* o);
PERL_CALLCONV OP*	Perl_scalarvoid(pTHX_ OP* o)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV NV	Perl_scan_bin(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV NV	Perl_scan_hex(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV char*	Perl_scan_num(pTHX_ const char* s, YYSTYPE *lvalp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV NV	Perl_scan_oct(pTHX_ const char* start, STRLEN len, STRLEN* retlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV const char*	Perl_parse_escape(pTHX_ const char *s, char *d, STRLEN *l, const char *send)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV OP*	Perl_scope(pTHX_ OP* o);
PERL_CALLCONV char*	Perl_screaminstr(pTHX_ SV *bigstr, SV *littlestr, I32 start_shift, I32 end_shift, I32 *oldposp, I32 last)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_5);

#if !defined(VMS)
PERL_CALLCONV I32	Perl_setenv_getix(pTHX_ const char* nam)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_setdefout(pTHX_ GV* gv);
PERL_CALLCONV HEK*	Perl_share_hek(pTHX_ const char* str, I32 len, U32 hash)
			__attribute__nonnull__(pTHX_1);

#if defined(HAS_SIGACTION) && defined(SA_SIGINFO)
PERL_CALLCONV Signal_t	Perl_sighandler(int sig, siginfo_t *info, void *uap);
PERL_CALLCONV Signal_t	Perl_csighandler(int sig, siginfo_t *info, void *uap);
#else
PERL_CALLCONV Signal_t	Perl_sighandler(int sig);
PERL_CALLCONV Signal_t	Perl_csighandler(int sig);
#endif
PERL_CALLCONV SV**	Perl_stack_grow(pTHX_ SV** sp, SV** p, int n)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_start_subparse(pTHX_ U32 flags);
PERL_CALLCONV void	Perl_sub_crush_depth(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_sv_2bool(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV CV*	Perl_sv_2cv(pTHX_ SV* sv, HV** st, GV** gvp, I32 lref)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV IO*	Perl_sv_2io(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

#ifdef PERL_IN_SV_C
STATIC bool	S_glob_2number(pTHX_ GV* const gv)
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_glob_2pv(pTHX_ GV* const gv, STRLEN * const len)
			__attribute__nonnull__(pTHX_1);

#endif
/* PERL_CALLCONV IV	Perl_sv_2iv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV IV	Perl_sv_2iv_flags(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_2mortal(pTHX_ SV* sv);
PERL_CALLCONV NV	Perl_sv_2nv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_2num(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV char*	Perl_sv_2pv(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV char*	Perl_sv_2pv_flags(pTHX_ SV* sv, STRLEN* lp, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_2pvutf8(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_2pvbyte(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_pvn_nomg(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV UV	Perl_sv_2uv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV UV	Perl_sv_2uv_flags(pTHX_ SV* sv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV IV	Perl_sv_iv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV UV	Perl_sv_uv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV NV	Perl_sv_nv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_pvn(pTHX_ SV *sv, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_pvutf8n(pTHX_ SV *sv, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_pvbyten(pTHX_ SV *sv, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_sv_true(pTHX_ SV *sv);
PERL_CALLCONV void	Perl_sv_add_arena(pTHX_ char* ptr, U32 size, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_sv_backoff(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_bless(pTHX_ SV* sv, HV* stash)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_catpvf(pTHX_ SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_vcatpvf(pTHX_ SV* sv, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_catpv(pTHX_ SV* sv, const char* ptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

/* PERL_CALLCONV void	Perl_sv_catpvn(pTHX_ SV* sv, const char* ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV void	Perl_sv_catsv(pTHX_ SV* dsv, SV* ssv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_chop(pTHX_ SV* sv, const char* ptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_sv_clean_all(pTHX);
PERL_CALLCONV void	Perl_sv_clean_objs(pTHX);
PERL_CALLCONV void	Perl_sv_clear(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_sv_cmp(pTHX_ SV* sv1, SV* sv2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_sv_cmp_locale(pTHX_ SV* sv1, SV* sv2)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#if defined(USE_LOCALE_COLLATE)
PERL_CALLCONV char*	Perl_sv_collxfrm(pTHX_ SV* sv, STRLEN* nxp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV OP*	Perl_sv_compile_2op(pTHX_ SV* sv, OP** startp, const char* code, PAD** padp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV int	Perl_getcwd_sv(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_dec(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_dump(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_sv_derived_from(pTHX_ SV* sv, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_sv_does(pTHX_ SV* sv, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV I32	Perl_sv_eq(pTHX_ SV* sv1, SV* sv2);
PERL_CALLCONV void	Perl_sv_free(pTHX_ SV* sv);
PERL_CALLCONV void	Perl_sv_free2(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_free_arenas(pTHX);
PERL_CALLCONV char*	Perl_sv_gets(pTHX_ SV* sv, PerlIO* fp, I32 append)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_grow(pTHX_ SV* sv, STRLEN newlen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_inc(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_insert(pTHX_ SV* bigsv, STRLEN offset, STRLEN len, const char* little, STRLEN littlelen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV int	Perl_sv_isa(pTHX_ SV* sv, const char* name)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_sv_isobject(pTHX_ SV* sv);
PERL_CALLCONV STRLEN	Perl_sv_len(pTHX_ SV* sv);
PERL_CALLCONV STRLEN	Perl_sv_len_utf8(pTHX_ SV* sv);
PERL_CALLCONV void	Perl_sv_magic(pTHX_ SV* sv, SV* obj, int how, const char* name, I32 namlen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV MAGIC *	Perl_sv_magicext(pTHX_ SV* sv, SV* obj, int how, const MGVTBL *vtbl, const char* name, I32 namlen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_mortalcopy(pTHX_ SV* oldsv)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_sv_newmortal(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV SV*	Perl_sv_newref(pTHX_ SV* sv);
PERL_CALLCONV char*	Perl_sv_peek(pTHX_ SV* sv);
PERL_CALLCONV void	Perl_sv_pos_u2b(pTHX_ SV* sv, I32* offsetp, I32* lenp)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_pos_b2u(pTHX_ SV* sv, I32* offsetp)
			__attribute__nonnull__(pTHX_2);

/* PERL_CALLCONV char*	Perl_sv_pvn_force(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV char*	Perl_sv_pvutf8n_force(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_pvbyten_force(pTHX_ SV* sv, STRLEN* lp)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_recode_to_utf8(pTHX_ SV* sv, SV *encoding)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV bool	Perl_sv_cat_decode(pTHX_ SV* dsv, SV *encoding, SV *ssv, int *offset, char* tstr, int tlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

PERL_CALLCONV const char*	Perl_sv_reftype(pTHX_ const SV* sv, int ob)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_replace(pTHX_ SV* sv, SV* nsv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_report_used(pTHX);
PERL_CALLCONV void	Perl_sv_setpvf(pTHX_ SV* sv, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_vsetpvf(pTHX_ SV* sv, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_setiv(pTHX_ SV* sv, IV num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setpviv(pTHX_ SV* sv, IV num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setuv(pTHX_ SV* sv, UV num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setnv(pTHX_ SV* sv, NV num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_setref_iv(pTHX_ SV* rv, const char* classname, IV iv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_setref_uv(pTHX_ SV* rv, const char* classname, UV uv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_setref_nv(pTHX_ SV* rv, const char* classname, NV nv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_setref_pv(pTHX_ SV* rv, const char* classname, void* pv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV SV*	Perl_sv_setref_pvn(pTHX_ SV* rv, const char* classname, const char* pv, STRLEN n)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_sv_setpv(pTHX_ SV* sv, const char* ptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setpvn(pTHX_ SV* sv, const char* ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_sv_setsv(pTHX_ SV* dsv, SV* ssv)
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV void	Perl_sv_taint(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV bool	Perl_sv_tainted(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_sv_unmagic(pTHX_ SV* sv, int type)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_sv_unref(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_unref_flags(pTHX_ SV* sv, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_untaint(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_upgrade(pTHX_ SV* sv, svtype new_type)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_sv_usepvn(pTHX_ SV* sv, char* ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_usepvn_flags(pTHX_ SV* sv, char* ptr, STRLEN len, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_vcatpvfn(pTHX_ SV* sv, const char* pat, STRLEN patlen, va_list* args, SV** svargs, I32 svmax, bool *maybe_tainted)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_vsetpvfn(pTHX_ SV* sv, const char* pat, STRLEN patlen, va_list* args, SV** svargs, I32 svmax, bool *maybe_tainted)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_swash_init(pTHX_ const char* pkg, const char* name, SV* listsv, I32 minbits, I32 none)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV UV	Perl_swash_fetch(pTHX_ SV *swash, const char *ptr, bool do_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_taint_env(pTHX);
PERL_CALLCONV void	Perl_taint_proper(pTHX_ const char* f, const char* s)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_to_utf8_case(pTHX_ const char *p, char* ustrp, STRLEN *lenp, SV **swashp, const char *normal, const char *special)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5)
			__attribute__nonnull__(pTHX_6);

PERL_CALLCONV UV	Perl_to_utf8_lower(pTHX_ const char *p, char* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_to_utf8_upper(pTHX_ const char *p, char* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_to_utf8_title(pTHX_ const char *p, char* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_to_utf8_fold(pTHX_ const char *p, char* ustrp, STRLEN *lenp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#if defined(UNLINK_ALL_VERSIONS)
PERL_CALLCONV I32	Perl_unlnk(pTHX_ const char* f)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV I32	Perl_unpack_str(pTHX_ const char *pat, const char *patend, const char *s, const char *strbeg, const char *strend, char **new_s, I32 ocnt, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_5);

PERL_CALLCONV I32	Perl_unpackstring(pTHX_ const char *pat, const char *patend, const char *s, const char *strend, U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV void	Perl_unsharepvn(pTHX_ const char* sv, I32 len, U32 hash);
PERL_CALLCONV void	Perl_unshare_hek(pTHX_ HEK* hek);
#ifdef PERL_MAD
PERL_CALLCONV OP *	Perl_utilize(pTHX_ int aver, I32 floor, OP* version, OP* idop, OP* arg)
			__attribute__nonnull__(pTHX_4);

#else
PERL_CALLCONV void	Perl_utilize(pTHX_ int aver, I32 floor, OP* version, OP* idop, OP* arg)
			__attribute__nonnull__(pTHX_4);

#endif
PERL_CALLCONV char*	Perl_utf16_to_utf8(pTHX_ const char* p, char *d, I32 bytelen, I32 *newlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV char*	Perl_utf16_to_utf8_reversed(pTHX_ char* p, char *d, I32 bytelen, I32 *newlen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV STRLEN	Perl_utf8_length(pTHX_ const char* s, const char *e)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV IV	Perl_utf8_distance(pTHX_ const char *a, const char *b)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_utf8_hop(pTHX_ const char *s, I32 off)
			__attribute__warn_unused_result__
			__attribute__pure__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_utf8_to_bytes(pTHX_ char *s, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_bytes_from_utf8(pTHX_ const char *s, STRLEN *len, bool *is_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_bytes_to_utf8(pTHX_ const char *s, STRLEN *len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV UV	Perl_utf8_to_uvchr(pTHX_ const char *s, STRLEN *retlen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV UV	Perl_utf8_to_uvuni(pTHX_ const char *s, STRLEN *retlen)
			__attribute__nonnull__(pTHX_1);


#ifdef EBCDIC
PERL_CALLCONV UV	Perl_utf8n_to_uvchr(pTHX_ const char *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1);

#else
/* PERL_CALLCONV UV	Perl_utf8n_to_uvchr(pTHX_ const char *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1); */

#endif

PERL_CALLCONV UV	Perl_utf8n_to_uvuni(pTHX_ const char *s, STRLEN curlen, STRLEN *retlen, U32 flags)
			__attribute__nonnull__(pTHX_1);


#ifdef EBCDIC
PERL_CALLCONV char*	Perl_uvchr_to_utf8(pTHX_ char *d, UV uv)
			__attribute__nonnull__(pTHX_1);

#else
/* PERL_CALLCONV char*	Perl_uvchr_to_utf8(pTHX_ char *d, UV uv)
			__attribute__nonnull__(pTHX_1); */

#endif

/* PERL_CALLCONV char*	Perl_uvuni_to_utf8(pTHX_ char *d, UV uv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV char*	Perl_uvchr_to_utf8_flags(pTHX_ char *d, UV uv, UV flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_uvuni_to_utf8_flags(pTHX_ char *d, UV uv, UV flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_pv_uni_display(pTHX_ SV *dsv, const char *spv, STRLEN len, STRLEN pvlim, UV flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_uni_display(pTHX_ SV *dsv, SV *ssv, STRLEN pvlim, UV flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_vivify_defelem(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_vivify_ref(pTHX_ SV* sv, U32 to_what)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_wait4pid(pTHX_ Pid_t pid, int* statusp, int flags)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV U32	Perl_parse_unicode_opts(pTHX_ const char **popt)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV U32	Perl_seed(pTHX);
PERL_CALLCONV UV	Perl_get_hash_seed(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_report_evil_fh(pTHX_ const GV *gv, const IO *io, I32 op);
PERL_CALLCONV void	Perl_report_uninit(pTHX_ SV* uninit_sv);
PERL_CALLCONV void	Perl_warn(pTHX_ const char* pat, ...)
			__attribute__format__(__printf__,pTHX_1,pTHX_2)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_vwarn(pTHX_ const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_warner(pTHX_ U32 err, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_vwarner(pTHX_ U32 err, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_watch(pTHX_ char** addr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_whichsig(pTHX_ const char* sig)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_write_to_stderr(pTHX_ const char* message, int msglen)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_yyerror(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_yylex(pTHX);
PERL_CALLCONV int	Perl_yyparse(pTHX);
PERL_CALLCONV void	Perl_parser_free(pTHX_ const yy_parser *)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_yywarn(pTHX_ const char* s)
			__attribute__nonnull__(pTHX_1);

#if defined(MYMALLOC)
PERL_CALLCONV void	Perl_dump_mstats(pTHX_ char* s)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_get_mstats(pTHX_ perl_mstats_t *buf, int buflen, int level)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV Malloc_t	Perl_safesysmalloc(MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_safesyscalloc(MEM_SIZE elements, MEM_SIZE size)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Malloc_t	Perl_safesysrealloc(Malloc_t where, MEM_SIZE nbytes)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV Free_t	Perl_safesysfree(Malloc_t where);
#if defined(PERL_GLOBAL_STRUCT)
PERL_CALLCONV struct perl_vars *	Perl_GetVars(pTHX);
PERL_CALLCONV struct perl_vars*	Perl_init_global_struct(pTHX);
PERL_CALLCONV void	Perl_free_global_struct(pTHX_ struct perl_vars *plvarsp)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV int	Perl_runops_standard(pTHX);
PERL_CALLCONV int	Perl_runops_debug(pTHX);
PERL_CALLCONV void	Perl_sv_catpvf_mg(pTHX_ SV *sv, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_vcatpvf_mg(pTHX_ SV* sv, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_catpv_mg(pTHX_ SV *sv, const char *ptr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

/* PERL_CALLCONV void	Perl_sv_catpvn_mg(pTHX_ SV *sv, const char *ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2); */

/* PERL_CALLCONV void	Perl_sv_catsv_mg(pTHX_ SV *dstr, SV *sstr)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_setpvf_mg(pTHX_ SV *sv, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_2,pTHX_3)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_vsetpvf_mg(pTHX_ SV* sv, const char* pat, va_list* args)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_setiv_mg(pTHX_ SV *sv, IV i)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setpviv_mg(pTHX_ SV *sv, IV iv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setuv_mg(pTHX_ SV *sv, UV u)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setnv_mg(pTHX_ SV *sv, NV num)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setpv_mg(pTHX_ SV *sv, const char *ptr)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_setpvn_mg(pTHX_ SV *sv, const char *ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_setsv_mg(pTHX_ SV *dstr, SV *sstr)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_sv_usepvn_mg(pTHX_ SV *sv, char *ptr, STRLEN len)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV MGVTBL*	Perl_get_vtbl(pTHX_ int vtbl_id)
			__attribute__warn_unused_result__;

PERL_CALLCONV char*	Perl_pv_display(pTHX_ SV *dsv, const char *pv, STRLEN cur, STRLEN len, STRLEN pvlim)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_pv_escape(pTHX_ SV *dsv, char const * const str, const STRLEN count, const STRLEN max, STRLEN * const escaped, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_pv_pretty(pTHX_ SV *dsv, char const * const str, const STRLEN count, const STRLEN max, char const * const start_color, char const * const end_color, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_dump_indent(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_dump_vindent(pTHX_ I32 level, PerlIO *file, const char* pat, va_list *args)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_do_gv_dump(pTHX_ I32 level, PerlIO *file, const char *name, GV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_do_gvgv_dump(pTHX_ I32 level, PerlIO *file, const char *name, GV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_do_hv_dump(pTHX_ I32 level, PerlIO *file, const char *name, HV *sv)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_do_magic_dump(pTHX_ I32 level, PerlIO *file, const MAGIC *mg, I32 nest, I32 maxnest, bool dumpops, STRLEN pvlim)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_do_op_dump(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_do_pmop_dump(pTHX_ I32 level, PerlIO *file, const PMOP *pm)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_do_sv_dump(pTHX_ I32 level, PerlIO *file, SV *sv, I32 nest, I32 maxnest, bool dumpops, STRLEN pvlim)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_magic_dump(pTHX_ const MAGIC *mg);
PERL_CALLCONV void	Perl_reginitcolors(pTHX);
/* PERL_CALLCONV char*	Perl_sv_2pv_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV char*	Perl_sv_2pvutf8_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV char*	Perl_sv_2pvbyte_nolen(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV char*	Perl_sv_pv(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV char*	Perl_sv_pvutf8(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

/* PERL_CALLCONV char*	Perl_sv_pvbyte(pTHX_ SV *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_utf8_encode(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_sv_utf8_decode(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

/* PERL_CALLCONV void	Perl_sv_force_normal(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1); */

PERL_CALLCONV void	Perl_sv_force_normal_flags(pTHX_ SV *sv, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_tmps_grow(pTHX_ I32 n);
PERL_CALLCONV SV*	Perl_sv_rvweaken(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_magic_killbackrefs(pTHX_ SV *sv, MAGIC *mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV OP*	Perl_newANONATTRSUB(pTHX_ I32 floor, OP *proto, OP *attrs, OP *block);
PERL_CALLCONV CV*	Perl_newATTRSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block);
#ifdef PERL_MAD
PERL_CALLCONV OP *	Perl_newMYSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block)
			__attribute__noreturn__;

#else
PERL_CALLCONV void	Perl_newMYSUB(pTHX_ I32 floor, OP *o, OP *proto, OP *attrs, OP *block)
			__attribute__noreturn__;

#endif
PERL_CALLCONV OP *	Perl_my_attrs(pTHX_ OP *o, OP *attrs)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_boot_core_xsutils(pTHX);
#if defined(USE_ITHREADS)
PERL_CALLCONV PERL_CONTEXT*	Perl_cx_dup(pTHX_ PERL_CONTEXT* cx, I32 ix, I32 max, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_4);

PERL_CALLCONV PERL_SI*	Perl_si_dup(pTHX_ PERL_SI* si, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV ANY*	Perl_ss_dup(pTHX_ PerlInterpreter* proto_perl, CLONE_PARAMS* param)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void*	Perl_any_dup(pTHX_ void* v, const PerlInterpreter* proto_perl)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV HE*	Perl_he_dup(pTHX_ const HE* e, bool shared, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV HEK*	Perl_hek_dup(pTHX_ HEK* e, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV REGEXP*	Perl_re_dup(pTHX_ const REGEXP* r, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV PerlIO*	Perl_fp_dup(pTHX_ PerlIO* fp, char type, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV DIR*	Perl_dirp_dup(pTHX_ DIR* dp)
			__attribute__warn_unused_result__;

PERL_CALLCONV GP*	Perl_gp_dup(pTHX_ GP* gp, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV MAGIC*	Perl_mg_dup(pTHX_ MAGIC* mg, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SV*	Perl_sv_dup(pTHX_ const SV* sstr, CLONE_PARAMS* param)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_rvpv_dup(pTHX_ SV* dstr, const SV *sstr, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV yy_parser*	Perl_parser_dup(pTHX_ const yy_parser *proto, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV PTR_TBL_t*	Perl_ptr_table_new(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void*	Perl_ptr_table_fetch(pTHX_ PTR_TBL_t *tbl, const void *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_ptr_table_store(pTHX_ PTR_TBL_t *tbl, const void *oldsv, void *newsv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_ptr_table_split(pTHX_ PTR_TBL_t *tbl)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_ptr_table_clear(pTHX_ PTR_TBL_t *tbl);
PERL_CALLCONV void	Perl_ptr_table_free(pTHX_ PTR_TBL_t *tbl);
#if defined(USE_ITHREADS)
#  if defined(HAVE_INTERP_INTERN)
PERL_CALLCONV void	Perl_sys_intern_dup(pTHX_ struct interp_intern* src, struct interp_intern* dst)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#  endif
#endif
#if defined(HAVE_INTERP_INTERN)
PERL_CALLCONV void	Perl_sys_intern_clear(pTHX);
PERL_CALLCONV void	Perl_sys_intern_init(pTHX);
#endif

PERL_CALLCONV const char *	Perl_custom_op_name(pTHX_ const OP* op)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV const char *	Perl_custom_op_desc(pTHX_ const OP* op)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV void	Perl_sv_nosharing(pTHX_ SV *sv);
/* PERL_CALLCONV void	Perl_sv_nolocking(pTHX_ SV *sv); */
#ifdef NO_MATHOMS
/* PERL_CALLCONV void	Perl_sv_nounlocking(pTHX_ SV *sv); */
#else
PERL_CALLCONV void	Perl_sv_nounlocking(pTHX_ SV *sv);
#endif
PERL_CALLCONV int	Perl_nothreadhook(pTHX);

END_EXTERN_C

#if defined(PERL_IN_DOOP_C) || defined(PERL_DECL_PROT)
STATIC I32	S_do_trans_simple(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_do_trans_count(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_do_trans_complex(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_do_trans_simple_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_do_trans_count_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_do_trans_complex_utf8(pTHX_ SV * const sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_GV_C) || defined(PERL_DECL_PROT)
STATIC void	S_gv_init_sv(pTHX_ GV *gv, I32 sv_type)
			__attribute__nonnull__(pTHX_1);

STATIC HV*	S_gv_get_super_pkg(pTHX_ const char* name, I32 namelen)
			__attribute__nonnull__(pTHX_1);

STATIC HV*	S_require_tie_mod(pTHX_ GV *gv, const char *varpv, SV* namesv, const char *methpv, const U32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

#endif

PERL_CALLCONV void*	Perl_get_arena(pTHX_ size_t svtype, U32 misc)
			__attribute__malloc__
			__attribute__warn_unused_result__;


#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
STATIC void	S_hsplit(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_hfreeentries(pTHX_ HV *hv)
			__attribute__nonnull__(pTHX_1);

STATIC HE*	S_new_he(pTHX)
			__attribute__malloc__
			__attribute__warn_unused_result__;

STATIC HEK*	S_save_hek_flags(const char *str, I32 len, U32 hash, int flags)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC void	S_hv_magic_check(HV *hv, bool *needs_copy, bool *needs_store)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);

STATIC void	S_unshare_hek_or_pvn(pTHX_ const HEK* hek, const char* str, I32 len, U32 hash);
STATIC HEK*	S_share_hek_flags(pTHX_ const char* sv, I32 len, U32 hash, int flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC void	S_hv_notallowed(pTHX_ int flags, const char *key, I32 klen, const char *msg)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);

STATIC struct xpvhv_aux*	S_hv_auxinit(HV *hv)
			__attribute__nonnull__(1);

STATIC SV*	S_hv_delete_common(pTHX_ HV* tb, SV* keysv, const char* key, STRLEN klen, int k_flags, I32 d_flags, U32 hash);
STATIC void	S_clear_placeholders(pTHX_ HV* hb, U32 items)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_MG_C) || defined(PERL_DECL_PROT)
STATIC void	S_save_magic(pTHX_ I32 mgs_ix, SV *sv)
			__attribute__nonnull__(pTHX_2);

STATIC int	S_magic_methpack(pTHX_ SV *sv, const MAGIC *mg, const char *meth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC int	S_magic_methcall(pTHX_ SV *sv, const MAGIC *mg, const char *meth, I32 f, int n, SV *val)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_restore_magic(pTHX_ const void *p)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_unwind_handler_stack(pTHX_ const void *p)
			__attribute__nonnull__(pTHX_1);


#endif

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV OP*	Perl_ck_anoncode(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_bitop(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_concat(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_defined(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_delete(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_die(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_eof(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_eval(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_exec(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_exists(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_exit(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_ftst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_fun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_glob(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_grep(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_index(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_join(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_lengthconst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_lfun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_listiob(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_match(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_method(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_null(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_open(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_readline(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_repeat(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_require(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_retarget(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_return(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_rfun(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_rvconst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_sassign(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_select(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_shift(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_sort(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_spair(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_split(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_subr(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_substr(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_svconst(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_trunc(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV OP*	Perl_ck_unpack(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC bool	S_is_handle_constructor(const OP *o, I32 numargs)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC I32	S_is_list_assignment(pTHX_ const OP *o)
			__attribute__warn_unused_result__;

STATIC void	S_cop_free(pTHX_ COP *cop)
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_modkids(pTHX_ OP *o, I32 type);
STATIC OP*	S_scalarboolean(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_newDEFSVOP(pTHX)
			__attribute__warn_unused_result__;

STATIC OP*	S_new_logop(pTHX_ I32 type, I32 flags, OP **firstp, OP **otherp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_simplify_sort(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC const char*	S_gv_ename(pTHX_ GV *gv)
			__attribute__nonnull__(pTHX_1);

STATIC bool	S_scalar_mod_type(const OP *o, I32 type)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC OP *	S_my_kid(pTHX_ OP *o, OP *attrs, OP **imopsp)
			__attribute__nonnull__(pTHX_3);

STATIC OP *	S_dup_attrlist(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_apply_attrs(pTHX_ HV *stash, SV *target, OP *attrs, bool for_my)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_apply_attrs_my(pTHX_ HV *stash, OP *target, OP *attrs, OP **imopsp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_bad_type(pTHX_ I32 n, const char *t, const char *name, const OP *kid)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_no_bareword_allowed(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_no_fh_allowed(pTHX_ OP *o)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_too_few_arguments(pTHX_ OP *o, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC OP*	S_too_many_arguments(pTHX_ OP *o, const char* name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC bool	S_looks_like_bool(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_newGIVWHENOP(pTHX_ OP* cond, OP *block, I32 enter_opcode, I32 leave_opcode, PADOFFSET entertarg)
			__attribute__nonnull__(pTHX_2);

STATIC OP*	S_ref_array_or_hash(pTHX_ OP* cond);
STATIC void	S_process_special_blocks(pTHX_ const char *const fullname, GV *const gv, CV *const cv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#endif
#if defined(PL_OP_SLAB_ALLOC)
PERL_CALLCONV void*	Perl_Slab_Alloc(pTHX_ size_t sz)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_Slab_Free(pTHX_ void *op)
			__attribute__nonnull__(pTHX_1);

#  if defined(PERL_DEBUG_READONLY_OPS)
PERL_CALLCONV void	Perl_pending_Slabs_to_ro(pTHX);
PERL_CALLCONV OP *	Perl_op_refcnt_inc(pTHX_ OP *o);
PERL_CALLCONV PADOFFSET	Perl_op_refcnt_dec(pTHX_ OP *o)
			__attribute__nonnull__(pTHX_1);

#    if defined(PERL_IN_OP_C)
STATIC void	S_Slab_to_rw(pTHX_ void *op)
			__attribute__nonnull__(pTHX_1);

#    endif
#  endif
#endif

#if defined(PERL_IN_PERL_C) || defined(PERL_DECL_PROT)
STATIC void	S_find_beginning(pTHX_ SV* linestr_sv, PerlIO *rsfp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_forbid_setid(pTHX_ const char flag, const int suidscript);
STATIC void	S_incpush(pTHX_ const char *dir, bool addsubdirs, bool addoldvers, bool usesep, bool canrelocate);
STATIC void	S_init_interp(pTHX);
STATIC void	S_init_ids(pTHX);
STATIC void	S_init_main_stash(pTHX);
STATIC void	S_init_perllib(pTHX);
STATIC void	S_init_postdump_symbols(pTHX_ int argc, char **argv, char **env)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_init_predump_symbols(pTHX);
STATIC void	S_my_exit_jump(pTHX)
			__attribute__noreturn__;

STATIC void	S_nuke_stacks(pTHX);
STATIC int	S_open_script(pTHX_ const char *scriptname, bool dosearch, int *suidscript, PerlIO **rsfpp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_usage(pTHX_ const char *name)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_validate_suid(pTHX_ const char *validarg, const char *scriptname, int fdscript, int suidscript, SV* linestr_sv, PerlIO *rsfp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_5)
			__attribute__nonnull__(pTHX_6);


#  if defined(IAMSUID)
STATIC int	S_fd_on_nosuid_fs(pTHX_ int fd);
#  endif
STATIC void*	S_parse_body(pTHX_ char **env, XSINIT_t xsinit);
STATIC void	S_run_body(pTHX_ I32 oldscope)
			__attribute__noreturn__;

STATIC SV *	S_incpush_if_exists(pTHX_ SV *dir)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_PP_C) || defined(PERL_DECL_PROT)
STATIC SV*	S_refto(pTHX_ SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif
#if defined(PERL_IN_PP_C) || defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV GV*	Perl_softref2xv(pTHX_ SV *const sv, const char *const what)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif

#if defined(PERL_IN_PP_PACK_C) || defined(PERL_DECL_PROT)
STATIC I32	S_unpack_rec(pTHX_ struct tempsym* symptr, const char *s, const char *strbeg, const char *strend, const char **new_s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC SV **	S_pack_rec(pTHX_ SV *cat, struct tempsym* symptr, SV **beglist, SV **endlist)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC SV*	S_mul128(pTHX_ SV *sv, U8 m)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_measure_struct(pTHX_ struct tempsym* symptr)
			__attribute__nonnull__(pTHX_1);

STATIC bool	S_next_symbol(pTHX_ struct tempsym* symptr)
			__attribute__nonnull__(pTHX_1);

STATIC SV*	S_is_an_int(pTHX_ const char *s, STRLEN l)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC int	S_div128(pTHX_ SV *pnum, bool *done)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC const char *	S_group_end(pTHX_ const char *pat, const char *patend, char ender)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC const char *	S_get_num(pTHX_ const char *ppat, I32 *lenptr)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC char *	S_sv_exp_grow(pTHX_ SV *sv, STRLEN needed)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_PP_CTL_C) || defined(PERL_DECL_PROT)
STATIC OP*	S_docatch(pTHX_ OP *o)
			__attribute__warn_unused_result__;

STATIC OP*	S_dofindlabel(pTHX_ OP *o, const char *label, OP **opstack, OP **oplimit)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC I32	S_dopoptoeval(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptogiven(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptolabel(pTHX_ const char *label)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_dopoptoloop(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC I32	S_dopoptosub_at(pTHX_ const PERL_CONTEXT* cxstk, I32 startingblock)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_dopoptowhen(pTHX_ I32 startingblock)
			__attribute__warn_unused_result__;

STATIC void	S_save_lines(pTHX_ AV *array, SV *sv)
			__attribute__nonnull__(pTHX_2);

STATIC bool	S_doeval(pTHX_ int gimme, OP** startop, CV* outside, U32 seq);
STATIC PerlIO *	S_check_type_and_open(pTHX_ const char *name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#ifndef PERL_DISABLE_PMC
STATIC PerlIO *	S_doopen_pm(pTHX_ const char *name, const STRLEN namelen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif
STATIC bool	S_path_is_absolute(const char *name)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC I32	S_run_user_filter(pTHX_ int idx, SV *buf_sv, int maxlen)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

STATIC PMOP*	S_make_matcher(pTHX_ regexp* re)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC bool	S_matcher_matches_sv(pTHX_ PMOP* matcher, SV* sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_destroy_matcher(pTHX_ PMOP* matcher)
			__attribute__nonnull__(pTHX_1);

STATIC OP*	S_do_smartmatch(pTHX_ HV* seen_this, HV* seen_other);
#endif

#if defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
STATIC void	S_do_oddball(pTHX_ HV *hash, SV **relem, SV **firstrelem)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC SV*	S_method_common(pTHX_ SV* meth, U32* hashp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_PP_SORT_C) || defined(PERL_DECL_PROT)
STATIC I32	S_sv_ncmp(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_sv_i_ncmp(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_amagic_ncmp(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_amagic_i_ncmp(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_amagic_cmp(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_sortcv(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_sortcv_xsub(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_sortcv_stacked(pTHX_ SV *a, SV *b)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_qsortsvu(pTHX_ SV** array, size_t num_elts, SVCOMPARE_t compare)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

#endif

#if defined(PERL_IN_PP_SYS_C) || defined(PERL_DECL_PROT)
#  if !defined(HAS_MKDIR) || !defined(HAS_RMDIR)
STATIC int	S_dooneliner(pTHX_ const char *cmd, const char *filename)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#  endif
STATIC SV *	S_space_join_names_mortal(pTHX_ char *const *array)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_REGCOMP_C) || defined(PERL_DECL_PROT)
STATIC regnode*	S_reg(pTHX_ struct RExC_state_t *state, I32 paren, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

STATIC regnode*	S_reganode(pTHX_ struct RExC_state_t *state, U8 op, U32 arg)
			__attribute__nonnull__(pTHX_1);

STATIC regnode*	S_regatom(pTHX_ struct RExC_state_t *state, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC regnode*	S_regbranch(pTHX_ struct RExC_state_t *state, I32 *flagp, I32 first, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC STRLEN	S_reguni(pTHX_ const struct RExC_state_t *state, UV uv, char *s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

STATIC regnode*	S_regclass(pTHX_ struct RExC_state_t *state, U32 depth)
			__attribute__nonnull__(pTHX_1);

STATIC regnode*	S_regclassfold(pTHX_ struct RExC_state_t *state, U32 depth)
			__attribute__nonnull__(pTHX_1);

STATIC regnode*	S_regclassfold_value(pTHX_ struct RExC_state_t *state, UV value)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_anyof_get_swash(pTHX_ struct RExC_state_t *state, regnode *ret, SV *listsv, AV* unicode_alternate)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC I32	S_regcurly(const char *)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC regnode*	S_reg_node(pTHX_ struct RExC_state_t *state, U8 op)
			__attribute__nonnull__(pTHX_1);

STATIC regnode*	S_regpiece(pTHX_ struct RExC_state_t *state, I32 *flagp, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC regnode*	S_reg_namedseq(pTHX_ struct RExC_state_t *state, UV *valuep)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_reginsert(pTHX_ struct RExC_state_t *state, U8 op, regnode *opnd, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_regtail(pTHX_ struct RExC_state_t *state, regnode *p, const regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC SV *	S_reg_scan_name(pTHX_ struct RExC_state_t *state, U32 flags)
			__attribute__nonnull__(pTHX_1);

STATIC U32	S_join_exact(pTHX_ struct RExC_state_t *state, regnode *scan, I32 *min, U32 flags, regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC char *	S_regwhite(struct RExC_state_t *state, char *p)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC char *	S_nextchar(pTHX_ struct RExC_state_t *state)
			__attribute__nonnull__(pTHX_1);

STATIC bool	S_reg_skipcomment(pTHX_ struct RExC_state_t *state)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_scan_commit(pTHX_ const struct RExC_state_t* state, struct scan_data_t *data, I32 *minlenp, int is_inf)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_cl_anything(const struct RExC_state_t* state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC int	S_cl_is_anything(const struct regnode_charclass_class *cl)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC void	S_cl_init(const struct RExC_state_t* state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC void	S_cl_init_zero(const struct RExC_state_t* state, struct regnode_charclass_class *cl)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC void	S_cl_and(struct regnode_charclass_class *cl, const struct regnode_charclass_class *and_with)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC void	S_cl_or(const struct RExC_state_t* state, struct regnode_charclass_class *cl, const struct regnode_charclass_class *or_with)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);

STATIC I32	S_study_chunk(pTHX_ struct RExC_state_t* state, regnode **scanp, I32 *minlenp, I32 *deltap, regnode *last, struct scan_data_t *data, I32 stopparen, char* recursed, struct regnode_charclass_class *and_withp, U32 flags, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

STATIC U32	S_add_data(struct RExC_state_t* state, U32 n, const char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

STATIC void	S_re_croak2(pTHX_ const char* pat1, const char* pat2, ...)
			__attribute__noreturn__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_regpposixcc(pTHX_ struct RExC_state_t* state, I32 value)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_checkposixcc(pTHX_ struct RExC_state_t* state)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_make_trie(pTHX_ struct RExC_state_t* state, regnode *startbranch, regnode *first, regnode *last, regnode *tail, U32 word_count, U32 flags, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

STATIC void	S_make_trie_failtable(pTHX_ struct RExC_state_t* state, regnode *source, regnode *node, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#  ifdef DEBUGGING
STATIC void	S_regdump_extflags(pTHX_ const char *lead, const U32 flags);
STATIC const regnode*	S_dumpuntil(pTHX_ const regexp *r, const regnode *start, const regnode *node, const regnode *last, const regnode *plast, SV* sv, I32 indent, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_6);

STATIC void	S_put_byte(pTHX_ SV* sv, int c)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_dump_trie(pTHX_ const struct _reg_trie_data *trie, AV *revcharmap, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_dump_trie_interim_list(pTHX_ const struct _reg_trie_data *trie, AV *revcharmap, U32 next_alloc, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_dump_trie_interim_table(pTHX_ const struct _reg_trie_data *trie, AV *revcharmap, U32 next_alloc, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC U8	S_regtail_study(pTHX_ struct RExC_state_t *state, regnode *p, const regnode *val, U32 depth)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#  endif
#endif

#if defined(PERL_IN_REGEXEC_C) || defined(PERL_DECL_PROT)
STATIC I32	S_regmatch(pTHX_ regmatch_info *reginfo, regnode *prog)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_regrepeat(pTHX_ const regexp *prog, const regnode *p, I32 max, int depth)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_regtry(pTHX_ regmatch_info *reginfo, char **startpos)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC bool	S_reginclass(pTHX_ const regexp *prog, const regnode *n, const char *p, STRLEN *lenp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC CHECKPOINT	S_regcppush(pTHX_ I32 parenfloor);
STATIC char*	S_regcppop(pTHX_ const regexp *rex)
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_reghop3(char *pos, I32 off, const char *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

STATIC char*	S_reghop3c(char *pos, I32 off, const char *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

STATIC char*	S_reghop3x(char *pos, I32 off, const char *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

STATIC char*	S_reghop4(char *pos, I32 off, const char *llim, const char *rlim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3)
			__attribute__nonnull__(4);

STATIC char*	S_reghopmaybe3(char *pos, I32 off, const char *lim)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

STATIC char*	S_find_byclass(pTHX_ regexp * prog, const regnode *c, char *s, const char *strend, regmatch_info *reginfo)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_swap_match_buff(pTHX_ regexp * prog)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_reg_check_named_buff_matched(pTHX_ const regexp *rex, const regnode *prog)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#  ifdef DEBUGGING
STATIC void	S_dump_exec_pos(pTHX_ const char *locinput, const regnode *scan, const char *loc_regeol, const char *loc_bostr, const char *loc_reg_starttry, const bool do_utf8)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

STATIC void	S_debug_start_match(pTHX_ const regexp *prog, const bool do_utf8, const char *start, const char *end, const char *blurb)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4)
			__attribute__nonnull__(pTHX_5);

#  endif
#endif

#if defined(PERL_IN_DUMP_C) || defined(PERL_DECL_PROT)
STATIC CV*	S_deb_curcv(pTHX_ const I32 ix);
STATIC void	S_debprof(pTHX_ const OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_sequence(pTHX_ const OP *o);
STATIC void	S_sequence_tail(pTHX_ const OP *o);
STATIC UV	S_sequence_num(pTHX_ const OP *o);
STATIC SV*	S_pm_description(pTHX_ const PMOP *pm)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_SCOPE_C) || defined(PERL_DECL_PROT)
STATIC SV*	S_save_scalar_at(pTHX_ SV **sptr)
			__attribute__nonnull__(pTHX_1);

#endif

#if defined(PERL_IN_GV_C) || defined(PERL_IN_SV_C) || defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV void	Perl_sv_add_backref(pTHX_ SV *tsv, SV *sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif

#if defined(PERL_IN_HV_C) || defined(PERL_IN_MG_C) || defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV int	Perl_sv_kill_backrefs(pTHX_ SV *sv, AV *av)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC char *	S_uiv_2buf(char *buf, IV iv, UV uv, int is_uv, char **peob)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(5);

STATIC void	S_sv_unglob(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_not_a_number(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_visit(pTHX_ SVFUNC_t f, U32 flags, U32 mask)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_sv_del_backref(pTHX_ SV *target, SV *ref)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC SV *	S_varname(pTHX_ GV *gv, const char gvtype, PADOFFSET targ, SV *keyname, I32 aindex, int subscript_type)
			__attribute__warn_unused_result__;

#  ifdef DEBUGGING
STATIC void	S_del_sv(pTHX_ SV *p)
			__attribute__nonnull__(pTHX_1);

#  endif
#  if !defined(NV_PRESERVES_UV)
STATIC int	S_sv_2iuv_non_preserve(pTHX_ SV *sv, I32 numtype)
			__attribute__nonnull__(pTHX_1);

#  endif
STATIC I32	S_expect_number(pTHX_ char** pattern)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#
STATIC STRLEN	S_sv_pos_u2b_forwards(const char *const start, const char *const send, STRLEN uoffset)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC STRLEN	S_sv_pos_u2b_midway(const char *const start, const char *send, STRLEN uoffset, STRLEN uend)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

STATIC STRLEN	S_sv_pos_u2b_cached(pTHX_ SV *sv, MAGIC **mgp, const char *const start, const char *const send, STRLEN uoffset, STRLEN uoffset0, STRLEN boffset0)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_4);

STATIC void	S_utf8_mg_pos_cache_update(pTHX_ SV *sv, MAGIC **mgp, STRLEN byte, STRLEN utf8, STRLEN blen)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC STRLEN	S_sv_pos_b2u_midway(pTHX_ const char *s, const char *const target, const char *end, STRLEN endu)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC char *	S_F0convert(NV nv, char *endbuf, STRLEN *len)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);

#  if defined(PERL_OLD_COPY_ON_WRITE)
STATIC void	S_sv_release_COW(pTHX_ SV *sv, const char *pvx, SV *after)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#  endif
STATIC SV *	S_more_sv(pTHX);
STATIC void *	S_more_bodies(pTHX_ svtype sv_type);
STATIC bool	S_sv_2iuv_common(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_glob_assign_glob(pTHX_ SV *dstr, SV *sstr, const int dtype)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_glob_assign_ref(pTHX_ SV *dstr, SV *sstr)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC PTR_TBL_ENT_t *	S_ptr_table_find(PTR_TBL_t *tbl, const void *sv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

#endif

#if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
STATIC void	S_check_uni(pTHX);
STATIC void	S_force_next(pTHX_ I32 type);
STATIC char*	S_force_version(pTHX_ char *start)
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_force_word(pTHX_ char *start, int token, int check_keyword, int allow_pack, int allow_tick)
			__attribute__nonnull__(pTHX_1);

STATIC SV*	S_tokeq(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_readpipe_override(pTHX);
STATIC char*	S_scan_const(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_scan_heredoc(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_scan_ident(pTHX_ char *s, const char *send, char *dest, STRLEN destlen, I32 ck_uni)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC char*	S_scan_pat(pTHX_ char *start, I32 type)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_scan_str(pTHX_ char *start, int keep_quoted, int keep_delims, yy_str_info *str_info)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_4);

STATIC char*	S_scan_subst(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_scan_trans(pTHX_ char *start)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_scan_word(pTHX_ char *s, char *dest, STRLEN destlen, int allow_package, STRLEN *slp)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_5);

STATIC void	S_update_debugger_info(pTHX_ SV *orig_sv, const char *buf, STRLEN len);
STATIC char*	S_skipspace(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_swallow_bom(pTHX_ char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

STATIC void	S_checkcomma(pTHX_ const char *s, const char *name, const char *what)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC bool	S_feature_is_enabled(pTHX_ const char* name, STRLEN namelen)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_force_ident(pTHX_ const char *s, int kind)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_incline(pTHX_ const char *s)
			__attribute__nonnull__(pTHX_1);

STATIC int	S_intuit_more(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_lop(pTHX_ I32 f, int x, char *s)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_missingterminator(pTHX_ char *s)
			__attribute__noreturn__;

STATIC void	S_no_op(pTHX_ const char *what, char *s)
			__attribute__nonnull__(pTHX_1);

STATIC I32	S_sublex_done(pTHX)
			__attribute__warn_unused_result__;

STATIC I32	S_sublex_push(pTHX)
			__attribute__warn_unused_result__;

STATIC I32	S_sublex_start(pTHX_ I32 op_type, OP *op)
			__attribute__warn_unused_result__;

STATIC char *	S_filter_gets(pTHX_ SV *sv, PerlIO *fp, STRLEN append)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

STATIC char *	S_tokenize_use(pTHX_ int is_use, char *s)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);

STATIC SV*	S_new_constant(pTHX_ const char *s, STRLEN len, const char *key, STRLEN keylen, SV *sv, SV *pv, const char *type, STRLEN typelen)
			__attribute__nonnull__(pTHX_3)
			__attribute__nonnull__(pTHX_5);

STATIC int	S_ao(pTHX_ int toketype);
#  if defined(PERL_CR_FILTER)
STATIC I32	S_cr_textfilter(pTHX_ int idx, SV *sv, int maxlen);
STATIC void	S_strip_return(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

#  endif
#  if defined(DEBUGGING)
STATIC int	S_tokereport(pTHX_ I32 rv, const YYSTYPE* lvalp)
			__attribute__nonnull__(pTHX_2);

STATIC void	S_printbuf(pTHX_ const char* fmt, const char* s)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#  endif
#endif

#if defined(PERL_IN_UNIVERSAL_C) || defined(PERL_DECL_PROT)
STATIC bool	S_isa_lookup(pTHX_ HV *stash, const char * const name, const HV * const name_stash)
			__attribute__nonnull__(pTHX_2);

#endif

#if defined(PERL_IN_LOCALE_C) || defined(PERL_DECL_PROT)
#if defined(USE_LOCALE_NUMERIC) || defined(USE_LOCALE_COLLATE)
STATIC char*	S_stdize_locale(pTHX_ char* locs)
			__attribute__nonnull__(pTHX_1);

#endif
#endif

#if defined(PERL_IN_UTIL_C) || defined(PERL_DECL_PROT)
STATIC const COP*	S_closest_cop(pTHX_ const COP *cop, const OP *o)
			__attribute__nonnull__(pTHX_1);

STATIC SV*	S_mess_alloc(pTHX);
STATIC const char *	S_vdie_croak_common(pTHX_ const char *pat, va_list *args, STRLEN *msglen, I32* utf8);
STATIC bool	S_vdie_common(pTHX_ const char *message, STRLEN msglen, I32 utf8, bool warn);
STATIC char *	S_write_no_mem(pTHX)
			__attribute__noreturn__;

#endif

#if defined(PERL_IN_NUMERIC_C) || defined(PERL_DECL_PROT)
STATIC NV	S_mulexp10(NV value, I32 exponent);
#endif

#if defined(PERL_IN_UTF8_C) || defined(PERL_DECL_PROT)
STATIC STRLEN	S_is_utf8_char_slow(const char *s, const STRLEN len)
			__attribute__warn_unused_result__
			__attribute__nonnull__(1);

STATIC bool	S_is_utf8_common(pTHX_ const char *const p, SV **swash, const char * const swashname)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC SV*	S_swash_get(pTHX_ SV* swash, UV start, UV span)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif

START_EXTERN_C

PERL_CALLCONV void	Perl_sv_setsv_flags(pTHX_ SV* dsv, SV* ssv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_catpvn_flags(pTHX_ SV* sv, const char* ptr, STRLEN len, I32 flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_sv_catsv_flags(pTHX_ SV* dsv, SV* ssv, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV char*	Perl_sv_pvn_force_flags(pTHX_ SV* sv, STRLEN* lp, I32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_sv_copypv(pTHX_ SV* dsv, SV* ssv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_my_atof2(pTHX_ const char *s, NV* value)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV int	Perl_my_socketpair(int family, int type, int protocol, int fd[2]);
PERL_CALLCONV int	Perl_my_dirfd(pTHX_ DIR* dir);
#ifdef PERL_OLD_COPY_ON_WRITE
PERL_CALLCONV SV*	Perl_sv_setsv_cow(pTHX_ SV* dsv, SV* ssv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif

PERL_CALLCONV const char *	Perl_PerlIO_context_layers(pTHX_ const char *mode);

#if defined(USE_PERLIO) && !defined(USE_SFIO)
PERL_CALLCONV int	Perl_PerlIO_close(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_fill(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_fileno(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_eof(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_error(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_flush(pTHX_ PerlIO *f);
PERL_CALLCONV void	Perl_PerlIO_clearerr(pTHX_ PerlIO *f);
PERL_CALLCONV void	Perl_PerlIO_set_cnt(pTHX_ PerlIO *f, int cnt);
PERL_CALLCONV void	Perl_PerlIO_set_ptrcnt(pTHX_ PerlIO *f, STDCHAR *ptr, int cnt)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_PerlIO_setlinebuf(pTHX_ PerlIO *f);
PERL_CALLCONV SSize_t	Perl_PerlIO_read(pTHX_ PerlIO *f, void *buf, Size_t count)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SSize_t	Perl_PerlIO_write(pTHX_ PerlIO *f, const void *buf, Size_t count)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV SSize_t	Perl_PerlIO_unread(pTHX_ PerlIO *f, const void *buf, Size_t count)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV Off_t	Perl_PerlIO_tell(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_seek(pTHX_ PerlIO *f, Off_t offset, int whence);

PERL_CALLCONV STDCHAR *	Perl_PerlIO_get_base(pTHX_ PerlIO *f);
PERL_CALLCONV STDCHAR *	Perl_PerlIO_get_ptr(pTHX_ PerlIO *f);
PERL_CALLCONV int	Perl_PerlIO_get_bufsiz(pTHX_ PerlIO *f)
			__attribute__warn_unused_result__;

PERL_CALLCONV int	Perl_PerlIO_get_cnt(pTHX_ PerlIO *f)
			__attribute__warn_unused_result__;


PERL_CALLCONV PerlIO *	Perl_PerlIO_stdin(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV PerlIO *	Perl_PerlIO_stdout(pTHX)
			__attribute__warn_unused_result__;

PERL_CALLCONV PerlIO *	Perl_PerlIO_stderr(pTHX)
			__attribute__warn_unused_result__;

#endif /* PERLIO_LAYERS */

PERL_CALLCONV void	Perl_deb_stack_all(pTHX);
#ifdef PERL_IN_DEB_C
STATIC void	S_deb_stack_n(pTHX_ SV** stack_base, I32 stack_min, I32 stack_max, I32 mark_min, I32 mark_max)
			__attribute__nonnull__(pTHX_1);

#endif

PERL_CALLCONV PADLIST*	Perl_pad_new(pTHX_ int flags)
			__attribute__malloc__
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_pad_undef(pTHX_ CV* cv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV PADOFFSET	Perl_pad_add_name(pTHX_ const char *name, HV* ourstash, bool clone, bool state)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV PADOFFSET	Perl_pad_add_anon(pTHX_ SV* sv, OPCODE op_type)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_pad_check_dup(pTHX_ const char* name, bool is_our, const HV* ourstash)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_3);

#ifdef DEBUGGING
PERL_CALLCONV void	Perl_pad_setsv(pTHX_ PADOFFSET po, SV* sv)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV void	Perl_pad_block_start(pTHX_ int full);
PERL_CALLCONV void	Perl_pad_tidy(pTHX_ padtidy_type type);
PERL_CALLCONV void	Perl_do_dump_pad(pTHX_ I32 level, PerlIO *file, PADLIST *padlist, int full)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_pad_fixup_inner_anons(pTHX_ PADLIST *padlist, CV *old_cv, CV *new_cv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);


PERL_CALLCONV void	Perl_pad_push(pTHX_ PADLIST *padlist, int depth)
			__attribute__nonnull__(pTHX_1);


#if defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
STATIC PADOFFSET	S_pad_findlex(pTHX_ const char *name, const CV* cv, U32 seq, int warn, SV** out_capture, SV** out_name_sv, int *out_flags)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_6)
			__attribute__nonnull__(pTHX_7);

#  if defined(DEBUGGING)
STATIC void	S_cv_dump(pTHX_ const CV *cv, const char *title)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#  endif
#endif
PERL_CALLCONV CV*	Perl_find_runcv(pTHX_ U32 *db_seqp)
			__attribute__warn_unused_result__;

PERL_CALLCONV void	Perl_free_tied_hv_pool(pTHX);
#if defined(DEBUGGING)
PERL_CALLCONV int	Perl_get_debug_opts(pTHX_ const char **s, bool givehelp)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_save_set_svflags(pTHX_ SV* sv, U32 mask, U32 val);
PERL_CALLCONV void	Perl_hv_assert(pTHX_ HV* tb)
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV SV*	Perl_hv_scalar(pTHX_ HV* hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32*	Perl_hv_riter_p(pTHX_ HV* hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV HE**	Perl_hv_eiter_p(pTHX_ HV* hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_hv_riter_set(pTHX_ HV* hv, I32 riter)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_hv_eiter_set(pTHX_ HV* hv, HE* eiter)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_hv_name_set(pTHX_ HV* hv, const char *name, U32 len, U32 flags)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV AV**	Perl_hv_backreferences_p(pTHX_ HV* hv)
			__attribute__nonnull__(pTHX_1);

#if defined(PERL_IN_DUMP_C) || defined(PERL_IN_HV_C) || defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
PERL_CALLCONV void	Perl_hv_kill_backrefs(pTHX_ HV* hv)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_hv_clear_placeholders(pTHX_ HV* hb)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32*	Perl_hv_placeholders_p(pTHX_ HV* hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV I32	Perl_hv_placeholders_get(pTHX_ HV* hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_hv_placeholders_set(pTHX_ HV* hv, I32 ph)
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV SV*	Perl_magic_scalarpack(pTHX_ HV* hv, MAGIC* mg)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);


#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
STATIC SV *	S_find_hash_subscript(pTHX_ HV *hv, SV *val)
			__attribute__nonnull__(pTHX_2);

STATIC I32	S_find_array_subscript(pTHX_ AV *av, SV *val)
			__attribute__nonnull__(pTHX_2);

STATIC SV*	S_find_uninit_var(pTHX_ OP* obase, SV* uninit_sv, bool top);
#endif

#ifdef PERL_NEED_MY_HTOLE16
PERL_CALLCONV U16	Perl_my_htole16(U16 n);
#endif
#ifdef PERL_NEED_MY_LETOH16
PERL_CALLCONV U16	Perl_my_letoh16(U16 n);
#endif
#ifdef PERL_NEED_MY_HTOBE16
PERL_CALLCONV U16	Perl_my_htobe16(U16 n);
#endif
#ifdef PERL_NEED_MY_BETOH16
PERL_CALLCONV U16	Perl_my_betoh16(U16 n);
#endif
#ifdef PERL_NEED_MY_HTOLE32
PERL_CALLCONV U32	Perl_my_htole32(U32 n);
#endif
#ifdef PERL_NEED_MY_LETOH32
PERL_CALLCONV U32	Perl_my_letoh32(U32 n);
#endif
#ifdef PERL_NEED_MY_HTOBE32
PERL_CALLCONV U32	Perl_my_htobe32(U32 n);
#endif
#ifdef PERL_NEED_MY_BETOH32
PERL_CALLCONV U32	Perl_my_betoh32(U32 n);
#endif
#ifdef PERL_NEED_MY_HTOLE64
PERL_CALLCONV U64	Perl_my_htole64(U64 n);
#endif
#ifdef PERL_NEED_MY_LETOH64
PERL_CALLCONV U64	Perl_my_letoh64(U64 n);
#endif
#ifdef PERL_NEED_MY_HTOBE64
PERL_CALLCONV U64	Perl_my_htobe64(U64 n);
#endif
#ifdef PERL_NEED_MY_BETOH64
PERL_CALLCONV U64	Perl_my_betoh64(U64 n);
#endif

#ifdef PERL_NEED_MY_HTOLES
PERL_CALLCONV short	Perl_my_htoles(short n);
#endif
#ifdef PERL_NEED_MY_LETOHS
PERL_CALLCONV short	Perl_my_letohs(short n);
#endif
#ifdef PERL_NEED_MY_HTOBES
PERL_CALLCONV short	Perl_my_htobes(short n);
#endif
#ifdef PERL_NEED_MY_BETOHS
PERL_CALLCONV short	Perl_my_betohs(short n);
#endif
#ifdef PERL_NEED_MY_HTOLEI
PERL_CALLCONV int	Perl_my_htolei(int n);
#endif
#ifdef PERL_NEED_MY_LETOHI
PERL_CALLCONV int	Perl_my_letohi(int n);
#endif
#ifdef PERL_NEED_MY_HTOBEI
PERL_CALLCONV int	Perl_my_htobei(int n);
#endif
#ifdef PERL_NEED_MY_BETOHI
PERL_CALLCONV int	Perl_my_betohi(int n);
#endif
#ifdef PERL_NEED_MY_HTOLEL
PERL_CALLCONV long	Perl_my_htolel(long n);
#endif
#ifdef PERL_NEED_MY_LETOHL
PERL_CALLCONV long	Perl_my_letohl(long n);
#endif
#ifdef PERL_NEED_MY_HTOBEL
PERL_CALLCONV long	Perl_my_htobel(long n);
#endif
#ifdef PERL_NEED_MY_BETOHL
PERL_CALLCONV long	Perl_my_betohl(long n);
#endif

PERL_CALLCONV void	Perl_my_swabn(void* ptr, int n)
			__attribute__nonnull__(1);


PERL_CALLCONV GV*	Perl_gv_fetchpvn_flags(pTHX_ const char* name, STRLEN len, I32 flags, I32 sv_type)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV GV*	Perl_gv_fetchsv(pTHX_ SV *name, I32 flags, I32 sv_type)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV bool	Perl_is_gv_magical_sv(pTHX_ SV *name, U32 flags)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV bool	Perl_stashpv_hvname_match(pTHX_ const COP *cop, const HV *hv)
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);


#ifdef DEBUG_LEAKING_SCALARS_FORK_DUMP
PERL_CALLCONV void	Perl_dump_sv_child(pTHX_ SV *sv)
			__attribute__nonnull__(pTHX_1);

#endif

#ifdef PERL_DONT_CREATE_GVSV
PERL_CALLCONV GV*	Perl_gv_SVadd(pTHX_ GV* gv)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV bool	Perl_ckwarn(pTHX_ U32 w);
PERL_CALLCONV bool	Perl_ckwarn_d(pTHX_ U32 w);
PERL_CALLCONV STRLEN *	Perl_new_warnings_bitfield(pTHX_ STRLEN *buffer, const char *const bits, STRLEN size)
			__attribute__malloc__
			__attribute__warn_unused_result__
			__attribute__nonnull__(pTHX_2);


PERL_CALLCONV void	Perl_offer_nice_chunk(pTHX_ void *chunk, U32 chunk_size)
			__attribute__nonnull__(pTHX_1);


#ifndef SPRINTF_RETURNS_STRLEN
PERL_CALLCONV int	Perl_my_sprintf(char *buffer, const char *pat, ...)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

#endif

PERL_CALLCONV int	Perl_my_snprintf(char *buffer, const Size_t len, const char *format, ...)
			__attribute__format__(__printf__,3,4)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);

PERL_CALLCONV int	Perl_my_vsnprintf(char *buffer, const Size_t len, const char *format, va_list ap)
			__attribute__nonnull__(1)
			__attribute__nonnull__(3);


PERL_CALLCONV void	Perl_my_clearenv(pTHX);

#ifdef PERL_IMPLICIT_CONTEXT
#ifdef PERL_GLOBAL_STRUCT_PRIVATE
PERL_CALLCONV void*	Perl_my_cxt_init(pTHX_ const char *my_cxt_key, size_t size)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV int	Perl_my_cxt_index(pTHX_ const char *my_cxt_key)
			__attribute__nonnull__(pTHX_1);

#else
PERL_CALLCONV void*	Perl_my_cxt_init(pTHX_ int *index, size_t size)
			__attribute__nonnull__(pTHX_1);

#endif
#endif

#ifndef HAS_STRLCAT
PERL_CALLCONV Size_t	Perl_my_strlcat(char *dst, const char *src, Size_t size);
#endif

#ifndef HAS_STRLCPY
PERL_CALLCONV Size_t	Perl_my_strlcpy(char *dst, const char *src, Size_t size);
#endif

#ifdef PERL_MAD
PERL_CALLCONV void	Perl_pad_peg(const char* s)
			__attribute__nonnull__(1);

#if defined(PERL_IN_DUMP_C) || defined(PERL_DECL_PROT)
STATIC void	S_xmldump_attr(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#endif
PERL_CALLCONV void	Perl_xmldump_indent(pTHX_ I32 level, PerlIO *file, const char* pat, ...)
			__attribute__format__(__printf__,pTHX_3,pTHX_4)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_xmldump_vindent(pTHX_ I32 level, PerlIO *file, const char* pat, va_list *args)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

PERL_CALLCONV void	Perl_xmldump_all(pTHX);
PERL_CALLCONV void	Perl_xmldump_packsubs(pTHX_ const HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_xmldump_sub(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_xmldump_form(pTHX_ const GV* gv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_xmldump_eval(pTHX);
PERL_CALLCONV char*	Perl_sv_catxmlsv(pTHX_ SV *dsv, SV *ssv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_catxmlpvn(pTHX_ SV *dsv, const char *pv, STRLEN len)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV char*	Perl_sv_xmlpeek(pTHX_ SV* sv)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_do_pmop_xmldump(pTHX_ I32 level, PerlIO *file, const PMOP *pm)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_pmop_xmldump(pTHX_ const PMOP* pm);
PERL_CALLCONV void	Perl_do_op_xmldump(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV void	Perl_op_xmldump(pTHX_ const OP* arg)
			__attribute__nonnull__(pTHX_1);


PERL_CALLCONV MADTOKEN*	Perl_newMADTOKEN(pTHX_ I32 optype, YYSTYPE lval, MADPROP* madprop);
PERL_CALLCONV void	Perl_token_free(pTHX_ MADTOKEN* arg)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_token_getmad(pTHX_ MADTOKEN* arg, OP* o, char slot)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_op_getmad_weak(pTHX_ OP* from, OP* o, char slot);
PERL_CALLCONV void	Perl_op_getmad(pTHX_ OP* from, OP* o, char slot);
PERL_CALLCONV void	Perl_prepend_madprops(pTHX_ MADPROP* mp, OP* o, char slot);
PERL_CALLCONV void	Perl_append_madprops(pTHX_ MADPROP* tm, OP* o, char slot);
PERL_CALLCONV void	Perl_append_madprops_pv(pTHX_ const char* v, OP* o, char slot)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_addmad(pTHX_ MADPROP* tm, MADPROP** root, char slot);
PERL_CALLCONV MADPROP*	Perl_newMADsv(pTHX_ char key, SV* sv)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV MADPROP*	Perl_newMADPROP(pTHX_ char key, char type, const void* val, I32 vlen);
PERL_CALLCONV void	Perl_mad_free(pTHX_ MADPROP* mp);

#  if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
STATIC char*	S_skipspace0(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_skipspace1(pTHX_ char *s)
			__attribute__nonnull__(pTHX_1);

STATIC char*	S_skipspace2(pTHX_ char *s, SV **sv)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_start_force(pTHX_ int where);
STATIC void	S_curmad(pTHX_ char slot, SV *sv);
#  endif
PERL_CALLCONV int	Perl_madlex(pTHX);
PERL_CALLCONV int	Perl_madparse(pTHX);
#endif
#if !defined(HAS_SIGNBIT)
PERL_CALLCONV int	Perl_signbit(NV f)
			__attribute__pure__;

#endif

PERL_CALLCONV void	Perl_emulate_cop_io(pTHX_ const COP *const c, SV *const sv)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

PERL_CALLCONV REGEXP *	Perl_get_re_arg(pTHX_ SV *sv);

PERL_CALLCONV struct mro_meta*	Perl_mro_meta_init(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);

#if defined(USE_ITHREADS)
PERL_CALLCONV struct mro_meta*	Perl_mro_meta_dup(pTHX_ struct mro_meta* smeta, CLONE_PARAMS* param)
			__attribute__nonnull__(pTHX_1)
			__attribute__nonnull__(pTHX_2);

#endif
PERL_CALLCONV AV*	Perl_mro_get_linear_isa(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);

#if defined(PERL_IN_MRO_C) || defined(PERL_DECL_PROT)
STATIC AV*	S_mro_get_linear_isa_c3(pTHX_ HV* stash, I32 level)
			__attribute__nonnull__(pTHX_1);

STATIC AV*	S_mro_get_linear_isa_dfs(pTHX_ HV* stash, I32 level)
			__attribute__nonnull__(pTHX_1);

#endif
PERL_CALLCONV void	Perl_mro_isa_changed_in(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_mro_method_changed_in(pTHX_ HV* stash)
			__attribute__nonnull__(pTHX_1);

PERL_CALLCONV void	Perl_boot_core_mro(pTHX);
PERL_CALLCONV void	Perl_sys_init(int* argc, char*** argv)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2);

PERL_CALLCONV void	Perl_sys_init3(int* argc, char*** argv, char*** env)
			__attribute__nonnull__(1)
			__attribute__nonnull__(2)
			__attribute__nonnull__(3);

PERL_CALLCONV void	Perl_sys_term(void);


#if defined(PERL_IN_DUMP_C)
STATIC SV*	S_dump_op_flags(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

STATIC SV*	S_dump_op_flags_private(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_dump_op_mad(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_dump_op_rest(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#endif

#if defined(PERL_IN_DUMP_C)
STATIC SV*	S_dump_op_flags(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

STATIC SV*	S_dump_op_flags_private(pTHX_ const OP* o)
			__attribute__nonnull__(pTHX_1);

STATIC void	S_dump_op_mad(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

STATIC void	S_dump_op_rest(pTHX_ I32 level, PerlIO *file, const OP *o)
			__attribute__nonnull__(pTHX_2)
			__attribute__nonnull__(pTHX_3);

#endif

END_EXTERN_C
/*
 * ex: set ts=8 sts=4 sw=4 noet:
 */
/* ex: set ro: */
