case $PERL_CONFIG_SH in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

if test -f config_h.SH -a ! -f config.h; then
    . ./config_h.SH
    CONFIG_H=already-done
fi

warn=''

# Add -Wall for the core modules iff gcc and not already -Wall
case "$gccversion" in
'') ;;
Intel*) ;; # The Intel C++ plays gcc on TV but is not really it.
*)  case "$ccflags" in
    *-Wall*) ;;
    *) warn="$warn -Wall" ;;
    esac
    ;;
esac

# Create a test source file for testing what options can be fed to
# gcc in this system; include a selection of most common and commonly
# hairy include files.

cat >_cflags.c <<__EOT__
#include "EXTERN.h"
#include "perl.h"
/* The stdio.h, errno.h, and setjmp.h should be there in any ANSI C89. */
#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
/* Just in case the inclusion of perl.h did not
 * pull in enough system headers, let's try again. */
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#ifdef I_STDDEF
#include <stddef.h>
#endif
#ifdef I_STDARG
#include <stdarg.h>
#endif
#ifdef I_LIMITS
#include <limits.h>
#endif
#ifdef I_DIRENT
#include <dirent.h>
#endif
#ifdef I_UNISTD
#include <unistd.h>
#endif
#ifdef I_SYSTYPES
#include <sys/types.h>
#endif
#ifdef I_SYSPARAM
#include <sys/param.h>
#endif
#ifdef I_SYSRESOURCE
#include <sys/resource.h>
#endif
#ifdef I_SYSSELECT
#include <sys/select.h>
#endif
#if defined(HAS_SOCKET) && !defined(VMS) && !defined(WIN32) /* See perl.h. */
#include <sys/socket.h>
#endif
#ifdef I_SYSSTAT
#include <sys/stat.h>
#endif
#ifdef I_SYSTIME
#include <sys/time.h>
#endif
#ifdef I_SYSTIMES
#include <sys/times.h>
#endif
#ifdef I_SYSWAIT
#include <sys/wait.h>
#endif
/* The gcc -ansi can cause a lot of noise in Solaris because of:
 /usr/include/sys/resource.h:148: warning: 'struct rlimit64' declared inside parameter list
 */
int main(int argc, char *argv[]) {

/* Add here test code found to be problematic in some gcc platform. */

/* Off_t/off_t is a struct in Solaris with largefiles, and with gcc -ansi
 * that struct cannot be compared in some gcc releases with a flat
 * integer, such as a STRLEN. */

  Off_t t0a = 2;
  STRLEN t0b = 3;
  int t0c = t0a == t0b;

  return 0;
}
__EOT__

stdflags=''

# Further gcc warning options.
case "$gccversion" in
'') ;;
[12]*) ;; # gcc versions 1 (gasp!) and 2 are not good for this.
Intel*) ;; # # Is that you, Intel C++?
*)  for opt in -ansi -pedantic -std=c89 -W -Wextra -Wdeclaration-after-statement -Wendif-labels -Wc++-compat
    do
       case " $ccflags " in
       *" $opt "*) ;; # Skip if already there.
       *) rm -f _cflags$_exe
          case "`$cc $cflags $opt _cflags.c -o _cflags$_exe 2>&1`" in
          *"unrecognized"*) ;;
          *"Invalid"*) ;;
          *"is valid for C"*) ;;
          *) if test -x _cflags$_exe
             then
               case "$opt" in
               -std*) stdflags="$stdflags $opt" ;;
               *) warn="$warn $opt" ;;
               esac
             fi
             ;;
          esac
          ;;
       esac
    done
    ;;
esac
rm -f _cflags.c _cflags$_exe

case "$gccversion" in
'') ;;
*)
  if [ "$gccansipedantic" = "" ]; then
    # If we have -Duse64bitint (or equivalent) in effect and the quadtype
    # has become 'long long', gcc -pedantic becomes unbearable (moreso
    # when combined with -Wall) because long long and LL and %lld|%Ld
    # become warn-worthy.  So let's drop the -pedantic in that case.
    case "$quadtype:$sPRId64" in
    "long long"*|*lld*|*Ld*)
      ccflags="`echo $ccflags|sed 's/-pedantic/ /'`"
      warn="`echo $warn|sed 's/-pedantic/ /'`"
      ;;
    esac
  fi
  # Using certain features (like the gcc statement expressions)
  # requires knowing whether -pedantic has been specified.
  case "$warn$ccflags" in
  *-pedantic*) warn="$warn -DPERL_GCC_PEDANTIC" ;;
  esac
  ;;
esac

# Code to set any extra flags here.
extra=''

echo "Extracting cflags (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
rm -f cflags
$spitshell >cflags <<!GROK!THIS!
$startsh

# Extra warnings, used e.g. for gcc.
warn="$warn"
# Extra standardness.
stdflags="$stdflags"
# Extra extra.
extra="$extra"

!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>cflags <<'!NO!SUBS!'
case $PERL_CONFIG_SH in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac

: syntax: cflags [optimize=XXX] [file[.suffix]]
: displays the compiler command line for file

case "X$1" in
Xoptimize=*|X"optimize=*")
	eval "$1"
	shift
	;;
esac

also=': '
case $# in
1) also='echo 1>&2 "	  CCCMD = "'
esac

case $# in
0) set *.c; echo "The current C flags are:" ;;
esac

set `echo "$* " | sed -e 's/\.[oc] / /g' -e 's/\.obj / /g' -e "s/\\$obj_ext / /g"`

for file do

    case "$#" in
    1) ;;
    *) echo $n "    $file.c	$c" ;;
    esac

    : allow variables like toke_cflags to be evaluated

    if echo $file | grep -v / >/dev/null
    then
      eval 'eval ${'"${file}_cflags"'-""}'
    fi

    : or customize here

    case "$file" in
    DB_File) ;;
    GDBM_File) ;;
    NDBM_File) ;;
    ODBM_File) ;;
    POSIX) ;;
    SDBM_File) ;;
    av) ;;
    byterun) ;;
    deb) ;;
    dl) ;;
    doio) ;;
    doop) ;;
    dump) ;;
    globals) ;;
    gv) ;;
    hv) ;;
    locale) ;;
    madly) ;;
    main) ;;
    malloc) ;;
    mg) ;;
    miniperlmain) ;;
    numeric) ;;
    op) ;;
    opmini) ;;
    pad) ;;
    perl) ;;
    perlapi) ;;
    perlmain) ;;
    perly) ;;
    pp) ;;
    pp_ctl) ;;
    pp_hot) ;;
    pp_pack) ;;
    pp_sort) ;;
    pp_sys) ;;
    regcomp) ;;
    regexec) ;;
    run) ;;
    scope) ;;
    sv) ;;
    taint) ;;
    toke) ;;
    universal) ;;
    usersub) ;;
    utf8) ;;
    util) ;;
    xsutils) ;;
    *) ;;
    esac

case "$cc" in
*g++*)
  # Extra paranoia in case people have bad canned ccflags:
  # bad in the sense that the flags are accepted by g++,
  # but then whined about.
  for f in -Wdeclaration-after-statement -std=c89
  do
    ccflags=`echo $ccflags|sed 's/$f/ /'`
  done
  ;;
esac

case "$cc" in
*g++*)
  # Without -Wno-unused-variable g++ 4.x compiles are rather unwatchable
  # because of all the warnings about Perl___notused, and g++ doesn't do
  # __attribute__((unused)) (and even if at some stage it may, people do
  # have older gcc installations), and ((void)x) isn't enough to silence
  # the noises about XS functions not using their cv parameter, so we need
  # the -Wno-unused-parameter too.
  # Yes, we lose some valid warnings, but hopefully other compilers
  # (like gcc) will still pick up those warnings.
  for o in -Wno-unused-variable -Wno-unused-parameter
  do
    case "$warn" in
    *$o*) ;;
    *) warn="$warn $o" ;;
    esac
  done
  ;;
esac

if test -e .git; then
  ccflags="-DKURILA_PATCHNUM=`git-rev-list --max-count=1 HEAD` $ccflags"
fi

    : Can we perhaps use $ansi2knr here
    echo "$cc -c -DPERL_CORE $ccflags $stdflags $optimize $warn $extra"
    eval "$also "'"$cc -DPERL_CORE -c $ccflags $stdflags $optimize $warn $extra"'

    . $TOP/config.sh

done
!NO!SUBS!
chmod 755 cflags
$eunicefix cflags
