use 5.10.0;
use warnings;
use strict;

package Task::BeLike::TomFahle;

our $VERSION = '0.20';

1;

__END__

=pod

=head1 NAME

Task::BeLike::TomFahle - Just an install package for CPAN modules I frequently use.

=head1 DESCRIPTION

Just an install package for CPAN modules I frequently use.

=head1 TASKs

=head2 App::Ack

App::Ack L<http://search.cpan.org/perldoc?App::Ack>

=head2 CPAN::Reporter

CPAN::Reporter L<http://search.cpan.org/perldoc?CPAN::Reporter>

=head2 Dancer

Dancer L<http://perldancer.org/>

=head2 Digest::MD5 

Digest::MD5 L<http://search.cpan.org/perldoc?Digest::MD5>

=head2 JSON

JSON L<http://search.cpan.org/perldoc?JSON>

=head2 JSON::Any

JSON::Any L<http://search.cpan.org/perldoc?JSON::Any>

=head2 JSON::DWIW

JSON::DWIW L<http://search.cpan.org/perldoc?JSON::DWIW>

=head2 JSON::Syck

JSON::Syck L<http://search.cpan.org/perldoc?JSON::Syck>

=head2 JSON::XS 

JSON::XS L<http://search.cpan.org/perldoc?JSON::XS>

=head2 HTML::HeadParser

HTML::HeadParser L<http://search.cpan.org/perldoc?HTML::HeadParser>

=head2 HTML::Tagset

HTML::Tagset  L<http://search.cpan.org/perldoc?HTML::Tagset>

=head2 HTML::Parser

HTML::Parser  L<http://search.cpan.org/perldoc?HTML::Parser>

=head2 Log::Dispatch 

Log::Dispatch L<http://search.cpan.org/perldoc?Log%3A%3ADispatch> 

=head2 Log::Dispatch::FileRotate

=head2 Logfile::Rotate

Logfile::Rotate L<http://search.cpan.org/perldoc?Logfile%3A%3ARotate>

Log::Dispatch::FileRotate L<http://search.cpan.org/perldoc?Log%3A%3ADispatch%3A%3AFileRotate>

=head2 Log::Log4perl 

Log::Log4perl  L<http://search.cpan.org/perldoc?Log%3A%3ALog4perl>

=head2 LWP

LWP L<http://search.cpan.org/perldoc?LWP>

=head2 Metabase::Client::Simple

Metabase::Client::Simple L<http://search.cpan.org/perldoc?Metabase::Client::Simple>

=head2 Metabase::Fact

Metabase::Fact L<http://search.cpan.org/perldoc?Metabase::Fact>

=head2 MIME::Base64

MIME::Base64 L<http://search.cpan.org/perldoc?MIME::Base64>

=head2 Mozilla::CA

Mozilla::CA L<http://search.cpan.org/perldoc?Mozilla::CA> 

=head2 Net::DNS

Net::DNS L<http://search.cpan.org/perldoc?Net::DNS> 

=head2 Net::FTP

Net::FTP L<http://search.cpan.org/perldoc?Net::FTP> 

=head2 Parallel::Iterator

Parallel::Iterator L<http://search.cpan.org/perldoc?Parallel%3A%3AIterator>  

=head2 Perl::Tidy

Perl::Tidy L<http://search.cpan.org/perldoc?Perl::Tidy>

=head2 Task::Kensho

Task::Kensho L<http://search.cpan.org/perldoc?Task::Kensho>

=head3 Task::Kensho::Async

Task::Kensho::Async L<http://search.cpan.org/perldoc?Task::Kensho::Async>

=head3 Task::Kensho::CLI

Task::Kensho::CLI L<http://search.cpan.org/perldoc?Task::Kensho::CLI>

=head3 Task::Kensho::Config

Task::Kensho::Config L<http://search.cpan.org/perldoc?Task::Kensho::Config>

=head3 Task::Kensho::DBDev

Task::Kensho::DBDev L<http://search.cpan.org/perldoc?Task::Kensho::DBDev>

=head3 Task::Kensho::Dates

Task::Kensho::Dates L<http://search.cpan.org/perldoc?Task::Kensho::Dates>

=head3 Task::Kensho::Email

Task::Kensho::Email L<http://search.cpan.org/perldoc?Task::Kensho::Email>

=head3 Task::Kensho::ExcelCSV

Task::Kensho::ExcelCSV L<http://search.cpan.org/perldoc?Task::Kensho::ExcelCSV>

=head3 Task::Kensho::Exceptions

Task::Kensho::Exceptions L<http://search.cpan.org/perldoc?Task::Kensho::Exceptions>

=head3 Task::Kensho::Hackery

Task::Kensho::Hackery L<http://search.cpan.org/perldoc?Task::Kensho::Hackery>

=head3 Task::Kensho::Logging

Task::Kensho::Logging L<http://search.cpan.org/perldoc?Task::Kensho::Logging>

=head3 Task::Kensho::ModuleDev

Task::Kensho::ModuleDev L<http://search.cpan.org/perldoc?Task::Kensho::ModuleDev>

=head3 Task::Kensho::OOP

Task::Kensho::OOP L<http://search.cpan.org/perldoc?Task::Kensho::OOP>

=head3 Task::Kensho::Scalability

Task::Kensho::Scalability L<http://search.cpan.org/perldoc?Task::Kensho::Scalability>

=head3 Task::Kensho::Testing

Task::Kensho::Testing L<http://search.cpan.org/perldoc?Task::Kensho::Testing>

=head3 Task::Kensho::Toolchain

Task::Kensho::Toolchain L<http://search.cpan.org/perldoc?Task::Kensho::Toolchain>

=head3 Task::Kensho::WebCrawling

Task::Kensho::WebCrawling L<http://search.cpan.org/perldoc?Task::Kensho::WebCrawling>

=head3 Task::Kensho::WebDev

Task::Kensho::WebDev L<http://search.cpan.org/perldoc?Task::Kensho::WebDev>

=head3 Task::Kensho::XML

Task::Kensho::XML Task::Kensho::XML L<http://search.cpan.org/perldoc?Task::Kensho::XML>

=head2 Test::Compile

Test::Compile L<http://search.cpan.org/perldoc?Test%3A%3ACompile>

=head2 Test::JSON 

Test::JSON  L<http://search.cpan.org/perldoc?Test::JSON>

=head2 Test::Reporter

Test::Reporter L<http://search.cpan.org/perldoc?Test::Reporter>

=head2 Test::Reporter::Transport::Metabase

Test::Reporter::Transport::Metabase L<http://search.cpan.org/perldoc?Test::Reporter::Transport::Metabase>

=head2 Test::TCP

Test::TCP L<http://search.cpan.org/perldoc?Test::TCP>

=head2 URI

URI L<http://search.cpan.org/perldoc?URI>

=head1 SEE ALSO

Task::BeLike::.* L<http://search.cpan.org/search?query=Task%3A%3ABelike&mode=all>

=head1 SUPPORT

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-BeLike-TomFahle>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-BeLike-TomFahle>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-BeLike-TomFahle>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-BeLike-TomFahle/>

=back

=head1 COPYRIGHT & LICENSE

Copyright 2012 Thomas Fahle

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
