use inc::Module::Install;
use Config;

name 'Data-MessagePack';
all_from 'lib/Data/MessagePack.pm';
readme_from('lib/Data/MessagePack.pm');

perl_version '5.008000';
license 'perl';

tests 't/*.t';
recursive_author_tests('xt');


if ( $] >= 5.008005 and want_xs() ) {
    can_cc or die "This module requires a C compiler. Please retry with --pp";

    my $has_c99 = c99_available(); # msgpack C library requires C99.

    if ( $has_c99 ) {
        use_ppport 3.19;
        cc_src_paths('xs-src');
        if ($ENV{DEBUG}) {
            cc_append_to_ccflags '-g';
        }
    }
    else {
        print <<NOT_SUPPORT_C99;

This distribution requires a C99 compiler, but yours seems not to support C99.
Instead of XS, configure PP version.

NOT_SUPPORT_C99

    }
}
else {
    print "configure PP version\n\n";
}

clean_files qw{
    *.stackdump
    *.gcov *.gcda *.gcno
    *.out
    nytprof
    cover_db
};

# copy modules
if ($Module::Install::AUTHOR && -d File::Spec->catfile('..', 'msgpack')) {
    mkdir 'msgpack' unless -d 'msgpack';
    require File::Copy;
    for my $src (<../msgpack/*.h>) {
        File::Copy::copy($src, 'msgpack/') or die "copy failed: $!";
    }
}

requires 'Test::More' => 0.94; # done_testing
test_requires('Test::Requires');

test_with_env( test_pp => PERL_DATA_MESSAGEPACK => 'pp' );

if($Module::Install::AUTHOR) {
    postamble qq{test :: test_pp\n\n};
}

auto_set_repository();
auto_include;
WriteAll;

# copied from Makefile.PL in Text::Xslate.
sub test_with_env {
    my($name, %env) = @_;

    my $dir = '.testenv';
    if(not -e $dir) {
        mkdir $dir or die "Cannot mkdir '.testenv': $!";
    }
    clean_files($dir);

    {
        open my $out, '>', "$dir/$name.pl"
            or die "Cannot open '$dir/$name.pl' for writing: $!";
       print $out "# This file sets the env for 'make $name', \n";
       print $out "# generated by $0 at ", scalar(localtime), ".\n";
       print $out "# DO NOT EDIT THIS FILE DIRECTLY.\n";
       print $out "\n";

        while(my($name, $value) = each %env) {
            printf $out '$ENV{q{%s}} = q{%s};'."\n", $name, $value;
        }
    }

    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    my $t =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
            .q{ "do q[%s]; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
            .q{ $(TEST_FILES)};

    postamble qq{$name :: pure_all\n}
            . qq{\t} . q{$(NOECHO) $(ECHO) TESTING: } . $name . qq{\n}
            . qq{\t} . sprintf($t, "$dir/$name.pl") . qq{\n\n}

            . qq{testall :: $name\n\n};
    return;
}
