# This Makefile.PL for Crypt-OpenSSL-AES was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008;
use ExtUtils::MakeMaker;

use Config;
use File::Spec;
use Crypt::OpenSSL::Guess qw(openssl_version openssl_inc_paths openssl_lib_paths);

my %args;

my ($major, $minor, $patch) = openssl_version();
print "Installed OpenSSL: $major.$minor.$patch\n";

$args{INC} =  openssl_inc_paths();
$args{LIBS} = [openssl_lib_paths() . ' -lssl -lcrypto'];

my $cc_option_flags;

if ($Config::Config{cc} =~ /gcc/i) {
  $cc_option_flags .= $ENV{AUTHOR_TESTING} ? ' -Wall -Wpointer-sign' : ' -Wall';
} else {
  $cc_option_flags .= $ENV{AUTHOR_TESTING} ? ' -Wall -Wpointer-sign' : '';
}

if ($Config{gccversion} =~ /llvm/i) {
  if ( $^O eq 'darwin' && (
    $Config{gccversion} =~ /LLVM 1[2-9].\d.[5-9]/ ||
    $Config{gccversion} =~ /LLVM 1[3-9]/ ))
  {
    $cc_option_flags .= ' -Wno-deprecated-declarations -Wno-compound-token-split-by-macro';
  } else {
    $cc_option_flags .= ' -Wno-deprecated-declarations';
  }

  if ($Config{gccversion} =~ /llvm 13/i) {
      $cc_option_flags .= ' -Wno-compound-token-split-by-macro';
  }

  if ($Config{PERL_VERSION} <= 20) {
    $cc_option_flags .= ' -Wno-error=pointer-bool-conversion';
  }
}

if ($Config{myuname} =~ /sunos|solaris/i) {
  $args{OPTIMIZE} = $cc_option_flags;
} else {
  $args{OPTIMIZE} = $cc_option_flags;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "A Perl wrapper around OpenSSL's AES library",
  "AUTHOR" => "Tolga Tarhan <cpan at ttar dot org>",
  "BUILD_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-OpenSSL-AES",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "Crypt::OpenSSL::AES",
  "PREREQ_PM" => {
    "Exporter" => 0,
    "XSLoader" => 0
  },
  "TEST_REQUIRES" => {
    "Crypt::CBC" => 0,
    "Crypt::Cipher::AES" => 0,
    "Crypt::Digest::SHA512_256" => 0,
    "Crypt::Mode::CBC" => 0,
    "Crypt::Mode::CFB" => 0,
    "Crypt::Mode::CTR" => 0,
    "Crypt::Mode::ECB" => 0,
    "Crypt::Mode::OFB" => 0,
    "Crypt::OpenSSL::Guess" => 0,
    "Crypt::PRNG" => 0,
    "Digest::SHA" => 0,
    "MIME::Base64" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.10",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Crypt::CBC" => 0,
  "Crypt::Cipher::AES" => 0,
  "Crypt::Digest::SHA512_256" => 0,
  "Crypt::Mode::CBC" => 0,
  "Crypt::Mode::CFB" => 0,
  "Crypt::Mode::CTR" => 0,
  "Crypt::Mode::ECB" => 0,
  "Crypt::Mode::OFB" => 0,
  "Crypt::OpenSSL::Guess" => 0,
  "Crypt::PRNG" => 0,
  "Digest::SHA" => 0,
  "Exporter" => 0,
  "MIME::Base64" => 0,
  "Test::More" => 0,
  "XSLoader" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
