/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TDoubleFunction;
import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntDoubleProcedure;
import gnu.trove.TIntIntHashMap;
import opennlp.maxent.DataIndexer;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;

class GISTrainer {
    private boolean _simpleSmoothing = false;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numTokens;
    private int numPreds;
    private int numOutcomes;
    private int TID;
    private int PID;
    private int OID;
    private double PABISUM;
    private int[][] contexts;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private TIntDoubleHashMap[] observedExpects;
    private TIntDoubleHashMap[] params;
    private TIntDoubleHashMap[] modifiers;
    private int[] predkeys;
    private boolean needCorrection;
    private int constant = 1;
    private double constantInverse;
    private double correctionParam = 0.0;
    private double cfObservedExpect;
    private double CFMOD;
    private TIntIntHashMap[] cfvals;
    private TIntDoubleHashMap[] pabi;
    private TDoubleFunction backToZeros = new TDoubleFunction(){

        public double execute(double arg) {
            return 0.0;
        }
    };
    private TDoubleFunction normalizePABI = new TDoubleFunction(){

        public double execute(double arg) {
            return arg / GISTrainer.this.PABISUM;
        }
    };
    private TIntDoubleProcedure addParamsToPABI = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer.this.pabi[GISTrainer.this.TID].adjustValue(oid, arg);
            return true;
        }
    };
    private TIntDoubleProcedure addCorrectionToPABIandExponentiate = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            if (GISTrainer.this.needCorrection) {
                arg += GISTrainer.this.correctionParam * (double)GISTrainer.this.cfvals[GISTrainer.this.TID].get(oid);
            }
            arg = Math.exp(arg);
            GISTrainer gISTrainer = GISTrainer.this;
            gISTrainer.PABISUM = gISTrainer.PABISUM + arg;
            GISTrainer.this.pabi[GISTrainer.this.TID].put(oid, arg);
            return true;
        }
    };
    private TIntDoubleProcedure updateModifiers = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer.this.modifiers[GISTrainer.this.PID].put(oid, arg + GISTrainer.this.pabi[GISTrainer.this.TID].get(oid) * (double)GISTrainer.this.numTimesEventsSeen[GISTrainer.this.TID]);
            return true;
        }
    };
    private TIntDoubleProcedure updateParams = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer.this.params[GISTrainer.this.PID].put(oid, arg + GISTrainer.this.constantInverse * (GISTrainer.this.observedExpects[GISTrainer.this.PID].get(oid) - Math.log(GISTrainer.this.modifiers[GISTrainer.this.PID].get(oid))));
            return true;
        }
    };
    private TIntDoubleProcedure updateCorrectionFeatureModifier = new TIntDoubleProcedure(){

        public boolean execute(int oid, double arg) {
            GISTrainer gISTrainer = GISTrainer.this;
            gISTrainer.CFMOD = gISTrainer.CFMOD + arg * (double)GISTrainer.this.cfvals[GISTrainer.this.TID].get(oid) * (double)GISTrainer.this.numTimesEventsSeen[GISTrainer.this.TID];
            return true;
        }
    };

    GISTrainer() {
    }

    GISTrainer(boolean printMessages) {
        this();
        this.printMessages = printMessages;
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }

    private void findParameters(int iterations) {
        this.display("Performing " + iterations + " iterations.\n");
        int i = 1;
        while (i <= iterations) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(String.valueOf(i) + ":  ");
            }
            this.nextIteration();
            ++i;
        }
        this.observedExpects = null;
        this.pabi = null;
        this.modifiers = null;
        this.cfvals = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private void nextIteration() {
        int j;
        this.CFMOD = 0.0;
        this.TID = 0;
        while (this.TID < this.numTokens) {
            this.pabi[this.TID].transformValues(this.backToZeros);
            j = 0;
            while (j < this.contexts[this.TID].length) {
                this.params[this.contexts[this.TID][j]].forEachEntry(this.addParamsToPABI);
                ++j;
            }
            this.PABISUM = 0.0;
            this.pabi[this.TID].forEachEntry(this.addCorrectionToPABIandExponentiate);
            if (this.PABISUM > 0.0) {
                this.pabi[this.TID].transformValues(this.normalizePABI);
            }
            if (this.needCorrection) {
                this.pabi[this.TID].forEachEntry(this.updateCorrectionFeatureModifier);
            }
            ++this.TID;
        }
        this.display(".");
        this.TID = 0;
        while (this.TID < this.numTokens) {
            j = 0;
            while (j < this.contexts[this.TID].length) {
                this.PID = this.contexts[this.TID][j];
                this.modifiers[this.PID].forEachEntry(this.updateModifiers);
                ++j;
            }
            ++this.TID;
        }
        this.display(".");
        this.PID = 0;
        while (this.PID < this.numPreds) {
            this.params[this.PID].forEachEntry(this.updateParams);
            this.modifiers[this.PID].transformValues(this.backToZeros);
            ++this.PID;
        }
        if (this.CFMOD > 0.0) {
            this.correctionParam += this.constantInverse * (this.cfObservedExpect - Math.log(this.CFMOD));
        }
        this.display(".\n");
    }

    public void setSmoothing(boolean smooth) {
        this._simpleSmoothing = smooth;
    }

    public void setSmoothingObservation(double timesSeen) {
        this._smoothingObservation = timesSeen;
    }

    public GISModel trainModel(EventStream eventStream, int iterations, int cutoff) {
        int initialCapacity;
        DataIndexer di = new DataIndexer(eventStream, cutoff);
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = di.contexts;
        this.numTimesEventsSeen = di.numTimesEventsSeen;
        this.numTokens = this.contexts.length;
        this.needCorrection = false;
        this.constant = this.contexts[0].length;
        this.TID = 1;
        while (this.TID < this.contexts.length) {
            if (this.contexts[this.TID].length < this.constant) {
                this.needCorrection = true;
            } else if (this.contexts[this.TID].length > this.constant) {
                this.needCorrection = true;
                this.constant = this.contexts[this.TID].length;
            }
            ++this.TID;
        }
        this.constantInverse = 1.0 / (double)this.constant;
        this.outcomeLabels = di.outcomeLabels;
        this.numOutcomes = this.outcomeLabels.length;
        this.predLabels = di.predLabels;
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numTokens + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        int[][] predCount = new int[this.numPreds][this.numOutcomes];
        this.TID = 0;
        while (this.TID < this.numTokens) {
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                int[] nArray = predCount[this.contexts[this.TID][j]];
                int n = di.outcomeList[this.TID];
                nArray[n] = nArray[n] + this.numTimesEventsSeen[this.TID];
                ++j;
            }
            ++this.TID;
        }
        di = null;
        double smoothingObservation = Math.log(this._smoothingObservation);
        this.params = new TIntDoubleHashMap[this.numPreds];
        this.modifiers = new TIntDoubleHashMap[this.numPreds];
        this.observedExpects = new TIntDoubleHashMap[this.numPreds];
        float loadFactor = 0.9f;
        if (this.numOutcomes < 3) {
            initialCapacity = 2;
            loadFactor = 1.0f;
        } else {
            initialCapacity = this.numOutcomes < 5 ? 2 : this.numOutcomes / 2;
        }
        this.PID = 0;
        while (this.PID < this.numPreds) {
            this.params[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.modifiers[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.observedExpects[this.PID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
            this.OID = 0;
            while (this.OID < this.numOutcomes) {
                if (predCount[this.PID][this.OID] > 0) {
                    this.params[this.PID].put(this.OID, 0.0);
                    this.modifiers[this.PID].put(this.OID, 0.0);
                    this.observedExpects[this.PID].put(this.OID, Math.log(predCount[this.PID][this.OID]));
                } else if (this._simpleSmoothing) {
                    this.params[this.PID].put(this.OID, 0.0);
                    this.modifiers[this.PID].put(this.OID, 0.0);
                    this.observedExpects[this.PID].put(this.OID, smoothingObservation);
                }
                ++this.OID;
            }
            this.params[this.PID].compact();
            this.modifiers[this.PID].compact();
            this.observedExpects[this.PID].compact();
            ++this.PID;
        }
        predCount = null;
        this.display("...done.\n");
        this.pabi = new TIntDoubleHashMap[this.numTokens];
        if (this.needCorrection) {
            this.display("Computing correction feature matrix... ");
            this.cfvals = new TIntIntHashMap[this.numTokens];
            this.TID = 0;
            while (this.TID < this.numTokens) {
                this.cfvals[this.TID] = new TIntIntHashMap(initialCapacity, loadFactor);
                this.pabi[this.TID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
                int j = 0;
                while (j < this.contexts[this.TID].length) {
                    this.PID = this.contexts[this.TID][j];
                    this.predkeys = this.params[this.PID].keys();
                    int i = 0;
                    while (i < this.predkeys.length) {
                        this.OID = this.predkeys[i];
                        if (!this.cfvals[this.TID].increment(this.OID)) {
                            this.cfvals[this.TID].put(this.OID, 1);
                            this.pabi[this.TID].put(this.OID, 0.0);
                        }
                        ++i;
                    }
                    ++j;
                }
                this.cfvals[this.TID].compact();
                this.pabi[this.TID].compact();
                ++this.TID;
            }
            this.TID = 0;
            while (this.TID < this.numTokens) {
                this.predkeys = this.cfvals[this.TID].keys();
                int i = 0;
                while (i < this.predkeys.length) {
                    this.OID = this.predkeys[i];
                    this.cfvals[this.TID].put(this.OID, this.constant - this.cfvals[this.TID].get(this.OID));
                    ++i;
                }
                ++this.TID;
            }
            int cfvalSum = 0;
            this.TID = 0;
            while (this.TID < this.numTokens) {
                cfvalSum += (this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID];
                ++this.TID;
            }
            this.cfObservedExpect = Math.log(cfvalSum);
            this.display("done.\n");
        } else {
            this.pabi = new TIntDoubleHashMap[this.numTokens];
            this.TID = 0;
            while (this.TID < this.numTokens) {
                this.pabi[this.TID] = new TIntDoubleHashMap(initialCapacity, loadFactor);
                int j = 0;
                while (j < this.contexts[this.TID].length) {
                    this.PID = this.contexts[this.TID][j];
                    this.predkeys = this.params[this.PID].keys();
                    int i = 0;
                    while (i < this.predkeys.length) {
                        this.pabi[this.TID].put(this.predkeys[i], 0.0);
                        ++i;
                    }
                    ++j;
                }
                this.pabi[this.TID].compact();
                ++this.TID;
            }
        }
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, this.constant, this.correctionParam);
    }
}

