/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.Splitter;

public class PDFSplit {
    private static final String PASSWORD = "-password";
    private static final String SPLIT = "-split";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String NONSEQ = "-nonSeq";

    private PDFSplit() {
    }

    public static void main(String[] args) throws Exception {
        PDFSplit split = new PDFSplit();
        split.split(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void split(String[] args) throws Exception {
        List<PDDocument> documents;
        block30: {
            String password = "";
            String split = null;
            String startPage = null;
            String endPage = null;
            boolean useNonSeqParser = false;
            Splitter splitter = new Splitter();
            String pdfFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        PDFSplit.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(SPLIT)) {
                    if (++i >= args.length) {
                        PDFSplit.usage();
                    }
                    split = args[i];
                    continue;
                }
                if (args[i].equals(START_PAGE)) {
                    if (++i >= args.length) {
                        PDFSplit.usage();
                    }
                    startPage = args[i];
                    continue;
                }
                if (args[i].equals(END_PAGE)) {
                    if (++i >= args.length) {
                        PDFSplit.usage();
                    }
                    endPage = args[i];
                    continue;
                }
                if (args[i].equals(NONSEQ)) {
                    useNonSeqParser = true;
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (pdfFile == null) {
                PDFSplit.usage();
                return;
            }
            PDDocument document = null;
            documents = null;
            try {
                if (useNonSeqParser) {
                    document = PDDocument.loadNonSeq(new File(pdfFile), null, password);
                } else {
                    document = PDDocument.load(pdfFile);
                    if (document.isEncrypted()) {
                        try {
                            document.decrypt(password);
                        }
                        catch (InvalidPasswordException e) {
                            if (args.length == 4) {
                                System.err.println("Error: The supplied password is incorrect.");
                                System.exit(2);
                            }
                            System.err.println("Error: The document is encrypted.");
                            PDFSplit.usage();
                        }
                    }
                }
                int numberOfPages = document.getNumberOfPages();
                boolean startEndPageSet = false;
                if (startPage != null) {
                    splitter.setStartPage(Integer.parseInt(startPage));
                    if (split == null) {
                        splitter.setSplitAtPage(numberOfPages);
                    }
                }
                if (endPage != null) {
                    splitter.setEndPage(Integer.parseInt(endPage));
                    if (split == null) {
                        splitter.setSplitAtPage(Integer.parseInt(endPage));
                    }
                }
                if (split != null) {
                    splitter.setSplitAtPage(Integer.parseInt(split));
                } else if (!startEndPageSet) {
                    splitter.setSplitAtPage(1);
                }
                documents = splitter.split(document);
                for (int i = 0; i < documents.size(); ++i) {
                    PDDocument doc = documents.get(i);
                    String fileName = pdfFile.substring(0, pdfFile.length() - 4) + "-" + i + ".pdf";
                    PDFSplit.writeDocument(doc, fileName);
                    doc.close();
                }
                if (document == null) break block30;
            }
            catch (Throwable throwable) {
                if (document != null) {
                    document.close();
                }
                for (int i = 0; documents != null && i < documents.size(); ++i) {
                    PDDocument doc = (PDDocument)documents.get(i);
                    doc.close();
                }
                throw throwable;
            }
            document.close();
        }
        for (int i = 0; documents != null && i < documents.size(); ++i) {
            PDDocument doc = documents.get(i);
            doc.close();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeDocument(PDDocument doc, String fileName) throws IOException, COSVisitorException {
        FileOutputStream output = null;
        COSWriter writer = null;
        try {
            output = new FileOutputStream(fileName);
            writer = new COSWriter(output);
            writer.write(doc);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PDFSplit [OPTIONS] <PDF file>\n  -password  <password>  Password to decrypt document\n  -split     <integer>   split after this many pages (default 1, if startPage and endPage are unset)\n  -startPage <integer>   start page\n  -endPage   <integer>   end page\n  -nonSeq                Enables the new non-sequential parser\n  <PDF file>             The PDF document to use\n");
        System.exit(1);
    }
}

