/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RenderingHintsProxy;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.RenderContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.ROIShape;

public class RenderContextProxy
implements Serializable {
    private transient RenderContext renderContext;

    public RenderContextProxy(RenderContext renderContext) {
        this.renderContext = renderContext;
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.renderContext == null;
        objectOutputStream.writeBoolean(bl);
        if (bl) {
            return;
        }
        AffineTransform affineTransform = this.renderContext.getTransform();
        RenderingHintsProxy renderingHintsProxy = new RenderingHintsProxy(this.renderContext.getRenderingHints());
        Shape shape = this.renderContext.getAreaOfInterest();
        objectOutputStream.writeObject(affineTransform);
        objectOutputStream.writeBoolean(shape != null);
        if (shape != null) {
            if (shape instanceof Serializable) {
                objectOutputStream.writeObject(shape);
            } else {
                objectOutputStream.writeObject(new ROIShape(shape));
            }
        }
        objectOutputStream.writeObject(renderingHintsProxy);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readBoolean()) {
            this.renderContext = null;
            return;
        }
        AffineTransform affineTransform = (AffineTransform)objectInputStream.readObject();
        Shape shape = null;
        Object object = objectInputStream.readBoolean() ? objectInputStream.readObject() : null;
        RenderingHintsProxy renderingHintsProxy = (RenderingHintsProxy)objectInputStream.readObject();
        RenderingHints renderingHints = renderingHintsProxy.getRenderingHints();
        if (object != null) {
            shape = object instanceof ROIShape ? ((ROIShape)object).getAsShape() : (Shape)object;
        }
        this.renderContext = object == null && renderingHints.isEmpty() ? new RenderContext(affineTransform) : (object == null ? new RenderContext(affineTransform, renderingHints) : (renderingHints.isEmpty() ? new RenderContext(affineTransform, shape) : new RenderContext(affineTransform, shape, renderingHints)));
    }
}

