/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MedianFilterShape;

abstract class MedianFilterOpImage
extends AreaOpImage {
    protected MedianFilterShape maskType;
    protected int maskSize;

    public MedianFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MedianFilterShape medianFilterShape, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n - 1) / 2, (n - 1) / 2, n / 2, n / 2);
        this.maskType = medianFilterShape;
        this.maskSize = n;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, this.maskSize);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected int medianFilter(int[] nArray) {
        if (nArray.length == 3) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            if (n < n2) {
                if (n2 < n3) {
                    return n2;
                }
                if (n3 > n) {
                    return n3;
                }
                return n;
            }
            if (n < n3) {
                return n;
            }
            if (n2 < n3) {
                return n3;
            }
            return n2;
        }
        int n = 0;
        int n4 = nArray.length - 1;
        int n5 = nArray.length / 2;
        while (true) {
            int n6 = n;
            int n7 = n4;
            int n8 = nArray[(n + n4) / 2];
            while (true) {
                if (nArray[n] < n8) {
                    ++n;
                    continue;
                }
                while (n8 < nArray[n4]) {
                    --n4;
                }
                if (n <= n4) {
                    int n9 = nArray[n];
                    nArray[n] = nArray[n4];
                    nArray[n4] = n9;
                    ++n;
                    --n4;
                }
                if (n > n4) break;
            }
            if (n6 < n4 && n4 >= n5) {
                n = n6;
                continue;
            }
            if (n >= n7 || n > n5) break;
            n4 = n7;
        }
        return nArray[n5];
    }

    protected float medianFilterFloat(float[] fArray) {
        if (fArray.length == 3) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (f < f2) {
                if (f2 < f3) {
                    return f2;
                }
                if (f3 > f) {
                    return f3;
                }
                return f;
            }
            if (f < f3) {
                return f;
            }
            if (f2 < f3) {
                return f3;
            }
            return f2;
        }
        int n = 0;
        int n2 = fArray.length - 1;
        int n3 = fArray.length / 2;
        while (true) {
            int n4 = n;
            int n5 = n2;
            float f = fArray[(n + n2) / 2];
            while (true) {
                if (fArray[n] < f) {
                    ++n;
                    continue;
                }
                while (f < fArray[n2]) {
                    --n2;
                }
                if (n <= n2) {
                    float f4 = fArray[n];
                    fArray[n] = fArray[n2];
                    fArray[n2] = f4;
                    ++n;
                    --n2;
                }
                if (n > n2) break;
            }
            if (n4 < n2 && n2 >= n3) {
                n = n4;
                continue;
            }
            if (n >= n5 || n > n3) break;
            n2 = n5;
        }
        return fArray[n3];
    }

    protected double medianFilterDouble(double[] dArray) {
        if (dArray.length == 3) {
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            if (d < d2) {
                if (d2 < d3) {
                    return d2;
                }
                if (d3 > d) {
                    return d3;
                }
                return d;
            }
            if (d < d3) {
                return d;
            }
            if (d2 < d3) {
                return d3;
            }
            return d2;
        }
        int n = 0;
        int n2 = dArray.length - 1;
        int n3 = dArray.length / 2;
        while (true) {
            int n4 = n;
            int n5 = n2;
            double d = dArray[(n + n2) / 2];
            while (true) {
                if (dArray[n] < d) {
                    ++n;
                    continue;
                }
                while (d < dArray[n2]) {
                    --n2;
                }
                if (n <= n2) {
                    double d4 = dArray[n];
                    dArray[n] = dArray[n2];
                    dArray[n2] = d4;
                    ++n;
                    --n2;
                }
                if (n > n2) break;
            }
            if (n4 < n2 && n2 >= n3) {
                n = n4;
                continue;
            }
            if (n >= n5 || n > n3) break;
            n2 = n5;
        }
        return dArray[n3];
    }
}

