/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.opimage.FFT;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;

public class FFTmediaLib
extends FFT {
    private boolean specialUnitaryScaling = false;
    private static final double SQUARE_ROOT_OF_2 = Math.sqrt(2.0);

    public FFTmediaLib(boolean bl, Integer n, int n2) {
        super(bl, n, n2);
    }

    public void setLength(int n) {
        if (this.lengthIsSet && n == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n)) {
            throw new RuntimeException(JaiI18N.getString("FFTmediaLib0"));
        }
        this.length = n;
        if (!this.lengthIsSet || n != this.real.length) {
            this.real = new double[n];
            this.imag = new double[n];
        }
        this.lengthIsSet = true;
        if (this.scaleType == FFT.SCALING_UNITARY) {
            int n2 = 0;
            int n3 = 1;
            while (n3 < n) {
                n3 <<= 1;
                ++n2;
            }
            this.specialUnitaryScaling = n2 % 2 != 0;
        }
    }

    public void getData(int n, Object object, int n2, int n3, Object object2, int n4, int n5) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n6 = 0;
                        while (n6 < this.length) {
                            fArray[n2] = (float)this.real[n6];
                            fArray2[n2] = (float)this.imag[n6];
                            n2 += n3;
                            ++n6;
                        }
                    } else {
                        int n7 = 0;
                        while (n7 < this.length) {
                            fArray[n2] = (float)this.real[n7];
                            fArray2[n4] = (float)this.imag[n7];
                            n2 += n3;
                            n4 += n5;
                            ++n7;
                        }
                    }
                } else {
                    int n8 = 0;
                    while (n8 < this.length) {
                        fArray[n2] = (float)this.real[n8];
                        n2 += n3;
                        ++n8;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n2 == n4 && n3 == n5) {
                        int n9 = 0;
                        while (n9 < this.length) {
                            dArray[n2] = this.real[n9];
                            dArray2[n2] = this.imag[n9];
                            n2 += n3;
                            ++n9;
                        }
                    } else {
                        int n10 = 0;
                        while (n10 < this.length) {
                            dArray[n2] = this.real[n10];
                            dArray2[n4] = this.imag[n10];
                            n2 += n3;
                            n4 += n5;
                            ++n10;
                        }
                    }
                } else {
                    int n11 = 0;
                    while (n11 < this.length) {
                        dArray[n2] = this.real[n11];
                        n2 += n3;
                        ++n11;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFTmediaLib1"));
            }
        }
    }

    public void transform() {
        if (this.exponentSign < 0) {
            if (this.scaleType == FFT.SCALING_NONE) {
                Image.FFT_1((double[])this.real, (double[])this.imag);
            } else if (this.scaleType == FFT.SCALING_UNITARY) {
                Image.FFT_3((double[])this.real, (double[])this.imag);
                if (this.specialUnitaryScaling) {
                    int n = 0;
                    while (n < this.length) {
                        int n2 = n;
                        this.real[n2] = this.real[n2] * SQUARE_ROOT_OF_2;
                        int n3 = n++;
                        this.imag[n3] = this.imag[n3] * SQUARE_ROOT_OF_2;
                    }
                }
            } else if (this.scaleType == FFT.SCALING_DIMENSIONS) {
                Image.FFT_2((double[])this.real, (double[])this.imag);
            }
        } else if (this.scaleType == FFT.SCALING_NONE) {
            Image.IFFT_2((double[])this.real, (double[])this.imag);
        } else if (this.scaleType == FFT.SCALING_UNITARY) {
            Image.IFFT_3((double[])this.real, (double[])this.imag);
            if (this.specialUnitaryScaling) {
                int n = 0;
                while (n < this.length) {
                    int n4 = n;
                    this.real[n4] = this.real[n4] / SQUARE_ROOT_OF_2;
                    int n5 = n++;
                    this.imag[n5] = this.imag[n5] / SQUARE_ROOT_OF_2;
                }
            }
        } else if (this.scaleType == FFT.SCALING_DIMENSIONS) {
            Image.IFFT_1((double[])this.real, (double[])this.imag);
        }
    }
}

