/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    public void setDataOffset(int n) {
        void dataOffset;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (dataOffset == -1) {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.dataOffset = dataOffset;
    }

    public long[] getSampleOffsets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        long[] result = new long[this.entries.size()];
        long offset = 0L;
        int i = 0;
        while (i < result.length) {
            result[i] = offset;
            offset = this.isSampleSizePresent() ? (offset += this.entries.get(i).getSampleSize()) : (offset += ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleSize());
            ++i;
        }
        return result;
    }

    public long[] getSampleSizes() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        long[] result = new long[this.entries.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.isSampleSizePresent() ? this.entries.get(i).getSampleSize() : ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleSize();
            ++i;
        }
        return result;
    }

    public long[] getSampleCompositionTimeOffsets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] result = new long[this.entries.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.entries.get(i).getSampleCompositionTimeOffset();
                ++i;
            }
            return result;
        }
        return null;
    }

    public long[] getSampleDurations() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        long[] result = new long[this.entries.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.isSampleDurationPresent() ? this.entries.get(i).getSampleDuration() : ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox().getDefaultSampleDuration();
            ++i;
        }
        return result;
    }

    public TrackRunBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            size += 4L;
        }
        if ((flags & 4) == 4) {
            size += 4L;
        }
        long entrySize = 0L;
        if ((flags & 0x100) == 256) {
            entrySize += 4L;
        }
        if ((flags & 0x200) == 512) {
            entrySize += 4L;
        }
        if ((flags & 0x400) == 1024) {
            entrySize += 4L;
        }
        if ((flags & 0x800) == 2048) {
            entrySize += 4L;
        }
        return size += entrySize * (long)this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer bb) throws IOException {
        this.writeVersionAndFlags(bb);
        IsoTypeWriter.writeUInt32(bb, this.entries.size());
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            IsoTypeWriter.writeUInt32(bb, this.dataOffset);
        }
        if ((flags & 4) == 4) {
            this.firstSampleFlags.getContent(bb);
        }
        for (Entry entry : this.entries) {
            if ((flags & 0x100) == 256) {
                IsoTypeWriter.writeUInt32(bb, entry.sampleDuration);
            }
            if ((flags & 0x200) == 512) {
                IsoTypeWriter.writeUInt32(bb, entry.sampleSize);
            }
            if ((flags & 0x400) == 1024) {
                entry.sampleFlags.getContent(bb);
            }
            if ((flags & 0x800) != 2048) continue;
            bb.putInt(entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        long sampleCount = IsoTypeReader.readUInt32(content);
        this.dataOffset = (this.getFlags() & 1) == 1 ? CastUtils.l2i(IsoTypeReader.readUInt32(content)) : -1;
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(content);
        }
        int i = 0;
        while ((long)i < sampleCount) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(content);
            }
            if ((this.getFlags() & 0x800) == 2048) {
                entry.sampleCompositionTimeOffset = content.getInt();
            }
            this.entries.add(entry);
            ++i;
        }
    }

    public long getSampleCount() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 1) == 1;
    }

    public boolean isFirstSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 4) == 4;
    }

    public boolean isSampleSizePresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x200) == 512;
    }

    public boolean isSampleDurationPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x100) == 256;
    }

    public boolean isSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x400) == 1024;
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x800) == 2048;
    }

    /*
     * WARNING - void declaration
     */
    public void setDataOffsetPresent(boolean bl) {
        void v;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v != false) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleSizePresent(boolean bl) {
        void v;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v != false) {
            this.setFlags(this.getFlags() | 0x200);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFF);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleDurationPresent(boolean bl) {
        void v;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v != false) {
            this.setFlags(this.getFlags() | 0x100);
        } else {
            this.setFlags(this.getFlags() & 0xFFFEFF);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleFlagsPresent(boolean bl) {
        void v;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v != false) {
            this.setFlags(this.getFlags() | 0x400);
        } else {
            this.setFlags(this.getFlags() & 0xFFFBFF);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleCompositionTimeOffsetPresent(boolean bl) {
        void v;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v != false) {
            this.setFlags(this.getFlags() | 0x800);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FF);
        }
    }

    public int getDataOffset() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_18, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.dataOffset;
    }

    public SampleFlags getFirstSampleFlags() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_19, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.firstSampleFlags;
    }

    public String getFirstSampleFlags4View() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_20, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.firstSampleFlags != null ? this.firstSampleFlags.toString() : "";
    }

    /*
     * WARNING - void declaration
     */
    public void setFirstSampleFlags(SampleFlags sampleFlags) {
        void firstSampleFlags;
        SampleFlags sampleFlags2 = sampleFlags;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_21, (Object)this, (Object)this, sampleFlags2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (firstSampleFlags == null) {
            this.setFlags(this.getFlags() & 0xFFFFFB);
        } else {
            this.setFlags(this.getFlags() | 4);
        }
        this.firstSampleFlags = firstSampleFlags;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_22, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        StringBuilder sb = new StringBuilder();
        sb.append("TrackRunBox");
        sb.append("{sampleCount=").append(this.entries.size());
        sb.append(", dataOffset=").append(this.dataOffset);
        sb.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        sb.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        sb.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        sb.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresent());
        sb.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        sb.append(", firstSampleFlags=").append(this.firstSampleFlags);
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setEntries(List<Entry> list) {
        void entries;
        List<Entry> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_23, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    static {
        TrackRunBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackRunBox.java", TrackRunBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "java.util.List"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffset", "com.coremedia.iso.boxes.fragment.TrackRunBox", "int", "dataOffset", "", "void"), 117);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleDurationPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 292);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 296);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleCompositionTimeOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 300);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 304);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleSizePresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 312);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleDurationPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 320);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 329);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleCompositionTimeOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "boolean", "v", "", "void"), 337);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataOffset", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "int"), 346);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstSampleFlags", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "com.coremedia.iso.boxes.fragment.SampleFlags"), 350);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleOffsets", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "[J"), 126);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstSampleFlags4View", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "java.lang.String"), 354);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFirstSampleFlags", "com.coremedia.iso.boxes.fragment.TrackRunBox", "com.coremedia.iso.boxes.fragment.SampleFlags", "firstSampleFlags", "", "void"), 358);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "java.lang.String"), 368);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.coremedia.iso.boxes.fragment.TrackRunBox", "java.util.List", "entries", "", "void"), 383);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleSizes", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "[J"), 142);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCompositionTimeOffsets", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "[J"), 156);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleDurations", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "[J"), 168);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCount", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "long"), 275);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDataOffsetPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 279);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirstSampleFlagsPresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 283);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleSizePresent", "com.coremedia.iso.boxes.fragment.TrackRunBox", "", "", "", "boolean"), 288);
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private int sampleCompositionTimeOffset;

        public Entry() {
        }

        public Entry(long sampleDuration, long sampleSize, SampleFlags sampleFlags, int sampleCompositionTimeOffset) {
            this.sampleDuration = sampleDuration;
            this.sampleSize = sampleSize;
            this.sampleFlags = sampleFlags;
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public SampleFlags getSampleFlags() {
            return this.sampleFlags;
        }

        public int getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleDuration(long sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public void setSampleSize(long sampleSize) {
            this.sampleSize = sampleSize;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public void setSampleCompositionTimeOffset(int sampleCompositionTimeOffset) {
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public String toString() {
            return "Entry{sampleDuration=" + this.sampleDuration + ", sampleSize=" + this.sampleSize + ", sampleFlags=" + this.sampleFlags + ", sampleCompositionTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

