package IPC::Semaphore::Set::Resource;
use strict;
use warnings;

use 5.008;
use IPC::SysV qw(SEM_UNDO IPC_NOWAIT);

our $VERSION = 0.05;

############
## Public ##
############

sub new
{
	my $class = shift;
	my $args  = ref($_[0]) ? $_[0] : {@_};
	if (ref($args->{set}) ne 'IPC::Semaphore::Set') {
		die "'set' is a required field and must be a IPC::Semaphore::Set";
	}
	if (!defined($args->{number})) {
		die "'number' is a required field, you must provide the resource number you want from the set";
	}
	my $self = bless($args, $class);
	if (!defined($self->available)) {
		my $total = () = $self->set->sem->getall;
		die $self->number . ' is not a valid resource for semaphore [' . $self->set->key
			. "] which only has [$total] total resources. The resources start at 0.";
	}
	return bless($args, $class);
}

sub lockOrDie {
	my $self = shift;
	if ($self->_lock(SEM_UNDO | IPC_NOWAIT)) {
		return 1;
	} else {
		die 'could not lock on semaphore [' . $self->set->key . '] resource number [' . $self->number . ']';
	}
}

sub lock     {return shift->_lock(SEM_UNDO | IPC_NOWAIT) ? 1 : 0}
sub lockWait {return shift->_lock(SEM_UNDO)              ? 1 : 0}
sub addValue {return shift->_add_value(IPC_NOWAIT) ? 1 : 0}

############
## Helper ##
############

sub available {
	my $self = shift;
	return $self->set->sem->getval($self->number);
}

sub number {return shift->{number}}
sub set    {return shift->{set}}
sub value  {return shift->available}

#############
## Private ##
#############

sub _lock
{
	my ($self, $flags) = @_;
	return $self->set->sem->op($self->number, -1, $flags);
}

sub _add_value
{
	my ($self, $flags) = @_;
	return $self->set->sem->op($self->number, 1, $flags);
}

1;

__END__

=head1 NAME

IPC::Semaphore::Set::Resource;

=head1 DESCRIPTION

A simple interface to a resource available in a semaphore set.

Main documentation is in IPC::Semaphore::Set.

=cut

