use Test::More tests => 13;

BEGIN {
	use_ok( 'IPC::Semaphore::Set' );
	use_ok( 'IPC::Semaphore::Set::Resource' );
};

#############
## LOCKING ##
#############

{
	my $semset = IPC::Semaphore::Set->new(
		key_name  => 'IPC::Semaphore::Set Tests',
		resources => 10,
		available => 3,
	);
	isa_ok($semset, 'IPC::Semaphore::Set');
	is($semset->resource->lock, 1, 'Able to lock');
	is($semset->resource->lock, 1, 'Able to lock a second time');
	is($semset->resource->lock, 1, 'Able to lock a third time');
	is($semset->resource->lock, 0, 'Unable to lock a fourth time');
	eval{$semset->resource->lockOrDie};
	my $error = ($@ =~ m/could not lock on semaphore/);
	is($error, 1, 'Died trying to get an unavailable resource');
	is($semset->resource->unlock, 1, 'Able to unlock');
	is($semset->resource->unlock, 1, 'Able to unlock a second time');
	is($semset->resource->unlock, 1, 'Able to unlock a third time');
	eval{$semset->resource->unlock};
	my $error = ($@ =~ m/tried to unlock resource/);
	is($error, 1, 'Failed to unlock fourth time');
	is($semset->remove, 1, 'Removed Semaphore');
}
