// This file is part of MorphoDiTa.
//
// Copyright 2013 by Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// MorphoDiTa is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of
// the License, or (at your option) any later version.
//
// MorphoDiTa is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with MorphoDiTa.  If not, see <http://www.gnu.org/licenses/>.

#include <cstring>
#include <unordered_set>

#include "english_tokenizer.h"
#include "../utils/utf8.h"

namespace ufal {
namespace morphodita {


static const char _english_tokenizer_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2
};

static const char _english_tokenizer_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _english_tokenizer_cond_keys[] = {
	43u, 43u, 45u, 45u, 0
};

static const char _english_tokenizer_cond_spaces[] = {
	1, 0, 0
};

static const short _english_tokenizer_key_offsets[] = {
	0, 0, 1, 2, 3, 5, 8, 9, 
	10, 45, 76, 77, 81, 113, 144, 175, 
	206, 236, 243, 246, 256, 277, 279, 295, 
	323, 355, 377, 379, 380, 382, 392, 394, 
	398, 399, 431, 459, 467, 475, 483, 491, 
	507, 513, 515, 516, 534, 535, 536, 539, 
	546, 552, 563, 566, 568, 580, 601, 611, 
	612, 622, 627, 650, 662, 676, 704, 718, 
	723, 724, 731, 737, 741, 744, 746, 747, 
	749, 765, 769, 773, 785, 787, 799, 806, 
	810, 812, 816, 820, 824, 827, 829, 831, 
	833, 834, 836, 846, 848, 864, 873, 876, 
	877, 888, 902, 914, 927, 936, 944, 951, 
	959, 965, 973, 990, 992, 1000, 1009, 1017, 
	1026, 1034, 1043, 1051, 1059, 1070, 1080, 1088, 
	1096, 1107, 1117, 1125, 1133, 1144, 1154, 1170, 
	1172, 1173, 1175, 1176, 1178, 1187, 1193, 1196, 
	1197, 1200, 1207, 1213, 1224, 1227, 1237, 1238, 
	1250, 1255, 1256, 1262, 1269, 1271, 1274, 1305, 
	1323, 1339, 1355, 1371, 1372, 1373, 1388, 1410, 
	1432, 1454, 1476, 1500, 1522, 1524, 1526, 1528, 
	1540, 1542, 1544, 1554, 1556, 1560, 1566, 1567, 
	1570, 1571, 1576, 1578, 1579, 1581, 1583, 1595, 
	1605, 1607, 1609, 1621, 1623, 1625, 1635, 1637, 
	1641, 1647, 1648, 1651, 1652, 1657, 1659, 1660, 
	1662, 1664, 1674, 1684, 1694, 1696, 1698, 1710, 
	1712, 1714, 1724, 1726, 1730, 1736, 1737, 1740, 
	1741, 1746, 1748, 1749, 1751, 1753, 1755, 1757, 
	1769, 1771, 1773, 1783, 1785, 1789, 1795, 1796, 
	1799, 1800, 1805, 1807, 1808, 1810, 1812, 1814, 
	1816, 1828, 1830, 1832, 1842, 1844, 1848, 1854, 
	1855, 1858, 1859, 1864, 1866, 1867, 1869, 1879, 
	1894, 1910, 1924, 1940, 1955, 1969, 1985, 1997, 
	2013, 2029, 2046, 2062, 2079, 2104, 2121, 2137, 
	2154, 2171, 2188, 2205, 2225, 2244, 2260, 2276, 
	2295, 2313, 2338, 2361, 2383, 2408, 2431, 2433, 
	2435, 2437, 2449, 2451, 2453, 2463, 2465, 2469, 
	2475, 2476, 2479, 2480, 2485, 2487, 2488, 2490, 
	2516, 2532, 2548, 2551, 2563, 2565, 2567, 2573, 
	2575, 2583, 2589, 2597, 2601, 2605, 2609, 2614, 
	2619, 2628, 2632, 2636, 2647, 2649, 2653, 2655, 
	2658, 2690, 2692, 2694, 2697, 2699, 2705, 2720, 
	2733, 2752, 2764, 2780, 2789, 2805, 2818, 2839, 
	2847, 2861, 2873, 2887, 2900, 2910, 2921, 2930, 
	2940, 2942, 2944, 2965, 2972, 2980, 2986, 2992, 
	2993, 3037, 3043, 3051, 3062, 3072, 3079, 3085, 
	3089, 3093, 3095, 3097, 3101, 3105, 3107, 3113, 
	3121, 3126, 3130, 3132, 3136, 3138, 3144, 3148, 
	3152, 3154, 3158, 3163, 3164, 3168, 3172, 3174, 
	3178, 3182, 3186, 3192, 3203, 3208, 3222, 3238, 
	3239, 3241, 3243, 3245, 3261, 3264, 3266, 3270, 
	3274, 3278, 3284, 3288, 3298, 3308, 3309, 3319, 
	3327, 3335, 3339, 3343, 3347, 3349, 3354, 3356, 
	3359, 3361, 3385, 3387, 3393, 3398, 3402, 3406, 
	3410, 3418, 3420, 3422, 3427, 3431, 3435, 3437, 
	3439, 3445, 3453, 3463, 3467, 3471, 3475, 3479, 
	3498, 3502, 3504, 3515, 3521, 3523, 3525, 3529, 
	3533, 3537, 3541, 3543, 3545, 3549, 3551, 3559, 
	3572, 3596, 3605, 3609, 3611, 3612, 3616, 3618, 
	3622, 3625, 3629, 3633, 3635, 3644, 3646, 3650, 
	3654, 3667, 3669, 3673, 3675, 3683, 3685, 3687, 
	3689, 3692, 3694, 3697, 3703, 3705, 3709, 3711, 
	3712, 3714, 3730, 3736, 3742, 3744, 3748, 3762, 
	3766, 3778, 3785, 3789, 3796, 3802, 3808, 3814, 
	3818, 3821, 3835, 3861, 3871, 3874, 3876, 3880, 
	3883, 3884, 3887, 3889, 3905, 3906, 3922, 3923, 
	3934, 3935, 3950, 3966, 3983, 3999, 4016, 4032, 
	4049, 4065, 4081, 4100, 4118, 4134, 4150, 4169, 
	4187, 4203, 4219, 4238, 4256, 4272, 4273, 4289, 
	4290, 4291, 4292, 4296, 4298, 4300, 4302, 4387, 
	4395, 4402, 4408, 4415, 4423, 4424, 4432, 4433, 
	4441, 4472, 4482, 4499, 4502, 4512, 4522, 4532, 
	4542, 4555, 4567, 4581, 4599, 4631, 4658, 4676, 
	4700, 4722, 4732, 4744, 4748, 4765, 4779, 4796, 
	4822, 4848, 4872, 4898, 4924, 4953, 4981, 5008, 
	5032, 5046, 5073, 5100, 5130, 5159, 5175, 5227, 
	5290, 5340, 5391, 5442, 5507, 5560, 5601, 5654, 
	5694, 5735, 5790, 5833, 5876, 5929, 5980, 6032, 
	6084, 6136, 6188, 6205, 6222, 6239, 6259, 6278, 
	6330, 6382, 6436, 6488, 6540, 6594, 6648, 6700, 
	6765, 6818, 6873, 6916, 6972, 7026, 7080, 7134, 
	7188, 7240, 7294, 7348, 7402, 7456, 7510, 7564, 
	7618, 7670, 7733, 7786, 7840, 7892, 7894, 7896, 
	7902, 7912, 7955, 7959, 7961, 7975, 7986, 7994, 
	7997, 8003, 8009, 8016, 8020, 8030, 8034, 8045, 
	8061, 8079, 8086, 8090, 8095, 8106, 8138, 8145, 
	8149, 8156, 8163, 8176, 8197, 8211, 8229, 8244, 
	8256, 8267, 8285, 8297, 8327, 8334, 8345, 8359, 
	8373, 8382, 8395, 8407, 8411, 8417, 8425, 8452, 
	8465, 8472, 8477, 8483, 8529, 8534, 8557, 8568, 
	8577, 8590, 8603, 8611, 8618, 8622, 8628, 8632, 
	8635, 8641, 8648, 8652, 8661, 8670, 8674, 8682, 
	8690, 8694, 8701, 8705, 8709, 8721, 8725, 8734, 
	8740, 8744, 8753, 8759, 8769, 8781, 8785, 8789, 
	8801, 8812, 8822, 8838, 8843, 8867, 8884, 8892, 
	8896, 8902, 8920, 8925, 8931, 8954, 8961, 8967, 
	8970, 8973, 8985, 8993, 8998, 9008, 9015, 9018, 
	9030, 9045, 9052, 9055, 9063, 9071, 9075, 9079, 
	9081, 9084, 9088, 9117, 9123, 9135, 9140, 9146, 
	9154, 9167, 9171, 9178, 9184, 9195, 9203, 9211, 
	9217, 9224, 9228, 9242, 9255, 9272, 9290, 9298, 
	9304, 9310, 9318, 9339, 9345, 9349, 9364, 9368, 
	9372, 9376, 9380, 9384, 9390, 9398, 9403, 9407, 
	9417, 9424, 9427, 9445, 9462, 9489, 9495, 9503, 
	9507, 9513, 9517, 9523, 9528, 9534, 9542, 9550, 
	9562, 9566, 9574, 9580, 9589, 9595, 9603, 9607, 
	9618, 9624, 9630, 9636, 9646, 9654, 9660, 9669, 
	9673, 9678, 9682, 9687, 9697, 9701, 9706, 9712, 
	9715, 9719, 9736, 9739, 9754, 9757, 9768, 9776, 
	9782, 9787, 9791, 9795, 9799, 9806, 9811, 9826, 
	9855, 9866, 9869, 9873, 9879, 9883, 9890, 9905, 
	9928, 9954
};

static const short _english_tokenizer_trans_keys[] = {
	160u, 154u, 128u, 128u, 129u, 175u, 128u, 138u, 
	159u, 128u, 13u, 32u, 34u, 40u, 91u, 96u, 
	123u, 194u, 195u, 196u, 197u, 198u, 199u, 200u, 
	201u, 205u, 206u, 207u, 208u, 209u, 210u, 211u, 
	212u, 213u, 224u, 225u, 226u, 227u, 234u, 239u, 
	240u, 9u, 10u, 65u, 90u, 34u, 40u, 91u, 
	96u, 123u, 194u, 195u, 196u, 197u, 198u, 199u, 
	200u, 201u, 205u, 206u, 207u, 208u, 209u, 210u, 
	211u, 212u, 213u, 224u, 225u, 226u, 227u, 234u, 
	239u, 240u, 65u, 90u, 171u, 128u, 150u, 152u, 
	158u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 185u, 187u, 189u, 
	191u, 129u, 131u, 133u, 135u, 138u, 140u, 142u, 
	144u, 146u, 148u, 150u, 152u, 154u, 156u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 187u, 189u, 184u, 185u, 
	132u, 162u, 164u, 169u, 172u, 181u, 188u, 129u, 
	130u, 134u, 135u, 137u, 139u, 142u, 145u, 147u, 
	148u, 150u, 152u, 156u, 157u, 159u, 160u, 166u, 
	167u, 174u, 175u, 177u, 179u, 183u, 184u, 141u, 
	143u, 145u, 147u, 149u, 151u, 153u, 155u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	180u, 186u, 188u, 190u, 132u, 133u, 135u, 136u, 
	138u, 139u, 177u, 178u, 182u, 184u, 128u, 130u, 
	132u, 134u, 136u, 138u, 140u, 142u, 144u, 146u, 
	148u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 176u, 178u, 
	186u, 187u, 189u, 190u, 129u, 136u, 138u, 140u, 
	142u, 131u, 134u, 176u, 178u, 182u, 134u, 140u, 
	136u, 138u, 142u, 143u, 145u, 161u, 163u, 171u, 
	143u, 152u, 154u, 156u, 158u, 160u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 180u, 183u, 146u, 
	148u, 185u, 186u, 189u, 191u, 128u, 175u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 131u, 133u, 135u, 137u, 139u, 
	141u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 184u, 186u, 188u, 
	190u, 128u, 129u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 177u, 
	191u, 128u, 150u, 188u, 186u, 188u, 130u, 131u, 
	154u, 186u, 188u, 189u, 190u, 191u, 184u, 187u, 
	160u, 191u, 135u, 141u, 128u, 133u, 155u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 150u, 152u, 154u, 156u, 158u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 136u, 143u, 152u, 157u, 168u, 
	175u, 184u, 191u, 153u, 155u, 157u, 159u, 136u, 
	141u, 168u, 175u, 136u, 143u, 152u, 159u, 168u, 
	175u, 184u, 188u, 136u, 140u, 152u, 155u, 168u, 
	172u, 184u, 188u, 128u, 129u, 130u, 132u, 133u, 
	134u, 140u, 157u, 159u, 166u, 167u, 176u, 177u, 
	178u, 179u, 184u, 152u, 185u, 154u, 156u, 158u, 
	159u, 133u, 189u, 141u, 130u, 135u, 149u, 164u, 
	166u, 168u, 139u, 141u, 144u, 146u, 153u, 157u, 
	170u, 173u, 176u, 179u, 190u, 191u, 133u, 131u, 
	136u, 138u, 169u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 133u, 166u, 168u, 170u, 172u, 174u, 
	131u, 133u, 135u, 137u, 139u, 141u, 143u, 145u, 
	147u, 149u, 151u, 152u, 154u, 188u, 128u, 174u, 
	160u, 167u, 169u, 171u, 178u, 181u, 162u, 164u, 
	173u, 176u, 190u, 191u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 171u, 173u, 
	178u, 130u, 132u, 137u, 140u, 156u, 160u, 162u, 
	164u, 166u, 168u, 128u, 136u, 138u, 140u, 142u, 
	144u, 148u, 150u, 152u, 154u, 157u, 153u, 154u, 
	156u, 157u, 158u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 185u, 187u, 189u, 190u, 
	128u, 130u, 132u, 134u, 139u, 141u, 144u, 146u, 
	160u, 162u, 164u, 166u, 168u, 170u, 180u, 184u, 
	185u, 188u, 189u, 190u, 151u, 181u, 183u, 185u, 
	187u, 189u, 191u, 129u, 131u, 135u, 153u, 155u, 
	157u, 136u, 187u, 161u, 186u, 155u, 159u, 162u, 
	144u, 157u, 144u, 128u, 167u, 144u, 145u, 146u, 
	147u, 148u, 149u, 150u, 151u, 152u, 153u, 154u, 
	155u, 156u, 157u, 158u, 159u, 128u, 153u, 180u, 
	191u, 128u, 141u, 168u, 191u, 156u, 162u, 128u, 
	129u, 158u, 159u, 165u, 166u, 169u, 172u, 174u, 
	181u, 144u, 169u, 132u, 133u, 135u, 138u, 141u, 
	148u, 150u, 156u, 184u, 185u, 187u, 190u, 134u, 
	128u, 132u, 138u, 144u, 172u, 191u, 128u, 133u, 
	160u, 185u, 148u, 173u, 136u, 161u, 188u, 191u, 
	128u, 149u, 176u, 191u, 128u, 137u, 168u, 191u, 
	128u, 162u, 186u, 156u, 180u, 150u, 174u, 144u, 
	168u, 138u, 160u, 171u, 130u, 131u, 154u, 186u, 
	188u, 189u, 190u, 191u, 184u, 187u, 128u, 155u, 
	128u, 129u, 130u, 132u, 133u, 134u, 140u, 157u, 
	159u, 166u, 167u, 176u, 177u, 178u, 179u, 184u, 
	152u, 175u, 185u, 128u, 138u, 154u, 156u, 158u, 
	159u, 133u, 159u, 189u, 128u, 128u, 136u, 138u, 
	140u, 142u, 144u, 148u, 150u, 152u, 154u, 157u, 
	33u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 64u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 39u, 41u, 
	61u, 95u, 36u, 47u, 48u, 57u, 58u, 59u, 
	63u, 64u, 65u, 90u, 97u, 122u, 48u, 57u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	48u, 49u, 50u, 51u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 48u, 49u, 50u, 51u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 48u, 49u, 50u, 51u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 53u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 53u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 53u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 34u, 39u, 41u, 59u, 
	93u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 160u, 187u, 188u, 187u, 189u, 154u, 
	128u, 156u, 128u, 129u, 130u, 140u, 157u, 159u, 
	166u, 167u, 184u, 153u, 157u, 175u, 186u, 128u, 
	138u, 134u, 159u, 190u, 142u, 137u, 139u, 170u, 
	169u, 171u, 173u, 175u, 177u, 179u, 181u, 134u, 
	167u, 169u, 171u, 173u, 175u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	153u, 155u, 189u, 131u, 133u, 138u, 141u, 157u, 
	161u, 163u, 165u, 167u, 169u, 128u, 128u, 137u, 
	139u, 141u, 143u, 145u, 149u, 151u, 153u, 155u, 
	158u, 159u, 180u, 184u, 185u, 188u, 189u, 191u, 
	152u, 182u, 184u, 186u, 188u, 190u, 128u, 130u, 
	132u, 136u, 154u, 156u, 158u, 137u, 189u, 157u, 
	160u, 163u, 13u, 32u, 33u, 34u, 40u, 58u, 
	59u, 64u, 93u, 95u, 125u, 194u, 224u, 225u, 
	226u, 227u, 239u, 9u, 10u, 36u, 37u, 39u, 
	41u, 42u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 73u, 87u, 95u, 105u, 
	119u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 58u, 64u, 83u, 95u, 
	115u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 58u, 64u, 65u, 95u, 
	97u, 36u, 37u, 39u, 46u, 48u, 57u, 66u, 
	90u, 98u, 122u, 33u, 58u, 64u, 83u, 95u, 
	115u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 128u, 153u, 33u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 45u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 43u, 45u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 160u, 169u, 176u, 185u, 128u, 137u, 
	165u, 167u, 169u, 171u, 173u, 175u, 177u, 179u, 
	181u, 185u, 187u, 188u, 166u, 175u, 144u, 153u, 
	129u, 130u, 159u, 160u, 165u, 167u, 170u, 173u, 
	174u, 177u, 134u, 143u, 128u, 137u, 144u, 153u, 
	152u, 163u, 164u, 167u, 169u, 175u, 188u, 144u, 
	145u, 157u, 146u, 129u, 131u, 132u, 135u, 155u, 
	182u, 191u, 159u, 142u, 191u, 160u, 169u, 43u, 
	45u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 48u, 57u, 176u, 185u, 128u, 
	137u, 165u, 167u, 169u, 171u, 173u, 175u, 177u, 
	179u, 181u, 185u, 187u, 188u, 166u, 175u, 144u, 
	153u, 129u, 130u, 159u, 160u, 165u, 167u, 170u, 
	173u, 174u, 177u, 134u, 143u, 128u, 137u, 144u, 
	153u, 152u, 163u, 164u, 167u, 169u, 175u, 188u, 
	144u, 145u, 157u, 146u, 129u, 131u, 132u, 135u, 
	155u, 182u, 191u, 159u, 142u, 191u, 160u, 169u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 48u, 57u, 176u, 185u, 
	128u, 137u, 165u, 167u, 169u, 171u, 173u, 175u, 
	177u, 179u, 181u, 185u, 187u, 188u, 166u, 175u, 
	144u, 153u, 129u, 130u, 159u, 160u, 165u, 167u, 
	170u, 173u, 174u, 177u, 134u, 143u, 128u, 137u, 
	144u, 153u, 152u, 163u, 164u, 167u, 169u, 175u, 
	188u, 144u, 145u, 157u, 146u, 129u, 131u, 132u, 
	135u, 155u, 182u, 191u, 159u, 142u, 191u, 160u, 
	169u, 176u, 185u, 128u, 137u, 165u, 167u, 169u, 
	171u, 173u, 175u, 177u, 179u, 181u, 185u, 187u, 
	188u, 166u, 175u, 144u, 153u, 129u, 130u, 159u, 
	160u, 165u, 167u, 170u, 173u, 174u, 177u, 134u, 
	143u, 128u, 137u, 144u, 153u, 152u, 163u, 164u, 
	167u, 169u, 175u, 188u, 144u, 145u, 157u, 146u, 
	129u, 131u, 132u, 135u, 155u, 182u, 191u, 159u, 
	142u, 191u, 160u, 169u, 176u, 185u, 128u, 137u, 
	165u, 167u, 169u, 171u, 173u, 175u, 177u, 179u, 
	181u, 185u, 187u, 188u, 166u, 175u, 144u, 153u, 
	129u, 130u, 159u, 160u, 165u, 167u, 170u, 173u, 
	174u, 177u, 134u, 143u, 128u, 137u, 144u, 153u, 
	152u, 163u, 164u, 167u, 169u, 175u, 188u, 144u, 
	145u, 157u, 146u, 129u, 131u, 132u, 135u, 155u, 
	182u, 191u, 159u, 142u, 191u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 48u, 57u, 33u, 
	45u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	48u, 49u, 50u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 51u, 57u, 65u, 90u, 97u, 122u, 
	33u, 48u, 49u, 50u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 53u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 43u, 45u, 46u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	43u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 160u, 
	169u, 176u, 185u, 128u, 137u, 165u, 167u, 169u, 
	171u, 173u, 175u, 177u, 179u, 181u, 185u, 187u, 
	188u, 166u, 175u, 144u, 153u, 129u, 130u, 159u, 
	160u, 165u, 167u, 170u, 173u, 174u, 177u, 134u, 
	143u, 128u, 137u, 144u, 153u, 152u, 163u, 164u, 
	167u, 169u, 175u, 188u, 144u, 145u, 157u, 146u, 
	129u, 131u, 132u, 135u, 155u, 182u, 191u, 159u, 
	142u, 191u, 33u, 58u, 64u, 68u, 76u, 77u, 
	82u, 83u, 86u, 95u, 100u, 108u, 109u, 114u, 
	115u, 118u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 76u, 
	95u, 108u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 69u, 
	95u, 101u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 170u, 181u, 186u, 68u, 
	76u, 77u, 82u, 83u, 86u, 100u, 108u, 109u, 
	114u, 115u, 118u, 76u, 108u, 69u, 101u, 128u, 
	150u, 152u, 182u, 184u, 191u, 128u, 191u, 172u, 
	174u, 128u, 129u, 134u, 145u, 160u, 164u, 128u, 
	180u, 182u, 183u, 186u, 189u, 134u, 140u, 136u, 
	138u, 142u, 161u, 163u, 191u, 128u, 181u, 183u, 
	191u, 128u, 129u, 131u, 191u, 128u, 167u, 177u, 
	191u, 153u, 128u, 150u, 161u, 191u, 191u, 128u, 
	135u, 145u, 189u, 135u, 129u, 130u, 132u, 133u, 
	144u, 170u, 176u, 178u, 144u, 154u, 160u, 191u, 
	128u, 159u, 174u, 191u, 191u, 128u, 147u, 149u, 
	156u, 159u, 168u, 170u, 175u, 186u, 188u, 144u, 
	191u, 128u, 138u, 141u, 191u, 128u, 177u, 186u, 
	138u, 181u, 160u, 161u, 162u, 163u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 171u, 172u, 173u, 
	174u, 175u, 176u, 177u, 178u, 179u, 180u, 181u, 
	182u, 183u, 184u, 185u, 186u, 187u, 188u, 189u, 
	190u, 191u, 128u, 173u, 128u, 155u, 160u, 162u, 
	172u, 164u, 190u, 128u, 163u, 177u, 183u, 185u, 
	191u, 178u, 129u, 131u, 133u, 140u, 143u, 144u, 
	147u, 168u, 170u, 176u, 182u, 185u, 188u, 191u, 
	151u, 128u, 132u, 135u, 136u, 139u, 142u, 156u, 
	157u, 159u, 163u, 176u, 177u, 188u, 129u, 131u, 
	133u, 138u, 143u, 144u, 147u, 168u, 170u, 176u, 
	178u, 179u, 181u, 182u, 184u, 185u, 190u, 191u, 
	145u, 158u, 128u, 130u, 135u, 136u, 139u, 141u, 
	153u, 156u, 176u, 181u, 129u, 131u, 133u, 141u, 
	143u, 145u, 147u, 168u, 170u, 176u, 178u, 179u, 
	181u, 185u, 188u, 191u, 144u, 128u, 133u, 135u, 
	137u, 139u, 141u, 160u, 163u, 129u, 131u, 133u, 
	140u, 143u, 144u, 147u, 168u, 170u, 176u, 178u, 
	179u, 181u, 185u, 188u, 191u, 177u, 128u, 132u, 
	135u, 136u, 139u, 141u, 150u, 151u, 156u, 157u, 
	159u, 163u, 156u, 130u, 131u, 133u, 138u, 142u, 
	144u, 146u, 149u, 153u, 154u, 158u, 159u, 163u, 
	164u, 168u, 170u, 174u, 185u, 190u, 191u, 144u, 
	151u, 128u, 130u, 134u, 136u, 138u, 141u, 129u, 
	131u, 133u, 140u, 142u, 144u, 146u, 168u, 170u, 
	179u, 181u, 185u, 189u, 191u, 128u, 132u, 134u, 
	136u, 138u, 141u, 149u, 150u, 152u, 153u, 160u, 
	163u, 130u, 131u, 133u, 140u, 142u, 144u, 146u, 
	168u, 170u, 179u, 181u, 185u, 188u, 191u, 158u, 
	128u, 132u, 134u, 136u, 138u, 141u, 149u, 150u, 
	160u, 163u, 177u, 178u, 130u, 131u, 133u, 140u, 
	142u, 144u, 146u, 186u, 189u, 191u, 151u, 128u, 
	132u, 134u, 136u, 138u, 142u, 160u, 163u, 186u, 
	191u, 189u, 130u, 131u, 133u, 150u, 154u, 177u, 
	179u, 187u, 138u, 150u, 128u, 134u, 143u, 148u, 
	152u, 159u, 178u, 179u, 129u, 186u, 128u, 142u, 
	132u, 138u, 141u, 165u, 167u, 129u, 130u, 135u, 
	136u, 148u, 151u, 153u, 159u, 161u, 163u, 170u, 
	171u, 173u, 185u, 187u, 189u, 134u, 128u, 132u, 
	136u, 141u, 156u, 159u, 128u, 181u, 183u, 185u, 
	152u, 153u, 190u, 191u, 128u, 135u, 137u, 172u, 
	177u, 191u, 128u, 132u, 134u, 151u, 153u, 188u, 
	134u, 129u, 130u, 131u, 137u, 138u, 139u, 140u, 
	141u, 142u, 143u, 144u, 153u, 154u, 155u, 156u, 
	157u, 159u, 160u, 161u, 162u, 163u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 172u, 173u, 174u, 
	175u, 176u, 177u, 179u, 183u, 188u, 189u, 190u, 
	191u, 128u, 158u, 180u, 187u, 128u, 143u, 154u, 
	157u, 160u, 191u, 135u, 141u, 128u, 133u, 144u, 
	186u, 188u, 191u, 152u, 128u, 136u, 138u, 141u, 
	144u, 150u, 154u, 157u, 160u, 191u, 128u, 136u, 
	138u, 141u, 144u, 176u, 178u, 181u, 184u, 190u, 
	128u, 130u, 133u, 136u, 150u, 152u, 191u, 128u, 
	144u, 146u, 149u, 152u, 191u, 128u, 154u, 157u, 
	159u, 128u, 143u, 160u, 191u, 128u, 180u, 129u, 
	191u, 128u, 172u, 175u, 191u, 129u, 154u, 160u, 
	191u, 128u, 170u, 128u, 140u, 142u, 148u, 160u, 
	180u, 128u, 147u, 160u, 172u, 174u, 176u, 178u, 
	179u, 151u, 128u, 147u, 156u, 157u, 139u, 141u, 
	160u, 191u, 128u, 183u, 128u, 170u, 176u, 191u, 
	128u, 181u, 128u, 156u, 160u, 171u, 176u, 187u, 
	144u, 173u, 176u, 180u, 128u, 171u, 176u, 191u, 
	128u, 137u, 128u, 155u, 160u, 191u, 191u, 128u, 
	158u, 160u, 188u, 167u, 128u, 139u, 171u, 179u, 
	128u, 175u, 186u, 191u, 128u, 179u, 141u, 143u, 
	154u, 189u, 144u, 146u, 148u, 182u, 128u, 166u, 
	188u, 191u, 128u, 149u, 152u, 157u, 160u, 191u, 
	153u, 155u, 157u, 128u, 133u, 136u, 141u, 144u, 
	151u, 159u, 189u, 190u, 128u, 180u, 182u, 188u, 
	130u, 132u, 134u, 140u, 144u, 147u, 150u, 155u, 
	160u, 172u, 178u, 180u, 182u, 188u, 128u, 129u, 
	130u, 131u, 132u, 133u, 134u, 176u, 177u, 178u, 
	179u, 180u, 181u, 182u, 183u, 184u, 153u, 177u, 
	191u, 144u, 156u, 144u, 176u, 130u, 135u, 149u, 
	164u, 166u, 168u, 138u, 147u, 153u, 157u, 170u, 
	173u, 175u, 185u, 188u, 191u, 142u, 133u, 137u, 
	131u, 132u, 128u, 174u, 176u, 191u, 128u, 158u, 
	160u, 191u, 128u, 164u, 171u, 179u, 167u, 173u, 
	128u, 165u, 176u, 191u, 175u, 191u, 128u, 167u, 
	128u, 150u, 160u, 166u, 168u, 174u, 176u, 182u, 
	184u, 190u, 128u, 134u, 136u, 142u, 144u, 150u, 
	152u, 158u, 160u, 191u, 175u, 128u, 129u, 130u, 
	131u, 132u, 133u, 134u, 135u, 144u, 191u, 133u, 
	134u, 170u, 175u, 177u, 181u, 187u, 188u, 128u, 
	150u, 153u, 154u, 157u, 159u, 161u, 191u, 128u, 
	186u, 188u, 191u, 133u, 173u, 177u, 191u, 128u, 
	142u, 160u, 186u, 176u, 191u, 182u, 128u, 181u, 
	184u, 191u, 128u, 191u, 191u, 128u, 190u, 128u, 
	140u, 146u, 147u, 152u, 153u, 154u, 155u, 156u, 
	158u, 159u, 160u, 161u, 163u, 164u, 165u, 167u, 
	168u, 169u, 171u, 172u, 175u, 128u, 170u, 176u, 
	191u, 144u, 189u, 128u, 140u, 144u, 159u, 170u, 
	171u, 191u, 128u, 178u, 180u, 189u, 128u, 151u, 
	159u, 191u, 128u, 165u, 176u, 177u, 151u, 159u, 
	162u, 191u, 128u, 136u, 139u, 142u, 144u, 147u, 
	160u, 170u, 184u, 191u, 128u, 167u, 187u, 128u, 
	132u, 160u, 183u, 138u, 173u, 176u, 191u, 128u, 
	147u, 160u, 188u, 128u, 143u, 128u, 182u, 128u, 
	141u, 160u, 182u, 186u, 187u, 128u, 130u, 155u, 
	157u, 160u, 175u, 178u, 182u, 129u, 134u, 137u, 
	142u, 145u, 150u, 160u, 166u, 168u, 174u, 128u, 
	170u, 172u, 173u, 158u, 159u, 128u, 157u, 128u, 
	163u, 176u, 191u, 128u, 134u, 139u, 187u, 169u, 
	171u, 172u, 173u, 174u, 175u, 180u, 181u, 182u, 
	183u, 184u, 185u, 187u, 188u, 189u, 190u, 191u, 
	164u, 186u, 128u, 173u, 176u, 191u, 128u, 153u, 
	190u, 128u, 134u, 147u, 151u, 157u, 168u, 170u, 
	182u, 184u, 188u, 128u, 129u, 131u, 132u, 134u, 
	191u, 147u, 191u, 128u, 189u, 128u, 143u, 146u, 
	191u, 128u, 135u, 176u, 187u, 128u, 143u, 160u, 
	166u, 176u, 180u, 182u, 191u, 128u, 188u, 161u, 
	186u, 129u, 154u, 166u, 191u, 128u, 190u, 130u, 
	135u, 138u, 143u, 146u, 151u, 154u, 156u, 144u, 
	145u, 146u, 147u, 150u, 155u, 157u, 158u, 170u, 
	171u, 175u, 160u, 169u, 128u, 129u, 130u, 131u, 
	135u, 138u, 139u, 140u, 141u, 142u, 143u, 146u, 
	160u, 161u, 164u, 166u, 168u, 169u, 172u, 173u, 
	176u, 177u, 144u, 145u, 191u, 128u, 139u, 141u, 
	166u, 168u, 186u, 188u, 189u, 128u, 141u, 144u, 
	157u, 128u, 186u, 189u, 128u, 156u, 160u, 191u, 
	128u, 144u, 128u, 158u, 176u, 191u, 128u, 130u, 
	137u, 128u, 157u, 160u, 191u, 128u, 131u, 136u, 
	143u, 128u, 157u, 136u, 188u, 191u, 128u, 133u, 
	138u, 181u, 183u, 184u, 128u, 149u, 128u, 149u, 
	160u, 185u, 128u, 183u, 190u, 191u, 191u, 128u, 
	131u, 133u, 134u, 140u, 147u, 149u, 151u, 153u, 
	179u, 184u, 186u, 160u, 188u, 128u, 149u, 160u, 
	178u, 128u, 136u, 128u, 129u, 130u, 131u, 132u, 
	134u, 135u, 154u, 128u, 134u, 144u, 168u, 128u, 
	132u, 141u, 128u, 140u, 128u, 174u, 144u, 128u, 
	143u, 168u, 188u, 189u, 190u, 160u, 167u, 128u, 
	184u, 128u, 132u, 144u, 190u, 143u, 159u, 128u, 
	128u, 129u, 133u, 134u, 137u, 145u, 146u, 147u, 
	148u, 149u, 154u, 155u, 156u, 157u, 158u, 159u, 
	144u, 153u, 165u, 169u, 173u, 178u, 187u, 191u, 
	128u, 130u, 133u, 139u, 170u, 173u, 130u, 132u, 
	128u, 148u, 150u, 191u, 162u, 187u, 128u, 156u, 
	158u, 159u, 165u, 166u, 169u, 172u, 174u, 185u, 
	189u, 191u, 128u, 131u, 133u, 191u, 128u, 133u, 
	135u, 138u, 141u, 148u, 150u, 156u, 158u, 185u, 
	187u, 190u, 134u, 128u, 132u, 138u, 144u, 146u, 
	191u, 128u, 165u, 168u, 191u, 128u, 130u, 154u, 
	156u, 186u, 188u, 191u, 128u, 148u, 150u, 180u, 
	182u, 191u, 128u, 142u, 144u, 174u, 176u, 191u, 
	128u, 136u, 138u, 168u, 170u, 191u, 128u, 130u, 
	132u, 139u, 184u, 185u, 186u, 164u, 167u, 185u, 
	187u, 128u, 131u, 133u, 159u, 161u, 162u, 169u, 
	178u, 180u, 183u, 130u, 135u, 137u, 139u, 148u, 
	151u, 153u, 155u, 157u, 159u, 164u, 190u, 141u, 
	143u, 145u, 146u, 161u, 162u, 167u, 170u, 172u, 
	178u, 180u, 183u, 185u, 188u, 128u, 137u, 139u, 
	155u, 161u, 163u, 165u, 169u, 171u, 187u, 155u, 
	128u, 191u, 128u, 150u, 156u, 160u, 128u, 159u, 
	168u, 160u, 167u, 160u, 135u, 132u, 134u, 128u, 
	175u, 128u, 129u, 130u, 131u, 132u, 133u, 134u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 153u, 128u, 129u, 130u, 131u, 132u, 133u, 
	134u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 153u, 33u, 47u, 95u, 36u, 37u, 
	39u, 57u, 65u, 90u, 97u, 122u, 47u, 33u, 
	48u, 49u, 50u, 95u, 36u, 37u, 39u, 46u, 
	51u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 48u, 
	49u, 50u, 58u, 64u, 95u, 36u, 37u, 39u, 
	46u, 51u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	48u, 49u, 50u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 51u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 48u, 49u, 50u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 53u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 53u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	128u, 129u, 130u, 131u, 132u, 133u, 134u, 176u, 
	177u, 178u, 179u, 180u, 181u, 182u, 183u, 184u, 
	153u, 128u, 129u, 130u, 131u, 132u, 133u, 134u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 153u, 128u, 152u, 73u, 87u, 105u, 119u, 
	83u, 115u, 65u, 97u, 83u, 115u, 9u, 10u, 
	13u, 32u, 33u, 38u, 39u, 44u, 46u, 47u, 
	48u, 49u, 50u, 63u, 67u, 68u, 71u, 76u, 
	77u, 87u, 95u, 96u, 99u, 100u, 103u, 108u, 
	109u, 119u, 194u, 195u, 203u, 204u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 301u, 
	557u, 811u, 1067u, 0u, 35u, 36u, 42u, 51u, 
	57u, 58u, 64u, 65u, 90u, 91u, 94u, 97u, 
	122u, 123u, 127u, 128u, 193u, 196u, 218u, 229u, 
	236u, 238u, 255u, 9u, 10u, 13u, 32u, 194u, 
	225u, 226u, 227u, 9u, 13u, 32u, 194u, 225u, 
	226u, 227u, 9u, 32u, 194u, 225u, 226u, 227u, 
	9u, 10u, 32u, 194u, 225u, 226u, 227u, 9u, 
	10u, 13u, 32u, 194u, 225u, 226u, 227u, 13u, 
	9u, 10u, 13u, 32u, 194u, 225u, 226u, 227u, 
	10u, 9u, 10u, 13u, 32u, 194u, 225u, 226u, 
	227u, 13u, 32u, 33u, 34u, 40u, 58u, 59u, 
	64u, 93u, 95u, 125u, 194u, 224u, 225u, 226u, 
	227u, 239u, 9u, 10u, 36u, 37u, 39u, 41u, 
	42u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 39u, 41u, 61u, 95u, 36u, 
	47u, 48u, 57u, 58u, 59u, 63u, 64u, 65u, 
	90u, 97u, 122u, 47u, 48u, 57u, 45u, 46u, 
	47u, 58u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 47u, 58u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	47u, 53u, 58u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 47u, 58u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 39u, 58u, 
	64u, 84u, 95u, 116u, 226u, 36u, 37u, 40u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 13u, 
	32u, 33u, 34u, 40u, 46u, 58u, 59u, 64u, 
	93u, 95u, 125u, 194u, 224u, 225u, 226u, 227u, 
	239u, 9u, 10u, 36u, 37u, 39u, 41u, 42u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	44u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 43u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 44u, 46u, 58u, 64u, 69u, 
	95u, 101u, 36u, 37u, 39u, 45u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 69u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 48u, 57u, 
	44u, 46u, 69u, 101u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 47u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 53u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 44u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 43u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	44u, 46u, 69u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 48u, 57u, 33u, 44u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 43u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 44u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 43u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 44u, 45u, 46u, 
	53u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 43u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 44u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 43u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 13u, 
	32u, 34u, 39u, 41u, 59u, 93u, 125u, 194u, 
	224u, 225u, 226u, 227u, 239u, 9u, 10u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 58u, 64u, 
	68u, 76u, 77u, 78u, 82u, 83u, 86u, 95u, 
	100u, 108u, 109u, 110u, 114u, 115u, 118u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 58u, 64u, 68u, 
	76u, 77u, 78u, 82u, 83u, 84u, 86u, 95u, 
	100u, 108u, 109u, 110u, 114u, 115u, 116u, 118u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 58u, 64u, 
	76u, 78u, 95u, 108u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	39u, 45u, 78u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 68u, 76u, 77u, 78u, 82u, 
	83u, 86u, 100u, 108u, 109u, 110u, 114u, 115u, 
	118u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 39u, 78u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 39u, 45u, 
	78u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 39u, 
	45u, 68u, 76u, 77u, 78u, 82u, 83u, 84u, 
	86u, 100u, 108u, 109u, 110u, 114u, 115u, 116u, 
	118u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 39u, 45u, 
	76u, 78u, 108u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 69u, 78u, 101u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 58u, 
	64u, 69u, 78u, 95u, 101u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 78u, 95u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 78u, 95u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 39u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	78u, 95u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 46u, 58u, 64u, 65u, 78u, 95u, 97u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 78u, 95u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 78u, 79u, 95u, 110u, 111u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	78u, 84u, 95u, 110u, 116u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 58u, 
	64u, 68u, 76u, 77u, 78u, 82u, 83u, 86u, 
	89u, 95u, 100u, 108u, 109u, 110u, 114u, 115u, 
	118u, 121u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	58u, 64u, 69u, 78u, 95u, 101u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 39u, 45u, 68u, 76u, 77u, 78u, 
	82u, 83u, 86u, 89u, 100u, 108u, 109u, 110u, 
	114u, 115u, 118u, 121u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 69u, 78u, 101u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 73u, 78u, 79u, 95u, 105u, 110u, 
	111u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 77u, 78u, 95u, 109u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	77u, 78u, 95u, 109u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 69u, 78u, 
	95u, 101u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 46u, 58u, 64u, 78u, 84u, 95u, 110u, 
	116u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 78u, 95u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 65u, 78u, 
	95u, 97u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 66u, 90u, 
	98u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 46u, 58u, 64u, 78u, 84u, 95u, 110u, 
	116u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 65u, 78u, 95u, 97u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 44u, 
	48u, 57u, 66u, 90u, 98u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	69u, 78u, 95u, 101u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 79u, 
	95u, 110u, 111u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 46u, 58u, 64u, 78u, 82u, 95u, 110u, 
	114u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 46u, 
	58u, 64u, 69u, 78u, 95u, 101u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	78u, 95u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 58u, 64u, 68u, 76u, 77u, 78u, 82u, 
	83u, 86u, 95u, 100u, 108u, 109u, 110u, 114u, 
	115u, 118u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 39u, 45u, 68u, 
	76u, 77u, 78u, 82u, 83u, 86u, 100u, 108u, 
	109u, 110u, 114u, 115u, 118u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 46u, 58u, 64u, 
	65u, 78u, 95u, 97u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 44u, 48u, 57u, 
	66u, 90u, 98u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 96u, 226u, 128u, 191u, 
	160u, 170u, 181u, 186u, 128u, 191u, 9u, 10u, 
	13u, 32u, 194u, 225u, 226u, 227u, 128u, 191u, 
	39u, 45u, 78u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 128u, 191u, 196u, 
	218u, 229u, 236u, 151u, 183u, 128u, 191u, 128u, 
	191u, 172u, 174u, 128u, 129u, 130u, 133u, 134u, 
	145u, 146u, 159u, 160u, 164u, 165u, 191u, 181u, 
	128u, 175u, 176u, 183u, 184u, 185u, 186u, 189u, 
	190u, 191u, 134u, 139u, 141u, 162u, 128u, 135u, 
	136u, 191u, 182u, 128u, 191u, 128u, 129u, 130u, 
	137u, 138u, 191u, 128u, 167u, 168u, 176u, 177u, 
	191u, 153u, 128u, 150u, 151u, 160u, 161u, 191u, 
	128u, 135u, 136u, 191u, 128u, 143u, 144u, 170u, 
	171u, 175u, 176u, 178u, 179u, 191u, 128u, 159u, 
	160u, 191u, 176u, 128u, 138u, 139u, 159u, 160u, 
	169u, 170u, 173u, 174u, 191u, 44u, 46u, 69u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 128u, 191u, 148u, 191u, 128u, 
	149u, 150u, 164u, 165u, 166u, 167u, 173u, 174u, 
	175u, 176u, 185u, 186u, 188u, 189u, 190u, 144u, 
	128u, 145u, 146u, 175u, 176u, 191u, 128u, 140u, 
	141u, 191u, 177u, 128u, 165u, 166u, 191u, 186u, 
	128u, 137u, 138u, 170u, 171u, 179u, 180u, 181u, 
	182u, 191u, 160u, 161u, 162u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 171u, 172u, 173u, 174u, 
	175u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 185u, 186u, 187u, 188u, 189u, 190u, 
	128u, 191u, 154u, 164u, 168u, 128u, 149u, 150u, 
	191u, 128u, 152u, 153u, 191u, 160u, 128u, 161u, 
	162u, 172u, 173u, 191u, 189u, 128u, 131u, 132u, 
	185u, 186u, 191u, 144u, 176u, 184u, 128u, 151u, 
	152u, 161u, 162u, 165u, 166u, 175u, 177u, 191u, 
	169u, 177u, 189u, 128u, 132u, 133u, 140u, 141u, 
	142u, 143u, 144u, 145u, 146u, 147u, 178u, 179u, 
	181u, 182u, 185u, 186u, 191u, 142u, 158u, 128u, 
	155u, 156u, 161u, 162u, 165u, 166u, 175u, 176u, 
	177u, 178u, 191u, 169u, 177u, 180u, 183u, 128u, 
	132u, 133u, 138u, 139u, 142u, 143u, 144u, 145u, 
	146u, 147u, 185u, 186u, 191u, 157u, 128u, 152u, 
	153u, 158u, 159u, 165u, 166u, 175u, 176u, 177u, 
	178u, 180u, 181u, 191u, 142u, 146u, 169u, 177u, 
	180u, 189u, 128u, 132u, 133u, 185u, 186u, 191u, 
	144u, 128u, 159u, 160u, 161u, 162u, 165u, 166u, 
	175u, 176u, 191u, 169u, 177u, 180u, 189u, 128u, 
	132u, 133u, 140u, 141u, 142u, 143u, 144u, 145u, 
	146u, 147u, 185u, 186u, 191u, 158u, 177u, 128u, 
	155u, 156u, 161u, 162u, 165u, 166u, 175u, 176u, 
	191u, 131u, 145u, 155u, 157u, 128u, 132u, 133u, 
	138u, 139u, 141u, 142u, 149u, 150u, 152u, 153u, 
	159u, 160u, 162u, 163u, 164u, 165u, 167u, 168u, 
	170u, 171u, 173u, 174u, 185u, 186u, 191u, 144u, 
	128u, 165u, 166u, 175u, 176u, 191u, 141u, 145u, 
	169u, 180u, 189u, 128u, 132u, 133u, 185u, 186u, 
	191u, 128u, 151u, 152u, 153u, 154u, 159u, 160u, 
	161u, 162u, 165u, 166u, 175u, 176u, 191u, 158u, 
	176u, 128u, 159u, 160u, 161u, 162u, 165u, 166u, 
	175u, 177u, 178u, 179u, 191u, 141u, 145u, 189u, 
	128u, 132u, 133u, 186u, 187u, 191u, 142u, 128u, 
	159u, 160u, 161u, 162u, 165u, 166u, 175u, 176u, 
	185u, 186u, 191u, 178u, 188u, 128u, 132u, 133u, 
	150u, 151u, 153u, 154u, 189u, 190u, 191u, 128u, 
	134u, 135u, 191u, 128u, 177u, 129u, 179u, 180u, 
	191u, 128u, 134u, 135u, 143u, 144u, 153u, 154u, 
	191u, 128u, 131u, 137u, 141u, 152u, 160u, 164u, 
	166u, 172u, 177u, 189u, 129u, 132u, 133u, 134u, 
	135u, 138u, 139u, 147u, 148u, 167u, 168u, 169u, 
	170u, 179u, 180u, 191u, 133u, 128u, 134u, 135u, 
	143u, 144u, 153u, 154u, 155u, 156u, 159u, 160u, 
	191u, 128u, 129u, 159u, 160u, 169u, 170u, 191u, 
	136u, 128u, 172u, 173u, 191u, 128u, 135u, 136u, 
	140u, 141u, 191u, 128u, 129u, 130u, 131u, 137u, 
	138u, 139u, 140u, 141u, 142u, 143u, 144u, 153u, 
	154u, 155u, 156u, 157u, 158u, 159u, 160u, 161u, 
	162u, 163u, 164u, 165u, 166u, 167u, 168u, 169u, 
	170u, 171u, 172u, 173u, 174u, 175u, 176u, 177u, 
	178u, 179u, 183u, 188u, 189u, 190u, 191u, 132u, 
	187u, 191u, 128u, 170u, 171u, 190u, 161u, 128u, 
	137u, 138u, 143u, 144u, 149u, 150u, 153u, 154u, 
	157u, 158u, 164u, 165u, 166u, 167u, 173u, 174u, 
	176u, 177u, 180u, 181u, 191u, 142u, 128u, 129u, 
	130u, 143u, 144u, 153u, 154u, 159u, 160u, 191u, 
	134u, 141u, 187u, 128u, 135u, 136u, 143u, 144u, 
	191u, 137u, 151u, 153u, 128u, 141u, 142u, 143u, 
	144u, 157u, 158u, 159u, 160u, 191u, 137u, 177u, 
	191u, 128u, 141u, 142u, 143u, 144u, 181u, 182u, 
	183u, 184u, 190u, 129u, 151u, 128u, 133u, 134u, 
	135u, 136u, 191u, 145u, 128u, 149u, 150u, 151u, 
	152u, 191u, 128u, 154u, 155u, 191u, 128u, 143u, 
	144u, 159u, 160u, 191u, 128u, 180u, 181u, 191u, 
	128u, 129u, 191u, 128u, 172u, 173u, 174u, 175u, 
	191u, 128u, 129u, 154u, 155u, 159u, 160u, 191u, 
	128u, 170u, 171u, 191u, 141u, 128u, 145u, 146u, 
	159u, 160u, 177u, 178u, 191u, 173u, 128u, 145u, 
	146u, 159u, 160u, 176u, 177u, 191u, 128u, 179u, 
	180u, 191u, 151u, 156u, 128u, 159u, 160u, 169u, 
	170u, 191u, 128u, 143u, 144u, 153u, 154u, 159u, 
	160u, 191u, 128u, 183u, 184u, 191u, 169u, 128u, 
	170u, 171u, 175u, 176u, 191u, 128u, 181u, 182u, 
	191u, 128u, 156u, 157u, 191u, 128u, 133u, 134u, 
	143u, 144u, 173u, 174u, 175u, 176u, 180u, 181u, 
	191u, 128u, 171u, 172u, 191u, 128u, 129u, 135u, 
	136u, 143u, 144u, 153u, 154u, 191u, 128u, 150u, 
	151u, 159u, 160u, 191u, 128u, 148u, 149u, 191u, 
	167u, 128u, 137u, 138u, 143u, 144u, 153u, 154u, 
	191u, 128u, 132u, 133u, 179u, 180u, 191u, 128u, 
	132u, 133u, 139u, 140u, 143u, 144u, 153u, 154u, 
	191u, 128u, 130u, 131u, 160u, 161u, 173u, 174u, 
	175u, 176u, 185u, 186u, 191u, 128u, 165u, 166u, 
	191u, 128u, 163u, 164u, 191u, 128u, 137u, 138u, 
	140u, 141u, 143u, 144u, 153u, 154u, 189u, 190u, 
	191u, 173u, 128u, 168u, 169u, 177u, 178u, 180u, 
	181u, 182u, 183u, 191u, 128u, 149u, 150u, 151u, 
	152u, 157u, 158u, 159u, 160u, 191u, 152u, 154u, 
	156u, 158u, 128u, 133u, 134u, 135u, 136u, 141u, 
	142u, 143u, 144u, 189u, 190u, 191u, 181u, 189u, 
	191u, 128u, 190u, 133u, 181u, 128u, 129u, 130u, 
	140u, 141u, 143u, 144u, 147u, 148u, 149u, 150u, 
	155u, 156u, 159u, 160u, 172u, 173u, 177u, 178u, 
	188u, 189u, 191u, 128u, 129u, 130u, 132u, 133u, 
	134u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 131u, 191u, 152u, 153u, 166u, 175u, 
	128u, 138u, 139u, 191u, 96u, 226u, 128u, 191u, 
	39u, 84u, 116u, 226u, 128u, 191u, 13u, 32u, 
	34u, 39u, 41u, 59u, 93u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 128u, 191u, 
	159u, 177u, 191u, 128u, 190u, 128u, 143u, 144u, 
	156u, 157u, 191u, 130u, 135u, 148u, 164u, 166u, 
	168u, 174u, 128u, 137u, 138u, 149u, 150u, 152u, 
	153u, 157u, 158u, 169u, 170u, 185u, 186u, 187u, 
	188u, 191u, 142u, 128u, 132u, 133u, 137u, 138u, 
	191u, 128u, 130u, 131u, 132u, 133u, 191u, 175u, 
	128u, 191u, 159u, 128u, 191u, 128u, 164u, 165u, 
	170u, 171u, 174u, 175u, 177u, 178u, 179u, 180u, 
	191u, 166u, 173u, 128u, 167u, 168u, 175u, 176u, 
	191u, 175u, 128u, 167u, 168u, 191u, 167u, 175u, 
	183u, 191u, 128u, 150u, 151u, 159u, 160u, 190u, 
	135u, 143u, 151u, 128u, 158u, 159u, 191u, 175u, 
	128u, 191u, 128u, 129u, 130u, 131u, 132u, 133u, 
	134u, 135u, 136u, 143u, 144u, 191u, 128u, 129u, 
	132u, 133u, 134u, 135u, 176u, 177u, 181u, 182u, 
	186u, 187u, 188u, 189u, 191u, 160u, 128u, 150u, 
	151u, 156u, 157u, 191u, 187u, 128u, 191u, 128u, 
	132u, 133u, 173u, 174u, 176u, 177u, 191u, 128u, 
	142u, 143u, 159u, 160u, 186u, 187u, 191u, 128u, 
	175u, 176u, 191u, 182u, 183u, 128u, 191u, 128u, 
	191u, 191u, 128u, 190u, 128u, 140u, 141u, 191u, 
	146u, 147u, 152u, 153u, 154u, 155u, 156u, 158u, 
	159u, 160u, 161u, 162u, 163u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 171u, 172u, 175u, 128u, 
	157u, 173u, 174u, 176u, 191u, 128u, 143u, 144u, 
	189u, 190u, 191u, 128u, 140u, 141u, 143u, 144u, 
	159u, 160u, 169u, 170u, 171u, 172u, 191u, 191u, 
	128u, 174u, 175u, 190u, 128u, 151u, 152u, 159u, 
	160u, 191u, 128u, 150u, 151u, 159u, 160u, 161u, 
	162u, 191u, 143u, 128u, 136u, 137u, 138u, 139u, 
	147u, 148u, 159u, 160u, 170u, 171u, 191u, 128u, 
	183u, 184u, 191u, 130u, 134u, 139u, 128u, 162u, 
	163u, 191u, 128u, 129u, 130u, 179u, 180u, 191u, 
	187u, 128u, 143u, 144u, 153u, 154u, 177u, 178u, 
	183u, 184u, 191u, 128u, 137u, 138u, 165u, 166u, 
	175u, 176u, 191u, 128u, 134u, 135u, 159u, 160u, 
	188u, 189u, 191u, 128u, 131u, 132u, 178u, 179u, 
	191u, 143u, 128u, 142u, 144u, 153u, 154u, 191u, 
	128u, 168u, 169u, 191u, 131u, 186u, 128u, 139u, 
	140u, 143u, 144u, 153u, 154u, 159u, 160u, 182u, 
	183u, 191u, 176u, 128u, 177u, 178u, 180u, 181u, 
	182u, 183u, 184u, 185u, 189u, 190u, 191u, 129u, 
	128u, 130u, 131u, 154u, 155u, 157u, 158u, 159u, 
	160u, 170u, 171u, 177u, 178u, 180u, 181u, 191u, 
	128u, 167u, 129u, 134u, 135u, 136u, 137u, 142u, 
	143u, 144u, 145u, 150u, 151u, 159u, 160u, 174u, 
	175u, 191u, 128u, 162u, 163u, 175u, 176u, 185u, 
	186u, 191u, 158u, 159u, 128u, 157u, 160u, 191u, 
	128u, 163u, 164u, 175u, 176u, 191u, 128u, 134u, 
	135u, 138u, 139u, 187u, 188u, 191u, 169u, 171u, 
	172u, 173u, 174u, 175u, 180u, 181u, 182u, 183u, 
	184u, 185u, 187u, 188u, 189u, 190u, 191u, 128u, 
	163u, 164u, 186u, 128u, 173u, 174u, 175u, 176u, 
	191u, 128u, 153u, 154u, 191u, 157u, 169u, 183u, 
	189u, 191u, 128u, 134u, 135u, 146u, 147u, 151u, 
	152u, 158u, 159u, 190u, 130u, 133u, 128u, 191u, 
	128u, 177u, 178u, 191u, 128u, 146u, 147u, 191u, 
	128u, 189u, 190u, 191u, 128u, 143u, 144u, 191u, 
	128u, 143u, 144u, 145u, 146u, 191u, 128u, 135u, 
	136u, 175u, 176u, 187u, 188u, 191u, 181u, 128u, 
	175u, 176u, 191u, 128u, 188u, 189u, 191u, 128u, 
	143u, 144u, 153u, 154u, 160u, 161u, 186u, 187u, 
	191u, 128u, 129u, 154u, 155u, 165u, 166u, 191u, 
	191u, 128u, 190u, 128u, 129u, 130u, 135u, 136u, 
	137u, 138u, 143u, 144u, 145u, 146u, 151u, 152u, 
	153u, 154u, 156u, 157u, 191u, 144u, 145u, 146u, 
	147u, 150u, 155u, 157u, 158u, 170u, 171u, 175u, 
	128u, 159u, 160u, 169u, 172u, 191u, 128u, 129u, 
	130u, 131u, 138u, 139u, 140u, 141u, 142u, 143u, 
	146u, 160u, 161u, 164u, 166u, 168u, 169u, 172u, 
	173u, 176u, 177u, 132u, 137u, 144u, 145u, 147u, 
	191u, 140u, 167u, 187u, 190u, 128u, 191u, 128u, 
	141u, 142u, 143u, 144u, 157u, 158u, 191u, 128u, 
	186u, 187u, 191u, 128u, 156u, 157u, 159u, 160u, 
	191u, 128u, 144u, 145u, 191u, 128u, 158u, 159u, 
	175u, 176u, 191u, 129u, 128u, 137u, 138u, 191u, 
	128u, 157u, 158u, 159u, 160u, 191u, 128u, 131u, 
	132u, 135u, 136u, 143u, 144u, 191u, 128u, 157u, 
	158u, 159u, 160u, 169u, 170u, 191u, 136u, 182u, 
	188u, 191u, 128u, 133u, 134u, 137u, 138u, 184u, 
	185u, 190u, 128u, 149u, 150u, 191u, 128u, 149u, 
	150u, 159u, 160u, 185u, 186u, 191u, 128u, 183u, 
	184u, 189u, 190u, 191u, 128u, 148u, 152u, 129u, 
	143u, 144u, 179u, 180u, 191u, 128u, 159u, 160u, 
	188u, 189u, 191u, 128u, 149u, 150u, 159u, 160u, 
	178u, 179u, 191u, 128u, 136u, 137u, 191u, 128u, 
	129u, 130u, 131u, 132u, 134u, 135u, 154u, 155u, 
	133u, 191u, 128u, 130u, 131u, 183u, 184u, 191u, 
	128u, 165u, 166u, 175u, 176u, 191u, 128u, 130u, 
	131u, 175u, 176u, 191u, 128u, 143u, 144u, 168u, 
	169u, 175u, 176u, 185u, 186u, 191u, 128u, 130u, 
	131u, 166u, 167u, 181u, 182u, 191u, 128u, 130u, 
	131u, 178u, 179u, 191u, 128u, 129u, 132u, 133u, 
	143u, 144u, 153u, 154u, 191u, 128u, 137u, 138u, 
	191u, 141u, 128u, 140u, 142u, 191u, 128u, 174u, 
	175u, 191u, 144u, 128u, 143u, 145u, 191u, 168u, 
	188u, 189u, 190u, 128u, 159u, 160u, 167u, 169u, 
	191u, 128u, 184u, 185u, 191u, 144u, 128u, 132u, 
	133u, 191u, 128u, 146u, 147u, 159u, 160u, 191u, 
	128u, 129u, 191u, 128u, 129u, 130u, 191u, 145u, 
	146u, 147u, 148u, 149u, 154u, 155u, 156u, 157u, 
	158u, 159u, 128u, 143u, 144u, 153u, 160u, 191u, 
	149u, 128u, 191u, 157u, 162u, 173u, 186u, 188u, 
	128u, 159u, 160u, 164u, 165u, 166u, 167u, 168u, 
	169u, 191u, 132u, 128u, 191u, 134u, 149u, 157u, 
	186u, 191u, 128u, 138u, 139u, 140u, 141u, 190u, 
	133u, 145u, 128u, 134u, 135u, 137u, 138u, 191u, 
	128u, 165u, 166u, 167u, 168u, 191u, 129u, 155u, 
	187u, 128u, 191u, 149u, 181u, 128u, 191u, 143u, 
	175u, 128u, 191u, 137u, 169u, 128u, 191u, 131u, 
	128u, 139u, 140u, 141u, 142u, 191u, 184u, 185u, 
	186u, 128u, 191u, 132u, 160u, 163u, 167u, 179u, 
	184u, 186u, 128u, 164u, 165u, 168u, 169u, 187u, 
	188u, 191u, 130u, 135u, 137u, 139u, 144u, 147u, 
	151u, 153u, 155u, 157u, 159u, 163u, 171u, 179u, 
	184u, 189u, 191u, 128u, 140u, 141u, 148u, 149u, 
	160u, 161u, 164u, 165u, 166u, 167u, 190u, 138u, 
	164u, 170u, 128u, 155u, 156u, 160u, 161u, 187u, 
	188u, 191u, 155u, 128u, 191u, 128u, 150u, 151u, 
	191u, 156u, 160u, 128u, 159u, 161u, 191u, 128u, 
	157u, 158u, 191u, 168u, 128u, 159u, 160u, 167u, 
	169u, 191u, 33u, 45u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 44u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 45u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	0
};

static const char _english_tokenizer_single_lengths[] = {
	0, 1, 1, 1, 2, 1, 1, 1, 
	31, 29, 1, 0, 32, 29, 7, 21, 
	26, 5, 3, 2, 15, 0, 16, 28, 
	30, 20, 0, 1, 2, 8, 0, 2, 
	1, 32, 28, 0, 4, 0, 0, 16, 
	2, 2, 1, 6, 1, 1, 3, 7, 
	6, 11, 3, 0, 6, 21, 10, 1, 
	10, 5, 23, 12, 14, 26, 14, 5, 
	1, 7, 6, 2, 3, 2, 1, 0, 
	16, 0, 0, 2, 0, 0, 1, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	1, 2, 8, 2, 16, 3, 3, 1, 
	11, 4, 2, 3, 3, 2, 1, 2, 
	0, 2, 5, 0, 2, 3, 2, 3, 
	2, 3, 2, 2, 3, 2, 2, 2, 
	3, 2, 2, 2, 3, 2, 14, 2, 
	1, 2, 1, 2, 9, 4, 3, 1, 
	3, 7, 6, 11, 3, 10, 1, 10, 
	5, 1, 6, 7, 2, 3, 17, 8, 
	6, 6, 6, 1, 1, 5, 12, 12, 
	12, 12, 14, 12, 0, 0, 0, 12, 
	0, 0, 10, 0, 0, 6, 1, 3, 
	1, 5, 0, 1, 0, 0, 10, 8, 
	0, 0, 12, 0, 0, 10, 0, 0, 
	6, 1, 3, 1, 5, 0, 1, 0, 
	0, 8, 8, 8, 0, 0, 12, 0, 
	0, 10, 0, 0, 6, 1, 3, 1, 
	5, 0, 1, 0, 0, 0, 0, 12, 
	0, 0, 10, 0, 0, 6, 1, 3, 
	1, 5, 0, 1, 0, 0, 0, 0, 
	12, 0, 0, 10, 0, 0, 6, 1, 
	3, 1, 5, 0, 1, 0, 8, 5, 
	6, 4, 6, 5, 4, 6, 2, 6, 
	6, 7, 6, 7, 15, 7, 6, 7, 
	7, 7, 7, 8, 7, 6, 6, 7, 
	6, 15, 13, 12, 15, 13, 0, 0, 
	0, 12, 0, 0, 10, 0, 0, 6, 
	1, 3, 1, 5, 0, 1, 0, 16, 
	6, 6, 3, 12, 2, 2, 0, 0, 
	2, 0, 2, 0, 0, 0, 1, 1, 
	1, 0, 0, 1, 0, 0, 0, 1, 
	32, 0, 0, 1, 0, 0, 1, 1, 
	1, 2, 0, 1, 0, 1, 1, 2, 
	0, 0, 0, 1, 0, 1, 1, 2, 
	0, 0, 5, 1, 4, 0, 0, 1, 
	40, 0, 2, 1, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 3, 1, 0, 16, 1, 
	2, 0, 0, 6, 1, 0, 0, 0, 
	0, 2, 2, 0, 0, 1, 8, 0, 
	0, 0, 0, 0, 0, 1, 0, 1, 
	0, 20, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 2, 0, 
	0, 0, 0, 0, 2, 0, 0, 17, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 11, 
	22, 1, 0, 0, 1, 0, 0, 0, 
	1, 0, 0, 0, 3, 0, 0, 0, 
	1, 0, 0, 0, 8, 0, 0, 0, 
	1, 0, 1, 4, 0, 0, 0, 1, 
	0, 14, 0, 0, 0, 0, 2, 0, 
	0, 1, 0, 1, 0, 0, 0, 0, 
	3, 4, 12, 0, 1, 0, 2, 1, 
	1, 1, 0, 16, 1, 16, 1, 3, 
	1, 5, 6, 7, 6, 7, 6, 7, 
	6, 6, 7, 6, 6, 6, 7, 6, 
	6, 6, 7, 6, 16, 1, 16, 1, 
	1, 1, 4, 2, 2, 2, 61, 8, 
	7, 6, 7, 8, 1, 8, 1, 8, 
	17, 4, 5, 1, 4, 4, 4, 4, 
	5, 4, 4, 8, 18, 17, 8, 14, 
	12, 8, 10, 4, 7, 4, 7, 16, 
	16, 14, 16, 16, 17, 16, 17, 14, 
	12, 17, 17, 18, 17, 14, 38, 49, 
	36, 37, 37, 51, 39, 33, 45, 32, 
	33, 47, 35, 35, 39, 37, 38, 38, 
	38, 38, 7, 7, 7, 8, 7, 38, 
	38, 40, 38, 38, 40, 40, 38, 51, 
	39, 47, 35, 42, 40, 40, 40, 40, 
	38, 40, 40, 40, 40, 40, 40, 40, 
	38, 49, 45, 40, 38, 2, 0, 4, 
	8, 33, 2, 0, 2, 1, 4, 1, 
	0, 0, 1, 0, 0, 0, 1, 12, 
	2, 1, 0, 1, 1, 30, 3, 0, 
	1, 1, 3, 3, 2, 4, 1, 6, 
	1, 4, 2, 4, 1, 5, 0, 2, 
	3, 1, 2, 0, 2, 0, 11, 1, 
	1, 1, 0, 44, 1, 1, 1, 3, 
	3, 3, 2, 1, 0, 0, 0, 1, 
	0, 1, 0, 1, 1, 0, 2, 0, 
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	1, 0, 4, 3, 2, 15, 4, 2, 
	4, 14, 3, 0, 7, 1, 0, 1, 
	1, 0, 2, 1, 4, 3, 1, 8, 
	1, 1, 1, 0, 0, 0, 2, 0, 
	1, 0, 23, 0, 0, 1, 0, 0, 
	1, 0, 3, 0, 1, 0, 0, 0, 
	1, 0, 2, 1, 1, 2, 0, 2, 
	0, 0, 17, 0, 0, 5, 2, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	1, 1, 0, 11, 21, 4, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 4, 
	0, 0, 0, 3, 0, 0, 0, 9, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	1, 0, 1, 4, 0, 1, 0, 1, 
	0, 11, 1, 5, 1, 5, 2, 0, 
	3, 2, 2, 2, 1, 3, 7, 17, 
	3, 1, 0, 2, 0, 1, 5, 13, 
	16, 12
};

static const char _english_tokenizer_range_lengths[] = {
	0, 0, 0, 0, 0, 1, 0, 0, 
	2, 1, 0, 2, 0, 1, 12, 5, 
	2, 1, 0, 4, 3, 1, 0, 0, 
	1, 1, 1, 0, 0, 1, 1, 1, 
	0, 0, 0, 4, 2, 4, 4, 0, 
	2, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 1, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 1, 
	0, 2, 2, 5, 1, 6, 3, 2, 
	1, 2, 2, 2, 1, 1, 1, 1, 
	0, 0, 1, 0, 0, 3, 0, 0, 
	0, 5, 5, 5, 3, 3, 3, 3, 
	3, 3, 6, 1, 3, 3, 3, 3, 
	3, 3, 3, 3, 4, 4, 3, 3, 
	4, 4, 3, 3, 4, 4, 1, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 7, 5, 
	5, 5, 5, 0, 0, 5, 5, 5, 
	5, 5, 5, 5, 1, 1, 1, 0, 
	1, 1, 0, 1, 2, 0, 0, 0, 
	0, 0, 1, 0, 1, 1, 1, 1, 
	1, 1, 0, 1, 1, 0, 1, 2, 
	0, 0, 0, 0, 0, 1, 0, 1, 
	1, 1, 1, 1, 1, 1, 0, 1, 
	1, 0, 1, 2, 0, 0, 0, 0, 
	0, 1, 0, 1, 1, 1, 1, 0, 
	1, 1, 0, 1, 2, 0, 0, 0, 
	0, 0, 1, 0, 1, 1, 1, 1, 
	0, 1, 1, 0, 1, 2, 0, 0, 
	0, 0, 0, 1, 0, 1, 1, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 6, 6, 5, 5, 6, 
	6, 5, 5, 5, 5, 5, 1, 1, 
	1, 0, 1, 1, 0, 1, 2, 0, 
	0, 0, 0, 0, 1, 0, 1, 5, 
	5, 5, 0, 0, 0, 0, 3, 1, 
	3, 3, 3, 2, 2, 2, 2, 2, 
	4, 2, 2, 5, 1, 2, 1, 1, 
	0, 1, 1, 1, 1, 3, 7, 6, 
	9, 5, 8, 4, 8, 6, 10, 3, 
	7, 6, 7, 6, 5, 5, 4, 4, 
	1, 1, 8, 3, 2, 3, 3, 0, 
	2, 3, 3, 5, 5, 3, 3, 2, 
	2, 1, 1, 2, 2, 1, 3, 4, 
	2, 2, 1, 2, 1, 3, 2, 2, 
	1, 2, 2, 0, 2, 2, 1, 2, 
	2, 2, 3, 4, 2, 7, 0, 0, 
	0, 1, 1, 5, 1, 1, 2, 2, 
	2, 2, 1, 5, 5, 0, 1, 4, 
	4, 2, 2, 2, 1, 2, 1, 1, 
	1, 2, 1, 3, 2, 2, 2, 2, 
	4, 1, 1, 2, 2, 2, 0, 1, 
	3, 4, 5, 2, 1, 2, 2, 1, 
	2, 1, 5, 3, 1, 1, 2, 2, 
	2, 2, 1, 1, 2, 1, 4, 1, 
	1, 4, 2, 1, 0, 2, 1, 2, 
	1, 2, 2, 1, 3, 1, 2, 2, 
	6, 1, 2, 1, 0, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 0, 
	1, 1, 3, 3, 1, 2, 6, 2, 
	6, 3, 2, 3, 3, 3, 3, 2, 
	0, 5, 7, 5, 1, 1, 1, 1, 
	0, 1, 1, 0, 0, 0, 0, 4, 
	0, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 6, 6, 5, 5, 6, 6, 
	5, 5, 6, 6, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 12, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	7, 3, 6, 1, 3, 3, 3, 3, 
	4, 4, 5, 5, 7, 5, 5, 5, 
	5, 1, 1, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 6, 6, 5, 5, 
	1, 5, 5, 6, 6, 1, 7, 7, 
	7, 7, 7, 7, 7, 4, 4, 4, 
	4, 4, 4, 4, 7, 7, 7, 7, 
	7, 7, 5, 5, 5, 6, 6, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 4, 4, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 4, 7, 7, 0, 1, 1, 
	1, 5, 1, 1, 6, 5, 2, 1, 
	3, 3, 3, 2, 5, 2, 5, 2, 
	8, 3, 2, 2, 5, 1, 2, 2, 
	3, 3, 5, 9, 6, 7, 7, 3, 
	5, 7, 5, 13, 3, 3, 7, 6, 
	3, 6, 5, 2, 2, 4, 8, 6, 
	3, 2, 3, 1, 2, 11, 5, 3, 
	5, 5, 3, 3, 2, 3, 2, 1, 
	3, 3, 2, 4, 4, 2, 3, 4, 
	2, 3, 2, 2, 6, 2, 4, 3, 
	2, 4, 3, 5, 6, 2, 2, 6, 
	5, 5, 6, 1, 11, 1, 2, 1, 
	1, 2, 1, 3, 8, 3, 3, 1, 
	1, 6, 3, 2, 3, 2, 1, 2, 
	7, 3, 1, 4, 4, 2, 1, 1, 
	1, 2, 3, 3, 6, 2, 3, 4, 
	6, 2, 2, 3, 5, 4, 4, 3, 
	3, 2, 6, 6, 8, 8, 4, 2, 
	3, 4, 2, 3, 2, 5, 1, 2, 
	2, 2, 2, 3, 4, 2, 2, 5, 
	3, 1, 9, 3, 3, 1, 4, 2, 
	3, 2, 3, 2, 3, 4, 4, 4, 
	2, 4, 3, 3, 3, 4, 2, 1, 
	3, 3, 3, 5, 4, 3, 4, 2, 
	2, 2, 2, 3, 2, 2, 3, 1, 
	2, 3, 1, 5, 1, 3, 3, 3, 
	1, 1, 1, 1, 3, 1, 4, 6, 
	4, 1, 2, 2, 2, 3, 5, 5, 
	5, 5
};

static const short _english_tokenizer_index_offsets[] = {
	0, 0, 2, 4, 6, 9, 12, 14, 
	16, 50, 81, 83, 86, 119, 150, 170, 
	197, 226, 233, 237, 244, 263, 265, 282, 
	311, 343, 365, 367, 369, 372, 382, 384, 
	388, 390, 423, 452, 457, 464, 469, 474, 
	491, 496, 499, 501, 514, 516, 518, 522, 
	530, 537, 549, 553, 555, 565, 587, 598, 
	600, 611, 617, 641, 654, 669, 697, 712, 
	718, 720, 728, 735, 739, 743, 746, 748, 
	750, 767, 770, 773, 781, 783, 790, 795, 
	798, 800, 803, 806, 809, 812, 814, 816, 
	818, 820, 823, 833, 836, 853, 860, 864, 
	866, 878, 888, 896, 905, 912, 918, 923, 
	929, 933, 939, 951, 953, 959, 966, 972, 
	979, 985, 992, 998, 1004, 1012, 1019, 1025, 
	1031, 1039, 1046, 1052, 1058, 1066, 1073, 1089, 
	1092, 1094, 1097, 1099, 1102, 1112, 1118, 1122, 
	1124, 1128, 1136, 1143, 1155, 1159, 1170, 1172, 
	1184, 1190, 1192, 1199, 1207, 1210, 1214, 1239, 
	1253, 1265, 1277, 1289, 1291, 1293, 1304, 1322, 
	1340, 1358, 1376, 1396, 1414, 1416, 1418, 1420, 
	1433, 1435, 1437, 1448, 1450, 1453, 1460, 1462, 
	1466, 1468, 1474, 1476, 1478, 1480, 1482, 1494, 
	1504, 1506, 1508, 1521, 1523, 1525, 1536, 1538, 
	1541, 1548, 1550, 1554, 1556, 1562, 1564, 1566, 
	1568, 1570, 1580, 1590, 1600, 1602, 1604, 1617, 
	1619, 1621, 1632, 1634, 1637, 1644, 1646, 1650, 
	1652, 1658, 1660, 1662, 1664, 1666, 1668, 1670, 
	1683, 1685, 1687, 1698, 1700, 1703, 1710, 1712, 
	1716, 1718, 1724, 1726, 1728, 1730, 1732, 1734, 
	1736, 1749, 1751, 1753, 1764, 1766, 1769, 1776, 
	1778, 1782, 1784, 1790, 1792, 1794, 1796, 1806, 
	1817, 1829, 1839, 1851, 1862, 1872, 1884, 1892, 
	1904, 1916, 1929, 1941, 1954, 1975, 1988, 2000, 
	2013, 2026, 2039, 2052, 2067, 2081, 2093, 2105, 
	2119, 2132, 2153, 2172, 2190, 2211, 2230, 2232, 
	2234, 2236, 2249, 2251, 2253, 2264, 2266, 2269, 
	2276, 2278, 2282, 2284, 2290, 2292, 2294, 2296, 
	2318, 2330, 2342, 2346, 2359, 2362, 2365, 2369, 
	2371, 2377, 2381, 2387, 2390, 2393, 2396, 2400, 
	2404, 2410, 2413, 2416, 2423, 2425, 2428, 2430, 
	2433, 2466, 2468, 2470, 2473, 2475, 2479, 2488, 
	2496, 2507, 2515, 2524, 2530, 2539, 2547, 2559, 
	2565, 2573, 2580, 2588, 2596, 2602, 2609, 2615, 
	2622, 2624, 2626, 2640, 2645, 2652, 2656, 2660, 
	2662, 2705, 2709, 2715, 2722, 2728, 2733, 2737, 
	2740, 2743, 2745, 2747, 2750, 2753, 2755, 2759, 
	2764, 2768, 2771, 2773, 2776, 2778, 2782, 2785, 
	2788, 2790, 2793, 2797, 2799, 2802, 2805, 2807, 
	2810, 2813, 2816, 2820, 2828, 2832, 2840, 2857, 
	2859, 2862, 2864, 2866, 2878, 2881, 2883, 2886, 
	2889, 2892, 2897, 2901, 2907, 2913, 2915, 2925, 
	2930, 2935, 2938, 2941, 2944, 2946, 2950, 2952, 
	2955, 2957, 2980, 2982, 2986, 2990, 2993, 2996, 
	2999, 3004, 3006, 3008, 3012, 3015, 3018, 3021, 
	3023, 3027, 3032, 3038, 3041, 3045, 3048, 3051, 
	3070, 3073, 3075, 3082, 3086, 3088, 3090, 3093, 
	3096, 3099, 3102, 3104, 3106, 3109, 3111, 3116, 
	3129, 3153, 3159, 3162, 3164, 3166, 3169, 3171, 
	3174, 3177, 3180, 3183, 3185, 3192, 3194, 3197, 
	3200, 3208, 3210, 3213, 3215, 3224, 3226, 3228, 
	3230, 3233, 3235, 3238, 3244, 3246, 3249, 3251, 
	3253, 3255, 3271, 3275, 3279, 3281, 3284, 3293, 
	3296, 3303, 3308, 3311, 3316, 3320, 3324, 3328, 
	3331, 3335, 3345, 3365, 3371, 3374, 3376, 3380, 
	3383, 3385, 3388, 3390, 3407, 3409, 3426, 3428, 
	3436, 3438, 3449, 3461, 3474, 3486, 3499, 3511, 
	3524, 3536, 3548, 3562, 3575, 3587, 3599, 3613, 
	3626, 3638, 3650, 3664, 3677, 3694, 3696, 3713, 
	3715, 3717, 3719, 3724, 3727, 3730, 3733, 3807, 
	3816, 3824, 3831, 3839, 3848, 3850, 3859, 3861, 
	3870, 3895, 3903, 3915, 3918, 3926, 3934, 3942, 
	3950, 3960, 3969, 3979, 3993, 4019, 4042, 4056, 
	4076, 4094, 4104, 4116, 4121, 4134, 4144, 4157, 
	4179, 4201, 4221, 4243, 4265, 4289, 4312, 4335, 
	4355, 4369, 4392, 4415, 4440, 4464, 4480, 4526, 
	4583, 4627, 4672, 4717, 4776, 4823, 4861, 4911, 
	4948, 4986, 5038, 5078, 5118, 5165, 5210, 5256, 
	5302, 5348, 5394, 5407, 5420, 5433, 5448, 5462, 
	5508, 5554, 5602, 5648, 5694, 5742, 5790, 5836, 
	5895, 5942, 5994, 6034, 6084, 6132, 6180, 6228, 
	6276, 6322, 6370, 6418, 6466, 6514, 6562, 6610, 
	6658, 6704, 6761, 6811, 6859, 6905, 6908, 6910, 
	6916, 6926, 6965, 6969, 6971, 6980, 6987, 6994, 
	6997, 7001, 7005, 7010, 7013, 7019, 7022, 7029, 
	7044, 7055, 7060, 7063, 7067, 7074, 7106, 7112, 
	7115, 7120, 7125, 7134, 7147, 7156, 7168, 7177, 
	7187, 7194, 7206, 7214, 7232, 7237, 7246, 7254, 
	7263, 7270, 7278, 7286, 7289, 7294, 7299, 7319, 
	7327, 7332, 7336, 7340, 7386, 7390, 7403, 7410, 
	7417, 7426, 7435, 7441, 7446, 7449, 7453, 7456, 
	7459, 7463, 7468, 7471, 7477, 7483, 7486, 7492, 
	7497, 7500, 7505, 7508, 7511, 7518, 7521, 7527, 
	7531, 7534, 7540, 7544, 7550, 7557, 7560, 7563, 
	7570, 7577, 7583, 7594, 7599, 7613, 7630, 7637, 
	7641, 7647, 7664, 7669, 7673, 7689, 7694, 7698, 
	7701, 7704, 7711, 7717, 7721, 7729, 7735, 7738, 
	7749, 7758, 7763, 7766, 7771, 7776, 7779, 7783, 
	7785, 7788, 7791, 7818, 7822, 7829, 7833, 7837, 
	7842, 7850, 7853, 7859, 7863, 7870, 7875, 7880, 
	7884, 7889, 7892, 7901, 7909, 7919, 7930, 7935, 
	7940, 7944, 7949, 7969, 7973, 7976, 7987, 7991, 
	7994, 7997, 8000, 8003, 8007, 8012, 8016, 8019, 
	8025, 8030, 8033, 8043, 8058, 8083, 8089, 8094, 
	8097, 8101, 8104, 8108, 8112, 8116, 8121, 8126, 
	8135, 8138, 8143, 8147, 8154, 8158, 8163, 8166, 
	8177, 8181, 8185, 8189, 8195, 8200, 8204, 8210, 
	8213, 8217, 8220, 8224, 8232, 8235, 8239, 8243, 
	8246, 8249, 8264, 8267, 8278, 8281, 8290, 8296, 
	8300, 8305, 8309, 8313, 8317, 8322, 8327, 8339, 
	8363, 8371, 8374, 8377, 8382, 8385, 8390, 8401, 
	8420, 8442
};

static const short _english_tokenizer_indicies[] = {
	1, 0, 2, 0, 1, 0, 3, 4, 
	0, 1, 1, 0, 1, 0, 2, 0, 
	6, 6, 7, 7, 7, 7, 7, 9, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 6, 
	8, 5, 7, 7, 7, 7, 7, 33, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 34, 35, 36, 30, 31, 32, 8, 
	5, 7, 5, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 37, 
	5, 7, 7, 5, 38, 39, 40, 42, 
	43, 44, 45, 46, 41, 5, 8, 5, 
	8, 8, 8, 5, 7, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 5, 47, 48, 49, 50, 51, 52, 
	53, 54, 55, 56, 57, 58, 59, 41, 
	60, 61, 5, 7, 7, 7, 7, 5, 
	7, 7, 5, 7, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 5, 8, 5, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	5, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 5, 7, 7, 7, 
	5, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 62, 5, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 63, 64, 65, 66, 67, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	68, 69, 70, 71, 72, 5, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 8, 5, 7, 7, 7, 5, 73, 
	74, 5, 75, 5, 8, 5, 76, 77, 
	78, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 5, 8, 
	8, 5, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 5, 8, 8, 5, 8, 5, 
	8, 8, 5, 8, 8, 5, 8, 8, 
	5, 8, 8, 5, 8, 5, 8, 5, 
	8, 5, 8, 5, 6, 7, 5, 38, 
	39, 92, 42, 43, 44, 45, 46, 41, 
	5, 6, 7, 5, 93, 94, 49, 50, 
	51, 52, 53, 54, 55, 56, 57, 58, 
	59, 41, 60, 61, 5, 7, 6, 7, 
	6, 7, 7, 5, 7, 6, 7, 5, 
	95, 5, 6, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 97, 98, 
	99, 97, 97, 97, 97, 97, 97, 96, 
	100, 100, 100, 100, 100, 100, 100, 96, 
	100, 99, 100, 100, 100, 100, 100, 100, 
	96, 101, 102, 103, 104, 105, 105, 96, 
	106, 107, 105, 105, 105, 96, 106, 105, 
	105, 105, 96, 106, 108, 105, 105, 105, 
	96, 105, 109, 110, 96, 106, 108, 105, 
	111, 105, 96, 112, 113, 113, 112, 112, 
	112, 113, 112, 112, 113, 113, 5, 114, 
	5, 106, 108, 105, 105, 115, 96, 116, 
	117, 118, 119, 109, 110, 96, 106, 120, 
	105, 105, 105, 96, 121, 122, 123, 124, 
	109, 110, 96, 106, 125, 105, 105, 105, 
	96, 126, 127, 128, 129, 109, 110, 96, 
	106, 125, 124, 105, 105, 96, 106, 125, 
	121, 105, 105, 96, 106, 125, 130, 124, 
	121, 105, 105, 96, 106, 125, 121, 105, 
	105, 105, 96, 106, 120, 119, 105, 105, 
	96, 106, 120, 116, 105, 105, 96, 106, 
	120, 131, 119, 116, 105, 105, 96, 106, 
	120, 116, 105, 105, 105, 96, 106, 107, 
	104, 105, 105, 96, 106, 107, 101, 105, 
	105, 96, 106, 107, 132, 104, 101, 105, 
	105, 96, 106, 107, 101, 105, 105, 105, 
	96, 133, 133, 134, 134, 134, 134, 134, 
	134, 135, 136, 137, 138, 139, 140, 133, 
	5, 6, 134, 5, 141, 5, 134, 134, 
	5, 142, 5, 6, 134, 5, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 5, 
	134, 134, 6, 134, 6, 5, 134, 6, 
	134, 5, 134, 5, 134, 134, 134, 5, 
	134, 134, 134, 134, 134, 134, 134, 5, 
	134, 134, 134, 134, 134, 134, 5, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 134, 5, 134, 134, 134, 5, 134, 
	134, 134, 134, 134, 134, 134, 134, 134, 
	134, 5, 152, 5, 6, 134, 134, 134, 
	134, 134, 134, 134, 134, 134, 134, 5, 
	153, 154, 155, 156, 157, 5, 134, 5, 
	134, 134, 134, 134, 134, 134, 5, 134, 
	134, 134, 134, 134, 134, 134, 5, 134, 
	134, 5, 134, 134, 134, 5, 133, 133, 
	97, 134, 97, 98, 134, 99, 134, 97, 
	134, 135, 136, 137, 138, 139, 140, 133, 
	97, 158, 97, 97, 97, 97, 5, 97, 
	98, 99, 159, 160, 97, 159, 160, 97, 
	97, 97, 97, 97, 5, 97, 98, 99, 
	161, 97, 161, 97, 97, 97, 97, 97, 
	5, 97, 98, 99, 162, 97, 162, 97, 
	97, 97, 97, 97, 5, 97, 98, 99, 
	163, 97, 163, 97, 97, 97, 97, 97, 
	5, 164, 5, 165, 5, 97, 166, 98, 
	99, 97, 97, 97, 97, 97, 97, 5, 
	97, 98, 99, 97, 168, 169, 170, 171, 
	172, 173, 174, 175, 97, 97, 167, 97, 
	97, 5, 97, 98, 99, 97, 177, 178, 
	179, 180, 181, 182, 183, 184, 97, 97, 
	176, 97, 97, 5, 97, 98, 99, 97, 
	186, 187, 188, 189, 190, 191, 192, 193, 
	97, 97, 185, 97, 97, 5, 97, 98, 
	99, 97, 195, 196, 197, 198, 199, 200, 
	201, 202, 97, 97, 194, 97, 97, 5, 
	97, 203, 203, 98, 99, 97, 205, 206, 
	207, 208, 209, 210, 211, 212, 97, 97, 
	204, 97, 97, 5, 97, 98, 99, 97, 
	205, 206, 207, 208, 209, 210, 211, 212, 
	97, 97, 204, 97, 97, 5, 213, 5, 
	213, 5, 213, 5, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 215, 215, 205, 
	5, 213, 5, 213, 5, 207, 215, 205, 
	215, 216, 215, 217, 215, 206, 217, 5, 
	213, 5, 213, 213, 5, 205, 215, 207, 
	215, 215, 206, 5, 215, 5, 218, 219, 
	220, 5, 205, 5, 214, 206, 221, 215, 
	207, 5, 213, 5, 222, 5, 213, 5, 
	223, 5, 224, 224, 205, 206, 207, 208, 
	209, 210, 211, 212, 213, 5, 205, 206, 
	207, 208, 209, 210, 211, 212, 213, 5, 
	223, 5, 223, 5, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 226, 226, 195, 
	5, 223, 5, 223, 5, 197, 226, 195, 
	226, 227, 226, 228, 226, 196, 228, 5, 
	223, 5, 223, 223, 5, 195, 226, 197, 
	226, 226, 196, 5, 226, 5, 229, 230, 
	231, 5, 195, 5, 225, 196, 232, 226, 
	197, 5, 223, 5, 233, 5, 223, 5, 
	234, 5, 168, 169, 170, 171, 172, 173, 
	174, 175, 235, 5, 177, 178, 179, 180, 
	181, 182, 183, 184, 236, 5, 186, 187, 
	188, 189, 190, 191, 192, 193, 234, 5, 
	234, 5, 234, 5, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 238, 238, 186, 
	5, 234, 5, 234, 5, 188, 238, 186, 
	238, 239, 238, 240, 238, 187, 240, 5, 
	234, 5, 234, 234, 5, 186, 238, 188, 
	238, 238, 187, 5, 238, 5, 241, 242, 
	243, 5, 186, 5, 237, 187, 244, 238, 
	188, 5, 234, 5, 245, 5, 234, 5, 
	236, 5, 236, 5, 236, 5, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 247, 
	247, 177, 5, 236, 5, 236, 5, 179, 
	247, 177, 247, 248, 247, 249, 247, 178, 
	249, 5, 236, 5, 236, 236, 5, 177, 
	247, 179, 247, 247, 178, 5, 247, 5, 
	250, 251, 252, 5, 177, 5, 246, 178, 
	253, 247, 179, 5, 236, 5, 254, 5, 
	236, 5, 235, 5, 235, 5, 235, 5, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 256, 256, 168, 5, 235, 5, 235, 
	5, 170, 256, 168, 256, 257, 256, 258, 
	256, 169, 258, 5, 235, 5, 235, 235, 
	5, 168, 256, 170, 256, 256, 169, 5, 
	256, 5, 259, 260, 261, 5, 168, 5, 
	255, 169, 262, 256, 170, 5, 235, 5, 
	263, 5, 235, 5, 195, 196, 197, 198, 
	199, 200, 201, 202, 223, 5, 97, 264, 
	98, 99, 97, 97, 97, 265, 265, 265, 
	96, 97, 264, 266, 98, 99, 97, 97, 
	97, 265, 265, 265, 96, 97, 98, 99, 
	97, 97, 97, 267, 268, 269, 96, 97, 
	270, 271, 98, 99, 97, 97, 97, 267, 
	267, 267, 96, 97, 270, 98, 99, 97, 
	97, 97, 267, 267, 267, 96, 97, 98, 
	99, 97, 97, 97, 267, 272, 273, 96, 
	97, 270, 271, 98, 99, 97, 97, 97, 
	267, 274, 267, 96, 100, 100, 100, 100, 
	275, 100, 100, 96, 97, 270, 271, 98, 
	99, 97, 97, 97, 267, 267, 276, 96, 
	97, 270, 271, 98, 99, 97, 97, 97, 
	267, 277, 267, 96, 97, 270, 271, 113, 
	278, 99, 97, 97, 97, 267, 277, 267, 
	96, 97, 270, 271, 98, 99, 97, 97, 
	97, 267, 267, 279, 96, 97, 270, 271, 
	113, 278, 99, 97, 97, 97, 267, 267, 
	279, 96, 97, 280, 281, 282, 98, 99, 
	97, 195, 196, 197, 198, 199, 200, 201, 
	202, 97, 97, 283, 268, 269, 5, 97, 
	284, 285, 286, 98, 99, 97, 97, 97, 
	287, 272, 273, 5, 97, 270, 288, 98, 
	99, 97, 97, 97, 267, 267, 267, 5, 
	97, 289, 290, 291, 98, 99, 97, 97, 
	97, 292, 272, 273, 5, 97, 270, 271, 
	113, 278, 99, 97, 97, 97, 267, 267, 
	267, 5, 97, 270, 271, 113, 278, 99, 
	97, 97, 97, 292, 267, 267, 5, 97, 
	270, 271, 113, 278, 99, 97, 97, 97, 
	289, 267, 267, 5, 97, 270, 271, 113, 
	293, 278, 99, 97, 97, 97, 292, 289, 
	267, 267, 5, 97, 270, 271, 113, 278, 
	99, 97, 97, 97, 289, 267, 267, 267, 
	5, 97, 270, 288, 98, 99, 97, 97, 
	97, 287, 267, 267, 5, 97, 270, 288, 
	98, 99, 97, 97, 97, 284, 267, 267, 
	5, 97, 270, 288, 294, 98, 99, 97, 
	97, 97, 287, 284, 267, 267, 5, 97, 
	270, 288, 98, 99, 97, 97, 97, 284, 
	267, 267, 267, 5, 97, 203, 295, 271, 
	98, 99, 97, 205, 206, 207, 208, 209, 
	210, 211, 212, 97, 97, 296, 267, 267, 
	5, 97, 270, 98, 99, 97, 205, 206, 
	207, 208, 209, 210, 211, 212, 97, 97, 
	296, 267, 267, 5, 97, 98, 99, 97, 
	195, 196, 197, 198, 199, 200, 201, 202, 
	97, 97, 297, 268, 269, 5, 97, 203, 
	298, 266, 98, 99, 97, 205, 206, 207, 
	208, 209, 210, 211, 212, 97, 97, 299, 
	265, 265, 5, 97, 264, 98, 99, 97, 
	205, 206, 207, 208, 209, 210, 211, 212, 
	97, 97, 299, 265, 265, 5, 300, 5, 
	300, 5, 300, 5, 301, 301, 301, 301, 
	301, 301, 301, 301, 301, 302, 302, 303, 
	5, 300, 5, 300, 5, 304, 302, 303, 
	302, 305, 302, 306, 302, 307, 306, 5, 
	300, 5, 300, 300, 5, 303, 302, 304, 
	302, 302, 307, 5, 302, 5, 308, 309, 
	310, 5, 303, 5, 301, 307, 311, 302, 
	304, 5, 300, 5, 312, 5, 300, 5, 
	97, 98, 99, 161, 313, 161, 314, 161, 
	314, 97, 161, 313, 161, 314, 161, 314, 
	97, 97, 97, 97, 97, 5, 97, 98, 
	99, 163, 97, 163, 97, 97, 97, 97, 
	97, 5, 97, 98, 99, 163, 97, 163, 
	97, 97, 97, 97, 97, 5, 315, 315, 
	315, 96, 316, 317, 316, 318, 316, 318, 
	316, 317, 316, 318, 316, 318, 5, 319, 
	319, 5, 319, 319, 5, 315, 315, 315, 
	96, 315, 96, 315, 315, 315, 315, 315, 
	96, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 96, 315, 315, 96, 315, 315, 
	96, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 96, 315, 315, 96, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 96, 315, 
	96, 315, 315, 96, 315, 96, 315, 315, 
	96, 320, 321, 322, 323, 324, 325, 326, 
	327, 328, 329, 330, 331, 332, 333, 334, 
	335, 336, 337, 338, 339, 340, 341, 342, 
	343, 344, 345, 346, 347, 348, 349, 350, 
	351, 96, 315, 96, 315, 96, 315, 315, 
	96, 315, 96, 315, 315, 315, 96, 315, 
	315, 315, 315, 315, 315, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 96, 315, 315, 315, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 315, 315, 96, 315, 
	315, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 96, 315, 315, 315, 315, 315, 315, 
	96, 315, 315, 315, 315, 315, 96, 315, 
	315, 315, 315, 315, 315, 96, 315, 96, 
	315, 96, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 96, 
	315, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 315, 96, 315, 96, 352, 353, 
	354, 355, 356, 357, 358, 359, 360, 361, 
	362, 363, 364, 365, 366, 367, 368, 369, 
	370, 371, 372, 373, 374, 375, 376, 377, 
	378, 379, 324, 380, 381, 382, 370, 383, 
	384, 385, 386, 387, 388, 389, 324, 324, 
	96, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	315, 96, 315, 315, 315, 315, 315, 96, 
	315, 315, 315, 315, 96, 315, 315, 315, 
	96, 315, 315, 96, 315, 315, 96, 315, 
	96, 315, 96, 315, 315, 96, 315, 315, 
	96, 315, 96, 315, 315, 315, 96, 315, 
	315, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 96, 315, 96, 315, 315, 96, 
	315, 96, 315, 315, 315, 96, 315, 315, 
	96, 315, 315, 96, 315, 96, 315, 315, 
	96, 315, 315, 315, 96, 315, 96, 315, 
	315, 96, 315, 315, 96, 315, 96, 315, 
	315, 96, 315, 315, 96, 315, 315, 96, 
	315, 315, 315, 96, 315, 315, 315, 315, 
	315, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 315, 96, 
	390, 391, 392, 393, 394, 395, 396, 397, 
	398, 324, 399, 400, 401, 402, 403, 404, 
	96, 405, 96, 315, 315, 96, 315, 96, 
	315, 96, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 315, 96, 315, 315, 
	96, 315, 96, 315, 315, 96, 315, 315, 
	96, 315, 315, 96, 315, 315, 315, 315, 
	96, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 96, 315, 315, 315, 315, 315, 
	96, 315, 96, 406, 362, 407, 408, 409, 
	324, 410, 411, 324, 96, 315, 315, 315, 
	315, 96, 315, 315, 315, 315, 96, 315, 
	315, 96, 315, 315, 96, 315, 315, 96, 
	315, 96, 372, 324, 324, 96, 324, 96, 
	412, 324, 96, 315, 96, 412, 413, 414, 
	415, 416, 417, 418, 419, 420, 421, 382, 
	422, 423, 424, 425, 426, 427, 428, 429, 
	430, 324, 324, 96, 315, 96, 315, 315, 
	315, 96, 315, 315, 315, 96, 315, 315, 
	96, 315, 315, 96, 315, 315, 96, 315, 
	315, 315, 315, 96, 315, 96, 315, 96, 
	315, 315, 315, 96, 315, 315, 96, 315, 
	315, 96, 315, 315, 96, 315, 96, 315, 
	315, 315, 96, 315, 315, 315, 315, 96, 
	315, 315, 315, 315, 315, 96, 315, 315, 
	96, 431, 432, 324, 96, 315, 315, 96, 
	315, 315, 96, 433, 434, 435, 436, 437, 
	438, 439, 352, 440, 441, 442, 443, 444, 
	445, 446, 447, 448, 324, 96, 315, 315, 
	96, 315, 96, 315, 315, 315, 315, 315, 
	315, 96, 315, 315, 315, 96, 315, 96, 
	315, 96, 315, 315, 96, 315, 315, 96, 
	315, 315, 96, 315, 315, 96, 315, 96, 
	315, 96, 315, 315, 96, 315, 96, 315, 
	315, 315, 315, 96, 449, 450, 451, 452, 
	453, 454, 455, 456, 458, 459, 460, 457, 
	96, 461, 462, 324, 463, 464, 465, 466, 
	467, 468, 469, 470, 471, 472, 473, 474, 
	475, 476, 477, 372, 478, 324, 479, 324, 
	96, 315, 315, 315, 315, 315, 96, 315, 
	315, 96, 315, 96, 315, 96, 315, 315, 
	96, 315, 96, 315, 315, 96, 315, 315, 
	96, 315, 315, 96, 315, 315, 96, 315, 
	96, 315, 315, 315, 315, 315, 315, 96, 
	315, 96, 315, 315, 96, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 315, 96, 
	315, 96, 315, 315, 96, 315, 96, 324, 
	480, 463, 481, 361, 324, 482, 370, 96, 
	315, 96, 315, 96, 315, 96, 483, 324, 
	96, 315, 96, 483, 324, 96, 484, 324, 
	485, 486, 324, 96, 315, 96, 315, 315, 
	96, 315, 96, 487, 96, 315, 96, 488, 
	489, 490, 491, 492, 493, 494, 495, 496, 
	497, 498, 499, 500, 501, 324, 96, 315, 
	315, 315, 96, 315, 315, 315, 96, 315, 
	96, 315, 315, 96, 315, 315, 315, 315, 
	315, 315, 315, 315, 96, 315, 315, 96, 
	315, 315, 315, 315, 315, 315, 96, 315, 
	315, 315, 315, 96, 315, 315, 96, 315, 
	315, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 315, 96, 315, 315, 315, 96, 
	315, 315, 96, 502, 503, 504, 96, 315, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	96, 315, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 96, 315, 315, 315, 
	315, 315, 96, 505, 324, 96, 315, 96, 
	361, 471, 324, 96, 471, 324, 96, 506, 
	96, 507, 324, 96, 315, 96, 508, 391, 
	392, 393, 394, 395, 396, 397, 398, 324, 
	399, 400, 401, 402, 403, 404, 5, 509, 
	5, 510, 391, 392, 393, 394, 395, 396, 
	397, 398, 324, 399, 400, 401, 402, 403, 
	404, 96, 511, 96, 100, 512, 100, 100, 
	100, 100, 100, 96, 513, 96, 97, 514, 
	515, 516, 97, 97, 97, 517, 267, 267, 
	96, 97, 270, 518, 98, 99, 97, 97, 
	97, 267, 267, 267, 96, 97, 519, 520, 
	521, 98, 99, 97, 97, 97, 522, 272, 
	273, 96, 97, 270, 523, 98, 99, 97, 
	97, 97, 267, 267, 267, 96, 97, 524, 
	525, 526, 98, 99, 97, 97, 97, 527, 
	272, 273, 96, 97, 270, 528, 98, 99, 
	97, 97, 97, 267, 267, 267, 96, 97, 
	529, 530, 531, 98, 99, 97, 97, 97, 
	532, 272, 273, 96, 97, 270, 528, 98, 
	99, 97, 97, 97, 527, 267, 267, 96, 
	97, 270, 528, 98, 99, 97, 97, 97, 
	524, 267, 267, 96, 97, 270, 528, 533, 
	98, 99, 97, 97, 97, 527, 524, 267, 
	267, 96, 97, 270, 528, 98, 99, 97, 
	97, 97, 524, 267, 267, 267, 96, 97, 
	270, 523, 98, 99, 97, 97, 97, 522, 
	267, 267, 96, 97, 270, 523, 98, 99, 
	97, 97, 97, 519, 267, 267, 96, 97, 
	270, 523, 534, 98, 99, 97, 97, 97, 
	522, 519, 267, 267, 96, 97, 270, 523, 
	98, 99, 97, 97, 97, 519, 267, 267, 
	267, 96, 97, 270, 518, 98, 99, 97, 
	97, 97, 517, 267, 267, 96, 97, 270, 
	518, 98, 99, 97, 97, 97, 514, 267, 
	267, 96, 97, 270, 518, 535, 98, 99, 
	97, 97, 97, 517, 514, 267, 267, 96, 
	97, 270, 518, 98, 99, 97, 97, 97, 
	514, 267, 267, 267, 96, 536, 391, 392, 
	393, 394, 395, 396, 397, 398, 324, 399, 
	400, 401, 402, 403, 404, 5, 537, 5, 
	538, 391, 392, 393, 394, 395, 396, 397, 
	398, 324, 399, 400, 401, 402, 403, 404, 
	5, 539, 5, 540, 5, 165, 5, 541, 
	542, 541, 542, 5, 316, 316, 5, 543, 
	543, 5, 319, 319, 5, 1, 544, 545, 
	1, 546, 165, 547, 166, 549, 165, 550, 
	551, 552, 554, 556, 557, 558, 559, 560, 
	561, 166, 562, 556, 557, 558, 559, 560, 
	561, 564, 565, 567, 563, 568, 569, 570, 
	571, 572, 573, 574, 575, 576, 577, 578, 
	579, 580, 581, 582, 583, 584, 585, 586, 
	587, 589, 590, 591, 592, 593, 594, 595, 
	166, 596, 165, 166, 553, 165, 555, 165, 
	555, 165, 563, 566, 588, 563, 548, 1, 
	598, 599, 1, 600, 601, 602, 603, 597, 
	1, 604, 1, 600, 601, 602, 603, 597, 
	1, 1, 600, 601, 602, 603, 597, 1, 
	604, 1, 600, 601, 602, 603, 597, 1, 
	605, 606, 1, 600, 601, 602, 603, 597, 
	608, 607, 1, 605, 609, 1, 600, 601, 
	602, 603, 597, 608, 607, 1, 606, 609, 
	1, 600, 601, 602, 603, 597, 133, 133, 
	97, 134, 97, 98, 134, 99, 134, 97, 
	134, 135, 136, 137, 138, 139, 140, 133, 
	97, 158, 97, 97, 97, 97, 610, 106, 
	108, 113, 611, 105, 111, 105, 610, 112, 
	113, 113, 112, 112, 112, 113, 112, 112, 
	113, 113, 610, 113, 114, 610, 106, 108, 
	113, 611, 105, 105, 115, 610, 106, 108, 
	113, 611, 105, 105, 105, 610, 106, 108, 
	113, 611, 129, 105, 105, 610, 106, 108, 
	113, 611, 126, 105, 105, 610, 106, 108, 
	113, 612, 611, 129, 126, 105, 105, 610, 
	106, 108, 113, 611, 126, 105, 105, 105, 
	610, 97, 98, 99, 97, 97, 97, 97, 
	97, 97, 96, 97, 166, 98, 99, 613, 
	97, 613, 614, 97, 97, 97, 97, 97, 
	610, 133, 133, 97, 134, 97, 615, 98, 
	134, 99, 134, 97, 134, 135, 136, 137, 
	138, 139, 140, 133, 97, 158, 97, 97, 
	97, 97, 610, 97, 616, 264, 617, 98, 
	99, 619, 97, 619, 303, 307, 304, 620, 
	621, 622, 623, 624, 97, 97, 618, 265, 
	265, 610, 97, 616, 625, 98, 99, 626, 
	97, 626, 97, 97, 97, 97, 97, 610, 
	97, 98, 99, 626, 97, 626, 195, 196, 
	197, 198, 199, 200, 201, 202, 97, 97, 
	194, 97, 97, 610, 97, 98, 99, 97, 
	205, 206, 207, 208, 209, 210, 211, 212, 
	97, 97, 204, 97, 97, 610, 205, 206, 
	207, 208, 209, 210, 211, 212, 213, 610, 
	627, 627, 195, 196, 197, 198, 199, 200, 
	201, 202, 223, 610, 628, 629, 627, 627, 
	610, 97, 270, 271, 113, 278, 99, 97, 
	97, 97, 267, 274, 267, 610, 100, 113, 
	99, 100, 100, 100, 275, 100, 100, 610, 
	97, 270, 271, 113, 278, 99, 97, 97, 
	97, 267, 267, 276, 610, 97, 270, 630, 
	98, 99, 631, 97, 631, 195, 196, 197, 
	198, 199, 200, 201, 202, 97, 97, 297, 
	267, 267, 610, 97, 270, 271, 98, 99, 
	631, 97, 631, 195, 196, 197, 198, 199, 
	200, 201, 202, 97, 97, 297, 267, 267, 
	610, 97, 270, 271, 98, 99, 97, 205, 
	206, 207, 208, 209, 210, 211, 212, 97, 
	97, 296, 267, 267, 610, 97, 270, 630, 
	98, 99, 631, 97, 631, 195, 196, 197, 
	198, 199, 200, 201, 202, 97, 97, 283, 
	267, 267, 610, 97, 270, 630, 98, 99, 
	631, 97, 631, 195, 196, 197, 198, 199, 
	200, 201, 202, 97, 97, 280, 267, 267, 
	610, 97, 270, 630, 632, 98, 99, 631, 
	97, 631, 195, 196, 197, 198, 199, 200, 
	201, 202, 97, 97, 283, 280, 267, 267, 
	610, 97, 270, 630, 98, 99, 631, 97, 
	631, 195, 196, 197, 198, 199, 200, 201, 
	202, 97, 97, 280, 297, 267, 267, 610, 
	97, 616, 264, 633, 98, 99, 619, 97, 
	619, 303, 307, 304, 620, 621, 622, 623, 
	624, 97, 97, 618, 265, 265, 610, 97, 
	264, 266, 98, 99, 97, 205, 206, 207, 
	208, 209, 210, 211, 212, 97, 97, 299, 
	265, 265, 610, 628, 629, 627, 627, 303, 
	307, 304, 620, 621, 622, 623, 624, 300, 
	610, 97, 616, 264, 617, 98, 99, 619, 
	97, 619, 303, 307, 304, 620, 621, 622, 
	623, 624, 97, 97, 553, 265, 265, 610, 
	97, 616, 264, 617, 98, 99, 619, 97, 
	619, 303, 307, 304, 620, 621, 622, 623, 
	624, 97, 97, 550, 265, 265, 610, 97, 
	616, 264, 617, 634, 98, 99, 619, 97, 
	619, 303, 307, 304, 620, 621, 622, 623, 
	624, 97, 97, 553, 550, 265, 265, 610, 
	97, 616, 264, 617, 98, 99, 619, 97, 
	619, 303, 307, 304, 620, 621, 622, 623, 
	624, 97, 97, 550, 618, 265, 265, 610, 
	133, 133, 134, 134, 134, 134, 134, 134, 
	135, 136, 137, 138, 139, 140, 133, 610, 
	97, 635, 636, 266, 98, 99, 638, 97, 
	638, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 657, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	265, 637, 637, 324, 457, 610, 97, 666, 
	667, 98, 99, 669, 670, 669, 671, 672, 
	669, 672, 97, 669, 670, 669, 671, 672, 
	669, 672, 639, 640, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	352, 653, 437, 654, 655, 656, 673, 658, 
	659, 660, 661, 662, 663, 664, 665, 97, 
	97, 97, 668, 668, 324, 457, 610, 97, 
	635, 98, 99, 671, 97, 671, 639, 640, 
	641, 642, 643, 644, 645, 646, 647, 648, 
	649, 650, 651, 652, 352, 653, 437, 654, 
	655, 656, 657, 658, 659, 660, 661, 662, 
	663, 664, 665, 97, 97, 97, 668, 668, 
	324, 457, 610, 97, 635, 667, 98, 99, 
	671, 97, 671, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	97, 97, 97, 668, 668, 324, 457, 96, 
	97, 674, 667, 98, 99, 671, 97, 671, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 352, 653, 
	437, 654, 655, 656, 675, 658, 659, 660, 
	661, 662, 663, 664, 665, 97, 97, 97, 
	668, 668, 324, 457, 96, 97, 666, 667, 
	98, 99, 669, 670, 669, 671, 672, 669, 
	676, 672, 97, 669, 670, 669, 671, 672, 
	669, 676, 672, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 673, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	97, 97, 97, 668, 668, 324, 457, 610, 
	97, 635, 667, 98, 99, 676, 671, 97, 
	676, 671, 639, 640, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	352, 653, 437, 654, 655, 656, 657, 658, 
	659, 660, 661, 662, 663, 664, 665, 97, 
	97, 97, 668, 668, 324, 457, 610, 405, 
	677, 678, 678, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	315, 315, 324, 457, 96, 509, 677, 679, 
	680, 679, 678, 681, 679, 681, 679, 680, 
	679, 678, 681, 679, 681, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 673, 658, 659, 660, 661, 662, 663, 
	664, 665, 315, 315, 324, 457, 610, 405, 
	678, 678, 639, 640, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	352, 653, 437, 654, 655, 656, 657, 658, 
	659, 660, 661, 662, 663, 664, 665, 315, 
	315, 324, 457, 610, 511, 677, 678, 678, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 352, 653, 
	437, 654, 655, 656, 675, 658, 659, 660, 
	661, 662, 663, 664, 665, 315, 315, 324, 
	457, 96, 509, 677, 679, 680, 679, 678, 
	681, 679, 682, 681, 679, 680, 679, 678, 
	681, 679, 682, 681, 639, 640, 641, 642, 
	643, 644, 645, 646, 647, 648, 649, 650, 
	651, 652, 352, 653, 437, 654, 655, 656, 
	673, 658, 659, 660, 661, 662, 663, 664, 
	665, 315, 315, 324, 457, 610, 405, 677, 
	682, 678, 682, 678, 639, 640, 641, 642, 
	643, 644, 645, 646, 647, 648, 649, 650, 
	651, 652, 352, 653, 437, 654, 655, 656, 
	657, 658, 659, 660, 661, 662, 663, 664, 
	665, 315, 315, 324, 457, 610, 405, 677, 
	682, 678, 682, 678, 639, 640, 641, 642, 
	643, 644, 645, 646, 647, 648, 649, 650, 
	651, 652, 352, 653, 437, 654, 655, 656, 
	657, 658, 659, 660, 661, 662, 663, 664, 
	665, 315, 315, 324, 457, 610, 97, 635, 
	667, 98, 99, 676, 671, 97, 676, 671, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 352, 653, 
	437, 654, 655, 656, 657, 658, 659, 660, 
	661, 662, 663, 664, 665, 97, 97, 97, 
	668, 668, 324, 457, 610, 97, 635, 264, 
	98, 99, 684, 97, 684, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 683, 683, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	684, 97, 684, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	97, 97, 265, 683, 683, 324, 457, 610, 
	97, 674, 636, 266, 98, 99, 684, 97, 
	684, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 675, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	265, 683, 683, 324, 457, 610, 97, 635, 
	636, 266, 98, 99, 686, 97, 686, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 635, 636, 266, 
	687, 99, 686, 97, 686, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 96, 97, 270, 271, 113, 278, 99, 
	97, 97, 97, 267, 267, 267, 610, 97, 
	270, 271, 113, 278, 99, 97, 97, 97, 
	532, 267, 267, 610, 97, 270, 271, 113, 
	278, 99, 97, 97, 97, 529, 267, 267, 
	610, 97, 270, 271, 113, 688, 278, 99, 
	97, 97, 97, 532, 529, 267, 267, 610, 
	97, 270, 271, 113, 278, 99, 97, 97, 
	97, 529, 267, 267, 267, 610, 97, 674, 
	636, 266, 687, 99, 686, 97, 686, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 675, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 674, 636, 266, 
	98, 99, 686, 97, 686, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 675, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	689, 638, 97, 689, 638, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 637, 637, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	690, 97, 690, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	97, 97, 265, 685, 685, 324, 457, 610, 
	97, 674, 636, 266, 687, 99, 691, 97, 
	691, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 675, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	265, 685, 685, 324, 457, 610, 97, 674, 
	636, 266, 687, 99, 686, 692, 97, 686, 
	692, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 675, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	265, 685, 685, 324, 457, 610, 97, 635, 
	636, 266, 687, 99, 686, 693, 97, 686, 
	693, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 657, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	265, 685, 685, 324, 457, 610, 97, 694, 
	636, 266, 98, 99, 638, 97, 638, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 695, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 637, 
	637, 324, 457, 610, 97, 666, 667, 98, 
	99, 669, 670, 669, 671, 672, 669, 672, 
	696, 97, 669, 670, 669, 671, 672, 669, 
	672, 696, 639, 640, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	352, 653, 437, 654, 655, 656, 673, 658, 
	659, 660, 661, 662, 663, 664, 665, 97, 
	97, 97, 668, 668, 324, 457, 610, 97, 
	635, 667, 98, 99, 669, 671, 97, 669, 
	671, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 657, 658, 659, 
	660, 661, 662, 663, 664, 665, 97, 97, 
	97, 668, 668, 324, 457, 610, 509, 677, 
	679, 680, 679, 678, 681, 679, 681, 697, 
	679, 680, 679, 678, 681, 679, 681, 697, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 352, 653, 
	437, 654, 655, 656, 673, 658, 659, 660, 
	661, 662, 663, 664, 665, 315, 315, 324, 
	457, 610, 405, 677, 679, 678, 679, 678, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 352, 653, 
	437, 654, 655, 656, 657, 658, 659, 660, 
	661, 662, 663, 664, 665, 315, 315, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	698, 638, 699, 97, 698, 638, 699, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 637, 
	637, 324, 457, 610, 97, 635, 636, 266, 
	98, 99, 700, 686, 97, 700, 686, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 635, 636, 266, 
	687, 99, 701, 686, 97, 701, 686, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 635, 636, 266, 
	687, 99, 702, 686, 97, 702, 686, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 635, 636, 266, 
	98, 99, 703, 704, 97, 703, 704, 639, 
	640, 641, 642, 643, 644, 645, 646, 647, 
	648, 649, 650, 651, 652, 352, 653, 437, 
	654, 655, 656, 657, 658, 659, 660, 661, 
	662, 663, 664, 665, 97, 97, 265, 685, 
	685, 324, 457, 610, 97, 674, 636, 266, 
	687, 99, 705, 97, 705, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 675, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 674, 636, 266, 687, 99, 
	702, 686, 97, 702, 686, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 675, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 635, 636, 266, 687, 99, 
	686, 706, 97, 686, 706, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 635, 636, 266, 687, 99, 
	702, 686, 97, 702, 686, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	698, 638, 97, 698, 638, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 637, 637, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	638, 707, 97, 638, 707, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 637, 637, 324, 
	457, 610, 97, 635, 636, 266, 98, 99, 
	686, 708, 97, 686, 708, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 635, 636, 266, 687, 99, 
	709, 686, 97, 709, 686, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 352, 653, 437, 654, 655, 
	656, 657, 658, 659, 660, 661, 662, 663, 
	664, 665, 97, 97, 265, 685, 685, 324, 
	457, 610, 97, 710, 636, 266, 687, 99, 
	686, 97, 686, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 651, 
	652, 352, 653, 437, 654, 655, 656, 711, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	97, 97, 265, 685, 685, 324, 457, 610, 
	97, 666, 667, 98, 99, 669, 670, 669, 
	712, 672, 669, 672, 97, 669, 670, 669, 
	712, 672, 669, 672, 639, 640, 641, 642, 
	643, 644, 645, 646, 647, 648, 649, 650, 
	651, 652, 352, 653, 437, 654, 655, 656, 
	673, 658, 659, 660, 661, 662, 663, 664, 
	665, 97, 97, 97, 668, 668, 324, 457, 
	610, 509, 677, 679, 680, 679, 713, 681, 
	679, 681, 679, 680, 679, 713, 681, 679, 
	681, 639, 640, 641, 642, 643, 644, 645, 
	646, 647, 648, 649, 650, 651, 652, 352, 
	653, 437, 654, 655, 656, 673, 658, 659, 
	660, 661, 662, 663, 664, 665, 315, 315, 
	324, 457, 610, 97, 635, 636, 266, 98, 
	99, 714, 638, 97, 714, 638, 639, 640, 
	641, 642, 643, 644, 645, 646, 647, 648, 
	649, 650, 651, 652, 352, 653, 437, 654, 
	655, 656, 657, 658, 659, 660, 661, 662, 
	663, 664, 665, 97, 97, 265, 637, 637, 
	324, 457, 610, 97, 635, 636, 266, 98, 
	99, 703, 97, 703, 639, 640, 641, 642, 
	643, 644, 645, 646, 647, 648, 649, 650, 
	651, 652, 352, 653, 437, 654, 655, 656, 
	657, 658, 659, 660, 661, 662, 663, 664, 
	665, 97, 97, 265, 685, 685, 324, 457, 
	610, 165, 715, 610, 563, 610, 716, 717, 
	717, 717, 563, 610, 1, 598, 599, 1, 
	600, 601, 602, 603, 563, 597, 405, 677, 
	678, 678, 639, 640, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	352, 653, 437, 654, 655, 656, 657, 658, 
	659, 660, 661, 662, 663, 664, 665, 315, 
	315, 563, 324, 457, 610, 563, 563, 717, 
	610, 717, 610, 717, 717, 717, 563, 717, 
	563, 717, 563, 610, 563, 563, 717, 563, 
	717, 563, 610, 717, 563, 563, 563, 563, 
	717, 610, 563, 717, 610, 717, 563, 717, 
	610, 717, 563, 717, 610, 717, 717, 563, 
	717, 610, 717, 563, 610, 563, 717, 563, 
	717, 563, 610, 563, 717, 610, 563, 717, 
	563, 718, 563, 717, 610, 628, 629, 627, 
	627, 303, 307, 304, 620, 621, 622, 623, 
	624, 300, 563, 610, 563, 717, 717, 563, 
	717, 563, 717, 718, 717, 563, 610, 717, 
	563, 717, 563, 610, 563, 717, 610, 717, 
	717, 563, 610, 717, 718, 717, 563, 717, 
	563, 610, 719, 720, 721, 722, 723, 724, 
	725, 726, 727, 728, 729, 730, 731, 732, 
	733, 734, 735, 734, 736, 737, 738, 739, 
	740, 741, 742, 743, 744, 745, 746, 747, 
	563, 610, 717, 717, 717, 717, 563, 610, 
	717, 563, 610, 717, 563, 717, 563, 610, 
	717, 563, 717, 563, 610, 717, 563, 563, 
	563, 717, 563, 718, 717, 610, 563, 563, 
	717, 563, 717, 563, 717, 563, 717, 563, 
	717, 563, 610, 717, 563, 563, 717, 563, 
	718, 717, 563, 610, 563, 563, 563, 563, 
	563, 717, 563, 717, 563, 717, 563, 610, 
	563, 563, 717, 563, 718, 563, 717, 563, 
	610, 563, 563, 563, 563, 563, 717, 563, 
	717, 563, 610, 717, 563, 717, 563, 718, 
	563, 610, 563, 563, 563, 717, 563, 717, 
	563, 717, 563, 717, 563, 610, 563, 717, 
	563, 717, 563, 718, 563, 610, 717, 563, 
	563, 563, 563, 717, 563, 717, 563, 717, 
	563, 717, 563, 717, 563, 717, 563, 610, 
	717, 563, 718, 563, 610, 563, 563, 563, 
	563, 717, 563, 717, 563, 610, 563, 717, 
	563, 717, 563, 718, 563, 610, 717, 563, 
	563, 717, 563, 718, 717, 563, 610, 563, 
	563, 717, 563, 717, 563, 610, 717, 563, 
	717, 563, 718, 563, 717, 610, 563, 563, 
	563, 717, 563, 717, 563, 610, 717, 563, 
	610, 563, 563, 717, 563, 610, 717, 563, 
	718, 563, 610, 563, 563, 563, 717, 563, 
	563, 563, 563, 563, 563, 717, 717, 563, 
	717, 563, 717, 563, 717, 563, 610, 563, 
	717, 563, 718, 563, 717, 563, 610, 717, 
	563, 718, 563, 610, 563, 717, 563, 610, 
	563, 717, 563, 610, 748, 749, 750, 751, 
	752, 753, 754, 755, 756, 757, 758, 759, 
	760, 761, 762, 763, 764, 765, 766, 767, 
	768, 769, 770, 771, 772, 773, 774, 775, 
	776, 777, 563, 778, 779, 780, 781, 782, 
	783, 563, 784, 563, 785, 786, 787, 788, 
	566, 610, 717, 717, 563, 610, 717, 718, 
	563, 717, 563, 717, 563, 717, 563, 717, 
	563, 717, 610, 717, 717, 563, 718, 563, 
	717, 610, 563, 717, 563, 717, 563, 717, 
	610, 563, 563, 563, 717, 563, 717, 563, 
	717, 610, 563, 563, 563, 717, 563, 717, 
	563, 717, 610, 563, 563, 717, 563, 717, 
	610, 563, 717, 563, 717, 610, 717, 563, 
	610, 717, 563, 717, 610, 717, 563, 610, 
	563, 717, 610, 717, 563, 717, 610, 716, 
	717, 563, 717, 610, 717, 563, 610, 563, 
	717, 563, 717, 563, 610, 563, 717, 563, 
	717, 563, 610, 717, 563, 610, 717, 717, 
	563, 718, 563, 610, 563, 718, 563, 717, 
	610, 717, 563, 610, 563, 717, 563, 717, 
	610, 717, 563, 610, 717, 563, 610, 563, 
	718, 717, 563, 717, 563, 610, 717, 563, 
	610, 563, 717, 563, 718, 563, 610, 717, 
	563, 717, 610, 717, 563, 610, 717, 718, 
	563, 718, 563, 610, 563, 717, 563, 610, 
	563, 717, 563, 718, 563, 610, 563, 717, 
	563, 717, 718, 717, 610, 717, 563, 610, 
	717, 563, 610, 718, 563, 717, 718, 717, 
	563, 610, 563, 563, 717, 563, 717, 563, 
	610, 717, 563, 717, 563, 717, 610, 563, 
	563, 563, 563, 717, 563, 717, 563, 717, 
	563, 610, 563, 563, 563, 717, 610, 563, 
	563, 563, 717, 563, 717, 563, 717, 563, 
	717, 563, 717, 563, 610, 789, 790, 791, 
	792, 793, 794, 795, 796, 566, 797, 798, 
	799, 800, 801, 802, 563, 610, 803, 804, 
	805, 716, 716, 563, 610, 165, 715, 563, 
	610, 165, 806, 806, 614, 563, 610, 133, 
	133, 134, 134, 134, 134, 134, 134, 135, 
	136, 137, 138, 139, 140, 133, 563, 610, 
	716, 717, 717, 563, 610, 563, 717, 563, 
	610, 717, 717, 563, 717, 717, 717, 563, 
	563, 717, 563, 717, 563, 717, 563, 717, 
	610, 717, 563, 717, 563, 610, 563, 717, 
	563, 610, 563, 717, 610, 563, 717, 610, 
	717, 563, 717, 563, 717, 563, 610, 563, 
	717, 717, 563, 717, 610, 717, 717, 563, 
	610, 563, 563, 563, 563, 717, 563, 717, 
	610, 563, 563, 563, 717, 563, 610, 717, 
	563, 610, 807, 759, 808, 809, 810, 566, 
	811, 812, 563, 566, 610, 716, 563, 717, 
	563, 717, 563, 717, 563, 610, 563, 717, 
	563, 717, 610, 563, 717, 610, 563, 717, 
	563, 717, 610, 717, 563, 717, 563, 610, 
	563, 717, 610, 770, 563, 566, 610, 566, 
	610, 813, 566, 610, 717, 563, 610, 813, 
	814, 815, 816, 817, 781, 818, 819, 820, 
	821, 765, 822, 823, 824, 825, 826, 827, 
	828, 829, 830, 831, 832, 833, 566, 563, 
	566, 610, 563, 717, 563, 610, 717, 563, 
	717, 718, 717, 563, 610, 717, 717, 563, 
	610, 717, 563, 717, 610, 563, 717, 563, 
	717, 610, 563, 717, 563, 717, 563, 717, 
	563, 610, 563, 717, 610, 563, 563, 563, 
	717, 563, 610, 563, 717, 563, 610, 717, 
	563, 718, 563, 717, 563, 610, 718, 717, 
	563, 717, 610, 717, 563, 717, 563, 610, 
	563, 717, 563, 610, 717, 563, 718, 563, 
	610, 717, 563, 610, 563, 717, 717, 563, 
	718, 563, 717, 563, 610, 563, 717, 563, 
	717, 563, 717, 563, 610, 563, 717, 563, 
	717, 563, 717, 563, 717, 563, 610, 563, 
	563, 717, 563, 717, 563, 717, 563, 717, 
	563, 610, 717, 563, 718, 563, 610, 834, 
	835, 566, 563, 610, 717, 563, 717, 610, 
	717, 563, 717, 563, 610, 836, 837, 838, 
	839, 840, 841, 842, 843, 844, 845, 563, 
	846, 847, 848, 849, 850, 851, 563, 566, 
	610, 717, 563, 717, 610, 717, 563, 610, 
	717, 563, 563, 563, 563, 717, 563, 717, 
	563, 717, 610, 563, 563, 717, 610, 717, 
	563, 610, 563, 717, 610, 717, 563, 610, 
	563, 717, 610, 717, 563, 717, 610, 717, 
	563, 717, 563, 610, 563, 563, 717, 610, 
	717, 563, 610, 563, 718, 563, 717, 563, 
	610, 563, 717, 563, 717, 610, 563, 717, 
	610, 563, 717, 563, 717, 563, 717, 563, 
	717, 563, 610, 852, 853, 854, 855, 856, 
	857, 858, 859, 860, 861, 862, 563, 588, 
	563, 610, 863, 864, 566, 865, 866, 867, 
	868, 869, 870, 871, 872, 873, 874, 875, 
	876, 877, 878, 770, 879, 566, 880, 563, 
	566, 563, 610, 563, 563, 563, 563, 717, 
	610, 717, 563, 717, 563, 610, 717, 563, 
	610, 717, 563, 717, 610, 717, 563, 610, 
	717, 563, 717, 610, 563, 717, 563, 610, 
	717, 563, 717, 610, 717, 563, 717, 563, 
	610, 717, 563, 718, 563, 610, 717, 563, 
	717, 717, 717, 563, 717, 563, 610, 717, 
	563, 610, 717, 563, 717, 563, 610, 717, 
	563, 717, 610, 717, 563, 563, 563, 717, 
	563, 610, 563, 717, 563, 610, 717, 563, 
	717, 563, 610, 717, 563, 610, 881, 882, 
	883, 884, 885, 886, 887, 762, 888, 563, 
	610, 563, 717, 563, 610, 563, 718, 563, 
	610, 563, 717, 563, 610, 563, 717, 563, 
	718, 563, 610, 563, 717, 563, 718, 610, 
	563, 717, 563, 610, 563, 717, 563, 718, 
	563, 610, 718, 563, 610, 889, 566, 563, 
	610, 717, 563, 610, 889, 566, 563, 610, 
	890, 566, 891, 892, 563, 566, 563, 610, 
	717, 563, 610, 717, 717, 563, 610, 563, 
	717, 563, 610, 893, 563, 610, 717, 563, 
	610, 894, 895, 896, 897, 898, 899, 900, 
	901, 902, 903, 904, 563, 566, 563, 610, 
	563, 717, 610, 563, 717, 563, 563, 563, 
	717, 563, 717, 563, 717, 610, 563, 717, 
	610, 563, 563, 563, 563, 563, 717, 563, 
	717, 610, 563, 563, 717, 563, 717, 610, 
	717, 563, 717, 610, 563, 563, 563, 717, 
	610, 563, 563, 717, 610, 563, 563, 717, 
	610, 563, 563, 717, 610, 563, 717, 563, 
	718, 610, 905, 906, 907, 563, 610, 563, 
	563, 563, 717, 563, 563, 563, 717, 563, 
	717, 563, 610, 717, 717, 717, 717, 563, 
	563, 717, 717, 717, 717, 717, 563, 563, 
	563, 563, 563, 563, 563, 717, 563, 717, 
	563, 717, 610, 563, 563, 563, 717, 563, 
	717, 563, 610, 908, 566, 610, 717, 563, 
	610, 758, 909, 566, 563, 610, 717, 563, 
	610, 909, 563, 566, 563, 610, 97, 166, 
	98, 99, 97, 97, 97, 97, 97, 97, 
	610, 97, 166, 98, 99, 97, 303, 307, 
	304, 620, 621, 622, 623, 624, 97, 97, 
	910, 97, 97, 610, 97, 616, 625, 98, 
	99, 626, 97, 626, 303, 307, 304, 620, 
	621, 622, 623, 624, 97, 97, 910, 97, 
	97, 610, 97, 98, 99, 97, 303, 307, 
	304, 620, 621, 622, 623, 624, 97, 97, 
	910, 97, 97, 610, 0
};

static const short _english_tokenizer_trans_targs[] = {
	558, 559, 3, 5, 6, 558, 8, 9, 
	558, 89, 11, 12, 13, 14, 15, 16, 
	17, 18, 19, 20, 21, 22, 23, 24, 
	25, 26, 27, 90, 92, 95, 57, 63, 
	69, 10, 29, 39, 55, 28, 30, 31, 
	32, 33, 34, 35, 36, 37, 38, 40, 
	41, 42, 43, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 56, 58, 
	59, 60, 61, 62, 64, 65, 66, 67, 
	68, 70, 72, 71, 73, 74, 75, 76, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 91, 93, 94, 96, 
	558, 97, 98, 100, 99, 101, 122, 124, 
	123, 103, 102, 109, 104, 105, 108, 569, 
	106, 570, 571, 572, 110, 118, 120, 119, 
	111, 112, 114, 116, 115, 113, 573, 574, 
	576, 575, 117, 121, 125, 8, 126, 127, 
	128, 130, 132, 142, 144, 129, 131, 133, 
	134, 135, 136, 137, 138, 139, 140, 141, 
	143, 145, 146, 147, 148, 149, 150, 152, 
	153, 578, 154, 578, 156, 558, 578, 159, 
	237, 238, 239, 240, 243, 246, 247, 248, 
	160, 220, 221, 222, 223, 226, 229, 230, 
	231, 582, 200, 204, 205, 206, 209, 212, 
	213, 214, 583, 181, 184, 185, 186, 189, 
	192, 193, 194, 163, 584, 164, 165, 166, 
	167, 170, 173, 174, 175, 585, 168, 169, 
	171, 172, 176, 177, 179, 178, 180, 586, 
	183, 187, 188, 190, 191, 195, 196, 198, 
	197, 199, 587, 202, 203, 207, 208, 210, 
	211, 215, 216, 218, 217, 219, 224, 225, 
	227, 228, 232, 233, 235, 234, 236, 241, 
	242, 244, 245, 249, 250, 252, 251, 253, 
	255, 256, 257, 258, 264, 266, 259, 260, 
	261, 263, 588, 589, 590, 265, 262, 267, 
	591, 594, 596, 595, 270, 277, 279, 278, 
	271, 272, 273, 275, 274, 276, 280, 282, 
	593, 592, 285, 599, 600, 290, 291, 286, 
	288, 293, 294, 287, 298, 299, 301, 300, 
	302, 304, 305, 613, 558, 308, 309, 558, 
	329, 330, 331, 332, 311, 333, 334, 335, 
	336, 337, 338, 339, 340, 341, 342, 343, 
	344, 345, 346, 347, 348, 349, 350, 351, 
	352, 353, 354, 355, 356, 357, 358, 359, 
	324, 361, 362, 363, 364, 365, 366, 367, 
	368, 369, 370, 371, 372, 373, 374, 375, 
	376, 377, 378, 379, 380, 381, 382, 383, 
	384, 385, 386, 387, 388, 389, 390, 391, 
	392, 393, 394, 395, 396, 397, 399, 400, 
	401, 402, 403, 404, 405, 406, 407, 408, 
	409, 410, 411, 412, 413, 614, 415, 416, 
	417, 418, 419, 420, 424, 426, 427, 428, 
	429, 430, 431, 432, 433, 434, 435, 436, 
	437, 438, 439, 440, 441, 442, 443, 445, 
	446, 448, 449, 450, 451, 326, 452, 453, 
	454, 455, 456, 457, 458, 459, 460, 461, 
	462, 464, 484, 488, 490, 491, 495, 497, 
	512, 422, 516, 518, 519, 465, 466, 467, 
	468, 469, 470, 471, 472, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 482, 483, 
	485, 486, 487, 489, 492, 493, 494, 496, 
	498, 499, 500, 501, 502, 503, 504, 505, 
	506, 507, 508, 509, 510, 511, 513, 514, 
	515, 517, 521, 522, 524, 307, 526, 617, 
	528, 529, 530, 544, 546, 545, 531, 532, 
	540, 542, 541, 533, 534, 536, 538, 537, 
	535, 626, 627, 629, 628, 539, 543, 547, 
	549, 641, 551, 658, 553, 555, 556, 557, 
	563, 567, 568, 579, 0, 580, 581, 601, 
	603, 602, 605, 606, 633, 638, 643, 652, 
	653, 659, 661, 662, 663, 666, 667, 668, 
	669, 670, 671, 672, 673, 674, 675, 676, 
	677, 678, 680, 681, 682, 683, 684, 685, 
	715, 757, 775, 782, 783, 784, 786, 807, 
	810, 827, 886, 887, 889, 558, 560, 562, 
	1, 2, 4, 7, 561, 564, 565, 558, 
	558, 566, 558, 107, 577, 151, 155, 157, 
	158, 268, 598, 284, 289, 292, 295, 296, 
	297, 161, 162, 182, 201, 254, 269, 281, 
	597, 283, 604, 607, 621, 624, 632, 306, 
	310, 312, 313, 314, 315, 316, 317, 318, 
	319, 320, 321, 322, 323, 325, 327, 328, 
	360, 398, 414, 421, 423, 425, 444, 447, 
	463, 520, 303, 608, 609, 609, 612, 610, 
	620, 523, 611, 525, 609, 615, 616, 613, 
	618, 619, 613, 622, 623, 625, 631, 527, 
	630, 634, 635, 636, 637, 625, 639, 548, 
	640, 642, 644, 647, 645, 646, 625, 648, 
	650, 649, 651, 654, 655, 656, 657, 550, 
	610, 616, 660, 552, 664, 665, 679, 686, 
	687, 688, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	703, 704, 705, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 716, 717, 718, 719, 
	720, 721, 722, 723, 724, 725, 726, 727, 
	728, 729, 730, 731, 732, 733, 734, 735, 
	736, 737, 738, 739, 740, 741, 742, 743, 
	744, 745, 746, 747, 748, 749, 750, 751, 
	752, 753, 754, 755, 756, 758, 762, 763, 
	764, 765, 766, 767, 768, 769, 770, 771, 
	772, 773, 774, 759, 760, 761, 554, 776, 
	777, 778, 779, 780, 781, 785, 787, 788, 
	789, 790, 791, 792, 793, 794, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 808, 809, 811, 812, 813, 814, 
	815, 816, 817, 818, 819, 820, 821, 822, 
	823, 824, 825, 826, 828, 847, 856, 858, 
	859, 863, 865, 877, 881, 883, 885, 829, 
	830, 831, 832, 833, 834, 835, 836, 837, 
	838, 839, 840, 841, 842, 843, 844, 845, 
	846, 848, 849, 850, 851, 852, 853, 854, 
	855, 857, 860, 861, 862, 864, 866, 867, 
	868, 869, 870, 871, 872, 873, 874, 875, 
	876, 878, 879, 880, 882, 884, 888
};

static const char _english_tokenizer_trans_actions[] = {
	1, 2, 0, 0, 0, 3, 0, 0, 
	4, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	5, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 6, 
	0, 2, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 6, 6, 
	6, 6, 0, 0, 0, 7, 0, 7, 
	0, 7, 7, 7, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 8, 0, 9, 0, 10, 6, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 0, 0, 0, 0, 0, 
	0, 0, 6, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 6, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 6, 6, 6, 0, 0, 0, 
	6, 6, 6, 6, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	6, 6, 0, 6, 2, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 11, 0, 0, 12, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 6, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 6, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 6, 6, 6, 0, 0, 0, 
	0, 6, 0, 6, 0, 0, 0, 0, 
	2, 2, 6, 6, 0, 6, 6, 6, 
	6, 6, 2, 6, 6, 6, 6, 6, 
	6, 6, 2, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 6, 6, 6, 15, 2, 2, 
	0, 0, 0, 0, 2, 0, 2, 16, 
	17, 0, 18, 0, 6, 0, 0, 0, 
	0, 0, 6, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	6, 0, 6, 6, 6, 6, 6, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 6, 8, 6, 6, 
	6, 0, 6, 0, 9, 6, 6, 8, 
	6, 6, 9, 6, 6, 6, 6, 0, 
	6, 6, 6, 6, 6, 9, 6, 0, 
	6, 6, 6, 6, 6, 6, 8, 6, 
	6, 6, 6, 6, 6, 6, 6, 0, 
	8, 8, 6, 0, 2, 6, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 6
};

static const char _english_tokenizer_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 13, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const char _english_tokenizer_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 14, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _english_tokenizer_eof_trans[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 6, 6, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 97, 6, 6, 6, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 6, 6, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 0, 598, 
	598, 598, 598, 598, 608, 598, 608, 598, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 97, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 97, 97, 611, 611, 97, 611, 611, 
	97, 611, 611, 611, 611, 611, 611, 611, 
	611, 97, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	598, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611, 611, 611, 611, 611, 611, 611, 
	611, 611
};

static const int english_tokenizer_start = 558;
static const int english_tokenizer_first_final = 558;
static const int english_tokenizer_error = 0;

static const int english_tokenizer_en_main = 558;




// The list of lower cased words that when preceding eos do not end sentence.
static unordered_set<string> eos_word_exceptions = {
  // Titles
  "adj", "adm", "adv", "assoc", "asst", "bart", "bldg", "brig", "bros", "capt",
  "cmdr", "col", "comdr", "con", "corp", "cpl", "d", "dr", "dr", "drs", "ens",
  "gen", "gov", "hon", "hosp", "hr", "insp", "lt", "mm", "mr", "mrs", "ms",
  "maj", "messrs", "mlle", "mme", "mr", "mrs", "ms", "msgr", "op", "ord",
  "pfc", "ph", "phd", "prof", "pvt", "rep", "reps", "res", "rev", "rt", "sen",
  "sens", "sfc", "sgt", "sr", "st", "supt", "surg", "univ",
  // Common abbrevs
  "addr", "approx", "apr", "aug", "calif", "co", "corp", "dec", "def", "e",
  "e.g", "eg", "feb", "fla", "ft", "gen", "gov", "hrs", "i.", "i.e", "ie",
  "inc", "jan", "jr", "ltd", "mar", "max", "min", "mph", "mt", "n", "nov",
  "oct", "ont", "pa", "pres", "rep", "rev", "s", "sec", "sen", "sep", "sept",
  "sgt", "sr", "tel", "un", "univ", "v", "va", "vs", "w", "yrs",
};

bool english_tokenizer::next_sentence(vector<string_piece>& forms) {
  int cs, act;
  const char* ts, *te;
  const char* text_start = text;

  char32_t unary_chr;
  const char* unary_text;
  const char* whitespace = nullptr; // Suppress "may be uninitialized" warning
  
	{
	cs = english_tokenizer_start;
	ts = 0;
	te = 0;
	act = 0;
	}

	{
	int _klen;
	const short *_keys;
	int _trans;
	short _widec;

	if ( ( text) == ( text_end) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	switch ( _english_tokenizer_from_state_actions[cs] ) {
	case 14:
	{ts = ( text);}
	break;
	}

	_widec = ( (unsigned char)*text);
	_klen = _english_tokenizer_cond_lengths[cs];
	_keys = _english_tokenizer_cond_keys + (_english_tokenizer_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _english_tokenizer_cond_spaces[_english_tokenizer_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && !utf8::is_Pd(unary_chr))  ) _widec += 256;
		break;
	}
	case 1: {
		_widec = (short)(768u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && unary_chr != '+')  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _english_tokenizer_trans_keys + _english_tokenizer_key_offsets[cs];
	_trans = _english_tokenizer_index_offsets[cs];

	_klen = _english_tokenizer_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _english_tokenizer_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _english_tokenizer_indicies[_trans];
_eof_trans:
	cs = _english_tokenizer_trans_targs[_trans];

	if ( _english_tokenizer_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _english_tokenizer_trans_actions[_trans] ) {
	case 7:
	{ whitespace = text; }
	break;
	case 2:
	{te = ( text)+1;}
	break;
	case 11:
	{te = ( text)+1;{ forms.emplace_back(ts, te - 2 - ts);
          forms.emplace_back(te - 2, 2);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 12:
	{te = ( text)+1;{ forms.emplace_back(ts, te - 3 - ts);
          forms.emplace_back(te - 3, 3);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 10:
	{te = ( text)+1;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 4:
	{te = ( text)+1;{
          // Does this eos character marks end of sentence?
          bool eos_word_exception = false;
          if (!forms.empty()) {
            // Is it single Lut?
            string_piece form = forms.back();
            eos_word_exception = utf8::is_Lut(utf8::decode(form.str, form.len)) && !form.len;

            // Is the lower case variant in eos_word_exceptions?
            buffer.clear(); utf8::lowercase(forms.back().str, forms.back().len, buffer);
            eos_word_exception |= eos_word_exceptions.count(buffer);
          }

          // Add all characters until first space to forms and break if eos.
          for (text = ts; text < whitespace; forms.emplace_back(ts, text - ts), ts = text) utf8_advance(text, whitespace);
          {( text) = (( whitespace))-1;}
          if (!eos_word_exception) {( text)++; goto _out; }
        }}
	break;
	case 17:
	{te = ( text)+1;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 18:
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 15:
	{te = ( text);( text)--;}
	break;
	case 16:
	{te = ( text);( text)--;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 3:
	{{( text) = ((te))-1;}{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 1:
	{{( text) = ((te))-1;}}
	break;
	case 5:
	{	switch( act ) {
	case 1:
	{{( text) = ((te))-1;} forms.emplace_back(ts, te - 2 - ts);
          forms.emplace_back(te - 2, 2);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }
	break;
	case 2:
	{{( text) = ((te))-1;} forms.emplace_back(ts, te - 3 - ts);
          forms.emplace_back(te - 3, 3);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }
	break;
	case 3:
	{{( text) = ((te))-1;} forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }
	break;
	}
	}
	break;
	case 8:
	{te = ( text)+1;}
	{act = 1;}
	break;
	case 9:
	{te = ( text)+1;}
	{act = 2;}
	break;
	case 6:
	{te = ( text)+1;}
	{act = 3;}
	break;
	}

_again:
	switch ( _english_tokenizer_to_state_actions[cs] ) {
	case 13:
	{ts = 0;}
	break;
	}

	if ( cs == 0 )
		goto _out;
	if ( ++( text) != ( text_end) )
		goto _resume;
	_test_eof: {}
	if ( ( text) == ( text_end) )
	{
	if ( _english_tokenizer_eof_trans[cs] > 0 ) {
		_trans = _english_tokenizer_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}


  (void)act; // Suppress unused variable warning

  return !forms.empty();
}

} // namespace morphodita
} // namespace ufal


