// This file is part of MorphoDiTa.
//
// Copyright 2013 by Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// MorphoDiTa is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of
// the License, or (at your option) any later version.
//
// MorphoDiTa is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with MorphoDiTa.  If not, see <http://www.gnu.org/licenses/>.

#include <cstring>
#include <unordered_set>

#include "generic_tokenizer.h"
#include "../utils/utf8.h"

namespace ufal {
namespace morphodita {


static const char _generic_tokenizer_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2
};

static const char _generic_tokenizer_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _generic_tokenizer_cond_keys[] = {
	43u, 43u, 45u, 45u, 0
};

static const char _generic_tokenizer_cond_spaces[] = {
	1, 0, 0
};

static const short _generic_tokenizer_key_offsets[] = {
	0, 0, 1, 2, 3, 5, 8, 9, 
	10, 45, 76, 77, 81, 113, 144, 175, 
	206, 236, 243, 246, 256, 277, 279, 295, 
	323, 355, 377, 379, 380, 382, 392, 394, 
	398, 399, 431, 459, 467, 475, 483, 491, 
	507, 513, 515, 516, 534, 535, 536, 539, 
	546, 552, 563, 566, 568, 580, 601, 611, 
	612, 622, 627, 650, 662, 676, 704, 718, 
	723, 724, 731, 737, 741, 744, 746, 747, 
	749, 765, 769, 773, 785, 787, 799, 806, 
	810, 812, 816, 820, 824, 827, 829, 831, 
	833, 834, 836, 846, 848, 864, 873, 876, 
	877, 888, 902, 914, 927, 936, 944, 951, 
	959, 965, 973, 990, 992, 1000, 1009, 1017, 
	1026, 1034, 1043, 1051, 1059, 1070, 1080, 1088, 
	1096, 1107, 1117, 1125, 1133, 1144, 1154, 1170, 
	1172, 1173, 1175, 1176, 1178, 1187, 1193, 1196, 
	1197, 1200, 1207, 1213, 1224, 1227, 1237, 1238, 
	1250, 1255, 1256, 1262, 1269, 1271, 1274, 1305, 
	1320, 1336, 1350, 1366, 1381, 1395, 1411, 1423, 
	1439, 1455, 1472, 1488, 1505, 1530, 1547, 1563, 
	1580, 1597, 1614, 1631, 1651, 1670, 1686, 1702, 
	1721, 1739, 1764, 1786, 1788, 1790, 1792, 1804, 
	1806, 1808, 1818, 1820, 1824, 1830, 1831, 1834, 
	1835, 1840, 1842, 1843, 1845, 1868, 1870, 1882, 
	1892, 1894, 1896, 1908, 1910, 1912, 1922, 1924, 
	1928, 1934, 1935, 1938, 1939, 1944, 1946, 1947, 
	1949, 1971, 1996, 2019, 2021, 2031, 2033, 2035, 
	2047, 2049, 2051, 2061, 2063, 2067, 2073, 2074, 
	2077, 2078, 2083, 2085, 2086, 2088, 2099, 2100, 
	2115, 2131, 2148, 2164, 2181, 2197, 2214, 2230, 
	2246, 2265, 2283, 2299, 2315, 2334, 2352, 2368, 
	2384, 2403, 2421, 2424, 2430, 2432, 2440, 2446, 
	2454, 2458, 2462, 2466, 2471, 2476, 2485, 2489, 
	2493, 2504, 2506, 2510, 2512, 2515, 2547, 2549, 
	2551, 2554, 2556, 2562, 2577, 2590, 2609, 2621, 
	2637, 2646, 2662, 2675, 2696, 2704, 2718, 2730, 
	2744, 2757, 2767, 2778, 2787, 2797, 2799, 2801, 
	2822, 2829, 2837, 2843, 2849, 2850, 2894, 2900, 
	2908, 2919, 2929, 2936, 2942, 2946, 2950, 2952, 
	2954, 2958, 2962, 2964, 2970, 2978, 2983, 2987, 
	2989, 2993, 2995, 3001, 3005, 3009, 3011, 3015, 
	3020, 3021, 3025, 3029, 3031, 3035, 3039, 3043, 
	3049, 3060, 3065, 3079, 3094, 3096, 3098, 3100, 
	3116, 3119, 3121, 3125, 3129, 3133, 3139, 3143, 
	3153, 3163, 3164, 3174, 3182, 3190, 3194, 3198, 
	3202, 3204, 3209, 3211, 3214, 3216, 3240, 3242, 
	3248, 3253, 3257, 3261, 3265, 3273, 3275, 3277, 
	3282, 3286, 3290, 3292, 3294, 3300, 3308, 3318, 
	3322, 3326, 3330, 3334, 3353, 3357, 3359, 3370, 
	3376, 3378, 3380, 3384, 3388, 3392, 3396, 3398, 
	3400, 3404, 3406, 3414, 3427, 3451, 3460, 3464, 
	3466, 3467, 3471, 3473, 3477, 3480, 3484, 3488, 
	3490, 3499, 3501, 3505, 3509, 3522, 3524, 3528, 
	3530, 3538, 3540, 3542, 3544, 3547, 3549, 3552, 
	3558, 3560, 3564, 3566, 3567, 3569, 3585, 3591, 
	3597, 3599, 3603, 3617, 3621, 3633, 3640, 3644, 
	3651, 3657, 3663, 3669, 3673, 3676, 3690, 3716, 
	3726, 3729, 3731, 3735, 3738, 3739, 3742, 3744, 
	3766, 3790, 3861, 3869, 3876, 3882, 3889, 3897, 
	3898, 3906, 3907, 3915, 3946, 3956, 3973, 3976, 
	3986, 3996, 4006, 4016, 4029, 4041, 4055, 4081, 
	4098, 4112, 4129, 4155, 4181, 4203, 4213, 4237, 
	4249, 4275, 4301, 4330, 4358, 4384, 4408, 4421, 
	4447, 4473, 4502, 4530, 4546, 4595, 4644, 4693, 
	4710, 4727, 4744, 4764, 4783, 4820, 4822, 4828, 
	4838, 4877, 4881, 4883, 4897, 4908, 4916, 4919, 
	4925, 4931, 4938, 4942, 4952, 4956, 4967, 4982, 
	5000, 5007, 5011, 5016, 5027, 5059, 5066, 5070, 
	5077, 5084, 5097, 5118, 5132, 5150, 5165, 5177, 
	5188, 5206, 5218, 5248, 5255, 5266, 5280, 5294, 
	5303, 5316, 5328, 5332, 5338, 5346, 5373, 5386, 
	5393, 5398, 5404, 5450, 5455, 5478, 5489, 5498, 
	5511, 5524, 5532, 5539, 5543, 5549, 5553, 5556, 
	5562, 5569, 5573, 5582, 5591, 5595, 5603, 5611, 
	5615, 5622, 5626, 5630, 5642, 5646, 5655, 5661, 
	5665, 5674, 5680, 5690, 5702, 5706, 5710, 5722, 
	5733, 5743, 5759, 5764, 5788, 5805, 5811, 5829, 
	5834, 5840, 5863, 5870, 5876, 5879, 5882, 5894, 
	5902, 5907, 5917, 5924, 5927, 5939, 5954, 5961, 
	5964, 5972, 5980, 5984, 5988, 5990, 5993, 5997, 
	6026, 6032, 6044, 6049, 6055, 6063, 6076, 6080, 
	6087, 6093, 6104, 6112, 6120, 6126, 6133, 6137, 
	6151, 6164, 6181, 6199, 6207, 6213, 6219, 6227, 
	6248, 6254, 6258, 6273, 6277, 6281, 6285, 6289, 
	6293, 6299, 6307, 6312, 6316, 6326, 6333, 6336, 
	6354, 6371, 6398, 6404, 6412, 6416, 6422, 6426, 
	6432, 6437, 6443, 6451, 6459, 6471, 6475, 6483, 
	6489, 6498, 6504, 6512, 6516, 6527, 6533, 6539, 
	6545, 6555, 6563, 6569, 6578, 6582, 6587, 6591, 
	6596, 6606, 6610, 6615, 6621, 6624, 6628, 6645, 
	6648, 6663, 6666, 6677, 6685, 6691, 6696, 6700, 
	6704, 6708, 6715, 6720, 6735, 6764, 6775, 6778, 
	6782, 6788, 6792, 6799, 6821, 6846
};

static const short _generic_tokenizer_trans_keys[] = {
	160u, 154u, 128u, 128u, 129u, 175u, 128u, 138u, 
	159u, 128u, 13u, 32u, 34u, 40u, 91u, 96u, 
	123u, 194u, 195u, 196u, 197u, 198u, 199u, 200u, 
	201u, 205u, 206u, 207u, 208u, 209u, 210u, 211u, 
	212u, 213u, 224u, 225u, 226u, 227u, 234u, 239u, 
	240u, 9u, 10u, 65u, 90u, 34u, 40u, 91u, 
	96u, 123u, 194u, 195u, 196u, 197u, 198u, 199u, 
	200u, 201u, 205u, 206u, 207u, 208u, 209u, 210u, 
	211u, 212u, 213u, 224u, 225u, 226u, 227u, 234u, 
	239u, 240u, 65u, 90u, 171u, 128u, 150u, 152u, 
	158u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 185u, 187u, 189u, 
	191u, 129u, 131u, 133u, 135u, 138u, 140u, 142u, 
	144u, 146u, 148u, 150u, 152u, 154u, 156u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 187u, 189u, 184u, 185u, 
	132u, 162u, 164u, 169u, 172u, 181u, 188u, 129u, 
	130u, 134u, 135u, 137u, 139u, 142u, 145u, 147u, 
	148u, 150u, 152u, 156u, 157u, 159u, 160u, 166u, 
	167u, 174u, 175u, 177u, 179u, 183u, 184u, 141u, 
	143u, 145u, 147u, 149u, 151u, 153u, 155u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	180u, 186u, 188u, 190u, 132u, 133u, 135u, 136u, 
	138u, 139u, 177u, 178u, 182u, 184u, 128u, 130u, 
	132u, 134u, 136u, 138u, 140u, 142u, 144u, 146u, 
	148u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 176u, 178u, 
	186u, 187u, 189u, 190u, 129u, 136u, 138u, 140u, 
	142u, 131u, 134u, 176u, 178u, 182u, 134u, 140u, 
	136u, 138u, 142u, 143u, 145u, 161u, 163u, 171u, 
	143u, 152u, 154u, 156u, 158u, 160u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 180u, 183u, 146u, 
	148u, 185u, 186u, 189u, 191u, 128u, 175u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 131u, 133u, 135u, 137u, 139u, 
	141u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 184u, 186u, 188u, 
	190u, 128u, 129u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 177u, 
	191u, 128u, 150u, 188u, 186u, 188u, 130u, 131u, 
	154u, 186u, 188u, 189u, 190u, 191u, 184u, 187u, 
	160u, 191u, 135u, 141u, 128u, 133u, 155u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 150u, 152u, 154u, 156u, 158u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 136u, 143u, 152u, 157u, 168u, 
	175u, 184u, 191u, 153u, 155u, 157u, 159u, 136u, 
	141u, 168u, 175u, 136u, 143u, 152u, 159u, 168u, 
	175u, 184u, 188u, 136u, 140u, 152u, 155u, 168u, 
	172u, 184u, 188u, 128u, 129u, 130u, 132u, 133u, 
	134u, 140u, 157u, 159u, 166u, 167u, 176u, 177u, 
	178u, 179u, 184u, 152u, 185u, 154u, 156u, 158u, 
	159u, 133u, 189u, 141u, 130u, 135u, 149u, 164u, 
	166u, 168u, 139u, 141u, 144u, 146u, 153u, 157u, 
	170u, 173u, 176u, 179u, 190u, 191u, 133u, 131u, 
	136u, 138u, 169u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 133u, 166u, 168u, 170u, 172u, 174u, 
	131u, 133u, 135u, 137u, 139u, 141u, 143u, 145u, 
	147u, 149u, 151u, 152u, 154u, 188u, 128u, 174u, 
	160u, 167u, 169u, 171u, 178u, 181u, 162u, 164u, 
	173u, 176u, 190u, 191u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 171u, 173u, 
	178u, 130u, 132u, 137u, 140u, 156u, 160u, 162u, 
	164u, 166u, 168u, 128u, 136u, 138u, 140u, 142u, 
	144u, 148u, 150u, 152u, 154u, 157u, 153u, 154u, 
	156u, 157u, 158u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 185u, 187u, 189u, 190u, 
	128u, 130u, 132u, 134u, 139u, 141u, 144u, 146u, 
	160u, 162u, 164u, 166u, 168u, 170u, 180u, 184u, 
	185u, 188u, 189u, 190u, 151u, 181u, 183u, 185u, 
	187u, 189u, 191u, 129u, 131u, 135u, 153u, 155u, 
	157u, 136u, 187u, 161u, 186u, 155u, 159u, 162u, 
	144u, 157u, 144u, 128u, 167u, 144u, 145u, 146u, 
	147u, 148u, 149u, 150u, 151u, 152u, 153u, 154u, 
	155u, 156u, 157u, 158u, 159u, 128u, 153u, 180u, 
	191u, 128u, 141u, 168u, 191u, 156u, 162u, 128u, 
	129u, 158u, 159u, 165u, 166u, 169u, 172u, 174u, 
	181u, 144u, 169u, 132u, 133u, 135u, 138u, 141u, 
	148u, 150u, 156u, 184u, 185u, 187u, 190u, 134u, 
	128u, 132u, 138u, 144u, 172u, 191u, 128u, 133u, 
	160u, 185u, 148u, 173u, 136u, 161u, 188u, 191u, 
	128u, 149u, 176u, 191u, 128u, 137u, 168u, 191u, 
	128u, 162u, 186u, 156u, 180u, 150u, 174u, 144u, 
	168u, 138u, 160u, 171u, 130u, 131u, 154u, 186u, 
	188u, 189u, 190u, 191u, 184u, 187u, 128u, 155u, 
	128u, 129u, 130u, 132u, 133u, 134u, 140u, 157u, 
	159u, 166u, 167u, 176u, 177u, 178u, 179u, 184u, 
	152u, 175u, 185u, 128u, 138u, 154u, 156u, 158u, 
	159u, 133u, 159u, 189u, 128u, 128u, 136u, 138u, 
	140u, 142u, 144u, 148u, 150u, 152u, 154u, 157u, 
	33u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 64u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 39u, 41u, 
	61u, 95u, 36u, 47u, 48u, 57u, 58u, 59u, 
	63u, 64u, 65u, 90u, 97u, 122u, 48u, 57u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	48u, 49u, 50u, 51u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 48u, 49u, 50u, 51u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 48u, 49u, 50u, 51u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 53u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 53u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 53u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 34u, 39u, 41u, 59u, 
	93u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 160u, 187u, 188u, 187u, 189u, 154u, 
	128u, 156u, 128u, 129u, 130u, 140u, 157u, 159u, 
	166u, 167u, 184u, 153u, 157u, 175u, 186u, 128u, 
	138u, 134u, 159u, 190u, 142u, 137u, 139u, 170u, 
	169u, 171u, 173u, 175u, 177u, 179u, 181u, 134u, 
	167u, 169u, 171u, 173u, 175u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	153u, 155u, 189u, 131u, 133u, 138u, 141u, 157u, 
	161u, 163u, 165u, 167u, 169u, 128u, 128u, 137u, 
	139u, 141u, 143u, 145u, 149u, 151u, 153u, 155u, 
	158u, 159u, 180u, 184u, 185u, 188u, 189u, 191u, 
	152u, 182u, 184u, 186u, 188u, 190u, 128u, 130u, 
	132u, 136u, 154u, 156u, 158u, 137u, 189u, 157u, 
	160u, 163u, 13u, 32u, 33u, 34u, 40u, 58u, 
	59u, 64u, 93u, 95u, 125u, 194u, 224u, 225u, 
	226u, 227u, 239u, 9u, 10u, 36u, 37u, 39u, 
	41u, 42u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 48u, 49u, 50u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 48u, 49u, 50u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 51u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 43u, 45u, 46u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 160u, 169u, 176u, 185u, 128u, 137u, 
	165u, 167u, 169u, 171u, 173u, 175u, 177u, 179u, 
	181u, 185u, 187u, 188u, 166u, 175u, 144u, 153u, 
	129u, 130u, 159u, 160u, 165u, 167u, 170u, 173u, 
	174u, 177u, 134u, 143u, 128u, 137u, 144u, 153u, 
	152u, 163u, 164u, 167u, 169u, 175u, 188u, 144u, 
	145u, 157u, 146u, 129u, 131u, 132u, 135u, 155u, 
	182u, 191u, 159u, 142u, 191u, 33u, 45u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 160u, 169u, 43u, 45u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 176u, 185u, 128u, 137u, 
	165u, 167u, 169u, 171u, 173u, 175u, 177u, 179u, 
	181u, 185u, 187u, 188u, 166u, 175u, 144u, 153u, 
	129u, 130u, 159u, 160u, 165u, 167u, 170u, 173u, 
	174u, 177u, 134u, 143u, 128u, 137u, 144u, 153u, 
	152u, 163u, 164u, 167u, 169u, 175u, 188u, 144u, 
	145u, 157u, 146u, 129u, 131u, 132u, 135u, 155u, 
	182u, 191u, 159u, 142u, 191u, 33u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 43u, 45u, 46u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 160u, 169u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 48u, 57u, 176u, 
	185u, 128u, 137u, 165u, 167u, 169u, 171u, 173u, 
	175u, 177u, 179u, 181u, 185u, 187u, 188u, 166u, 
	175u, 144u, 153u, 129u, 130u, 159u, 160u, 165u, 
	167u, 170u, 173u, 174u, 177u, 134u, 143u, 128u, 
	137u, 144u, 153u, 152u, 163u, 164u, 167u, 169u, 
	175u, 188u, 144u, 145u, 157u, 146u, 129u, 131u, 
	132u, 135u, 155u, 182u, 191u, 159u, 142u, 191u, 
	33u, 47u, 95u, 36u, 37u, 39u, 57u, 65u, 
	90u, 97u, 122u, 47u, 33u, 48u, 49u, 50u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 48u, 49u, 50u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 51u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 48u, 49u, 50u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 51u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 48u, 49u, 
	50u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	51u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 53u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 170u, 181u, 186u, 
	128u, 150u, 152u, 182u, 184u, 191u, 128u, 191u, 
	172u, 174u, 128u, 129u, 134u, 145u, 160u, 164u, 
	128u, 180u, 182u, 183u, 186u, 189u, 134u, 140u, 
	136u, 138u, 142u, 161u, 163u, 191u, 128u, 181u, 
	183u, 191u, 128u, 129u, 131u, 191u, 128u, 167u, 
	177u, 191u, 153u, 128u, 150u, 161u, 191u, 191u, 
	128u, 135u, 145u, 189u, 135u, 129u, 130u, 132u, 
	133u, 144u, 170u, 176u, 178u, 144u, 154u, 160u, 
	191u, 128u, 159u, 174u, 191u, 191u, 128u, 147u, 
	149u, 156u, 159u, 168u, 170u, 175u, 186u, 188u, 
	144u, 191u, 128u, 138u, 141u, 191u, 128u, 177u, 
	186u, 138u, 181u, 160u, 161u, 162u, 163u, 164u, 
	165u, 166u, 167u, 168u, 169u, 170u, 171u, 172u, 
	173u, 174u, 175u, 176u, 177u, 178u, 179u, 180u, 
	181u, 182u, 183u, 184u, 185u, 186u, 187u, 188u, 
	189u, 190u, 191u, 128u, 173u, 128u, 155u, 160u, 
	162u, 172u, 164u, 190u, 128u, 163u, 177u, 183u, 
	185u, 191u, 178u, 129u, 131u, 133u, 140u, 143u, 
	144u, 147u, 168u, 170u, 176u, 182u, 185u, 188u, 
	191u, 151u, 128u, 132u, 135u, 136u, 139u, 142u, 
	156u, 157u, 159u, 163u, 176u, 177u, 188u, 129u, 
	131u, 133u, 138u, 143u, 144u, 147u, 168u, 170u, 
	176u, 178u, 179u, 181u, 182u, 184u, 185u, 190u, 
	191u, 145u, 158u, 128u, 130u, 135u, 136u, 139u, 
	141u, 153u, 156u, 176u, 181u, 129u, 131u, 133u, 
	141u, 143u, 145u, 147u, 168u, 170u, 176u, 178u, 
	179u, 181u, 185u, 188u, 191u, 144u, 128u, 133u, 
	135u, 137u, 139u, 141u, 160u, 163u, 129u, 131u, 
	133u, 140u, 143u, 144u, 147u, 168u, 170u, 176u, 
	178u, 179u, 181u, 185u, 188u, 191u, 177u, 128u, 
	132u, 135u, 136u, 139u, 141u, 150u, 151u, 156u, 
	157u, 159u, 163u, 156u, 130u, 131u, 133u, 138u, 
	142u, 144u, 146u, 149u, 153u, 154u, 158u, 159u, 
	163u, 164u, 168u, 170u, 174u, 185u, 190u, 191u, 
	144u, 151u, 128u, 130u, 134u, 136u, 138u, 141u, 
	129u, 131u, 133u, 140u, 142u, 144u, 146u, 168u, 
	170u, 179u, 181u, 185u, 189u, 191u, 128u, 132u, 
	134u, 136u, 138u, 141u, 149u, 150u, 152u, 153u, 
	160u, 163u, 130u, 131u, 133u, 140u, 142u, 144u, 
	146u, 168u, 170u, 179u, 181u, 185u, 188u, 191u, 
	158u, 128u, 132u, 134u, 136u, 138u, 141u, 149u, 
	150u, 160u, 163u, 177u, 178u, 130u, 131u, 133u, 
	140u, 142u, 144u, 146u, 186u, 189u, 191u, 151u, 
	128u, 132u, 134u, 136u, 138u, 142u, 160u, 163u, 
	186u, 191u, 189u, 130u, 131u, 133u, 150u, 154u, 
	177u, 179u, 187u, 138u, 150u, 128u, 134u, 143u, 
	148u, 152u, 159u, 178u, 179u, 129u, 186u, 128u, 
	142u, 132u, 138u, 141u, 165u, 167u, 129u, 130u, 
	135u, 136u, 148u, 151u, 153u, 159u, 161u, 163u, 
	170u, 171u, 173u, 185u, 187u, 189u, 134u, 128u, 
	132u, 136u, 141u, 156u, 159u, 128u, 181u, 183u, 
	185u, 152u, 153u, 190u, 191u, 128u, 135u, 137u, 
	172u, 177u, 191u, 128u, 132u, 134u, 151u, 153u, 
	188u, 134u, 129u, 130u, 131u, 137u, 138u, 139u, 
	140u, 141u, 142u, 143u, 144u, 153u, 154u, 155u, 
	156u, 157u, 159u, 160u, 161u, 162u, 163u, 164u, 
	165u, 166u, 167u, 168u, 169u, 170u, 172u, 173u, 
	174u, 175u, 176u, 177u, 179u, 183u, 188u, 189u, 
	190u, 191u, 128u, 158u, 180u, 187u, 128u, 143u, 
	154u, 157u, 160u, 191u, 135u, 141u, 128u, 133u, 
	144u, 186u, 188u, 191u, 152u, 128u, 136u, 138u, 
	141u, 144u, 150u, 154u, 157u, 160u, 191u, 128u, 
	136u, 138u, 141u, 144u, 176u, 178u, 181u, 184u, 
	190u, 128u, 130u, 133u, 136u, 150u, 152u, 191u, 
	128u, 144u, 146u, 149u, 152u, 191u, 128u, 154u, 
	157u, 159u, 128u, 143u, 160u, 191u, 128u, 180u, 
	129u, 191u, 128u, 172u, 175u, 191u, 129u, 154u, 
	160u, 191u, 128u, 170u, 128u, 140u, 142u, 148u, 
	160u, 180u, 128u, 147u, 160u, 172u, 174u, 176u, 
	178u, 179u, 151u, 128u, 147u, 156u, 157u, 139u, 
	141u, 160u, 191u, 128u, 183u, 128u, 170u, 176u, 
	191u, 128u, 181u, 128u, 156u, 160u, 171u, 176u, 
	187u, 144u, 173u, 176u, 180u, 128u, 171u, 176u, 
	191u, 128u, 137u, 128u, 155u, 160u, 191u, 191u, 
	128u, 158u, 160u, 188u, 167u, 128u, 139u, 171u, 
	179u, 128u, 175u, 186u, 191u, 128u, 179u, 141u, 
	143u, 154u, 189u, 144u, 146u, 148u, 182u, 128u, 
	166u, 188u, 191u, 128u, 149u, 152u, 157u, 160u, 
	191u, 153u, 155u, 157u, 128u, 133u, 136u, 141u, 
	144u, 151u, 159u, 189u, 190u, 128u, 180u, 182u, 
	188u, 130u, 132u, 134u, 140u, 144u, 147u, 150u, 
	155u, 160u, 172u, 178u, 180u, 182u, 188u, 129u, 
	130u, 131u, 132u, 133u, 134u, 176u, 177u, 178u, 
	179u, 180u, 181u, 182u, 183u, 184u, 177u, 191u, 
	144u, 156u, 144u, 176u, 130u, 135u, 149u, 164u, 
	166u, 168u, 138u, 147u, 153u, 157u, 170u, 173u, 
	175u, 185u, 188u, 191u, 142u, 133u, 137u, 131u, 
	132u, 128u, 174u, 176u, 191u, 128u, 158u, 160u, 
	191u, 128u, 164u, 171u, 179u, 167u, 173u, 128u, 
	165u, 176u, 191u, 175u, 191u, 128u, 167u, 128u, 
	150u, 160u, 166u, 168u, 174u, 176u, 182u, 184u, 
	190u, 128u, 134u, 136u, 142u, 144u, 150u, 152u, 
	158u, 160u, 191u, 175u, 128u, 129u, 130u, 131u, 
	132u, 133u, 134u, 135u, 144u, 191u, 133u, 134u, 
	170u, 175u, 177u, 181u, 187u, 188u, 128u, 150u, 
	153u, 154u, 157u, 159u, 161u, 191u, 128u, 186u, 
	188u, 191u, 133u, 173u, 177u, 191u, 128u, 142u, 
	160u, 186u, 176u, 191u, 182u, 128u, 181u, 184u, 
	191u, 128u, 191u, 191u, 128u, 190u, 128u, 140u, 
	146u, 147u, 152u, 153u, 154u, 155u, 156u, 158u, 
	159u, 160u, 161u, 163u, 164u, 165u, 167u, 168u, 
	169u, 171u, 172u, 175u, 128u, 170u, 176u, 191u, 
	144u, 189u, 128u, 140u, 144u, 159u, 170u, 171u, 
	191u, 128u, 178u, 180u, 189u, 128u, 151u, 159u, 
	191u, 128u, 165u, 176u, 177u, 151u, 159u, 162u, 
	191u, 128u, 136u, 139u, 142u, 144u, 147u, 160u, 
	170u, 184u, 191u, 128u, 167u, 187u, 128u, 132u, 
	160u, 183u, 138u, 173u, 176u, 191u, 128u, 147u, 
	160u, 188u, 128u, 143u, 128u, 182u, 128u, 141u, 
	160u, 182u, 186u, 187u, 128u, 130u, 155u, 157u, 
	160u, 175u, 178u, 182u, 129u, 134u, 137u, 142u, 
	145u, 150u, 160u, 166u, 168u, 174u, 128u, 170u, 
	172u, 173u, 158u, 159u, 128u, 157u, 128u, 163u, 
	176u, 191u, 128u, 134u, 139u, 187u, 169u, 171u, 
	172u, 173u, 174u, 175u, 180u, 181u, 182u, 183u, 
	184u, 185u, 187u, 188u, 189u, 190u, 191u, 164u, 
	186u, 128u, 173u, 176u, 191u, 128u, 153u, 190u, 
	128u, 134u, 147u, 151u, 157u, 168u, 170u, 182u, 
	184u, 188u, 128u, 129u, 131u, 132u, 134u, 191u, 
	147u, 191u, 128u, 189u, 128u, 143u, 146u, 191u, 
	128u, 135u, 176u, 187u, 128u, 143u, 160u, 166u, 
	176u, 180u, 182u, 191u, 128u, 188u, 161u, 186u, 
	129u, 154u, 166u, 191u, 128u, 190u, 130u, 135u, 
	138u, 143u, 146u, 151u, 154u, 156u, 144u, 145u, 
	146u, 147u, 150u, 155u, 157u, 158u, 170u, 171u, 
	175u, 160u, 169u, 128u, 129u, 130u, 131u, 135u, 
	138u, 139u, 140u, 141u, 142u, 143u, 146u, 160u, 
	161u, 164u, 166u, 168u, 169u, 172u, 173u, 176u, 
	177u, 144u, 145u, 191u, 128u, 139u, 141u, 166u, 
	168u, 186u, 188u, 189u, 128u, 141u, 144u, 157u, 
	128u, 186u, 189u, 128u, 156u, 160u, 191u, 128u, 
	144u, 128u, 158u, 176u, 191u, 128u, 130u, 137u, 
	128u, 157u, 160u, 191u, 128u, 131u, 136u, 143u, 
	128u, 157u, 136u, 188u, 191u, 128u, 133u, 138u, 
	181u, 183u, 184u, 128u, 149u, 128u, 149u, 160u, 
	185u, 128u, 183u, 190u, 191u, 191u, 128u, 131u, 
	133u, 134u, 140u, 147u, 149u, 151u, 153u, 179u, 
	184u, 186u, 160u, 188u, 128u, 149u, 160u, 178u, 
	128u, 136u, 128u, 129u, 130u, 131u, 132u, 134u, 
	135u, 154u, 128u, 134u, 144u, 168u, 128u, 132u, 
	141u, 128u, 140u, 128u, 174u, 144u, 128u, 143u, 
	168u, 188u, 189u, 190u, 160u, 167u, 128u, 184u, 
	128u, 132u, 144u, 190u, 143u, 159u, 128u, 128u, 
	129u, 133u, 134u, 137u, 145u, 146u, 147u, 148u, 
	149u, 154u, 155u, 156u, 157u, 158u, 159u, 144u, 
	153u, 165u, 169u, 173u, 178u, 187u, 191u, 128u, 
	130u, 133u, 139u, 170u, 173u, 130u, 132u, 128u, 
	148u, 150u, 191u, 162u, 187u, 128u, 156u, 158u, 
	159u, 165u, 166u, 169u, 172u, 174u, 185u, 189u, 
	191u, 128u, 131u, 133u, 191u, 128u, 133u, 135u, 
	138u, 141u, 148u, 150u, 156u, 158u, 185u, 187u, 
	190u, 134u, 128u, 132u, 138u, 144u, 146u, 191u, 
	128u, 165u, 168u, 191u, 128u, 130u, 154u, 156u, 
	186u, 188u, 191u, 128u, 148u, 150u, 180u, 182u, 
	191u, 128u, 142u, 144u, 174u, 176u, 191u, 128u, 
	136u, 138u, 168u, 170u, 191u, 128u, 130u, 132u, 
	139u, 184u, 185u, 186u, 164u, 167u, 185u, 187u, 
	128u, 131u, 133u, 159u, 161u, 162u, 169u, 178u, 
	180u, 183u, 130u, 135u, 137u, 139u, 148u, 151u, 
	153u, 155u, 157u, 159u, 164u, 190u, 141u, 143u, 
	145u, 146u, 161u, 162u, 167u, 170u, 172u, 178u, 
	180u, 183u, 185u, 188u, 128u, 137u, 139u, 155u, 
	161u, 163u, 165u, 169u, 171u, 187u, 155u, 128u, 
	191u, 128u, 150u, 156u, 160u, 128u, 159u, 168u, 
	160u, 167u, 160u, 135u, 132u, 134u, 128u, 175u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 43u, 
	45u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 9u, 10u, 
	13u, 32u, 33u, 38u, 44u, 46u, 47u, 48u, 
	49u, 50u, 63u, 95u, 194u, 195u, 203u, 204u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 301u, 557u, 811u, 1067u, 0u, 35u, 36u, 
	42u, 51u, 57u, 58u, 64u, 65u, 90u, 91u, 
	96u, 97u, 122u, 123u, 127u, 128u, 193u, 196u, 
	218u, 229u, 236u, 238u, 255u, 9u, 10u, 13u, 
	32u, 194u, 225u, 226u, 227u, 9u, 13u, 32u, 
	194u, 225u, 226u, 227u, 9u, 32u, 194u, 225u, 
	226u, 227u, 9u, 10u, 32u, 194u, 225u, 226u, 
	227u, 9u, 10u, 13u, 32u, 194u, 225u, 226u, 
	227u, 13u, 9u, 10u, 13u, 32u, 194u, 225u, 
	226u, 227u, 10u, 9u, 10u, 13u, 32u, 194u, 
	225u, 226u, 227u, 13u, 32u, 33u, 34u, 40u, 
	58u, 59u, 64u, 93u, 95u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 36u, 37u, 
	39u, 41u, 42u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 39u, 41u, 61u, 
	95u, 36u, 47u, 48u, 57u, 58u, 59u, 63u, 
	64u, 65u, 90u, 97u, 122u, 47u, 48u, 57u, 
	45u, 46u, 47u, 58u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 47u, 58u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	47u, 58u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 53u, 58u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 47u, 
	58u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 47u, 64u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 48u, 57u, 33u, 45u, 46u, 
	58u, 64u, 95u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 69u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 48u, 
	57u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	53u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	46u, 69u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 48u, 57u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 53u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 34u, 39u, 41u, 59u, 
	93u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	95u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 53u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 128u, 191u, 160u, 170u, 
	181u, 186u, 128u, 191u, 9u, 10u, 13u, 32u, 
	194u, 225u, 226u, 227u, 128u, 191u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 65u, 90u, 97u, 122u, 128u, 
	191u, 196u, 218u, 229u, 236u, 151u, 183u, 128u, 
	191u, 128u, 191u, 172u, 174u, 128u, 129u, 130u, 
	133u, 134u, 145u, 146u, 159u, 160u, 164u, 165u, 
	191u, 181u, 128u, 175u, 176u, 183u, 184u, 185u, 
	186u, 189u, 190u, 191u, 134u, 139u, 141u, 162u, 
	128u, 135u, 136u, 191u, 182u, 128u, 191u, 128u, 
	129u, 130u, 137u, 138u, 191u, 128u, 167u, 168u, 
	176u, 177u, 191u, 153u, 128u, 150u, 151u, 160u, 
	161u, 191u, 128u, 135u, 136u, 191u, 128u, 143u, 
	144u, 170u, 171u, 175u, 176u, 178u, 179u, 191u, 
	128u, 159u, 160u, 191u, 176u, 128u, 138u, 139u, 
	159u, 160u, 169u, 170u, 173u, 174u, 191u, 46u, 
	69u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 128u, 191u, 148u, 191u, 
	128u, 149u, 150u, 164u, 165u, 166u, 167u, 173u, 
	174u, 175u, 176u, 185u, 186u, 188u, 189u, 190u, 
	144u, 128u, 145u, 146u, 175u, 176u, 191u, 128u, 
	140u, 141u, 191u, 177u, 128u, 165u, 166u, 191u, 
	186u, 128u, 137u, 138u, 170u, 171u, 179u, 180u, 
	181u, 182u, 191u, 160u, 161u, 162u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 171u, 172u, 173u, 
	174u, 175u, 176u, 177u, 178u, 179u, 180u, 181u, 
	182u, 183u, 184u, 185u, 186u, 187u, 188u, 189u, 
	190u, 128u, 191u, 154u, 164u, 168u, 128u, 149u, 
	150u, 191u, 128u, 152u, 153u, 191u, 160u, 128u, 
	161u, 162u, 172u, 173u, 191u, 189u, 128u, 131u, 
	132u, 185u, 186u, 191u, 144u, 176u, 184u, 128u, 
	151u, 152u, 161u, 162u, 165u, 166u, 175u, 177u, 
	191u, 169u, 177u, 189u, 128u, 132u, 133u, 140u, 
	141u, 142u, 143u, 144u, 145u, 146u, 147u, 178u, 
	179u, 181u, 182u, 185u, 186u, 191u, 142u, 158u, 
	128u, 155u, 156u, 161u, 162u, 165u, 166u, 175u, 
	176u, 177u, 178u, 191u, 169u, 177u, 180u, 183u, 
	128u, 132u, 133u, 138u, 139u, 142u, 143u, 144u, 
	145u, 146u, 147u, 185u, 186u, 191u, 157u, 128u, 
	152u, 153u, 158u, 159u, 165u, 166u, 175u, 176u, 
	177u, 178u, 180u, 181u, 191u, 142u, 146u, 169u, 
	177u, 180u, 189u, 128u, 132u, 133u, 185u, 186u, 
	191u, 144u, 128u, 159u, 160u, 161u, 162u, 165u, 
	166u, 175u, 176u, 191u, 169u, 177u, 180u, 189u, 
	128u, 132u, 133u, 140u, 141u, 142u, 143u, 144u, 
	145u, 146u, 147u, 185u, 186u, 191u, 158u, 177u, 
	128u, 155u, 156u, 161u, 162u, 165u, 166u, 175u, 
	176u, 191u, 131u, 145u, 155u, 157u, 128u, 132u, 
	133u, 138u, 139u, 141u, 142u, 149u, 150u, 152u, 
	153u, 159u, 160u, 162u, 163u, 164u, 165u, 167u, 
	168u, 170u, 171u, 173u, 174u, 185u, 186u, 191u, 
	144u, 128u, 165u, 166u, 175u, 176u, 191u, 141u, 
	145u, 169u, 180u, 189u, 128u, 132u, 133u, 185u, 
	186u, 191u, 128u, 151u, 152u, 153u, 154u, 159u, 
	160u, 161u, 162u, 165u, 166u, 175u, 176u, 191u, 
	158u, 176u, 128u, 159u, 160u, 161u, 162u, 165u, 
	166u, 175u, 177u, 178u, 179u, 191u, 141u, 145u, 
	189u, 128u, 132u, 133u, 186u, 187u, 191u, 142u, 
	128u, 159u, 160u, 161u, 162u, 165u, 166u, 175u, 
	176u, 185u, 186u, 191u, 178u, 188u, 128u, 132u, 
	133u, 150u, 151u, 153u, 154u, 189u, 190u, 191u, 
	128u, 134u, 135u, 191u, 128u, 177u, 129u, 179u, 
	180u, 191u, 128u, 134u, 135u, 143u, 144u, 153u, 
	154u, 191u, 128u, 131u, 137u, 141u, 152u, 160u, 
	164u, 166u, 172u, 177u, 189u, 129u, 132u, 133u, 
	134u, 135u, 138u, 139u, 147u, 148u, 167u, 168u, 
	169u, 170u, 179u, 180u, 191u, 133u, 128u, 134u, 
	135u, 143u, 144u, 153u, 154u, 155u, 156u, 159u, 
	160u, 191u, 128u, 129u, 159u, 160u, 169u, 170u, 
	191u, 136u, 128u, 172u, 173u, 191u, 128u, 135u, 
	136u, 140u, 141u, 191u, 128u, 129u, 130u, 131u, 
	137u, 138u, 139u, 140u, 141u, 142u, 143u, 144u, 
	153u, 154u, 155u, 156u, 157u, 158u, 159u, 160u, 
	161u, 162u, 163u, 164u, 165u, 166u, 167u, 168u, 
	169u, 170u, 171u, 172u, 173u, 174u, 175u, 176u, 
	177u, 178u, 179u, 183u, 188u, 189u, 190u, 191u, 
	132u, 187u, 191u, 128u, 170u, 171u, 190u, 161u, 
	128u, 137u, 138u, 143u, 144u, 149u, 150u, 153u, 
	154u, 157u, 158u, 164u, 165u, 166u, 167u, 173u, 
	174u, 176u, 177u, 180u, 181u, 191u, 142u, 128u, 
	129u, 130u, 143u, 144u, 153u, 154u, 159u, 160u, 
	191u, 134u, 141u, 187u, 128u, 135u, 136u, 143u, 
	144u, 191u, 137u, 151u, 153u, 128u, 141u, 142u, 
	143u, 144u, 157u, 158u, 159u, 160u, 191u, 137u, 
	177u, 191u, 128u, 141u, 142u, 143u, 144u, 181u, 
	182u, 183u, 184u, 190u, 129u, 151u, 128u, 133u, 
	134u, 135u, 136u, 191u, 145u, 128u, 149u, 150u, 
	151u, 152u, 191u, 128u, 154u, 155u, 191u, 128u, 
	143u, 144u, 159u, 160u, 191u, 128u, 180u, 181u, 
	191u, 128u, 129u, 191u, 128u, 172u, 173u, 174u, 
	175u, 191u, 128u, 129u, 154u, 155u, 159u, 160u, 
	191u, 128u, 170u, 171u, 191u, 141u, 128u, 145u, 
	146u, 159u, 160u, 177u, 178u, 191u, 173u, 128u, 
	145u, 146u, 159u, 160u, 176u, 177u, 191u, 128u, 
	179u, 180u, 191u, 151u, 156u, 128u, 159u, 160u, 
	169u, 170u, 191u, 128u, 143u, 144u, 153u, 154u, 
	159u, 160u, 191u, 128u, 183u, 184u, 191u, 169u, 
	128u, 170u, 171u, 175u, 176u, 191u, 128u, 181u, 
	182u, 191u, 128u, 156u, 157u, 191u, 128u, 133u, 
	134u, 143u, 144u, 173u, 174u, 175u, 176u, 180u, 
	181u, 191u, 128u, 171u, 172u, 191u, 128u, 129u, 
	135u, 136u, 143u, 144u, 153u, 154u, 191u, 128u, 
	150u, 151u, 159u, 160u, 191u, 128u, 148u, 149u, 
	191u, 167u, 128u, 137u, 138u, 143u, 144u, 153u, 
	154u, 191u, 128u, 132u, 133u, 179u, 180u, 191u, 
	128u, 132u, 133u, 139u, 140u, 143u, 144u, 153u, 
	154u, 191u, 128u, 130u, 131u, 160u, 161u, 173u, 
	174u, 175u, 176u, 185u, 186u, 191u, 128u, 165u, 
	166u, 191u, 128u, 163u, 164u, 191u, 128u, 137u, 
	138u, 140u, 141u, 143u, 144u, 153u, 154u, 189u, 
	190u, 191u, 173u, 128u, 168u, 169u, 177u, 178u, 
	180u, 181u, 182u, 183u, 191u, 128u, 149u, 150u, 
	151u, 152u, 157u, 158u, 159u, 160u, 191u, 152u, 
	154u, 156u, 158u, 128u, 133u, 134u, 135u, 136u, 
	141u, 142u, 143u, 144u, 189u, 190u, 191u, 181u, 
	189u, 191u, 128u, 190u, 133u, 181u, 128u, 129u, 
	130u, 140u, 141u, 143u, 144u, 147u, 148u, 149u, 
	150u, 155u, 156u, 159u, 160u, 172u, 173u, 177u, 
	178u, 188u, 189u, 191u, 128u, 129u, 130u, 132u, 
	133u, 134u, 176u, 177u, 178u, 179u, 180u, 181u, 
	182u, 183u, 184u, 131u, 191u, 166u, 175u, 128u, 
	138u, 139u, 191u, 13u, 32u, 34u, 39u, 41u, 
	59u, 93u, 125u, 194u, 224u, 225u, 226u, 227u, 
	239u, 9u, 10u, 128u, 191u, 159u, 177u, 191u, 
	128u, 190u, 128u, 143u, 144u, 156u, 157u, 191u, 
	130u, 135u, 148u, 164u, 166u, 168u, 174u, 128u, 
	137u, 138u, 149u, 150u, 152u, 153u, 157u, 158u, 
	169u, 170u, 185u, 186u, 187u, 188u, 191u, 142u, 
	128u, 132u, 133u, 137u, 138u, 191u, 128u, 130u, 
	131u, 132u, 133u, 191u, 175u, 128u, 191u, 159u, 
	128u, 191u, 128u, 164u, 165u, 170u, 171u, 174u, 
	175u, 177u, 178u, 179u, 180u, 191u, 166u, 173u, 
	128u, 167u, 168u, 175u, 176u, 191u, 175u, 128u, 
	167u, 168u, 191u, 167u, 175u, 183u, 191u, 128u, 
	150u, 151u, 159u, 160u, 190u, 135u, 143u, 151u, 
	128u, 158u, 159u, 191u, 175u, 128u, 191u, 128u, 
	129u, 130u, 131u, 132u, 133u, 134u, 135u, 136u, 
	143u, 144u, 191u, 128u, 129u, 132u, 133u, 134u, 
	135u, 176u, 177u, 181u, 182u, 186u, 187u, 188u, 
	189u, 191u, 160u, 128u, 150u, 151u, 156u, 157u, 
	191u, 187u, 128u, 191u, 128u, 132u, 133u, 173u, 
	174u, 176u, 177u, 191u, 128u, 142u, 143u, 159u, 
	160u, 186u, 187u, 191u, 128u, 175u, 176u, 191u, 
	182u, 183u, 128u, 191u, 128u, 191u, 191u, 128u, 
	190u, 128u, 140u, 141u, 191u, 146u, 147u, 152u, 
	153u, 154u, 155u, 156u, 158u, 159u, 160u, 161u, 
	162u, 163u, 164u, 165u, 166u, 167u, 168u, 169u, 
	170u, 171u, 172u, 175u, 128u, 157u, 173u, 174u, 
	176u, 191u, 128u, 143u, 144u, 189u, 190u, 191u, 
	128u, 140u, 141u, 143u, 144u, 159u, 160u, 169u, 
	170u, 171u, 172u, 191u, 191u, 128u, 174u, 175u, 
	190u, 128u, 151u, 152u, 159u, 160u, 191u, 128u, 
	150u, 151u, 159u, 160u, 161u, 162u, 191u, 143u, 
	128u, 136u, 137u, 138u, 139u, 147u, 148u, 159u, 
	160u, 170u, 171u, 191u, 128u, 183u, 184u, 191u, 
	130u, 134u, 139u, 128u, 162u, 163u, 191u, 128u, 
	129u, 130u, 179u, 180u, 191u, 187u, 128u, 143u, 
	144u, 153u, 154u, 177u, 178u, 183u, 184u, 191u, 
	128u, 137u, 138u, 165u, 166u, 175u, 176u, 191u, 
	128u, 134u, 135u, 159u, 160u, 188u, 189u, 191u, 
	128u, 131u, 132u, 178u, 179u, 191u, 143u, 128u, 
	142u, 144u, 153u, 154u, 191u, 128u, 168u, 169u, 
	191u, 131u, 186u, 128u, 139u, 140u, 143u, 144u, 
	153u, 154u, 159u, 160u, 182u, 183u, 191u, 176u, 
	128u, 177u, 178u, 180u, 181u, 182u, 183u, 184u, 
	185u, 189u, 190u, 191u, 129u, 128u, 130u, 131u, 
	154u, 155u, 157u, 158u, 159u, 160u, 170u, 171u, 
	177u, 178u, 180u, 181u, 191u, 128u, 167u, 129u, 
	134u, 135u, 136u, 137u, 142u, 143u, 144u, 145u, 
	150u, 151u, 159u, 160u, 174u, 175u, 191u, 128u, 
	162u, 163u, 175u, 176u, 185u, 186u, 191u, 158u, 
	159u, 128u, 157u, 160u, 191u, 128u, 163u, 164u, 
	175u, 176u, 191u, 128u, 134u, 135u, 138u, 139u, 
	187u, 188u, 191u, 169u, 171u, 172u, 173u, 174u, 
	175u, 180u, 181u, 182u, 183u, 184u, 185u, 187u, 
	188u, 189u, 190u, 191u, 128u, 163u, 164u, 186u, 
	128u, 173u, 174u, 175u, 176u, 191u, 128u, 153u, 
	154u, 191u, 157u, 169u, 183u, 189u, 191u, 128u, 
	134u, 135u, 146u, 147u, 151u, 152u, 158u, 159u, 
	190u, 130u, 133u, 128u, 191u, 128u, 177u, 178u, 
	191u, 128u, 146u, 147u, 191u, 128u, 189u, 190u, 
	191u, 128u, 143u, 144u, 191u, 128u, 143u, 144u, 
	145u, 146u, 191u, 128u, 135u, 136u, 175u, 176u, 
	187u, 188u, 191u, 181u, 128u, 175u, 176u, 191u, 
	128u, 188u, 189u, 191u, 128u, 143u, 144u, 153u, 
	154u, 160u, 161u, 186u, 187u, 191u, 128u, 129u, 
	154u, 155u, 165u, 166u, 191u, 191u, 128u, 190u, 
	128u, 129u, 130u, 135u, 136u, 137u, 138u, 143u, 
	144u, 145u, 146u, 151u, 152u, 153u, 154u, 156u, 
	157u, 191u, 144u, 145u, 146u, 147u, 150u, 155u, 
	157u, 158u, 170u, 171u, 175u, 128u, 159u, 160u, 
	169u, 172u, 191u, 128u, 129u, 130u, 131u, 138u, 
	139u, 140u, 141u, 142u, 143u, 146u, 160u, 161u, 
	164u, 166u, 168u, 169u, 172u, 173u, 176u, 177u, 
	132u, 137u, 144u, 145u, 147u, 191u, 140u, 167u, 
	187u, 190u, 128u, 191u, 128u, 141u, 142u, 143u, 
	144u, 157u, 158u, 191u, 128u, 186u, 187u, 191u, 
	128u, 156u, 157u, 159u, 160u, 191u, 128u, 144u, 
	145u, 191u, 128u, 158u, 159u, 175u, 176u, 191u, 
	129u, 128u, 137u, 138u, 191u, 128u, 157u, 158u, 
	159u, 160u, 191u, 128u, 131u, 132u, 135u, 136u, 
	143u, 144u, 191u, 128u, 157u, 158u, 159u, 160u, 
	169u, 170u, 191u, 136u, 182u, 188u, 191u, 128u, 
	133u, 134u, 137u, 138u, 184u, 185u, 190u, 128u, 
	149u, 150u, 191u, 128u, 149u, 150u, 159u, 160u, 
	185u, 186u, 191u, 128u, 183u, 184u, 189u, 190u, 
	191u, 128u, 148u, 152u, 129u, 143u, 144u, 179u, 
	180u, 191u, 128u, 159u, 160u, 188u, 189u, 191u, 
	128u, 149u, 150u, 159u, 160u, 178u, 179u, 191u, 
	128u, 136u, 137u, 191u, 128u, 129u, 130u, 131u, 
	132u, 134u, 135u, 154u, 155u, 133u, 191u, 128u, 
	130u, 131u, 183u, 184u, 191u, 128u, 165u, 166u, 
	175u, 176u, 191u, 128u, 130u, 131u, 175u, 176u, 
	191u, 128u, 143u, 144u, 168u, 169u, 175u, 176u, 
	185u, 186u, 191u, 128u, 130u, 131u, 166u, 167u, 
	181u, 182u, 191u, 128u, 130u, 131u, 178u, 179u, 
	191u, 128u, 129u, 132u, 133u, 143u, 144u, 153u, 
	154u, 191u, 128u, 137u, 138u, 191u, 141u, 128u, 
	140u, 142u, 191u, 128u, 174u, 175u, 191u, 144u, 
	128u, 143u, 145u, 191u, 168u, 188u, 189u, 190u, 
	128u, 159u, 160u, 167u, 169u, 191u, 128u, 184u, 
	185u, 191u, 144u, 128u, 132u, 133u, 191u, 128u, 
	146u, 147u, 159u, 160u, 191u, 128u, 129u, 191u, 
	128u, 129u, 130u, 191u, 145u, 146u, 147u, 148u, 
	149u, 154u, 155u, 156u, 157u, 158u, 159u, 128u, 
	143u, 144u, 153u, 160u, 191u, 149u, 128u, 191u, 
	157u, 162u, 173u, 186u, 188u, 128u, 159u, 160u, 
	164u, 165u, 166u, 167u, 168u, 169u, 191u, 132u, 
	128u, 191u, 134u, 149u, 157u, 186u, 191u, 128u, 
	138u, 139u, 140u, 141u, 190u, 133u, 145u, 128u, 
	134u, 135u, 137u, 138u, 191u, 128u, 165u, 166u, 
	167u, 168u, 191u, 129u, 155u, 187u, 128u, 191u, 
	149u, 181u, 128u, 191u, 143u, 175u, 128u, 191u, 
	137u, 169u, 128u, 191u, 131u, 128u, 139u, 140u, 
	141u, 142u, 191u, 184u, 185u, 186u, 128u, 191u, 
	132u, 160u, 163u, 167u, 179u, 184u, 186u, 128u, 
	164u, 165u, 168u, 169u, 187u, 188u, 191u, 130u, 
	135u, 137u, 139u, 144u, 147u, 151u, 153u, 155u, 
	157u, 159u, 163u, 171u, 179u, 184u, 189u, 191u, 
	128u, 140u, 141u, 148u, 149u, 160u, 161u, 164u, 
	165u, 166u, 167u, 190u, 138u, 164u, 170u, 128u, 
	155u, 156u, 160u, 161u, 187u, 188u, 191u, 155u, 
	128u, 191u, 128u, 150u, 151u, 191u, 156u, 160u, 
	128u, 159u, 161u, 191u, 128u, 157u, 158u, 191u, 
	168u, 128u, 159u, 160u, 167u, 169u, 191u, 33u, 
	58u, 64u, 95u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 45u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 0
};

static const char _generic_tokenizer_single_lengths[] = {
	0, 1, 1, 1, 2, 1, 1, 1, 
	31, 29, 1, 0, 32, 29, 7, 21, 
	26, 5, 3, 2, 15, 0, 16, 28, 
	30, 20, 0, 1, 2, 8, 0, 2, 
	1, 32, 28, 0, 4, 0, 0, 16, 
	2, 2, 1, 6, 1, 1, 3, 7, 
	6, 11, 3, 0, 6, 21, 10, 1, 
	10, 5, 23, 12, 14, 26, 14, 5, 
	1, 7, 6, 2, 3, 2, 1, 0, 
	16, 0, 0, 2, 0, 0, 1, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	1, 2, 8, 2, 16, 3, 3, 1, 
	11, 4, 2, 3, 3, 2, 1, 2, 
	0, 2, 5, 0, 2, 3, 2, 3, 
	2, 3, 2, 2, 3, 2, 2, 2, 
	3, 2, 2, 2, 3, 2, 14, 2, 
	1, 2, 1, 2, 9, 4, 3, 1, 
	3, 7, 6, 11, 3, 10, 1, 10, 
	5, 1, 6, 7, 2, 3, 17, 5, 
	6, 4, 6, 5, 4, 6, 2, 6, 
	6, 7, 6, 7, 15, 7, 6, 7, 
	7, 7, 7, 8, 7, 6, 6, 7, 
	6, 15, 12, 0, 0, 0, 12, 0, 
	0, 10, 0, 0, 6, 1, 3, 1, 
	5, 0, 1, 0, 13, 0, 10, 8, 
	0, 0, 12, 0, 0, 10, 0, 0, 
	6, 1, 3, 1, 5, 0, 1, 0, 
	12, 15, 13, 0, 8, 0, 0, 12, 
	0, 0, 10, 0, 0, 6, 1, 3, 
	1, 5, 0, 1, 0, 3, 1, 5, 
	6, 7, 6, 7, 6, 7, 6, 6, 
	7, 6, 6, 6, 7, 6, 6, 6, 
	7, 6, 3, 0, 0, 2, 0, 2, 
	0, 0, 0, 1, 1, 1, 0, 0, 
	1, 0, 0, 0, 1, 32, 0, 0, 
	1, 0, 0, 1, 1, 1, 2, 0, 
	1, 0, 1, 1, 2, 0, 0, 0, 
	1, 0, 1, 1, 2, 0, 0, 5, 
	1, 4, 0, 0, 1, 40, 0, 2, 
	1, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	3, 1, 0, 15, 2, 0, 0, 6, 
	1, 0, 0, 0, 0, 2, 2, 0, 
	0, 1, 8, 0, 0, 0, 0, 0, 
	0, 1, 0, 1, 0, 20, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 2, 0, 0, 0, 0, 0, 
	2, 0, 0, 17, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 11, 22, 1, 0, 0, 
	1, 0, 0, 0, 1, 0, 0, 0, 
	3, 0, 0, 0, 1, 0, 0, 0, 
	8, 0, 0, 0, 1, 0, 1, 4, 
	0, 0, 0, 1, 0, 14, 0, 0, 
	0, 0, 2, 0, 0, 1, 0, 1, 
	0, 0, 0, 0, 3, 4, 12, 0, 
	1, 0, 2, 1, 1, 1, 0, 12, 
	14, 47, 8, 7, 6, 7, 8, 1, 
	8, 1, 8, 17, 4, 5, 1, 4, 
	4, 4, 4, 5, 4, 4, 16, 7, 
	4, 7, 16, 16, 12, 8, 14, 10, 
	16, 16, 17, 16, 16, 14, 11, 16, 
	16, 17, 16, 14, 35, 35, 35, 7, 
	7, 7, 8, 7, 29, 0, 4, 8, 
	29, 2, 0, 2, 1, 4, 1, 0, 
	0, 1, 0, 0, 0, 1, 11, 2, 
	1, 0, 1, 1, 30, 3, 0, 1, 
	1, 3, 3, 2, 4, 1, 6, 1, 
	4, 2, 4, 1, 5, 0, 2, 3, 
	1, 2, 0, 2, 0, 11, 1, 1, 
	1, 0, 44, 1, 1, 1, 3, 3, 
	3, 2, 1, 0, 0, 0, 1, 0, 
	1, 0, 1, 1, 0, 2, 0, 0, 
	1, 0, 0, 0, 0, 1, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 1, 
	0, 4, 3, 2, 15, 2, 14, 3, 
	0, 7, 1, 0, 1, 1, 0, 2, 
	1, 4, 3, 1, 8, 1, 1, 1, 
	0, 0, 0, 2, 0, 1, 0, 23, 
	0, 0, 1, 0, 0, 1, 0, 3, 
	0, 1, 0, 0, 0, 1, 0, 2, 
	1, 1, 2, 0, 2, 0, 0, 17, 
	0, 0, 5, 2, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 1, 1, 0, 
	11, 21, 4, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 4, 0, 0, 0, 
	3, 0, 0, 0, 9, 0, 0, 0, 
	0, 0, 0, 1, 0, 1, 0, 1, 
	4, 0, 1, 0, 1, 0, 11, 1, 
	5, 1, 5, 2, 0, 3, 2, 2, 
	2, 1, 3, 7, 17, 3, 1, 0, 
	2, 0, 1, 12, 15, 14
};

static const char _generic_tokenizer_range_lengths[] = {
	0, 0, 0, 0, 0, 1, 0, 0, 
	2, 1, 0, 2, 0, 1, 12, 5, 
	2, 1, 0, 4, 3, 1, 0, 0, 
	1, 1, 1, 0, 0, 1, 1, 1, 
	0, 0, 0, 4, 2, 4, 4, 0, 
	2, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 1, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 1, 
	0, 2, 2, 5, 1, 6, 3, 2, 
	1, 2, 2, 2, 1, 1, 1, 1, 
	0, 0, 1, 0, 0, 3, 0, 0, 
	0, 5, 5, 5, 3, 3, 3, 3, 
	3, 3, 6, 1, 3, 3, 3, 3, 
	3, 3, 3, 3, 4, 4, 3, 3, 
	4, 4, 3, 3, 4, 4, 1, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 7, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 6, 6, 5, 5, 6, 
	6, 5, 5, 1, 1, 1, 0, 1, 
	1, 0, 1, 2, 0, 0, 0, 0, 
	0, 1, 0, 1, 5, 1, 1, 1, 
	1, 1, 0, 1, 1, 0, 1, 2, 
	0, 0, 0, 0, 0, 1, 0, 1, 
	5, 5, 5, 1, 1, 1, 1, 0, 
	1, 1, 0, 1, 2, 0, 0, 0, 
	0, 0, 1, 0, 1, 4, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	6, 6, 5, 5, 6, 6, 5, 5, 
	6, 6, 0, 3, 1, 3, 3, 3, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	5, 1, 2, 1, 1, 0, 1, 1, 
	1, 1, 3, 7, 6, 9, 5, 8, 
	4, 8, 6, 10, 3, 7, 6, 7, 
	6, 5, 5, 4, 4, 1, 1, 8, 
	3, 2, 3, 3, 0, 2, 3, 3, 
	5, 5, 3, 3, 2, 2, 1, 1, 
	2, 2, 1, 3, 4, 2, 2, 1, 
	2, 1, 3, 2, 2, 1, 2, 2, 
	0, 2, 2, 1, 2, 2, 2, 3, 
	4, 2, 7, 0, 0, 1, 1, 5, 
	1, 1, 2, 2, 2, 2, 1, 5, 
	5, 0, 1, 4, 4, 2, 2, 2, 
	1, 2, 1, 1, 1, 2, 1, 3, 
	2, 2, 2, 2, 4, 1, 1, 2, 
	2, 2, 0, 1, 3, 4, 5, 2, 
	1, 2, 2, 1, 2, 1, 5, 3, 
	1, 1, 2, 2, 2, 2, 1, 1, 
	2, 1, 4, 1, 1, 4, 2, 1, 
	0, 2, 1, 2, 1, 2, 2, 1, 
	3, 1, 2, 2, 6, 1, 2, 1, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 0, 1, 1, 3, 3, 
	1, 2, 6, 2, 6, 3, 2, 3, 
	3, 3, 3, 2, 0, 5, 7, 5, 
	1, 1, 1, 1, 0, 1, 1, 5, 
	5, 12, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 7, 3, 6, 1, 3, 
	3, 3, 3, 4, 4, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 5, 1, 
	5, 5, 6, 6, 5, 5, 1, 5, 
	5, 6, 6, 1, 7, 7, 7, 5, 
	5, 5, 6, 6, 4, 1, 1, 1, 
	5, 1, 1, 6, 5, 2, 1, 3, 
	3, 3, 2, 5, 2, 5, 2, 8, 
	3, 2, 2, 5, 1, 2, 2, 3, 
	3, 5, 9, 6, 7, 7, 3, 5, 
	7, 5, 13, 3, 3, 7, 6, 3, 
	6, 5, 2, 2, 4, 8, 6, 3, 
	2, 3, 1, 2, 11, 5, 3, 5, 
	5, 3, 3, 2, 3, 2, 1, 3, 
	3, 2, 4, 4, 2, 3, 4, 2, 
	3, 2, 2, 6, 2, 4, 3, 2, 
	4, 3, 5, 6, 2, 2, 6, 5, 
	5, 6, 1, 11, 1, 2, 2, 1, 
	3, 8, 3, 3, 1, 1, 6, 3, 
	2, 3, 2, 1, 2, 7, 3, 1, 
	4, 4, 2, 1, 1, 1, 2, 3, 
	3, 6, 2, 3, 4, 6, 2, 2, 
	3, 5, 4, 4, 3, 3, 2, 6, 
	6, 8, 8, 4, 2, 3, 4, 2, 
	3, 2, 5, 1, 2, 2, 2, 2, 
	3, 4, 2, 2, 5, 3, 1, 9, 
	3, 3, 1, 4, 2, 3, 2, 3, 
	2, 3, 4, 4, 4, 2, 4, 3, 
	3, 3, 4, 2, 1, 3, 3, 3, 
	5, 4, 3, 4, 2, 2, 2, 2, 
	3, 2, 2, 3, 1, 2, 3, 1, 
	5, 1, 3, 3, 3, 1, 1, 1, 
	1, 3, 1, 4, 6, 4, 1, 2, 
	2, 2, 3, 5, 5, 5
};

static const short _generic_tokenizer_index_offsets[] = {
	0, 0, 2, 4, 6, 9, 12, 14, 
	16, 50, 81, 83, 86, 119, 150, 170, 
	197, 226, 233, 237, 244, 263, 265, 282, 
	311, 343, 365, 367, 369, 372, 382, 384, 
	388, 390, 423, 452, 457, 464, 469, 474, 
	491, 496, 499, 501, 514, 516, 518, 522, 
	530, 537, 549, 553, 555, 565, 587, 598, 
	600, 611, 617, 641, 654, 669, 697, 712, 
	718, 720, 728, 735, 739, 743, 746, 748, 
	750, 767, 770, 773, 781, 783, 790, 795, 
	798, 800, 803, 806, 809, 812, 814, 816, 
	818, 820, 823, 833, 836, 853, 860, 864, 
	866, 878, 888, 896, 905, 912, 918, 923, 
	929, 933, 939, 951, 953, 959, 966, 972, 
	979, 985, 992, 998, 1004, 1012, 1019, 1025, 
	1031, 1039, 1046, 1052, 1058, 1066, 1073, 1089, 
	1092, 1094, 1097, 1099, 1102, 1112, 1118, 1122, 
	1124, 1128, 1136, 1143, 1155, 1159, 1170, 1172, 
	1184, 1190, 1192, 1199, 1207, 1210, 1214, 1239, 
	1250, 1262, 1272, 1284, 1295, 1305, 1317, 1325, 
	1337, 1349, 1362, 1374, 1387, 1408, 1421, 1433, 
	1446, 1459, 1472, 1485, 1500, 1514, 1526, 1538, 
	1552, 1565, 1586, 1604, 1606, 1608, 1610, 1623, 
	1625, 1627, 1638, 1640, 1643, 1650, 1652, 1656, 
	1658, 1664, 1666, 1668, 1670, 1689, 1691, 1703, 
	1713, 1715, 1717, 1730, 1732, 1734, 1745, 1747, 
	1750, 1757, 1759, 1763, 1765, 1771, 1773, 1775, 
	1777, 1795, 1816, 1835, 1837, 1847, 1849, 1851, 
	1864, 1866, 1868, 1879, 1881, 1884, 1891, 1893, 
	1897, 1899, 1905, 1907, 1909, 1911, 1919, 1921, 
	1932, 1944, 1957, 1969, 1982, 1994, 2007, 2019, 
	2031, 2045, 2058, 2070, 2082, 2096, 2109, 2121, 
	2133, 2147, 2160, 2164, 2168, 2170, 2176, 2180, 
	2186, 2189, 2192, 2195, 2199, 2203, 2209, 2212, 
	2215, 2222, 2224, 2227, 2229, 2232, 2265, 2267, 
	2269, 2272, 2274, 2278, 2287, 2295, 2306, 2314, 
	2323, 2329, 2338, 2346, 2358, 2364, 2372, 2379, 
	2387, 2395, 2401, 2408, 2414, 2421, 2423, 2425, 
	2439, 2444, 2451, 2455, 2459, 2461, 2504, 2508, 
	2514, 2521, 2527, 2532, 2536, 2539, 2542, 2544, 
	2546, 2549, 2552, 2554, 2558, 2563, 2567, 2570, 
	2572, 2575, 2577, 2581, 2584, 2587, 2589, 2592, 
	2596, 2598, 2601, 2604, 2606, 2609, 2612, 2615, 
	2619, 2627, 2631, 2639, 2655, 2658, 2660, 2662, 
	2674, 2677, 2679, 2682, 2685, 2688, 2693, 2697, 
	2703, 2709, 2711, 2721, 2726, 2731, 2734, 2737, 
	2740, 2742, 2746, 2748, 2751, 2753, 2776, 2778, 
	2782, 2786, 2789, 2792, 2795, 2800, 2802, 2804, 
	2808, 2811, 2814, 2817, 2819, 2823, 2828, 2834, 
	2837, 2841, 2844, 2847, 2866, 2869, 2871, 2878, 
	2882, 2884, 2886, 2889, 2892, 2895, 2898, 2900, 
	2902, 2905, 2907, 2912, 2925, 2949, 2955, 2958, 
	2960, 2962, 2965, 2967, 2970, 2973, 2976, 2979, 
	2981, 2988, 2990, 2993, 2996, 3004, 3006, 3009, 
	3011, 3020, 3022, 3024, 3026, 3029, 3031, 3034, 
	3040, 3042, 3045, 3047, 3049, 3051, 3067, 3071, 
	3075, 3077, 3080, 3089, 3092, 3099, 3104, 3107, 
	3112, 3116, 3120, 3124, 3127, 3131, 3141, 3161, 
	3167, 3170, 3172, 3176, 3179, 3181, 3184, 3186, 
	3204, 3224, 3284, 3293, 3301, 3308, 3316, 3325, 
	3327, 3336, 3338, 3347, 3372, 3380, 3392, 3395, 
	3403, 3411, 3419, 3427, 3437, 3446, 3456, 3478, 
	3491, 3501, 3514, 3536, 3558, 3576, 3586, 3606, 
	3618, 3640, 3662, 3686, 3709, 3731, 3751, 3764, 
	3786, 3808, 3832, 3855, 3871, 3914, 3957, 4000, 
	4013, 4026, 4039, 4054, 4068, 4102, 4104, 4110, 
	4120, 4155, 4159, 4161, 4170, 4177, 4184, 4187, 
	4191, 4195, 4200, 4203, 4209, 4212, 4219, 4233, 
	4244, 4249, 4252, 4256, 4263, 4295, 4301, 4304, 
	4309, 4314, 4323, 4336, 4345, 4357, 4366, 4376, 
	4383, 4395, 4403, 4421, 4426, 4435, 4443, 4452, 
	4459, 4467, 4475, 4478, 4483, 4488, 4508, 4516, 
	4521, 4525, 4529, 4575, 4579, 4592, 4599, 4606, 
	4615, 4624, 4630, 4635, 4638, 4642, 4645, 4648, 
	4652, 4657, 4660, 4666, 4672, 4675, 4681, 4686, 
	4689, 4694, 4697, 4700, 4707, 4710, 4716, 4720, 
	4723, 4729, 4733, 4739, 4746, 4749, 4752, 4759, 
	4766, 4772, 4783, 4788, 4802, 4819, 4824, 4841, 
	4846, 4850, 4866, 4871, 4875, 4878, 4881, 4888, 
	4894, 4898, 4906, 4912, 4915, 4926, 4935, 4940, 
	4943, 4948, 4953, 4956, 4960, 4962, 4965, 4968, 
	4995, 4999, 5006, 5010, 5014, 5019, 5027, 5030, 
	5036, 5040, 5047, 5052, 5057, 5061, 5066, 5069, 
	5078, 5086, 5096, 5107, 5112, 5117, 5121, 5126, 
	5146, 5150, 5153, 5164, 5168, 5171, 5174, 5177, 
	5180, 5184, 5189, 5193, 5196, 5202, 5207, 5210, 
	5220, 5235, 5260, 5266, 5271, 5274, 5278, 5281, 
	5285, 5289, 5293, 5298, 5303, 5312, 5315, 5320, 
	5324, 5331, 5335, 5340, 5343, 5354, 5358, 5362, 
	5366, 5372, 5377, 5381, 5387, 5390, 5394, 5397, 
	5401, 5409, 5412, 5416, 5420, 5423, 5426, 5441, 
	5444, 5455, 5458, 5467, 5473, 5477, 5482, 5486, 
	5490, 5494, 5499, 5504, 5516, 5540, 5548, 5551, 
	5554, 5559, 5562, 5567, 5585, 5606
};

static const short _generic_tokenizer_indicies[] = {
	1, 0, 2, 0, 1, 0, 3, 4, 
	0, 1, 1, 0, 1, 0, 2, 0, 
	6, 6, 7, 7, 7, 7, 7, 9, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 6, 
	8, 5, 7, 7, 7, 7, 7, 33, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 34, 35, 36, 30, 31, 32, 8, 
	5, 7, 5, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 37, 
	5, 7, 7, 5, 38, 39, 40, 42, 
	43, 44, 45, 46, 41, 5, 8, 5, 
	8, 8, 8, 5, 7, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 5, 47, 48, 49, 50, 51, 52, 
	53, 54, 55, 56, 57, 58, 59, 41, 
	60, 61, 5, 7, 7, 7, 7, 5, 
	7, 7, 5, 7, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 5, 8, 5, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	5, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 5, 7, 7, 7, 
	5, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 62, 5, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 63, 64, 65, 66, 67, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	68, 69, 70, 71, 72, 5, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 8, 5, 7, 7, 7, 5, 73, 
	74, 5, 75, 5, 8, 5, 76, 77, 
	78, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 5, 8, 
	8, 5, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 5, 8, 8, 5, 8, 5, 
	8, 8, 5, 8, 8, 5, 8, 8, 
	5, 8, 8, 5, 8, 5, 8, 5, 
	8, 5, 8, 5, 6, 7, 5, 38, 
	39, 92, 42, 43, 44, 45, 46, 41, 
	5, 6, 7, 5, 93, 94, 49, 50, 
	51, 52, 53, 54, 55, 56, 57, 58, 
	59, 41, 60, 61, 5, 7, 6, 7, 
	6, 7, 7, 5, 7, 6, 7, 5, 
	95, 5, 6, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 96, 97, 
	98, 96, 96, 96, 96, 96, 96, 5, 
	99, 99, 99, 99, 99, 99, 99, 5, 
	99, 98, 99, 99, 99, 99, 99, 99, 
	5, 100, 101, 102, 103, 104, 104, 5, 
	105, 106, 104, 104, 104, 5, 105, 104, 
	104, 104, 5, 105, 107, 104, 104, 104, 
	5, 104, 108, 109, 5, 105, 107, 104, 
	110, 104, 5, 111, 112, 112, 111, 111, 
	111, 112, 111, 111, 112, 112, 5, 113, 
	5, 105, 107, 104, 104, 114, 5, 115, 
	116, 117, 118, 108, 109, 5, 105, 119, 
	104, 104, 104, 5, 120, 121, 122, 123, 
	108, 109, 5, 105, 124, 104, 104, 104, 
	5, 125, 126, 127, 128, 108, 109, 5, 
	105, 124, 123, 104, 104, 5, 105, 124, 
	120, 104, 104, 5, 105, 124, 129, 123, 
	120, 104, 104, 5, 105, 124, 120, 104, 
	104, 104, 5, 105, 119, 118, 104, 104, 
	5, 105, 119, 115, 104, 104, 5, 105, 
	119, 130, 118, 115, 104, 104, 5, 105, 
	119, 115, 104, 104, 104, 5, 105, 106, 
	103, 104, 104, 5, 105, 106, 100, 104, 
	104, 5, 105, 106, 131, 103, 100, 104, 
	104, 5, 105, 106, 100, 104, 104, 104, 
	5, 132, 132, 133, 133, 133, 133, 133, 
	133, 134, 135, 136, 137, 138, 139, 132, 
	5, 6, 133, 5, 140, 5, 133, 133, 
	5, 141, 5, 6, 133, 5, 142, 143, 
	144, 145, 146, 147, 148, 149, 150, 5, 
	133, 133, 6, 133, 6, 5, 133, 6, 
	133, 5, 133, 5, 133, 133, 133, 5, 
	133, 133, 133, 133, 133, 133, 133, 5, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 5, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 5, 151, 5, 6, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 5, 
	152, 153, 154, 155, 156, 5, 133, 5, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 5, 133, 133, 133, 5, 132, 132, 
	96, 133, 96, 97, 133, 98, 133, 96, 
	133, 134, 135, 136, 137, 138, 139, 132, 
	96, 157, 96, 96, 96, 96, 5, 96, 
	158, 97, 98, 96, 96, 96, 159, 159, 
	159, 5, 96, 158, 160, 97, 98, 96, 
	96, 96, 159, 159, 159, 5, 96, 97, 
	98, 96, 96, 96, 161, 162, 163, 5, 
	96, 164, 165, 97, 98, 96, 96, 96, 
	161, 161, 161, 5, 96, 164, 97, 98, 
	96, 96, 96, 161, 161, 161, 5, 96, 
	97, 98, 96, 96, 96, 161, 166, 167, 
	5, 96, 164, 165, 97, 98, 96, 96, 
	96, 161, 168, 161, 5, 99, 99, 99, 
	99, 169, 99, 99, 5, 96, 164, 165, 
	97, 98, 96, 96, 96, 161, 161, 170, 
	5, 96, 164, 165, 97, 98, 96, 96, 
	96, 161, 171, 161, 5, 96, 164, 165, 
	112, 172, 98, 96, 96, 96, 161, 171, 
	161, 5, 96, 164, 165, 97, 98, 96, 
	96, 96, 161, 161, 173, 5, 96, 164, 
	165, 112, 172, 98, 96, 96, 96, 161, 
	161, 173, 5, 96, 174, 175, 176, 97, 
	98, 96, 178, 179, 180, 181, 182, 183, 
	184, 185, 96, 96, 177, 162, 163, 5, 
	96, 186, 187, 188, 97, 98, 96, 96, 
	96, 189, 166, 167, 5, 96, 164, 190, 
	97, 98, 96, 96, 96, 161, 161, 161, 
	5, 96, 191, 192, 193, 97, 98, 96, 
	96, 96, 194, 166, 167, 5, 96, 164, 
	165, 112, 172, 98, 96, 96, 96, 161, 
	161, 161, 5, 96, 164, 165, 112, 172, 
	98, 96, 96, 96, 194, 161, 161, 5, 
	96, 164, 165, 112, 172, 98, 96, 96, 
	96, 191, 161, 161, 5, 96, 164, 165, 
	112, 195, 172, 98, 96, 96, 96, 194, 
	191, 161, 161, 5, 96, 164, 165, 112, 
	172, 98, 96, 96, 96, 191, 161, 161, 
	161, 5, 96, 164, 190, 97, 98, 96, 
	96, 96, 189, 161, 161, 5, 96, 164, 
	190, 97, 98, 96, 96, 96, 186, 161, 
	161, 5, 96, 164, 190, 196, 97, 98, 
	96, 96, 96, 189, 186, 161, 161, 5, 
	96, 164, 190, 97, 98, 96, 96, 96, 
	186, 161, 161, 161, 5, 96, 197, 198, 
	165, 97, 98, 96, 200, 201, 202, 203, 
	204, 205, 206, 207, 96, 96, 199, 161, 
	161, 5, 96, 97, 98, 96, 200, 201, 
	202, 203, 204, 205, 206, 207, 96, 96, 
	208, 96, 96, 5, 209, 5, 209, 5, 
	209, 5, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 211, 211, 200, 5, 209, 
	5, 209, 5, 202, 211, 200, 211, 212, 
	211, 213, 211, 201, 213, 5, 209, 5, 
	209, 209, 5, 200, 211, 202, 211, 211, 
	201, 5, 211, 5, 214, 215, 216, 5, 
	200, 5, 210, 201, 217, 211, 202, 5, 
	209, 5, 218, 5, 209, 5, 96, 164, 
	97, 98, 96, 200, 201, 202, 203, 204, 
	205, 206, 207, 96, 96, 199, 161, 161, 
	5, 219, 5, 220, 220, 200, 201, 202, 
	203, 204, 205, 206, 207, 209, 5, 200, 
	201, 202, 203, 204, 205, 206, 207, 209, 
	5, 219, 5, 219, 5, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 222, 222, 
	178, 5, 219, 5, 219, 5, 180, 222, 
	178, 222, 223, 222, 224, 222, 179, 224, 
	5, 219, 5, 219, 219, 5, 178, 222, 
	180, 222, 222, 179, 5, 222, 5, 225, 
	226, 227, 5, 178, 5, 221, 179, 228, 
	222, 180, 5, 219, 5, 229, 5, 219, 
	5, 96, 97, 98, 96, 178, 179, 180, 
	181, 182, 183, 184, 185, 96, 96, 230, 
	162, 163, 5, 96, 197, 231, 160, 97, 
	98, 96, 200, 201, 202, 203, 204, 205, 
	206, 207, 96, 96, 232, 159, 159, 5, 
	96, 158, 97, 98, 96, 200, 201, 202, 
	203, 204, 205, 206, 207, 96, 96, 232, 
	159, 159, 5, 233, 5, 178, 179, 180, 
	181, 182, 183, 184, 185, 219, 5, 233, 
	5, 233, 5, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 235, 235, 236, 5, 
	233, 5, 233, 5, 237, 235, 236, 235, 
	238, 235, 239, 235, 240, 239, 5, 233, 
	5, 233, 233, 5, 236, 235, 237, 235, 
	235, 240, 5, 235, 5, 241, 242, 243, 
	5, 236, 5, 234, 240, 244, 235, 237, 
	5, 233, 5, 245, 5, 233, 5, 99, 
	246, 99, 99, 99, 99, 99, 5, 247, 
	5, 96, 248, 249, 250, 96, 96, 96, 
	251, 161, 161, 5, 96, 164, 252, 97, 
	98, 96, 96, 96, 161, 161, 161, 5, 
	96, 253, 254, 255, 97, 98, 96, 96, 
	96, 256, 166, 167, 5, 96, 164, 257, 
	97, 98, 96, 96, 96, 161, 161, 161, 
	5, 96, 258, 259, 260, 97, 98, 96, 
	96, 96, 261, 166, 167, 5, 96, 164, 
	262, 97, 98, 96, 96, 96, 161, 161, 
	161, 5, 96, 263, 264, 265, 97, 98, 
	96, 96, 96, 266, 166, 167, 5, 96, 
	164, 262, 97, 98, 96, 96, 96, 261, 
	161, 161, 5, 96, 164, 262, 97, 98, 
	96, 96, 96, 258, 161, 161, 5, 96, 
	164, 262, 267, 97, 98, 96, 96, 96, 
	261, 258, 161, 161, 5, 96, 164, 262, 
	97, 98, 96, 96, 96, 258, 161, 161, 
	161, 5, 96, 164, 257, 97, 98, 96, 
	96, 96, 256, 161, 161, 5, 96, 164, 
	257, 97, 98, 96, 96, 96, 253, 161, 
	161, 5, 96, 164, 257, 268, 97, 98, 
	96, 96, 96, 256, 253, 161, 161, 5, 
	96, 164, 257, 97, 98, 96, 96, 96, 
	253, 161, 161, 161, 5, 96, 164, 252, 
	97, 98, 96, 96, 96, 251, 161, 161, 
	5, 96, 164, 252, 97, 98, 96, 96, 
	96, 248, 161, 161, 5, 96, 164, 252, 
	269, 97, 98, 96, 96, 96, 251, 248, 
	161, 161, 5, 96, 164, 252, 97, 98, 
	96, 96, 96, 248, 161, 161, 161, 5, 
	270, 270, 270, 5, 270, 270, 270, 5, 
	270, 5, 270, 270, 270, 270, 270, 5, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 5, 270, 270, 5, 270, 270, 5, 
	270, 270, 5, 270, 270, 270, 5, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	5, 270, 270, 5, 270, 270, 5, 270, 
	270, 270, 270, 270, 270, 5, 270, 5, 
	270, 270, 5, 270, 5, 270, 270, 5, 
	271, 272, 273, 274, 275, 276, 277, 278, 
	279, 280, 281, 282, 283, 284, 285, 286, 
	287, 288, 289, 290, 291, 292, 293, 294, 
	295, 296, 297, 298, 299, 300, 301, 302, 
	5, 270, 5, 270, 5, 270, 270, 5, 
	270, 5, 270, 270, 270, 5, 270, 270, 
	270, 270, 270, 270, 270, 270, 5, 270, 
	270, 270, 270, 270, 270, 270, 5, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 5, 270, 270, 270, 270, 270, 270, 
	270, 5, 270, 270, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	5, 270, 270, 270, 270, 270, 270, 270, 
	270, 5, 270, 270, 270, 270, 270, 270, 
	270, 5, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 5, 270, 270, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	5, 270, 270, 270, 270, 270, 270, 5, 
	270, 270, 270, 270, 270, 5, 270, 270, 
	270, 270, 270, 270, 5, 270, 5, 270, 
	5, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 5, 270, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 5, 270, 
	270, 270, 5, 270, 5, 303, 304, 305, 
	306, 307, 308, 309, 310, 311, 312, 313, 
	314, 315, 316, 317, 318, 319, 320, 321, 
	322, 323, 324, 325, 326, 327, 328, 329, 
	330, 275, 331, 332, 333, 321, 334, 335, 
	336, 337, 338, 339, 340, 275, 275, 5, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 5, 270, 270, 270, 270, 270, 270, 
	5, 270, 270, 270, 270, 270, 5, 270, 
	270, 270, 270, 5, 270, 270, 270, 5, 
	270, 270, 5, 270, 270, 5, 270, 5, 
	270, 5, 270, 270, 5, 270, 270, 5, 
	270, 5, 270, 270, 270, 5, 270, 270, 
	270, 270, 5, 270, 270, 270, 5, 270, 
	270, 5, 270, 5, 270, 270, 5, 270, 
	5, 270, 270, 270, 5, 270, 270, 5, 
	270, 270, 5, 270, 5, 270, 270, 5, 
	270, 270, 270, 5, 270, 5, 270, 270, 
	5, 270, 270, 5, 270, 5, 270, 270, 
	5, 270, 270, 5, 270, 270, 5, 270, 
	270, 270, 5, 270, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 5, 270, 
	270, 270, 270, 270, 270, 270, 5, 341, 
	342, 343, 344, 345, 346, 347, 348, 275, 
	349, 350, 351, 352, 353, 354, 5, 270, 
	270, 5, 270, 5, 270, 5, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 5, 270, 270, 5, 270, 5, 270, 
	270, 5, 270, 270, 5, 270, 270, 5, 
	270, 270, 270, 270, 5, 270, 270, 270, 
	5, 270, 270, 270, 270, 270, 5, 270, 
	270, 270, 270, 270, 5, 270, 5, 355, 
	313, 356, 357, 358, 275, 359, 360, 275, 
	5, 270, 270, 270, 270, 5, 270, 270, 
	270, 270, 5, 270, 270, 5, 270, 270, 
	5, 270, 270, 5, 270, 5, 323, 275, 
	275, 5, 275, 5, 361, 275, 5, 270, 
	5, 361, 362, 363, 364, 365, 366, 367, 
	368, 369, 370, 333, 371, 372, 373, 374, 
	375, 376, 377, 378, 379, 275, 275, 5, 
	270, 5, 270, 270, 270, 5, 270, 270, 
	270, 5, 270, 270, 5, 270, 270, 5, 
	270, 270, 5, 270, 270, 270, 270, 5, 
	270, 5, 270, 5, 270, 270, 270, 5, 
	270, 270, 5, 270, 270, 5, 270, 270, 
	5, 270, 5, 270, 270, 270, 5, 270, 
	270, 270, 270, 5, 270, 270, 270, 270, 
	270, 5, 270, 270, 5, 380, 381, 275, 
	5, 270, 270, 5, 270, 270, 5, 382, 
	383, 384, 385, 386, 387, 388, 303, 389, 
	390, 391, 392, 393, 394, 395, 396, 397, 
	275, 5, 270, 270, 5, 270, 5, 270, 
	270, 270, 270, 270, 270, 5, 270, 270, 
	270, 5, 270, 5, 270, 5, 270, 270, 
	5, 270, 270, 5, 270, 270, 5, 270, 
	270, 5, 270, 5, 270, 5, 270, 270, 
	5, 270, 5, 270, 270, 270, 270, 5, 
	398, 399, 400, 401, 402, 403, 404, 405, 
	407, 408, 409, 406, 5, 410, 411, 275, 
	412, 413, 414, 415, 416, 417, 418, 419, 
	420, 421, 422, 423, 424, 425, 426, 323, 
	427, 275, 428, 275, 5, 270, 270, 270, 
	270, 270, 5, 270, 270, 5, 270, 5, 
	270, 5, 270, 270, 5, 270, 5, 270, 
	270, 5, 270, 270, 5, 270, 270, 5, 
	270, 270, 5, 270, 5, 270, 270, 270, 
	270, 270, 270, 5, 270, 5, 270, 270, 
	5, 270, 270, 5, 270, 270, 270, 270, 
	270, 270, 270, 5, 270, 5, 270, 270, 
	5, 270, 5, 275, 429, 412, 430, 312, 
	275, 431, 321, 5, 270, 5, 270, 5, 
	270, 5, 432, 275, 5, 270, 5, 432, 
	275, 5, 433, 275, 434, 435, 275, 5, 
	270, 5, 270, 270, 5, 270, 5, 436, 
	5, 270, 5, 437, 438, 439, 440, 441, 
	442, 443, 444, 445, 446, 447, 448, 449, 
	450, 275, 5, 270, 270, 270, 5, 270, 
	270, 270, 5, 270, 5, 270, 270, 5, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	5, 270, 270, 5, 270, 270, 270, 270, 
	270, 270, 5, 270, 270, 270, 270, 5, 
	270, 270, 5, 270, 270, 270, 270, 5, 
	270, 270, 270, 5, 270, 270, 270, 5, 
	270, 270, 270, 5, 270, 270, 5, 451, 
	452, 453, 5, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 5, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	5, 270, 270, 270, 270, 270, 5, 454, 
	275, 5, 270, 5, 312, 420, 275, 5, 
	420, 275, 5, 455, 5, 456, 275, 5, 
	270, 5, 96, 97, 98, 96, 178, 179, 
	180, 181, 182, 183, 184, 185, 96, 96, 
	457, 96, 96, 5, 96, 197, 197, 97, 
	98, 96, 200, 201, 202, 203, 204, 205, 
	206, 207, 96, 96, 208, 96, 96, 5, 
	1, 459, 460, 1, 461, 458, 462, 461, 
	458, 464, 465, 466, 468, 462, 471, 472, 
	474, 470, 475, 476, 477, 478, 479, 480, 
	481, 482, 483, 484, 485, 486, 487, 488, 
	489, 490, 491, 492, 493, 494, 496, 497, 
	498, 499, 500, 462, 501, 462, 501, 458, 
	462, 467, 458, 469, 458, 469, 458, 470, 
	473, 495, 470, 463, 1, 503, 504, 1, 
	505, 506, 507, 508, 502, 1, 509, 1, 
	505, 506, 507, 508, 502, 1, 1, 505, 
	506, 507, 508, 502, 1, 509, 1, 505, 
	506, 507, 508, 502, 1, 510, 511, 1, 
	505, 506, 507, 508, 502, 513, 512, 1, 
	510, 514, 1, 505, 506, 507, 508, 502, 
	513, 512, 1, 511, 514, 1, 505, 506, 
	507, 508, 502, 132, 132, 96, 133, 96, 
	97, 133, 98, 133, 96, 133, 134, 135, 
	136, 137, 138, 139, 132, 96, 157, 96, 
	96, 96, 96, 515, 105, 107, 112, 516, 
	104, 110, 104, 515, 111, 112, 112, 111, 
	111, 111, 112, 111, 111, 112, 112, 515, 
	112, 113, 515, 105, 107, 112, 516, 104, 
	104, 114, 515, 105, 107, 112, 516, 104, 
	104, 104, 515, 105, 107, 112, 516, 128, 
	104, 104, 515, 105, 107, 112, 516, 125, 
	104, 104, 515, 105, 107, 112, 517, 516, 
	128, 125, 104, 104, 515, 105, 107, 112, 
	516, 125, 104, 104, 104, 515, 96, 97, 
	98, 96, 96, 96, 96, 96, 96, 515, 
	96, 158, 518, 97, 98, 520, 96, 520, 
	236, 240, 237, 521, 522, 523, 524, 525, 
	96, 96, 519, 159, 159, 515, 96, 164, 
	165, 112, 172, 98, 96, 96, 96, 161, 
	168, 161, 515, 99, 112, 98, 99, 99, 
	99, 169, 99, 99, 515, 96, 164, 165, 
	112, 172, 98, 96, 96, 96, 161, 161, 
	170, 515, 96, 164, 526, 97, 98, 527, 
	96, 527, 178, 179, 180, 181, 182, 183, 
	184, 185, 96, 96, 230, 161, 161, 515, 
	96, 164, 165, 97, 98, 527, 96, 527, 
	178, 179, 180, 181, 182, 183, 184, 185, 
	96, 96, 230, 161, 161, 515, 96, 97, 
	98, 96, 200, 201, 202, 203, 204, 205, 
	206, 207, 96, 96, 208, 96, 96, 515, 
	200, 201, 202, 203, 204, 205, 206, 207, 
	209, 515, 96, 164, 165, 97, 98, 96, 
	200, 201, 202, 203, 204, 205, 206, 207, 
	96, 96, 199, 161, 161, 515, 528, 528, 
	178, 179, 180, 181, 182, 183, 184, 185, 
	219, 515, 96, 164, 526, 97, 98, 527, 
	96, 527, 178, 179, 180, 181, 182, 183, 
	184, 185, 96, 96, 177, 161, 161, 515, 
	96, 164, 526, 97, 98, 527, 96, 527, 
	178, 179, 180, 181, 182, 183, 184, 185, 
	96, 96, 174, 161, 161, 515, 96, 164, 
	526, 529, 97, 98, 527, 96, 527, 178, 
	179, 180, 181, 182, 183, 184, 185, 96, 
	96, 177, 174, 161, 161, 515, 96, 164, 
	526, 97, 98, 527, 96, 527, 178, 179, 
	180, 181, 182, 183, 184, 185, 96, 96, 
	174, 230, 161, 161, 515, 96, 158, 530, 
	97, 98, 520, 96, 520, 236, 240, 237, 
	521, 522, 523, 524, 525, 96, 96, 519, 
	159, 159, 515, 96, 158, 160, 97, 98, 
	96, 200, 201, 202, 203, 204, 205, 206, 
	207, 96, 96, 232, 159, 159, 515, 531, 
	528, 528, 236, 240, 237, 521, 522, 523, 
	524, 525, 233, 515, 96, 158, 518, 97, 
	98, 520, 96, 520, 236, 240, 237, 521, 
	522, 523, 524, 525, 96, 96, 467, 159, 
	159, 515, 96, 158, 518, 97, 98, 520, 
	96, 520, 236, 240, 237, 521, 522, 523, 
	524, 525, 96, 96, 464, 159, 159, 515, 
	96, 158, 518, 532, 97, 98, 520, 96, 
	520, 236, 240, 237, 521, 522, 523, 524, 
	525, 96, 96, 467, 464, 159, 159, 515, 
	96, 158, 518, 97, 98, 520, 96, 520, 
	236, 240, 237, 521, 522, 523, 524, 525, 
	96, 96, 464, 519, 159, 159, 515, 132, 
	132, 133, 133, 133, 133, 133, 133, 134, 
	135, 136, 137, 138, 139, 132, 515, 96, 
	158, 160, 97, 98, 96, 534, 535, 536, 
	537, 538, 539, 540, 541, 542, 543, 544, 
	545, 546, 547, 303, 548, 386, 549, 550, 
	551, 552, 553, 554, 555, 556, 557, 558, 
	559, 560, 96, 96, 159, 533, 533, 275, 
	406, 515, 96, 158, 160, 97, 98, 96, 
	534, 535, 536, 537, 538, 539, 540, 541, 
	542, 543, 544, 545, 546, 547, 303, 548, 
	386, 549, 550, 551, 552, 553, 554, 555, 
	556, 557, 558, 559, 560, 96, 96, 159, 
	561, 561, 275, 406, 515, 96, 158, 160, 
	562, 98, 96, 534, 535, 536, 537, 538, 
	539, 540, 541, 542, 543, 544, 545, 546, 
	547, 303, 548, 386, 549, 550, 551, 552, 
	553, 554, 555, 556, 557, 558, 559, 560, 
	96, 96, 159, 561, 561, 275, 406, 515, 
	96, 164, 165, 112, 172, 98, 96, 96, 
	96, 161, 161, 161, 515, 96, 164, 165, 
	112, 172, 98, 96, 96, 96, 266, 161, 
	161, 515, 96, 164, 165, 112, 172, 98, 
	96, 96, 96, 263, 161, 161, 515, 96, 
	164, 165, 112, 563, 172, 98, 96, 96, 
	96, 266, 263, 161, 161, 515, 96, 164, 
	165, 112, 172, 98, 96, 96, 96, 263, 
	161, 161, 161, 515, 534, 535, 536, 537, 
	538, 539, 540, 541, 542, 543, 544, 545, 
	546, 547, 303, 548, 386, 549, 550, 551, 
	552, 553, 554, 555, 556, 557, 558, 559, 
	560, 270, 270, 275, 406, 515, 470, 515, 
	564, 565, 565, 565, 470, 515, 1, 503, 
	504, 1, 505, 506, 507, 508, 470, 502, 
	534, 535, 536, 537, 538, 539, 540, 541, 
	542, 543, 544, 545, 546, 547, 303, 548, 
	386, 549, 550, 551, 552, 553, 554, 555, 
	556, 557, 558, 559, 560, 270, 270, 470, 
	275, 406, 515, 470, 470, 565, 515, 565, 
	515, 565, 565, 565, 470, 565, 470, 565, 
	470, 515, 470, 470, 565, 470, 565, 470, 
	515, 565, 470, 470, 470, 470, 565, 515, 
	470, 565, 515, 565, 470, 565, 515, 565, 
	470, 565, 515, 565, 565, 470, 565, 515, 
	565, 470, 515, 470, 565, 470, 565, 470, 
	515, 470, 565, 515, 470, 565, 470, 566, 
	470, 565, 515, 531, 528, 528, 236, 240, 
	237, 521, 522, 523, 524, 525, 233, 470, 
	515, 470, 565, 565, 470, 565, 470, 565, 
	566, 565, 470, 515, 565, 470, 565, 470, 
	515, 470, 565, 515, 565, 565, 470, 515, 
	565, 566, 565, 470, 565, 470, 515, 567, 
	568, 569, 570, 571, 572, 573, 574, 575, 
	576, 577, 578, 579, 580, 581, 582, 583, 
	582, 584, 585, 586, 587, 588, 589, 590, 
	591, 592, 593, 594, 595, 470, 515, 565, 
	565, 565, 565, 470, 515, 565, 470, 515, 
	565, 470, 565, 470, 515, 565, 470, 565, 
	470, 515, 565, 470, 470, 470, 565, 470, 
	566, 565, 515, 470, 470, 565, 470, 565, 
	470, 565, 470, 565, 470, 565, 470, 515, 
	565, 470, 470, 565, 470, 566, 565, 470, 
	515, 470, 470, 470, 470, 470, 565, 470, 
	565, 470, 565, 470, 515, 470, 470, 565, 
	470, 566, 470, 565, 470, 515, 470, 470, 
	470, 470, 470, 565, 470, 565, 470, 515, 
	565, 470, 565, 470, 566, 470, 515, 470, 
	470, 470, 565, 470, 565, 470, 565, 470, 
	565, 470, 515, 470, 565, 470, 565, 470, 
	566, 470, 515, 565, 470, 470, 470, 470, 
	565, 470, 565, 470, 565, 470, 565, 470, 
	565, 470, 565, 470, 515, 565, 470, 566, 
	470, 515, 470, 470, 470, 470, 565, 470, 
	565, 470, 515, 470, 565, 470, 565, 470, 
	566, 470, 515, 565, 470, 470, 565, 470, 
	566, 565, 470, 515, 470, 470, 565, 470, 
	565, 470, 515, 565, 470, 565, 470, 566, 
	470, 565, 515, 470, 470, 470, 565, 470, 
	565, 470, 515, 565, 470, 515, 470, 470, 
	565, 470, 515, 565, 470, 566, 470, 515, 
	470, 470, 470, 565, 470, 470, 470, 470, 
	470, 470, 565, 565, 470, 565, 470, 565, 
	470, 565, 470, 515, 470, 565, 470, 566, 
	470, 565, 470, 515, 565, 470, 566, 470, 
	515, 470, 565, 470, 515, 470, 565, 470, 
	515, 596, 597, 598, 599, 600, 601, 602, 
	603, 604, 605, 606, 607, 608, 609, 610, 
	611, 612, 613, 614, 615, 616, 617, 618, 
	619, 620, 621, 622, 623, 624, 625, 470, 
	626, 627, 628, 629, 630, 631, 470, 632, 
	470, 633, 634, 635, 636, 473, 515, 565, 
	565, 470, 515, 565, 566, 470, 565, 470, 
	565, 470, 565, 470, 565, 470, 565, 515, 
	565, 565, 470, 566, 470, 565, 515, 470, 
	565, 470, 565, 470, 565, 515, 470, 470, 
	470, 565, 470, 565, 470, 565, 515, 470, 
	470, 470, 565, 470, 565, 470, 565, 515, 
	470, 470, 565, 470, 565, 515, 470, 565, 
	470, 565, 515, 565, 470, 515, 565, 470, 
	565, 515, 565, 470, 515, 470, 565, 515, 
	565, 470, 565, 515, 564, 565, 470, 565, 
	515, 565, 470, 515, 470, 565, 470, 565, 
	470, 515, 470, 565, 470, 565, 470, 515, 
	565, 470, 515, 565, 565, 470, 566, 470, 
	515, 470, 566, 470, 565, 515, 565, 470, 
	515, 470, 565, 470, 565, 515, 565, 470, 
	515, 565, 470, 515, 470, 566, 565, 470, 
	565, 470, 515, 565, 470, 515, 470, 565, 
	470, 566, 470, 515, 565, 470, 565, 515, 
	565, 470, 515, 565, 566, 470, 566, 470, 
	515, 470, 565, 470, 515, 470, 565, 470, 
	566, 470, 515, 470, 565, 470, 565, 566, 
	565, 515, 565, 470, 515, 565, 470, 515, 
	566, 470, 565, 566, 565, 470, 515, 470, 
	470, 565, 470, 565, 470, 515, 565, 470, 
	565, 470, 565, 515, 470, 470, 470, 470, 
	565, 470, 565, 470, 565, 470, 515, 470, 
	470, 470, 565, 515, 470, 470, 470, 565, 
	470, 565, 470, 565, 470, 565, 470, 565, 
	470, 515, 637, 638, 639, 640, 641, 642, 
	643, 644, 473, 645, 646, 647, 648, 649, 
	650, 470, 515, 651, 564, 564, 470, 515, 
	132, 132, 133, 133, 133, 133, 133, 133, 
	134, 135, 136, 137, 138, 139, 132, 470, 
	515, 564, 565, 565, 470, 515, 470, 565, 
	470, 515, 565, 565, 470, 565, 565, 565, 
	470, 470, 565, 470, 565, 470, 565, 470, 
	565, 515, 565, 470, 565, 470, 515, 470, 
	565, 470, 515, 470, 565, 515, 470, 565, 
	515, 565, 470, 565, 470, 565, 470, 515, 
	470, 565, 565, 470, 565, 515, 565, 565, 
	470, 515, 470, 470, 470, 470, 565, 470, 
	565, 515, 470, 470, 470, 565, 470, 515, 
	565, 470, 515, 652, 607, 653, 654, 655, 
	473, 656, 657, 470, 473, 515, 564, 470, 
	565, 470, 565, 470, 565, 470, 515, 470, 
	565, 470, 565, 515, 470, 565, 515, 470, 
	565, 470, 565, 515, 565, 470, 565, 470, 
	515, 470, 565, 515, 618, 470, 473, 515, 
	473, 515, 658, 473, 515, 565, 470, 515, 
	658, 659, 660, 661, 662, 629, 663, 664, 
	665, 666, 613, 667, 668, 669, 670, 671, 
	672, 673, 674, 675, 676, 677, 678, 473, 
	470, 473, 515, 470, 565, 470, 515, 565, 
	470, 565, 566, 565, 470, 515, 565, 565, 
	470, 515, 565, 470, 565, 515, 470, 565, 
	470, 565, 515, 470, 565, 470, 565, 470, 
	565, 470, 515, 470, 565, 515, 470, 470, 
	470, 565, 470, 515, 470, 565, 470, 515, 
	565, 470, 566, 470, 565, 470, 515, 566, 
	565, 470, 565, 515, 565, 470, 565, 470, 
	515, 470, 565, 470, 515, 565, 470, 566, 
	470, 515, 565, 470, 515, 470, 565, 565, 
	470, 566, 470, 565, 470, 515, 470, 565, 
	470, 565, 470, 565, 470, 515, 470, 565, 
	470, 565, 470, 565, 470, 565, 470, 515, 
	470, 470, 565, 470, 565, 470, 565, 470, 
	565, 470, 515, 565, 470, 566, 470, 515, 
	679, 680, 473, 470, 515, 565, 470, 565, 
	515, 565, 470, 565, 470, 515, 681, 682, 
	683, 684, 685, 686, 687, 688, 689, 690, 
	470, 691, 692, 693, 694, 695, 696, 470, 
	473, 515, 565, 470, 565, 515, 565, 470, 
	515, 565, 470, 470, 470, 470, 565, 470, 
	565, 470, 565, 515, 470, 470, 565, 515, 
	565, 470, 515, 470, 565, 515, 565, 470, 
	515, 470, 565, 515, 565, 470, 565, 515, 
	565, 470, 565, 470, 515, 470, 470, 565, 
	515, 565, 470, 515, 470, 566, 470, 565, 
	470, 515, 470, 565, 470, 565, 515, 470, 
	565, 515, 470, 565, 470, 565, 470, 565, 
	470, 565, 470, 515, 697, 698, 699, 700, 
	701, 702, 703, 704, 705, 706, 707, 470, 
	495, 470, 515, 708, 709, 473, 710, 711, 
	712, 713, 714, 715, 716, 717, 718, 719, 
	720, 721, 722, 723, 618, 724, 473, 725, 
	470, 473, 470, 515, 470, 470, 470, 470, 
	565, 515, 565, 470, 565, 470, 515, 565, 
	470, 515, 565, 470, 565, 515, 565, 470, 
	515, 565, 470, 565, 515, 470, 565, 470, 
	515, 565, 470, 565, 515, 565, 470, 565, 
	470, 515, 565, 470, 566, 470, 515, 565, 
	470, 565, 565, 565, 470, 565, 470, 515, 
	565, 470, 515, 565, 470, 565, 470, 515, 
	565, 470, 565, 515, 565, 470, 470, 470, 
	565, 470, 515, 470, 565, 470, 515, 565, 
	470, 565, 470, 515, 565, 470, 515, 726, 
	727, 728, 729, 730, 731, 732, 610, 733, 
	470, 515, 470, 565, 470, 515, 470, 566, 
	470, 515, 470, 565, 470, 515, 470, 565, 
	470, 566, 470, 515, 470, 565, 470, 566, 
	515, 470, 565, 470, 515, 470, 565, 470, 
	566, 470, 515, 566, 470, 515, 734, 473, 
	470, 515, 565, 470, 515, 734, 473, 470, 
	515, 735, 473, 736, 737, 470, 473, 470, 
	515, 565, 470, 515, 565, 565, 470, 515, 
	470, 565, 470, 515, 738, 470, 515, 565, 
	470, 515, 739, 740, 741, 742, 743, 744, 
	745, 746, 747, 748, 749, 470, 473, 470, 
	515, 470, 565, 515, 470, 565, 470, 470, 
	470, 565, 470, 565, 470, 565, 515, 470, 
	565, 515, 470, 470, 470, 470, 470, 565, 
	470, 565, 515, 470, 470, 565, 470, 565, 
	515, 565, 470, 565, 515, 470, 470, 470, 
	565, 515, 470, 470, 565, 515, 470, 470, 
	565, 515, 470, 470, 565, 515, 470, 565, 
	470, 566, 515, 750, 751, 752, 470, 515, 
	470, 470, 470, 565, 470, 470, 470, 565, 
	470, 565, 470, 515, 565, 565, 565, 565, 
	470, 470, 565, 565, 565, 565, 565, 470, 
	470, 470, 470, 470, 470, 470, 565, 470, 
	565, 470, 565, 515, 470, 470, 470, 565, 
	470, 565, 470, 515, 753, 473, 515, 565, 
	470, 515, 606, 754, 473, 470, 515, 565, 
	470, 515, 754, 470, 473, 470, 515, 96, 
	97, 98, 96, 236, 240, 237, 521, 522, 
	523, 524, 525, 96, 96, 755, 96, 96, 
	515, 96, 756, 97, 98, 757, 96, 757, 
	236, 240, 237, 521, 522, 523, 524, 525, 
	96, 96, 755, 96, 96, 515, 96, 97, 
	98, 757, 96, 757, 178, 179, 180, 181, 
	182, 183, 184, 185, 96, 96, 457, 96, 
	96, 515, 0
};

static const short _generic_tokenizer_trans_targs[] = {
	473, 474, 3, 5, 6, 473, 8, 9, 
	473, 89, 11, 12, 13, 14, 15, 16, 
	17, 18, 19, 20, 21, 22, 23, 24, 
	25, 26, 27, 90, 92, 95, 57, 63, 
	69, 10, 29, 39, 55, 28, 30, 31, 
	32, 33, 34, 35, 36, 37, 38, 40, 
	41, 42, 43, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 56, 58, 
	59, 60, 61, 62, 64, 65, 66, 67, 
	68, 70, 72, 71, 73, 74, 75, 76, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 91, 93, 94, 96, 
	97, 98, 100, 99, 101, 122, 124, 123, 
	103, 102, 109, 104, 105, 108, 484, 106, 
	485, 486, 487, 110, 118, 120, 119, 111, 
	112, 114, 116, 115, 113, 488, 489, 491, 
	490, 117, 121, 125, 8, 126, 127, 128, 
	130, 132, 142, 144, 129, 131, 133, 134, 
	135, 136, 137, 138, 139, 140, 141, 143, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 160, 162, 155, 156, 157, 159, 
	495, 496, 497, 161, 158, 163, 498, 504, 
	506, 505, 197, 200, 201, 202, 205, 208, 
	209, 210, 166, 173, 175, 174, 167, 168, 
	169, 171, 170, 172, 176, 178, 196, 502, 
	179, 180, 181, 182, 185, 188, 189, 190, 
	500, 501, 183, 184, 186, 187, 191, 192, 
	194, 193, 195, 503, 199, 203, 204, 206, 
	207, 211, 212, 214, 213, 215, 499, 218, 
	509, 510, 224, 225, 219, 222, 227, 228, 
	221, 232, 233, 235, 234, 236, 238, 239, 
	240, 254, 256, 255, 241, 242, 250, 252, 
	251, 243, 244, 246, 248, 247, 245, 519, 
	520, 522, 521, 249, 253, 257, 524, 278, 
	279, 280, 281, 260, 282, 283, 284, 285, 
	286, 287, 288, 289, 290, 291, 292, 293, 
	294, 295, 296, 297, 298, 299, 300, 301, 
	302, 303, 304, 305, 306, 307, 308, 273, 
	310, 311, 312, 313, 314, 315, 316, 317, 
	318, 319, 320, 321, 322, 323, 324, 325, 
	326, 327, 328, 329, 330, 331, 332, 333, 
	334, 335, 336, 337, 338, 339, 340, 341, 
	342, 343, 344, 345, 346, 348, 349, 350, 
	351, 352, 353, 354, 355, 356, 357, 358, 
	359, 360, 361, 363, 364, 365, 366, 367, 
	368, 372, 374, 375, 376, 377, 378, 379, 
	380, 381, 382, 383, 384, 385, 386, 387, 
	388, 389, 390, 391, 393, 394, 396, 397, 
	398, 399, 275, 400, 401, 402, 403, 404, 
	405, 406, 407, 408, 409, 410, 412, 432, 
	436, 438, 439, 443, 445, 460, 370, 464, 
	466, 467, 413, 414, 415, 416, 417, 418, 
	419, 420, 421, 422, 423, 424, 425, 426, 
	427, 428, 429, 430, 431, 433, 434, 435, 
	437, 440, 441, 442, 444, 446, 447, 448, 
	449, 450, 451, 452, 453, 454, 455, 456, 
	457, 458, 459, 461, 462, 463, 465, 469, 
	470, 749, 473, 478, 482, 483, 493, 0, 
	494, 511, 513, 512, 515, 516, 525, 526, 
	529, 530, 531, 532, 533, 534, 535, 536, 
	537, 538, 539, 540, 541, 543, 544, 545, 
	546, 547, 548, 578, 620, 636, 643, 644, 
	645, 647, 668, 671, 688, 747, 473, 475, 
	477, 1, 2, 4, 7, 476, 479, 480, 
	473, 473, 481, 473, 107, 492, 164, 508, 
	217, 223, 226, 229, 230, 231, 165, 177, 
	198, 507, 216, 220, 514, 517, 258, 259, 
	261, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 271, 272, 274, 276, 277, 309, 
	347, 362, 369, 371, 373, 392, 395, 411, 
	468, 518, 237, 523, 527, 528, 542, 549, 
	550, 551, 552, 553, 554, 555, 556, 557, 
	558, 559, 560, 561, 562, 563, 564, 565, 
	566, 567, 568, 569, 570, 571, 572, 573, 
	574, 575, 576, 577, 579, 580, 581, 582, 
	583, 584, 585, 586, 587, 588, 589, 590, 
	591, 592, 593, 594, 595, 596, 597, 598, 
	599, 600, 601, 602, 603, 604, 605, 606, 
	607, 608, 609, 610, 611, 612, 613, 614, 
	615, 616, 617, 618, 619, 621, 623, 624, 
	625, 626, 627, 628, 629, 630, 631, 632, 
	633, 634, 635, 622, 637, 638, 639, 640, 
	641, 642, 646, 648, 649, 650, 651, 652, 
	653, 654, 655, 656, 657, 658, 659, 660, 
	661, 662, 663, 664, 665, 666, 667, 669, 
	670, 672, 673, 674, 675, 676, 677, 678, 
	679, 680, 681, 682, 683, 684, 685, 686, 
	687, 689, 708, 717, 719, 720, 724, 726, 
	738, 742, 744, 746, 690, 691, 692, 693, 
	694, 695, 696, 697, 698, 699, 700, 701, 
	702, 703, 704, 705, 706, 707, 709, 710, 
	711, 712, 713, 714, 715, 716, 718, 721, 
	722, 723, 725, 727, 728, 729, 730, 731, 
	732, 733, 734, 735, 736, 737, 739, 740, 
	741, 743, 745, 748, 471, 472
};

static const char _generic_tokenizer_trans_actions[] = {
	1, 2, 0, 0, 0, 3, 0, 0, 
	4, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	2, 0, 2, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 2, 2, 
	2, 0, 0, 0, 5, 0, 5, 0, 
	5, 5, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 2, 0, 0, 0, 2, 2, 
	2, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	2, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	2, 2, 2, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 8, 2, 2, 2, 2, 0, 
	2, 2, 2, 2, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 9, 2, 
	2, 0, 0, 0, 0, 2, 0, 2, 
	10, 11, 0, 12, 0, 2, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 2, 2, 2, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 0, 0
};

static const char _generic_tokenizer_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const char _generic_tokenizer_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _generic_tokenizer_eof_trans[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 0, 503, 503, 503, 503, 503, 513, 
	503, 513, 503, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 503, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516
};

static const int generic_tokenizer_start = 473;
static const int generic_tokenizer_first_final = 473;
static const int generic_tokenizer_error = 0;

static const int generic_tokenizer_en_main = 473;




bool generic_tokenizer::next_sentence(vector<string_piece>& forms) {
  int cs, act;
  const char* ts, *te;
  const char* text_start = text;

  char32_t unary_chr;
  const char* unary_text;
  const char* whitespace = nullptr; // Suppress "may be uninitialized" warning
  
	{
	cs = generic_tokenizer_start;
	ts = 0;
	te = 0;
	act = 0;
	}

	{
	int _klen;
	const short *_keys;
	int _trans;
	short _widec;

	if ( ( text) == ( text_end) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	switch ( _generic_tokenizer_from_state_actions[cs] ) {
	case 7:
	{ts = ( text);}
	break;
	}

	_widec = ( (unsigned char)*text);
	_klen = _generic_tokenizer_cond_lengths[cs];
	_keys = _generic_tokenizer_cond_keys + (_generic_tokenizer_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _generic_tokenizer_cond_spaces[_generic_tokenizer_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && !utf8::is_Pd(unary_chr))  ) _widec += 256;
		break;
	}
	case 1: {
		_widec = (short)(768u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && unary_chr != '+')  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _generic_tokenizer_trans_keys + _generic_tokenizer_key_offsets[cs];
	_trans = _generic_tokenizer_index_offsets[cs];

	_klen = _generic_tokenizer_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _generic_tokenizer_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _generic_tokenizer_indicies[_trans];
_eof_trans:
	cs = _generic_tokenizer_trans_targs[_trans];

	if ( _generic_tokenizer_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _generic_tokenizer_trans_actions[_trans] ) {
	case 5:
	{ whitespace = text; }
	break;
	case 2:
	{te = ( text)+1;}
	break;
	case 8:
	{te = ( text)+1;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 4:
	{te = ( text)+1;{
          // Does this eos character marks end of sentence?
          bool eos_exception = false;
          if (!forms.empty()) {
            // Is it single Lut?
            string_piece form = forms.back();
            eos_exception = utf8::is_Lut(utf8::decode(form.str, form.len)) && !form.len;
          }

          // Add all characters until first space to forms and break if eos.
          for (text = ts; text < whitespace; forms.emplace_back(ts, text - ts), ts = text) utf8_advance(text, whitespace);
          {( text) = (( whitespace))-1;}
          if (!eos_exception) {( text)++; goto _out; }
        }}
	break;
	case 11:
	{te = ( text)+1;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 12:
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 9:
	{te = ( text);( text)--;}
	break;
	case 10:
	{te = ( text);( text)--;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 3:
	{{( text) = ((te))-1;}{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 1:
	{{( text) = ((te))-1;}}
	break;
	}

_again:
	switch ( _generic_tokenizer_to_state_actions[cs] ) {
	case 6:
	{ts = 0;}
	break;
	}

	if ( cs == 0 )
		goto _out;
	if ( ++( text) != ( text_end) )
		goto _resume;
	_test_eof: {}
	if ( ( text) == ( text_end) )
	{
	if ( _generic_tokenizer_eof_trans[cs] > 0 ) {
		_trans = _generic_tokenizer_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}


  (void)act; // Suppress unused variable warning

  return !forms.empty();
}

} // namespace morphodita
} // namespace ufal
