package Spp::Cursor;

use Exporter;
our @ISA    = qw(Exporter);
our @EXPORT_OK = qw(new_cursor step getchar prechar);

use 5.012;

sub new_cursor {
   my ($str, $ns) = @_;
   $str = $str . chr(0);
   return {
      str    => $str,
      ns     => $ns,
      len    => length($str),
      off    => 0,
      maxoff => 0,      # record max match location
      debug  => 0,      # 1 open debug mode
      depth  => 0,      # match_rule trace depth
   };
}

sub step {
   my $cursor = shift;
   $cursor->{off} += 1;
   return 1;
}

sub getchar {
   my $cursor = shift;
   return substr($cursor->{str}, $cursor->{off}, 1);
}

sub prechar {
   my $cursor = shift;
   return substr($cursor->{str}, $cursor->{off} - 1, 1);
}

1;
