package Perinci::To::Text;

use 5.010001;
use Log::Any '$log';
use Moo;

extends 'Perinci::To::PackageBase';
with    'SHARYANTO::Role::Doc::Section::AddTextLines';

our $VERSION = '0.26'; # VERSION

sub BUILD {
    my ($self, $args) = @_;
}

sub gen_doc_section_summary {
    my ($self) = @_;

    $self->SUPER::gen_doc_section_summary;

    my $name_summary = join(
        "",
        $self->{_doc_res}{name} // "",
        ($self->{_doc_res}{name} && $self->{_doc_res}{summary} ? ' - ' : ''),
        $self->{_doc_res}{summary} // ""
    );

    $self->add_doc_lines(uc($self->loc("Name")), "");

    $self->inc_doc_indent;
    $self->add_doc_lines($name_summary);
    $self->dec_doc_indent;
}

sub gen_doc_section_version {
    my ($self) = @_;
    $self->add_doc_lines("", uc($self->loc("Version")), "");

    $self->inc_doc_indent;
    $self->add_doc_lines($self->{_doc_meta}{entity_v} // '?');
    $self->dec_doc_indent;
}

sub gen_doc_section_description {
    my ($self) = @_;

    $self->SUPER::gen_doc_section_description;
    return unless $self->{_doc_res}{description};

    $self->add_doc_lines("", uc($self->loc("Description")), "");

    $self->inc_doc_indent;
    $self->add_doc_lines($self->{_doc_res}{description});
    $self->dec_doc_indent;
}

sub gen_doc_section_functions {
    require Perinci::Sub::To::Text;

    my ($self) = @_;

    $self->{_doc_fgen} //= Perinci::Sub::To::Text->new(
        _pa => $self->_pa, # to avoid multiple instances of pa objects
    );

    $self->add_doc_lines("", uc($self->loc("Functions")), "");
    $self->SUPER::gen_doc_section_functions;
    for my $furi (sort keys %{ $self->{_doc_res}{functions} }) {
        my $fname;
        for ($fname) { $_ = $furi; s!.+/!! }
        for (@{ $self->{_doc_res}{functions}{$furi} }) {
            chomp;
            $self->add_doc_lines({wrap=>0}, $_);
        }
        $self->add_doc_lines('');
    }
}

1;
# ABSTRACT: Generate text documentation for a package from Rinci metadata

__END__

=pod

=encoding utf-8

=head1 NAME

Perinci::To::Text - Generate text documentation for a package from Rinci metadata

=head1 SYNOPSIS

 use Perinci::To::POD;
 my $doc = Perinci::To::Text->new(url => "/Some/Module/");
 say $doc->gen_doc;

You can also try the L<peri-pkg-doc> script (included in the L<Perinci::To::POD>
distribution) with the C<--format text> option:

 % peri-pkg-doc --format text /Some/Module/

To generate documentation for a single function, see L<Perinci::Sub::To::Text>
or the provided command-line script L<peri-func-doc>.

To generate a usage-like help message for a single function, you can try the
L<peri-func-usage> from the L<Perinci::CmdLine> distribution.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at
L<https://metacpan.org/release/Perinci-To-Text>.

=head1 SOURCE

Source repository is at L<https://github.com/sharyanto/perl-Perinci-To-Text>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
http://rt.cpan.org/Public/Dist/Display.html?Name=Perinci-To-Text

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
