use strict ;
use App::Framework ;

	# Create application and run it
	App::Framework->new()->go() ;



#=================================================================================
# SUBROUTINES EXECUTED BY APP
#=================================================================================

#----------------------------------------------------------------------
# Main execution
#
sub run
{
	my ($app) = @_ ;
	
	# options
	my %opts = $app->options() ;


	# Set up database
	my %sql_vars ;
	$app->set(
		'sql' => {
			'database'	=> $opts{'database'},
			'table'		=> $opts{'table'},
			'user'		=> $opts{'user'},
			'password'	=> $opts{'password'},
			
			'trace'		=> $opts{'debug'} ? 4 : 0,
#			'trace'		=> 4,
			'trace_file'=> 'logsql.log',
'debug' => $opts{'debug'},
			
			'prepare'	=> {
				'check',  {
					'limit'	=> 1,
					'where'	=> {
						'vars'	=> [qw/pid channel/],
						'vals'	=> \%sql_vars,
					},
				},
				'select',  {
					'where'	=> {
						'sql' => '`pid`>=? AND `channel`=?',
						'vars'	=> [qw/pid channel/],
						'vals'	=> \%sql_vars,
					},
				},
				'delete',  {
					'where'	=> {
						'sql' => '`pid`>=? AND `channel`=?',
						'vars'	=> [qw/pid channel/],
						'vals'	=> \%sql_vars,
					},
				},
				'insert',  {
					'vars'	=> [qw/pid channel title date start duration episode num_episodes repeat text/],
					'vals'	=> \%sql_vars,
				},
			},
		}
	) ;

print "== Create table ===\n" ;
#my $sql = $app->sql() ;
#my $sql_text = $app->data("listings2.sql") ;
#eval {
#$sql->do($sql_text) ;
#} ;
#if ($@)
#{
#	die "Failed to create table: $@" ;
#}
$app->sql_from_data("listings2.sql") ;

my $pid = $$ ;
my $start_pid = $pid ;
my $start_chan = '_adummy' ;

%sql_vars = (
	'pid'	=> $start_pid,
	'channel' => $start_chan,
	'title' => 'a test program',
	'date' => '2008-06-10',
	'start' => '10:30',
	'duration' => '01:00',
	'episode' => 2,
	'num_episodes' => 6,
	'repeat' => 0,
	'text' => "This is a test program",
) ;
#$sql_vars{'pid'} = $start_pid ;
#$sql_vars{'channel'} = $start_chan ;
#$sql_vars{'title'} = 'a test program' ;
#$sql_vars{'date'} = '2008-06-10' ;
#$sql_vars{'start'} = '10:30' ;
#$sql_vars{'duration'} = '01:00' ;
#$sql_vars{'episode'} = 2 ;
#$sql_vars{'num_episodes'} = 6 ;
#$sql_vars{'repeat'} = 0 ;
#$sql_vars{'text'} = "This is a test program" ;

print "Insert pid=$sql_vars{'pid'}...\n" ;
$app->sql_query('insert') ;

#exit 0 ;

%sql_vars = (
	'pid'	=> ++$pid,
	'channel' => $start_chan,
	'title' => 'a test program 2',
	'date' => '2008-06-11',
	'start' => '11:30',
	'duration' => '01:00',
	'episode' => 2,
	'num_episodes' => 6,
	'repeat' => 0,
	'text' => "This is a test program",
) ;
print "Insert pid=$sql_vars{'pid'}...\n" ;
$app->sql_query('insert') ;

%sql_vars = (
	'pid'	=> ++$pid,
	'channel' => $start_chan,
	'title' => 'a test program 3',
	'date' => '2008-06-12',
	'start' => '12:30',
	'duration' => '01:00',
	'episode' => 2,
	'num_episodes' => 6,
	'repeat' => 0,
	'text' => "This is a test program",
) ;
print "Insert pid=$sql_vars{'pid'}...\n" ;
$app->sql_query('insert') ;

%sql_vars = (
	'pid'	=> ++$pid,
	'channel' => $start_chan,
	'title' => 'a test program 4',
	'date' => '2008-06-13',
	'start' => '13:30',
	'duration' => '01:00',
	'episode' => 2,
	'num_episodes' => 6,
	'repeat' => 0,
	'text' => "This is a test program",
) ;
print "Insert pid=$sql_vars{'pid'}...\n" ;
$app->sql_query('insert') ;



print "== Just stored... =================\n" ;
show($app, \%sql_vars, $start_pid, $start_chan) ;

print "== All stored... ===================\n" ;
show($app, \%sql_vars, 0, $start_chan) ;

print "Delete..\n" ;
$sql_vars{'pid'} = $start_pid ;
$app->sql_query('delete') ;

print "== After delete... ===================\n" ;
show($app, \%sql_vars, 0, $start_chan) ;

}


sub show
{
	my ($app, $sql_vars_href, $pid, $chan) = @_ ;

## now get results back
$sql_vars_href->{'pid'} = $pid ;
$sql_vars_href->{'channel'} = $chan ;

$app->sql_query('select') ;
while (my $href = $app->sql_next('select'))
{
	foreach my $key (sort keys %$href)
	{
		print "$key=$href->{$key} " ;
	}
	print "\n" ;
}
	
}



__DATA__

[SUMMARY]
Tests the application object with SQL

[DESCRIPTION]

B<$name> will read the content file in I<dir> to gather the information it needs to
create the full repository. 

The script creates the package files, product files, media files, archive files, MD5SUMS, and updates
the content file.

The script also signs the repository using a pre-generated GPG key.


[OPTIONS]

-database=s	Database name [default=test]


-table=s	Table name [default=listings2]


-user=s User [default=steve]

-password=s	Pass


__#-----------------------------------------------------------------------------------------------------------------------------
__DATA__ listings23.sql
CREATE TABLE IF NOT EXISTS `listings2` (
  `pid` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `start` time NOT NULL,
  `duration` time NOT NULL,
  `episode` int(11) default NULL,
  `num_episodes` int(11) default NULL,
  `repeat` varchar(128) default NULL,
  `text` longtext NOT NULL,
  `channel` varchar(128) NOT NULL,
  `adapter` tinyint(8) NOT NULL default '0' COMMENT 'DVB adapter number',
  `genre` varchar(256) default NULL,
  `chan_type` varchar(256) NOT NULL default 'tv',
  `audio` tinyint(1) default '1',
  `video` tinyint(1) default '1',
  KEY `pid` (`pid`),
  KEY `chan_date_start_duration` (`channel`,`date`,`start`,`duration`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


__#-----------------------------------------------------------------------------------------------------------------------------
__DATA__ listings2.sql

-- http://www.phpmyadmin.net
-- 
-- Host: localhost
-- Generation Time: Feb 26, 2009 at 12:13 PM
-- Server version: 5.0.51
-- PHP Version: 5.2.6
-- 
-- Database: `test`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `listings2`
-- 

DROP TABLE IF EXISTS `listings2`;
CREATE TABLE IF NOT EXISTS `listings2` (
  `pid` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `start` time NOT NULL,
  `duration` time NOT NULL,
  `episode` int(11) default NULL,
  `num_episodes` int(11) default NULL,
  `repeat` varchar(128) default NULL,
  `text` longtext NOT NULL,
  `channel` varchar(128) NOT NULL,
  `adapter` tinyint(8) NOT NULL default '0' COMMENT 'DVB adapter number',
  `genre` varchar(256) default NULL,
  `chan_type` varchar(256) NOT NULL default 'tv',
  `audio` tinyint(1) default '1',
  `video` tinyint(1) default '1',
  KEY `pid` (`pid`),
  KEY `chan_date_start_duration` (`channel`,`date`,`start`,`duration`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

__#-----------------------------------------------------------------------------------------------------------------------------
__END__