use strict;
use warnings;

use ExtUtils::MakeMaker;

# ----------------

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my(%params) =
(
	($] ge '5.005') ?
	(
		AUTHOR   => 'Ron Savage (ron@savage.net.au)',
		ABSTRACT => 'Address SVG images using cells of $n1 x $n2 pixels',
	) : (),
	clean =>
	{
		FILES => 'blib/* Makefile MANIFEST SVG-Grid-*'
	},
	dist =>
	{
		COMPRESS => 'gzip',
		SUFFIX   => 'gz'
	},
	DISTNAME  => 'SVG-Grid',
	NAME      => 'SVG::Grid',
	LICENSE   => 'artistic_2',
	PL_FILES  => {},
	PREREQ_PM =>
	{
		'File::Slurper'		=> 0.008,
		'File::Spec'		=> 0,
		'File::Temp'		=> 0,
		'Getopt::Long'		=> 0,
		'Moo'				=> 2.000002,
		'Pod::Usage'		=> 0,
		'strict'			=> 0,
		'SVG'				=> 2.64,
		'Test::More'		=> 1.001014,
		'Test::Stream'		=> 1.302026,
		'Test::Pod'			=> 1.48,
		'Types::Standard'	=> 1.000005,
		'warnings'			=> 0,
	},
	VERSION_FROM => 'lib/SVG/Grid.pm',
);

if ( ($ExtUtils::MakeMaker::VERSION =~ /^\d\.\d\d$/) && ($ExtUtils::MakeMaker::VERSION > 6.30) )
{
	$params{LICENSE} = 'artistic_2';
}

if ($ExtUtils::MakeMaker::VERSION ge '6.46')
{
	$params{META_MERGE} =
	{
		'meta-spec' =>
		{
		'version' => 2,
		},
		resources   =>
		{
		'bugtracker' => 'https://rt.cpan.org/Public/Dist/Display.html?Name=SVG-Grid',
		'license' => 'http://opensource.org/licenses/Artistic-2.0',
			repository =>
			{
		'type' => 'git',
		'url' => 'https://github.com/ronsavage/SVG-Grid.git',
		'web' => 'https://github.com/ronsavage/SVG-Grid',
			},
		},
	};
}

WriteMakefile(%params);
