use Module::Build;

my $class = Module::Build->subclass(code => <<'EOF');

sub ACTION_build
{
	my $self = shift;
	$self->SUPER::ACTION_build(@_);
	$self->run_perl_script('scripts/copy.config.pl');
}
EOF

$class -> new
(
	module_name    => 'Benchmark::Featureset::SetOps',
	license        => 'artistic',
	dist_abstract  => 'Compare various array/set handling modules',
	dist_author    => 'Ron Savage <ron@savage.net.au>',
	build_requires =>
	{
	Test::More => 0.94,
	Test::Pod  => 1.44,
	},
	configure_requires =>
	{
		Module::Build => 0.3800,
	},
	requires =>
	{
	App::moduleswhere => 0.03,
	Config::Tiny      => 2.13,
	Module::Version   => 0.12,
	},
) -> create_build_script();
