use utf8;

package SemanticWeb::Schema::HyperTocEntry;

# ABSTRACT: A HyperToEntry is an item within a [[HyperToc]]

use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'HyperTocEntry';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v14.0.0';


has associated_media => (
    is        => 'rw',
    predicate => '_has_associated_media',
    json_ld   => 'associatedMedia',
);



has toc_continuation => (
    is        => 'rw',
    predicate => '_has_toc_continuation',
    json_ld   => 'tocContinuation',
);



has utterances => (
    is        => 'rw',
    predicate => '_has_utterances',
    json_ld   => 'utterances',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::HyperTocEntry - A HyperToEntry is an item within a [[HyperToc]]

=head1 VERSION

version v14.0.0

=head1 DESCRIPTION

A HyperToEntry is an item within a L<SemanticWeb::Schema::HyperToc>, which represents a hypertext table of contents for complex media objects, such as L<SemanticWeb::Schema::VideoObject>, L<SemanticWeb::Schema::AudioObject>. The media object itself is indicated using [[associatedMedia]]. Each section of interest within that content can be described with a L<SemanticWeb::Schema::HyperTocEntry>, with associated [[startOffset]] and [[endOffset]]. When several entries are all from the same file, [[associatedMedia]] is used on the overarching L<SemanticWeb::Schema::HyperTocEntry>; if the content has been split into multiple files, they can be referenced using [[associatedMedia]] on each L<SemanticWeb::Schema::HyperTocEntry>.

=head1 ATTRIBUTES

=head2 C<associated_media>

C<associatedMedia>

A media object that encodes this CreativeWork. This property is a synonym
for encoding.

A associated_media should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::MediaObject']>

=back

=head2 C<_has_associated_media>

A predicate for the L</associated_media> attribute.

=head2 C<toc_continuation>

C<tocContinuation>

A L<SemanticWeb::Schema::HyperTocEntry> can have a [[tocContinuation]] indicated, which is another L<SemanticWeb::Schema::HyperTocEntry> that would be the default next item to play or render.

A toc_continuation should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::HyperTocEntry']>

=back

=head2 C<_has_toc_continuation>

A predicate for the L</toc_continuation> attribute.

=head2 C<utterances>

Text of an utterances (spoken words, lyrics etc.) that occurs at a certain section of a media object, represented as a L<SemanticWeb::Schema::HyperTocEntry>.

A utterances should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_utterances>

A predicate for the L</utterances> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
