package App::ExtractLinks;

# ABSTRACT: extract href's in HTML docs to stdout

use strict;
use warnings;

use HTML::Parser;

my $parser = HTML::Parser->new(api_version => 3);

sub handler {
    my $attr = shift;

    foreach my $key (keys %$attr) {
        my $val = %$attr{$key};

        if ($key eq 'href') {
            print "$val\n";
        }
    }
}

sub run {
    $parser->handler(start => \&handler, 'attr');

    while (<>) {
       $parser->parse($_); 
    }

    $parser->eof;
}

;
