/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxRequest {
    private String objectNameS;
    private ObjectName objectName;
    private String attributeName;
    private String value;
    private List<String> extraArgs;
    private String operation;
    private Type type;
    private TargetConfig targetConfig = null;
    private int maxDepth = 0;
    private int maxCollectionSize = 0;
    private int maxObjects = 0;

    JmxRequest(Type pType) {
        this.type = pType;
    }

    JmxRequest(Type pType, String pObjectNameS) throws MalformedObjectNameException {
        this.type = pType;
        if (pObjectNameS != null) {
            this.objectNameS = pObjectNameS;
            this.objectName = new ObjectName(this.objectNameS);
        }
    }

    JmxRequest(Map<String, ?> pMap) throws MalformedObjectNameException {
        Map target;
        this.type = Type.valueOf((String)pMap.get("type"));
        if (this.type == null) {
            throw new IllegalArgumentException("Type is required");
        }
        String s = (String)pMap.get("mbean");
        if (s != null) {
            this.objectNameS = s;
            this.objectName = new ObjectName(s);
        }
        if ((s = (String)pMap.get("attribute")) != null) {
            this.attributeName = s;
        }
        this.extraArgs = (s = (String)pMap.get("path")) != null ? this.splitPath(s) : new ArrayList<String>();
        List l = (List)pMap.get("arguments");
        if (l != null) {
            this.extraArgs = l;
        }
        if ((s = (String)pMap.get("value")) != null) {
            this.value = s;
        }
        if ((s = (String)pMap.get("operation")) != null) {
            this.operation = s;
        }
        if ((target = (Map)pMap.get("target")) != null) {
            this.targetConfig = new TargetConfig(target);
        }
    }

    public String getObjectNameAsString() {
        return this.objectNameS;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public List<String> getExtraArgs() {
        return this.extraArgs;
    }

    public String getExtraArgsAsPath() {
        if (this.extraArgs.size() > 0) {
            StringBuffer buf = new StringBuffer();
            Iterator<String> it = this.extraArgs.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append("/");
            }
            return buf.toString();
        }
        return null;
    }

    private List<String> splitPath(String pPath) {
        String[] elements = pPath.split("/");
        return Arrays.asList(elements);
    }

    public String getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    void setAttributeName(String pName) {
        this.attributeName = pName;
    }

    void setValue(String pValue) {
        this.value = pValue;
    }

    void setOperation(String pOperation) {
        this.operation = pOperation;
    }

    void setExtraArgs(List<String> pExtraArgs) {
        this.extraArgs = pExtraArgs;
    }

    void setMaxObjects(int pMaxObjects) {
        this.maxObjects = pMaxObjects;
    }

    void setMaxCollectionSize(int pMaxCollectionSize) {
        this.maxCollectionSize = pMaxCollectionSize;
    }

    void setMaxDepth(int pMaxDepth) {
        this.maxDepth = pMaxDepth;
    }

    public TargetConfig getTargetConfig() {
        return this.targetConfig;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("JmxRequest[");
        if (this.type == Type.READ) {
            ret.append("READ mbean=").append(this.objectNameS).append(", attribute=").append(this.attributeName);
        } else if (this.type == Type.WRITE) {
            ret.append("WRITE mbean=").append(this.objectNameS).append(", attribute=").append(this.attributeName).append(", value=").append(this.value);
        } else if (this.type == Type.EXEC) {
            ret.append("EXEC mbean=").append(this.objectNameS).append(", operation=").append(this.operation);
        } else {
            ret.append((Object)this.type).append(" mbean=").append(this.objectNameS);
        }
        if (this.extraArgs != null && this.extraArgs.size() > 0) {
            ret.append(", extra=").append(this.extraArgs);
        }
        if (this.targetConfig != null) {
            ret.append(", target=").append(this.targetConfig);
        }
        ret.append("]");
        return ret.toString();
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"type", (Object)this.type.value);
        if (this.objectName != null) {
            ret.put((Object)"mbean", (Object)this.objectName.getCanonicalName());
        }
        if (this.attributeName != null) {
            ret.put((Object)"attribute", (Object)this.attributeName);
        }
        if (this.extraArgs != null && this.extraArgs.size() > 0) {
            if (this.type == Type.READ || this.type == Type.WRITE) {
                ret.put((Object)"path", (Object)this.getExtraArgsAsPath());
            } else if (this.type == Type.EXEC) {
                ret.put((Object)"arguments", this.extraArgs);
            }
        }
        if (this.value != null) {
            ret.put((Object)"value", (Object)this.value);
        }
        if (this.operation != null) {
            ret.put((Object)"operation", (Object)this.operation);
        }
        if (this.targetConfig != null) {
            ret.put((Object)"target", (Object)this.targetConfig.toJSON());
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TargetConfig {
        private String url;
        private Map<String, Object> env;

        public TargetConfig(Map pMap) {
            String url = (String)pMap.get("url");
            if (url == null) {
                throw new IllegalArgumentException("No service url given for JSR-160 target");
            }
            this.url = url;
            String user = (String)pMap.get("user");
            if (user != null) {
                this.env = new HashMap<String, Object>();
                this.env.put("user", user);
                String pwd = (String)pMap.get("password");
                if (pwd != null) {
                    this.env.put("password", pwd);
                }
            }
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, Object> getEnv() {
            return this.env;
        }

        public JSONObject toJSON() {
            JSONObject ret = new JSONObject();
            ret.put((Object)"url", (Object)this.url);
            if (this.env != null) {
                ret.put((Object)"env", this.env);
            }
            return ret;
        }

        public String toString() {
            return "TargetConfig[" + this.url + ", " + this.env + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        READ("read"),
        LIST("list"),
        WRITE("write"),
        EXEC("exec"),
        VERSION("version"),
        SEARCH("search"),
        REGNOTIF("regnotif"),
        REMNOTIF("remnotif"),
        CONFIG("config");

        private String value;

        private Type(String pValue) {
            this.value = pValue;
        }

        public String getValue() {
            return this.value;
        }
    }
}

