/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHandler
implements ObjectToJsonConverter.Handler {
    @Override
    public Class getType() {
        return List.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        List list = (List)pValue;
        int length = pConverter.getCollectionLength(list.size());
        Iterator it = list.iterator();
        if (!pExtraArgs.isEmpty()) {
            int idx = Integer.parseInt(pExtraArgs.pop());
            return pConverter.extractObject(list.get(idx), pExtraArgs, jsonify);
        }
        if (jsonify) {
            JSONArray ret = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Object val = it.next();
                ret.add(pConverter.extractObject(val, pExtraArgs, jsonify));
            }
            return ret;
        }
        return list;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, String pValueS) throws IllegalAccessException, InvocationTargetException {
        int idx;
        List list = (List)pInner;
        try {
            idx = Integer.parseInt(pAttribute);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing collection " + pInner + ". (index = " + pAttribute + ", value to set = " + pValueS + ")", exp);
        }
        Object oldValue = list.get(idx);
        String value = oldValue != null ? pConverter.convertFromString(oldValue.getClass().getName(), pValueS) : pValueS;
        list.set(idx, value);
        return oldValue;
    }
}

