package org.jmx4perl.osgi.bundle;

import org.jmx4perl.osgi.J4pActivator;
import org.ops4j.pax.web.service.jetty.internal.CompositeActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * osgish - An OSGi Shell
 *
 * Copyright (C) 2009 Roland Huß, roland@cpan.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * A commercial license is available as well. Please contact roland@cpan.org for
 * further details.
 */


/**
 * Activator for activation the embedded j4p agent as well
 * as the Aries JMX bundle. So it's an aggregat activator.
 *
 * It also registers an (arbitrary) MBeanServer if not already
 * an MBeanServer is registered. This service is required by Aries JMX.

 * @author roland
 * @since Jan 9, 2010
 */
public class Activator implements BundleActivator {

    // J4p Activator
    private J4pActivator j4pActivator;

    // Pax-Web Activator
    private CompositeActivator paxWebActivator;

    public Activator() {
        j4pActivator = new J4pActivator();
        paxWebActivator = new CompositeActivator();
    }

    public void start(BundleContext pContext) throws Exception {
        paxWebActivator.start(pContext);
        j4pActivator.start(pContext);
    }

    public void stop(BundleContext pContext) throws Exception {
        j4pActivator.stop(pContext);
        paxWebActivator.stop(pContext);
    }

}
